/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.util.typedef.F;

public class H2RowCache
implements GridQueryRowCacheCleaner {
    private ConcurrentHashMap<Long, GridH2KeyValueRowOnheap> rows = new ConcurrentHashMap();
    private final CacheGroupContext grpCtx;
    private int usageCnt = 1;

    public H2RowCache(CacheGroupContext grpCtx) {
        this.grpCtx = grpCtx;
    }

    public GridH2KeyValueRowOnheap get(long link) throws IgniteCheckedException {
        GridH2KeyValueRowOnheap row = this.rows.get(link);
        if (row != null) {
            this.touch(link);
        }
        return row;
    }

    public void put(GridH2KeyValueRowOnheap row) {
        this.rows.put(row.link(), row);
    }

    public void remove(long link) {
        this.rows.remove(link);
    }

    public void onCacheRegistered() {
        ++this.usageCnt;
    }

    public boolean onCacheUnregistered(GridCacheContext cctx) {
        boolean res = --this.usageCnt == 0;
        this.clearForCache(cctx);
        return res;
    }

    public int size() {
        return this.rows.size();
    }

    private void clearForCache(GridCacheContext cctx) {
        int cacheId = cctx.cacheId();
        Iterator<Map.Entry<Long, GridH2KeyValueRowOnheap>> iter = this.rows.entrySet().iterator();
        while (iter.hasNext()) {
            GridH2KeyValueRowOnheap row = iter.next().getValue();
            if (!F.eq((Object)cacheId, (Object)row.cacheId())) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touch(long link) throws IgniteCheckedException {
        PageMemory mem = this.grpCtx.dataRegion().pageMemory();
        int grpId = this.grpCtx.groupId();
        long pageId = PageIdUtils.pageId((long)link);
        long page = mem.acquirePage(grpId, pageId);
        try {
            mem.readLock(grpId, pageId, page);
            mem.readUnlock(grpId, pageId, page);
        }
        finally {
            mem.releasePage(grpId, pageId, page);
        }
    }
}

