/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ImmutableGenericPartitionStatisticsFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.PartitionStats;
import org.apache.iceberg.PartitionStatsUtil;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.parquet.InternalReader;
import org.apache.iceberg.data.parquet.InternalWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;

public class PartitionStatsHandler {
    public static final int PARTITION_FIELD_ID = 0;
    public static final String PARTITION_FIELD_NAME = "partition";
    public static final Types.NestedField SPEC_ID = Types.NestedField.required((int)1, (String)"spec_id", (Type)Types.IntegerType.get());
    public static final Types.NestedField DATA_RECORD_COUNT = Types.NestedField.required((int)2, (String)"data_record_count", (Type)Types.LongType.get());
    public static final Types.NestedField DATA_FILE_COUNT = Types.NestedField.required((int)3, (String)"data_file_count", (Type)Types.IntegerType.get());
    public static final Types.NestedField TOTAL_DATA_FILE_SIZE_IN_BYTES = Types.NestedField.required((int)4, (String)"total_data_file_size_in_bytes", (Type)Types.LongType.get());
    public static final Types.NestedField POSITION_DELETE_RECORD_COUNT = Types.NestedField.optional((int)5, (String)"position_delete_record_count", (Type)Types.LongType.get());
    public static final Types.NestedField POSITION_DELETE_FILE_COUNT = Types.NestedField.optional((int)6, (String)"position_delete_file_count", (Type)Types.IntegerType.get());
    public static final Types.NestedField EQUALITY_DELETE_RECORD_COUNT = Types.NestedField.optional((int)7, (String)"equality_delete_record_count", (Type)Types.LongType.get());
    public static final Types.NestedField EQUALITY_DELETE_FILE_COUNT = Types.NestedField.optional((int)8, (String)"equality_delete_file_count", (Type)Types.IntegerType.get());
    public static final Types.NestedField TOTAL_RECORD_COUNT = Types.NestedField.optional((int)9, (String)"total_record_count", (Type)Types.LongType.get());
    public static final Types.NestedField LAST_UPDATED_AT = Types.NestedField.optional((int)10, (String)"last_updated_at", (Type)Types.LongType.get());
    public static final Types.NestedField LAST_UPDATED_SNAPSHOT_ID = Types.NestedField.optional((int)11, (String)"last_updated_snapshot_id", (Type)Types.LongType.get());

    private PartitionStatsHandler() {
    }

    public static Schema schema(Types.StructType unifiedPartitionType) {
        Preconditions.checkState((!unifiedPartitionType.fields().isEmpty() ? 1 : 0) != 0, (Object)"Table must be partitioned");
        return new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)PARTITION_FIELD_NAME, (Type)unifiedPartitionType), SPEC_ID, DATA_RECORD_COUNT, DATA_FILE_COUNT, TOTAL_DATA_FILE_SIZE_IN_BYTES, POSITION_DELETE_RECORD_COUNT, POSITION_DELETE_FILE_COUNT, EQUALITY_DELETE_RECORD_COUNT, EQUALITY_DELETE_FILE_COUNT, TOTAL_RECORD_COUNT, LAST_UPDATED_AT, LAST_UPDATED_SNAPSHOT_ID});
    }

    public static PartitionStatisticsFile computeAndWriteStatsFile(Table table) throws IOException {
        if (table.currentSnapshot() == null) {
            return null;
        }
        return PartitionStatsHandler.computeAndWriteStatsFile(table, table.currentSnapshot().snapshotId());
    }

    public static PartitionStatisticsFile computeAndWriteStatsFile(Table table, long snapshotId) throws IOException {
        Snapshot snapshot = table.snapshot(snapshotId);
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (String)"Snapshot not found: %s", (long)snapshotId);
        Collection stats = PartitionStatsUtil.computeStats((Table)table, (Snapshot)snapshot);
        if (stats.isEmpty()) {
            return null;
        }
        Types.StructType partitionType = Partitioning.partitionType((Table)table);
        List sortedStats = PartitionStatsUtil.sortStats((Collection)stats, (Types.StructType)partitionType);
        return PartitionStatsHandler.writePartitionStatsFile(table, snapshot.snapshotId(), PartitionStatsHandler.schema(partitionType), sortedStats);
    }

    @VisibleForTesting
    static PartitionStatisticsFile writePartitionStatsFile(Table table, long snapshotId, Schema dataSchema, Iterable<PartitionStats> records) throws IOException {
        FileFormat fileFormat = FileFormat.fromString((String)table.properties().getOrDefault("write.format.default", "parquet"));
        OutputFile outputFile = PartitionStatsHandler.newPartitionStatsFile(table, fileFormat, snapshotId);
        try (DataWriter<StructLike> writer = PartitionStatsHandler.dataWriter(dataSchema, outputFile, fileFormat);){
            records.iterator().forEachRemaining(arg_0 -> writer.write(arg_0));
        }
        return ImmutableGenericPartitionStatisticsFile.builder().snapshotId(snapshotId).path(outputFile.location()).fileSizeInBytes(outputFile.toInputFile().getLength()).build();
    }

    public static CloseableIterable<PartitionStats> readPartitionStatsFile(Schema schema, InputFile inputFile) {
        CloseableIterable<StructLike> records = PartitionStatsHandler.dataReader(schema, inputFile);
        return CloseableIterable.transform(records, PartitionStatsHandler::recordToPartitionStats);
    }

    private static OutputFile newPartitionStatsFile(Table table, FileFormat fileFormat, long snapshotId) {
        Preconditions.checkArgument((boolean)(table instanceof HasTableOperations), (Object)"Table must have operations to retrieve metadata location");
        return table.io().newOutputFile(((HasTableOperations)table).operations().metadataFileLocation(fileFormat.addExtension(String.format(Locale.ROOT, "partition-stats-%d-%s", snapshotId, UUID.randomUUID()))));
    }

    private static DataWriter<StructLike> dataWriter(Schema dataSchema, OutputFile outputFile, FileFormat fileFormat) throws IOException {
        switch (fileFormat) {
            case PARQUET: {
                return Parquet.writeData((OutputFile)outputFile).schema(dataSchema).createWriterFunc(InternalWriter::createWriter).withSpec(PartitionSpec.unpartitioned()).build();
            }
            case AVRO: {
                return Avro.writeData((OutputFile)outputFile).schema(dataSchema).createWriterFunc(org.apache.iceberg.avro.InternalWriter::create).withSpec(PartitionSpec.unpartitioned()).build();
            }
        }
        throw new UnsupportedOperationException("Unsupported file format:" + fileFormat.name());
    }

    private static CloseableIterable<StructLike> dataReader(Schema schema, InputFile inputFile) {
        FileFormat fileFormat = FileFormat.fromFileName((CharSequence)inputFile.location());
        Preconditions.checkArgument((fileFormat != null ? 1 : 0) != 0, (String)"Unable to determine format of file: %s", (Object)inputFile.location());
        switch (fileFormat) {
            case PARQUET: {
                return Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> InternalReader.create((Schema)schema, (MessageType)fileSchema)).build();
            }
            case AVRO: {
                return Avro.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> org.apache.iceberg.avro.InternalReader.create((Schema)schema)).build();
            }
        }
        throw new UnsupportedOperationException("Unsupported file format:" + fileFormat.name());
    }

    private static PartitionStats recordToPartitionStats(StructLike record) {
        PartitionStats stats = new PartitionStats((StructLike)record.get(0, StructLike.class), ((Integer)record.get(SPEC_ID.fieldId(), Integer.class)).intValue());
        stats.set(DATA_RECORD_COUNT.fieldId(), (Object)((Long)record.get(DATA_RECORD_COUNT.fieldId(), Long.class)));
        stats.set(DATA_FILE_COUNT.fieldId(), (Object)((Integer)record.get(DATA_FILE_COUNT.fieldId(), Integer.class)));
        stats.set(TOTAL_DATA_FILE_SIZE_IN_BYTES.fieldId(), (Object)((Long)record.get(TOTAL_DATA_FILE_SIZE_IN_BYTES.fieldId(), Long.class)));
        stats.set(POSITION_DELETE_RECORD_COUNT.fieldId(), (Object)((Long)record.get(POSITION_DELETE_RECORD_COUNT.fieldId(), Long.class)));
        stats.set(POSITION_DELETE_FILE_COUNT.fieldId(), (Object)((Integer)record.get(POSITION_DELETE_FILE_COUNT.fieldId(), Integer.class)));
        stats.set(EQUALITY_DELETE_RECORD_COUNT.fieldId(), (Object)((Long)record.get(EQUALITY_DELETE_RECORD_COUNT.fieldId(), Long.class)));
        stats.set(EQUALITY_DELETE_FILE_COUNT.fieldId(), (Object)((Integer)record.get(EQUALITY_DELETE_FILE_COUNT.fieldId(), Integer.class)));
        stats.set(TOTAL_RECORD_COUNT.fieldId(), (Object)((Long)record.get(TOTAL_RECORD_COUNT.fieldId(), Long.class)));
        stats.set(LAST_UPDATED_AT.fieldId(), (Object)((Long)record.get(LAST_UPDATED_AT.fieldId(), Long.class)));
        stats.set(LAST_UPDATED_SNAPSHOT_ID.fieldId(), (Object)((Long)record.get(LAST_UPDATED_SNAPSHOT_ID.fieldId(), Long.class)));
        return stats;
    }
}

