/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.events;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.iceberg.events.Listener;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class Listeners {
    private static final Map<Class<?>, Queue<Listener<?>>> LISTENERS = Maps.newConcurrentMap();

    private Listeners() {
    }

    public static <E> void register(Listener<E> listener, Class<E> eventType) {
        Queue list = LISTENERS.computeIfAbsent(eventType, k -> new ConcurrentLinkedQueue());
        list.add(listener);
    }

    public static <E> void notifyAll(E event) {
        Preconditions.checkNotNull(event, (Object)"Cannot notify listeners for a null event.");
        Queue<Listener<?>> list = LISTENERS.get(event.getClass());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Listener value;
                Listener listener = value = (Listener)iterator.next();
                listener.notify(event);
            }
        }
    }
}

