/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;

public interface Transform<S, T>
extends Serializable {
    @Deprecated
    default public T apply(S value) {
        throw new UnsupportedOperationException("apply(value) is deprecated, use bind(Type).apply(value)");
    }

    default public SerializableFunction<S, T> bind(Type type) {
        throw new UnsupportedOperationException("bind is not implemented");
    }

    public boolean canTransform(Type var1);

    public Type getResultType(Type var1);

    default public boolean preservesOrder() {
        return false;
    }

    default public boolean satisfiesOrderOf(Transform<?, ?> other) {
        return this.equals(other);
    }

    public UnboundPredicate<T> project(String var1, BoundPredicate<S> var2);

    public UnboundPredicate<T> projectStrict(String var1, BoundPredicate<S> var2);

    default public boolean isIdentity() {
        return false;
    }

    default public boolean isVoid() {
        return false;
    }

    @Deprecated
    default public String toHumanString(T value) {
        if (value instanceof ByteBuffer) {
            return TransformUtil.base64encode(((ByteBuffer)value).duplicate());
        }
        if (value instanceof byte[]) {
            return TransformUtil.base64encode(ByteBuffer.wrap((byte[])value));
        }
        return String.valueOf(value);
    }

    default public String toHumanString(Type type, T value) {
        if (value == null) {
            return "null";
        }
        switch (type.typeId()) {
            case DATE: {
                return TransformUtil.humanDay((Integer)value);
            }
            case TIME: {
                return TransformUtil.humanTime((Long)value);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return TransformUtil.humanTimestampWithZone((Long)value);
                }
                return TransformUtil.humanTimestampWithoutZone((Long)value);
            }
            case TIMESTAMP_NANO: {
                if (((Types.TimestampNanoType)type).shouldAdjustToUTC()) {
                    return TransformUtil.humanTimestampNanoWithZone((Long)value);
                }
                return TransformUtil.humanTimestampNanoWithoutZone((Long)value);
            }
            case FIXED: 
            case BINARY: {
                if (value instanceof ByteBuffer) {
                    return TransformUtil.base64encode(((ByteBuffer)value).duplicate());
                }
                if (value instanceof byte[]) {
                    return TransformUtil.base64encode(ByteBuffer.wrap((byte[])value));
                }
                throw new UnsupportedOperationException("Unsupported binary type: " + value.getClass());
            }
        }
        return value.toString();
    }

    default public String dedupName() {
        return this.toString();
    }
}

