/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoUnit;

public class DateTimeUtil {
    public static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    public static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();
    public static final long MICROS_PER_MILLIS = 1000L;
    public static final long MICROS_PER_SECOND = 1000000L;

    private DateTimeUtil() {
    }

    public static LocalDate dateFromDays(int daysFromEpoch) {
        return ChronoUnit.DAYS.addTo(EPOCH_DAY, daysFromEpoch);
    }

    public static int daysFromDate(LocalDate date) {
        return (int)ChronoUnit.DAYS.between(EPOCH_DAY, date);
    }

    public static int daysFromInstant(Instant instant) {
        return (int)ChronoUnit.DAYS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static LocalTime timeFromMicros(long microFromMidnight) {
        return LocalTime.ofNanoOfDay(microFromMidnight * 1000L);
    }

    public static long microsFromTime(LocalTime time) {
        return time.toNanoOfDay() / 1000L;
    }

    public static LocalDateTime timestampFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch).toLocalDateTime();
    }

    public static long microsFromInstant(Instant instant) {
        return ChronoUnit.MICROS.between(EPOCH, instant.atOffset(ZoneOffset.UTC));
    }

    public static long microsFromTimestamp(LocalDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime.atOffset(ZoneOffset.UTC));
    }

    public static long microsToMillis(long micros) {
        return Math.floorDiv(micros, 1000L);
    }

    public static OffsetDateTime timestamptzFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch);
    }

    public static long microsFromTimestamptz(OffsetDateTime dateTime) {
        return ChronoUnit.MICROS.between(EPOCH, dateTime);
    }

    public static String formatTimestampMillis(long millis) {
        return Instant.ofEpochMilli(millis).toString().replace("Z", "+00:00");
    }

    public static String daysToIsoDate(int days) {
        return DateTimeUtil.dateFromDays(days).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String microsToIsoTime(long micros) {
        return DateTimeUtil.timeFromMicros(micros).format(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static String microsToIsoTimestamptz(long micros) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromMicros(micros);
        DateTimeFormatter zeroOffsetFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendOffset("+HH:MM:ss", "+00:00").toFormatter();
        return localDateTime.atOffset(ZoneOffset.UTC).format(zeroOffsetFormatter);
    }

    public static String microsToIsoTimestamp(long micros) {
        LocalDateTime localDateTime = DateTimeUtil.timestampFromMicros(micros);
        return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static int isoDateToDays(String dateString) {
        return DateTimeUtil.daysFromDate(LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE));
    }

    public static long isoTimeToMicros(String timeString) {
        return DateTimeUtil.microsFromTime(LocalTime.parse(timeString, DateTimeFormatter.ISO_LOCAL_TIME));
    }

    public static long isoTimestamptzToMicros(String timestampString) {
        return DateTimeUtil.microsFromTimestamptz(OffsetDateTime.parse(timestampString, DateTimeFormatter.ISO_DATE_TIME));
    }

    public static boolean isUTCTimestamptz(String timestampString) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(timestampString, DateTimeFormatter.ISO_DATE_TIME);
        return offsetDateTime.getOffset().equals(ZoneOffset.UTC);
    }

    public static long isoTimestampToMicros(String timestampString) {
        return DateTimeUtil.microsFromTimestamp(LocalDateTime.parse(timestampString, DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    public static int daysToYears(int days) {
        return DateTimeUtil.convertDays(days, ChronoUnit.YEARS);
    }

    public static int daysToMonths(int days) {
        return DateTimeUtil.convertDays(days, ChronoUnit.MONTHS);
    }

    private static int convertDays(int days, ChronoUnit granularity) {
        if (days >= 0) {
            LocalDate date = EPOCH_DAY.plusDays(days);
            return (int)granularity.between(EPOCH_DAY, date);
        }
        LocalDate date = EPOCH_DAY.plusDays(days + 1);
        return (int)granularity.between(EPOCH_DAY, date) - 1;
    }

    public static int microsToYears(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.YEARS);
    }

    public static int microsToMonths(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.MONTHS);
    }

    public static int microsToDays(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.DAYS);
    }

    public static int microsToHours(long micros) {
        return DateTimeUtil.convertMicros(micros, ChronoUnit.HOURS);
    }

    private static int convertMicros(long micros, ChronoUnit granularity) {
        if (micros >= 0L) {
            long epochSecond = Math.floorDiv(micros, 1000000L);
            long nanoAdjustment = Math.floorMod(micros, 1000000L) * 1000L;
            return (int)granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment));
        }
        long epochSecond = Math.floorDiv(micros, 1000000L);
        long nanoAdjustment = Math.floorMod(micros + 1L, 1000000L) * 1000L;
        return (int)granularity.between(EPOCH, DateTimeUtil.toOffsetDateTime(epochSecond, nanoAdjustment)) - 1;
    }

    private static OffsetDateTime toOffsetDateTime(long epochSecond, long nanoAdjustment) {
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment).atOffset(ZoneOffset.UTC);
    }
}

