/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.Accessors;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.BiMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableBiMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.primitives.Ints;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class Schema
implements Serializable {
    private static final Joiner NEWLINE = Joiner.on((char)'\n');
    private static final String ALL_COLUMNS = "*";
    private static final int DEFAULT_SCHEMA_ID = 0;
    private final Types.StructType struct;
    private final int schemaId;
    private final int[] identifierFieldIds;
    private transient BiMap<String, Integer> aliasToId = null;
    private transient Map<Integer, Types.NestedField> idToField = null;
    private transient Map<String, Integer> nameToId = null;
    private transient Map<String, Integer> lowerCaseNameToId = null;
    private transient Map<Integer, Accessor<StructLike>> idToAccessor = null;
    private transient Map<Integer, String> idToName = null;
    private transient Set<Integer> identifierFieldIdSet = null;

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases) {
        this(columns, aliases, (Set<Integer>)ImmutableSet.of());
    }

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases, Set<Integer> identifierFieldIds) {
        this(0, columns, aliases, identifierFieldIds);
    }

    public Schema(List<Types.NestedField> columns) {
        this(columns, (Set<Integer>)ImmutableSet.of());
    }

    public Schema(List<Types.NestedField> columns, Set<Integer> identifierFieldIds) {
        this(0, columns, identifierFieldIds);
    }

    public Schema(int schemaId, List<Types.NestedField> columns) {
        this(schemaId, columns, (Set<Integer>)ImmutableSet.of());
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Set<Integer> identifierFieldIds) {
        this(schemaId, columns, null, identifierFieldIds);
    }

    public Schema(int schemaId, List<Types.NestedField> columns, Map<String, Integer> aliases, Set<Integer> identifierFieldIds) {
        this.schemaId = schemaId;
        this.struct = Types.StructType.of(columns);
        ImmutableBiMap immutableBiMap = this.aliasToId = aliases != null ? ImmutableBiMap.copyOf(aliases) : null;
        if (identifierFieldIds != null) {
            Map<Integer, Integer> idToParent = TypeUtil.indexParents(this.struct);
            identifierFieldIds.forEach(id -> Schema.validateIdentifierField(id, this.lazyIdToField(), idToParent));
        }
        this.identifierFieldIds = identifierFieldIds != null ? Ints.toArray(identifierFieldIds) : new int[]{};
        this.lazyIdToName();
    }

    static void validateIdentifierField(int fieldId, Map<Integer, Types.NestedField> idToField, Map<Integer, Integer> idToParent) {
        Types.NestedField field = idToField.get(fieldId);
        Preconditions.checkArgument((boolean)field.type().isPrimitiveType(), (String)"Cannot add field %s as an identifier field: not a primitive type field", (Object)field.name());
        Preconditions.checkArgument((boolean)field.isRequired(), (String)"Cannot add field %s as an identifier field: not a required field", (Object)field.name());
        Preconditions.checkArgument((!Types.DoubleType.get().equals(field.type()) && !Types.FloatType.get().equals(field.type()) ? 1 : 0) != 0, (String)"Cannot add field %s as an identifier field: must not be float or double field", (Object)field.name());
        Integer parentId = idToParent.get(field.fieldId());
        while (parentId != null) {
            Types.NestedField parent = idToField.get(parentId);
            Preconditions.checkArgument((boolean)parent.type().isStructType(), (String)"Cannot add field %s as an identifier field: must not be nested in %s", (Object)field.name(), (Object)parent);
            parentId = idToParent.get(parent.fieldId());
        }
    }

    public Schema(Types.NestedField ... columns) {
        this(0, Arrays.asList(columns));
    }

    public Schema(int schemaId, Types.NestedField ... columns) {
        this(schemaId, Arrays.asList(columns));
    }

    private Map<Integer, Types.NestedField> lazyIdToField() {
        if (this.idToField == null) {
            this.idToField = TypeUtil.indexById(this.struct);
        }
        return this.idToField;
    }

    private Map<String, Integer> lazyNameToId() {
        if (this.nameToId == null) {
            this.nameToId = ImmutableMap.copyOf(TypeUtil.indexByName(this.struct));
        }
        return this.nameToId;
    }

    private Map<Integer, String> lazyIdToName() {
        if (this.idToName == null) {
            this.idToName = ImmutableMap.copyOf(TypeUtil.indexNameById(this.struct));
        }
        return this.idToName;
    }

    private Map<String, Integer> lazyLowerCaseNameToId() {
        if (this.lowerCaseNameToId == null) {
            this.lowerCaseNameToId = ImmutableMap.copyOf(TypeUtil.indexByLowerCaseName(this.struct));
        }
        return this.lowerCaseNameToId;
    }

    private Map<Integer, Accessor<StructLike>> lazyIdToAccessor() {
        if (this.idToAccessor == null) {
            this.idToAccessor = Accessors.forSchema(this);
        }
        return this.idToAccessor;
    }

    private Set<Integer> lazyIdentifierFieldIdSet() {
        if (this.identifierFieldIdSet == null) {
            this.identifierFieldIdSet = ImmutableSet.copyOf((Collection)Ints.asList((int[])this.identifierFieldIds));
        }
        return this.identifierFieldIdSet;
    }

    public int schemaId() {
        return this.schemaId;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    public Types.StructType asStruct() {
        return this.struct;
    }

    public List<Types.NestedField> columns() {
        return this.struct.fields();
    }

    public Set<Integer> identifierFieldIds() {
        return this.lazyIdentifierFieldIdSet();
    }

    public Set<String> identifierFieldNames() {
        return this.identifierFieldIds().stream().map(id -> this.lazyIdToName().get(id)).collect(Collectors.toSet());
    }

    public Type findType(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = this.lazyNameToId().get(name);
        if (id != null) {
            return this.findType(id);
        }
        return null;
    }

    public Type findType(int id) {
        Types.NestedField field = this.lazyIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Types.NestedField findField(int id) {
        return this.lazyIdToField().get(id);
    }

    public Types.NestedField findField(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = this.lazyNameToId().get(name);
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public Types.NestedField caseInsensitiveFindField(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = this.lazyLowerCaseNameToId().get(name.toLowerCase(Locale.ROOT));
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public String findColumnName(int id) {
        return this.lazyIdToName().get(id);
    }

    public Integer aliasToId(String alias) {
        if (this.aliasToId != null) {
            return (Integer)this.aliasToId.get((Object)alias);
        }
        return null;
    }

    public String idToAlias(Integer fieldId) {
        if (this.aliasToId != null) {
            return (String)this.aliasToId.inverse().get((Object)fieldId);
        }
        return null;
    }

    public Accessor<StructLike> accessorForField(int id) {
        return this.lazyIdToAccessor().get(id);
    }

    public Schema select(String ... names) {
        return this.select(Arrays.asList(names));
    }

    public Schema select(Collection<String> names) {
        return this.internalSelect(names, true);
    }

    public Schema caseInsensitiveSelect(String ... names) {
        return this.caseInsensitiveSelect(Arrays.asList(names));
    }

    public Schema caseInsensitiveSelect(Collection<String> names) {
        return this.internalSelect(names, false);
    }

    public boolean sameSchema(Schema anotherSchema) {
        return this.asStruct().equals(anotherSchema.asStruct()) && this.identifierFieldIds().equals(anotherSchema.identifierFieldIds());
    }

    private Schema internalSelect(Collection<String> names, boolean caseSensitive) {
        if (names.contains(ALL_COLUMNS)) {
            return this;
        }
        HashSet selected = Sets.newHashSet();
        for (String name : names) {
            Integer id = caseSensitive ? this.lazyNameToId().get(name) : this.lazyLowerCaseNameToId().get(name.toLowerCase(Locale.ROOT));
            if (id == null) continue;
            selected.add(id);
        }
        return TypeUtil.select(this, (Set<Integer>)selected);
    }

    private String identifierFieldToString(Types.NestedField field) {
        return "  " + field + (this.identifierFieldIds().contains(field.fieldId()) ? " (id)" : "");
    }

    public String toString() {
        return String.format("table {\n%s\n}", NEWLINE.join((Iterable)this.struct.fields().stream().map(this::identifierFieldToString).collect(Collectors.toList())));
    }
}

