/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class UUIDUtil {
    private UUIDUtil() {
    }

    public static UUID convert(byte[] buf) {
        Preconditions.checkArgument((buf.length == 16 ? 1 : 0) != 0, (Object)"UUID require 16 bytes");
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        return UUIDUtil.convert(bb);
    }

    public static UUID convert(byte[] buf, int offset) {
        Preconditions.checkArgument((offset >= 0 && offset < buf.length ? 1 : 0) != 0, (String)"Offset overflow, offset=%d, length=%d", (int)offset, (int)buf.length);
        Preconditions.checkArgument((offset + 16 <= buf.length ? 1 : 0) != 0, (String)"UUID require 16 bytes, offset=%d, length=%d", (int)offset, (int)buf.length);
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, 16);
        bb.order(ByteOrder.BIG_ENDIAN);
        return UUIDUtil.convert(bb);
    }

    public static UUID convert(ByteBuffer buf) {
        long mostSigBits = buf.getLong();
        long leastSigBits = buf.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public static byte[] convert(UUID value) {
        return UUIDUtil.convertToByteBuffer(value).array();
    }

    public static ByteBuffer convertToByteBuffer(UUID value) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(0, value.getMostSignificantBits());
        buffer.putLong(8, value.getLeastSignificantBits());
        return buffer;
    }
}

