/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class SortOrder
implements Serializable {
    private static final SortOrder UNSORTED_ORDER = new SortOrder(new Schema(new Types.NestedField[0]), 0, Collections.emptyList());
    private final Schema schema;
    private final int orderId;
    private final SortField[] fields;
    private volatile transient List<SortField> fieldList;

    private SortOrder(Schema schema, int orderId, List<SortField> fields) {
        this.schema = schema;
        this.orderId = orderId;
        this.fields = fields.toArray(new SortField[0]);
    }

    public Schema schema() {
        return this.schema;
    }

    public int orderId() {
        return this.orderId;
    }

    public List<SortField> fields() {
        return this.lazyFieldList();
    }

    public boolean isUnsorted() {
        return this.fields.length < 1;
    }

    public boolean satisfies(SortOrder anotherSortOrder) {
        if (anotherSortOrder.isUnsorted()) {
            return true;
        }
        if (anotherSortOrder.fields.length > this.fields.length) {
            return false;
        }
        return IntStream.range(0, anotherSortOrder.fields.length).allMatch(index -> this.fields[index].equals(anotherSortOrder.fields[index]));
    }

    public boolean sameOrder(SortOrder anotherSortOrder) {
        return Arrays.equals(this.fields, anotherSortOrder.fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SortField> lazyFieldList() {
        if (this.fieldList == null) {
            SortOrder sortOrder = this;
            synchronized (sortOrder) {
                if (this.fieldList == null) {
                    this.fieldList = ImmutableList.copyOf((Object[])this.fields);
                }
            }
        }
        return this.fieldList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (SortField field : this.fields) {
            sb.append("\n");
            sb.append("  ").append(field);
        }
        if (this.fields.length > 0) {
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SortOrder that = (SortOrder)other;
        return this.orderId == that.orderId && this.sameOrder(that);
    }

    public int hashCode() {
        return 31 * Integer.hashCode(this.orderId) + Arrays.hashCode(this.fields);
    }

    public static SortOrder unsorted() {
        return UNSORTED_ORDER;
    }

    public static Builder builderFor(Schema schema) {
        return new Builder(schema);
    }

    static void checkCompatibility(SortOrder sortOrder, Schema schema) {
        for (SortField field : sortOrder.fields) {
            Type sourceType = schema.findType(field.sourceId());
            ValidationException.check(sourceType != null, "Cannot find source column for sort field: %s", field);
            ValidationException.check(sourceType.isPrimitiveType(), "Cannot sort by non-primitive source field: %s", sourceType);
            ValidationException.check(field.transform().canTransform(sourceType), "Invalid source type %s for transform: %s", sourceType, field.transform());
        }
    }

    public static class Builder {
        private final Schema schema;
        private final List<SortField> fields = Lists.newArrayList();
        private int orderId = 1;
        private boolean caseSensitive = true;

        private Builder(Schema schema) {
            this.schema = schema;
        }

        public Builder asc(String name) {
            return this.asc(name, NullOrder.NULLS_FIRST);
        }

        public Builder asc(String name, NullOrder nullOrder) {
            return this.addSortField(Expressions.ref(name), SortDirection.ASC, nullOrder);
        }

        public Builder asc(Term term) {
            return this.asc(term, NullOrder.NULLS_FIRST);
        }

        public Builder asc(Term term, NullOrder nullOrder) {
            return this.addSortField(term, SortDirection.ASC, nullOrder);
        }

        public Builder desc(String name) {
            return this.desc(name, NullOrder.NULLS_LAST);
        }

        public Builder desc(String name, NullOrder nullOrder) {
            return this.addSortField(Expressions.ref(name), SortDirection.DESC, nullOrder);
        }

        public Builder desc(Term term) {
            return this.desc(term, NullOrder.NULLS_LAST);
        }

        public Builder desc(Term term, NullOrder nullOrder) {
            return this.addSortField(term, SortDirection.DESC, nullOrder);
        }

        public Builder withOrderId(int newOrderId) {
            this.orderId = newOrderId;
            return this;
        }

        public Builder caseSensitive(boolean sortCaseSensitive) {
            this.caseSensitive = sortCaseSensitive;
            return this;
        }

        Builder addSortField(Term term, SortDirection direction, NullOrder nullOrder) {
            Preconditions.checkArgument((boolean)(term instanceof UnboundTerm), (Object)"Term must be unbound");
            BoundTerm boundTerm = (BoundTerm)((UnboundTerm)term).bind(this.schema.asStruct(), this.caseSensitive);
            int sourceId = boundTerm.ref().fieldId();
            SortField sortField = new SortField(this.toTransform(boundTerm), sourceId, direction, nullOrder);
            this.fields.add(sortField);
            return this;
        }

        Builder addSortField(String transformAsString, int sourceId, SortDirection direction, NullOrder nullOrder) {
            Types.NestedField column = this.schema.findField(sourceId);
            Preconditions.checkNotNull((Object)column, (String)"Cannot find source column: %s", (int)sourceId);
            Transform<?, ?> transform = Transforms.fromString(column.type(), transformAsString);
            SortField sortField = new SortField(transform, sourceId, direction, nullOrder);
            this.fields.add(sortField);
            return this;
        }

        public SortOrder build() {
            if (this.orderId == 0 && this.fields.size() != 0) {
                throw new IllegalArgumentException("Sort order ID 0 is reserved for unsorted order");
            }
            if (this.fields.size() == 0 && this.orderId != 0) {
                throw new IllegalArgumentException("Unsorted order ID must be 0");
            }
            SortOrder sortOrder = new SortOrder(this.schema, this.orderId, this.fields);
            SortOrder.checkCompatibility(sortOrder, this.schema);
            return sortOrder;
        }

        private Transform<?, ?> toTransform(BoundTerm<?> term) {
            if (term instanceof BoundReference) {
                return Transforms.identity(term.type());
            }
            if (term instanceof BoundTransform) {
                return ((BoundTransform)term).transform();
            }
            throw new ValidationException("Invalid term: %s, expected either a bound reference or transform", term);
        }
    }
}

