/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.MessageWriter;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;

@NotThreadSafe
public class HttpMultipart
extends Multipart {
    private static final ByteArrayBuffer CR_LF = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "\r\n");
    private static final ByteArrayBuffer TWO_DASHES = HttpMultipart.encode(MIME.DEFAULT_CHARSET, "--");
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;

    private static ByteArrayBuffer encode(Charset charset, String string) {
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer bab = new ByteArrayBuffer(encoded.remaining());
        bab.append(encoded.array(), encoded.position(), encoded.remaining());
        return bab;
    }

    private static void writeBytes(ByteArrayBuffer b, OutputStream out) throws IOException {
        out.write(b.buffer(), 0, b.length());
    }

    private static void writeBytes(ByteSequence b, OutputStream out) throws IOException {
        if (b instanceof ByteArrayBuffer) {
            HttpMultipart.writeBytes((ByteArrayBuffer)b, out);
        } else {
            out.write(b.toByteArray());
        }
    }

    public HttpMultipart(String subType) {
        super(subType);
    }

    public HttpMultipartMode getMode() {
        return this.mode;
    }

    public void setMode(HttpMultipartMode mode) {
        this.mode = mode;
    }

    protected Charset getCharset() {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        Charset charset = null;
        switch (this.mode) {
            case STRICT: {
                charset = MIME.DEFAULT_CHARSET;
                break;
            }
            case BROWSER_COMPATIBLE: {
                charset = cField.getCharset() != null ? CharsetUtil.getCharset((String)cField.getCharset()) : CharsetUtil.getCharset((String)"ISO-8859-1");
            }
        }
        return charset;
    }

    protected String getBoundary() {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        return cField.getBoundary();
    }

    private void doWriteTo(HttpMultipartMode mode, OutputStream out, boolean writeContent) throws IOException {
        List bodyParts = this.getBodyParts();
        Charset charset = this.getCharset();
        ByteArrayBuffer boundary = HttpMultipart.encode(charset, this.getBoundary());
        switch (mode) {
            case STRICT: {
                String preamble = this.getPreamble();
                if (preamble != null && preamble.length() != 0) {
                    ByteArrayBuffer b = HttpMultipart.encode(charset, preamble);
                    HttpMultipart.writeBytes(b, out);
                    HttpMultipart.writeBytes(CR_LF, out);
                }
                for (int i = 0; i < bodyParts.size(); ++i) {
                    HttpMultipart.writeBytes(TWO_DASHES, out);
                    HttpMultipart.writeBytes(boundary, out);
                    HttpMultipart.writeBytes(CR_LF, out);
                    BodyPart part = (BodyPart)bodyParts.get(i);
                    Header header = part.getHeader();
                    List fields = header.getFields();
                    for (Field field : fields) {
                        HttpMultipart.writeBytes(field.getRaw(), out);
                        HttpMultipart.writeBytes(CR_LF, out);
                    }
                    HttpMultipart.writeBytes(CR_LF, out);
                    if (writeContent) {
                        MessageWriter.DEFAULT.writeBody(part.getBody(), out);
                    }
                    HttpMultipart.writeBytes(CR_LF, out);
                }
                HttpMultipart.writeBytes(TWO_DASHES, out);
                HttpMultipart.writeBytes(boundary, out);
                HttpMultipart.writeBytes(TWO_DASHES, out);
                HttpMultipart.writeBytes(CR_LF, out);
                String epilogue = this.getEpilogue();
                if (epilogue == null || epilogue.length() == 0) break;
                ByteArrayBuffer b = HttpMultipart.encode(charset, epilogue);
                HttpMultipart.writeBytes(b, out);
                HttpMultipart.writeBytes(CR_LF, out);
                break;
            }
            case BROWSER_COMPATIBLE: {
                for (int i = 0; i < bodyParts.size(); ++i) {
                    HttpMultipart.writeBytes(TWO_DASHES, out);
                    HttpMultipart.writeBytes(boundary, out);
                    HttpMultipart.writeBytes(CR_LF, out);
                    BodyPart part = (BodyPart)bodyParts.get(i);
                    Field cd = part.getHeader().getField("Content-Disposition");
                    StringBuilder s = new StringBuilder();
                    s.append(cd.getName());
                    s.append(": ");
                    s.append(cd.getBody());
                    HttpMultipart.writeBytes(HttpMultipart.encode(charset, s.toString()), out);
                    HttpMultipart.writeBytes(CR_LF, out);
                    HttpMultipart.writeBytes(CR_LF, out);
                    if (writeContent) {
                        MessageWriter.DEFAULT.writeBody(part.getBody(), out);
                    }
                    HttpMultipart.writeBytes(CR_LF, out);
                }
                HttpMultipart.writeBytes(TWO_DASHES, out);
                HttpMultipart.writeBytes(boundary, out);
                HttpMultipart.writeBytes(TWO_DASHES, out);
                HttpMultipart.writeBytes(CR_LF, out);
            }
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.doWriteTo(this.mode, out, true);
    }

    public long getTotalLength() {
        List bodyParts = this.getBodyParts();
        long contentLen = 0L;
        for (int i = 0; i < bodyParts.size(); ++i) {
            BodyPart part = (BodyPart)bodyParts.get(i);
            Body body = part.getBody();
            if (body instanceof ContentBody) {
                long len = ((ContentBody)body).getContentLength();
                if (len >= 0L) {
                    contentLen += len;
                    continue;
                }
                return -1L;
            }
            return -1L;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.doWriteTo(this.mode, out, false);
            byte[] extra = out.toByteArray();
            return contentLen + (long)extra.length;
        }
        catch (IOException ex) {
            return -1L;
        }
    }
}

