/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.RetryExec;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRetryExec {
    @Mock
    private ClientExecChain requestExecutor;
    @Mock
    private HttpRequestRetryHandler retryHandler;
    @Mock
    private HttpExecutionAware execAware;
    private RetryExec retryExec;
    private HttpHost target;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.retryExec = new RetryExec(this.requestExecutor, this.retryHandler);
        this.target = new HttpHost("localhost", 80);
    }

    @Test(expected=IOException.class)
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        get.addHeader("header", "this");
        get.addHeader("header", "that");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                HttpRequestWrapper wrapper = (HttpRequestWrapper)args[1];
                Header[] headers = wrapper.getAllHeaders();
                Assert.assertEquals((int)2, (int)headers.length);
                Assert.assertEquals((String)"this", (String)headers[0].getValue());
                Assert.assertEquals((String)"that", (String)headers[1].getValue());
                wrapper.addHeader("Cookie", "monster");
                throw new IOException("Ka-boom");
            }
        });
        Mockito.when((Object)this.retryHandler.retryRequest((IOException)Mockito.any(), Mockito.eq((int)1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        try {
            this.retryExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ClientExecChain)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)2))).execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.same((Object)context), (HttpExecutionAware)Mockito.same((Object)this.execAware));
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testAbortedRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        Mockito.when((Object)this.execAware.isAborted()).thenReturn((Object)Boolean.TRUE);
        try {
            this.retryExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ClientExecChain)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.same((Object)context), (HttpExecutionAware)Mockito.same((Object)this.execAware));
            ((HttpRequestRetryHandler)Mockito.verify((Object)this.retryHandler, (VerificationMode)Mockito.never())).retryRequest((IOException)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any());
            throw ex;
        }
    }

    @Test(expected=NonRepeatableRequestException.class)
    public void testNonRepeatableRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpPost post = new HttpPost("/test");
        post.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)post);
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)args[1];
                request.getEntity().writeTo((OutputStream)new ByteArrayOutputStream());
                throw new IOException("Ka-boom");
            }
        });
        Mockito.when((Object)this.retryHandler.retryRequest((IOException)Mockito.any(), Mockito.eq((int)1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        try {
            this.retryExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ClientExecChain)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.same((Object)context), (HttpExecutionAware)Mockito.same((Object)this.execAware));
            throw ex;
        }
    }
}

