/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestBasicHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    @Mock
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    @Mock
    private ConnectionSocketFactory plainSocketFactory;
    @Mock
    private LayeredConnectionSocketFactory sslSocketFactory;
    @Mock
    private Socket socket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    private BasicHttpClientConnectionManager mgr;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mgr = new BasicHttpClientConnectionManager(this.socketFactoryRegistry, this.connFactory, this.schemePortResolver, this.dnsResolver);
    }

    @Test
    public void testLeaseReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertFalse((boolean)conn1.isOpen());
        this.mgr.releaseConnection(conn1, null, 100L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)this.mgr.getRoute());
        Assert.assertNull((Object)this.mgr.getState());
        ConnectionRequest connRequest2 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn2 = connRequest2.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isOpen());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
    }

    @Test
    public void testLeaseReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.releaseConnection(conn1, null, 10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        ConnectionRequest connRequest2 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn2 = connRequest2.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((boolean)conn2.isOpen());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
    }

    @Test
    public void testLeaseReleaseReusableWithState() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, (Object)"some state");
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.releaseConnection(conn1, (Object)"some other state", 10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals((Object)"some other state", (Object)this.mgr.getState());
        ConnectionRequest connRequest2 = this.mgr.requestConnection(route, (Object)"some other state");
        HttpClientConnection conn2 = connRequest2.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertTrue((boolean)conn2.isOpen());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
    }

    @Test
    public void testLeaseDifferentRoute() throws Exception {
        HttpHost target1 = new HttpHost("somehost");
        HttpRoute route1 = new HttpRoute(target1);
        Mockito.when((Object)this.connFactory.create(Mockito.any(), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route1, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route1), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.releaseConnection(conn1, null, 0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route1, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        HttpHost target2 = new HttpHost("otherhost");
        HttpRoute route2 = new HttpRoute(target2);
        ConnectionRequest connRequest2 = this.mgr.requestConnection(route2, null);
        HttpClientConnection conn2 = connRequest2.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isOpen());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close();
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route1), (ConnectionConfig)Mockito.any());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route2), (ConnectionConfig)Mockito.any());
    }

    @Test
    public void testLeaseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.releaseConnection(conn1, null, 10L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(50L);
        ConnectionRequest connRequest2 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn2 = connRequest2.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        Assert.assertFalse((boolean)conn2.isOpen());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close();
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLeaseInvalidArg() throws Exception {
        this.mgr.requestConnection(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReleaseInvalidArg() throws Exception {
        this.mgr.releaseConnection(null, null, 0L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=IllegalStateException.class)
    public void testReleaseAnotherConnection() throws Exception {
        HttpClientConnection wrongCon = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        this.mgr.releaseConnection(wrongCon, null, 0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testShutdown() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        this.mgr.releaseConnection(conn1, null, 0L, TimeUnit.MILLISECONDS);
        this.mgr.shutdown();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).shutdown();
        try {
            ConnectionRequest connRequest2 = this.mgr.requestConnection(route, null);
            connRequest2.get(0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.mgr.closeExpiredConnections();
        this.mgr.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        this.mgr.shutdown();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testCloseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.releaseConnection(conn1, null, 10L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(50L);
        this.mgr.closeExpiredConnections();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close();
    }

    @Test
    public void testCloseIdle() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.releaseConnection(conn1, null, 0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assert.assertEquals(null, (Object)this.mgr.getState());
        Thread.sleep(100L);
        this.mgr.closeIdleConnections(50L, TimeUnit.MILLISECONDS);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close();
    }

    @Test(expected=IllegalStateException.class)
    public void testAlreadyLeased() throws Exception {
        HttpHost target = new HttpHost("somehost");
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        this.mgr.releaseConnection(conn1, null, 100L, TimeUnit.MILLISECONDS);
        this.mgr.getConnection(route, null);
        this.mgr.getConnection(route, null);
    }

    @Test
    public void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("somehost", -1, "https");
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(conn1, route, 123, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(123, this.socket, target, new InetSocketAddress(remote, 8443), new InetSocketAddress(local, 0), (HttpContext)context);
        this.mgr.routeComplete(conn1, route, (HttpContext)context);
    }

    @Test
    public void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("somehost", -1, "https");
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        Mockito.when((Object)this.connFactory.create(Mockito.eq((Object)route), (ConnectionConfig)Mockito.any())).thenReturn((Object)this.conn);
        ConnectionRequest connRequest1 = this.mgr.requestConnection(route, null);
        HttpClientConnection conn1 = connRequest1.get(0L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.sslSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(conn1, route, 123, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(123, this.socket, proxy, new InetSocketAddress(remote, 8080), new InetSocketAddress(local, 0), (HttpContext)context);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        this.mgr.upgrade(conn1, route, (HttpContext)context);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((LayeredConnectionSocketFactory)Mockito.verify((Object)this.sslSocketFactory, (VerificationMode)Mockito.times((int)1))).createLayeredSocket(this.socket, "somehost", 8443, (HttpContext)context);
        this.mgr.routeComplete(conn1, route, (HttpContext)context);
    }
}

