/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCookie2Support
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.startServer();
        this.httpclient = HttpClients.createDefault();
    }

    @Test
    public void testCookieVersionSupportHeader1() throws Exception {
        this.localServer.register("*", new CookieVer0Service());
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        HttpGet httpget = new HttpGet("/test/");
        CloseableHttpResponse response1 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e1 = response1.getEntity();
        EntityUtils.consume((HttpEntity)e1);
        List cookies = cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        CloseableHttpResponse response2 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e2 = response2.getEntity();
        EntityUtils.consume((HttpEntity)e2);
        HttpRequest reqWrapper = context.getRequest();
        Header cookiesupport = reqWrapper.getFirstHeader("Cookie2");
        Assert.assertNotNull((Object)cookiesupport);
        Assert.assertEquals((Object)"$Version=1", (Object)cookiesupport.getValue());
    }

    @Test
    public void testCookieVersionSupportHeader2() throws Exception {
        this.localServer.register("*", new CookieVer1Service());
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        HttpGet httpget = new HttpGet("/test/");
        CloseableHttpResponse response1 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e1 = response1.getEntity();
        EntityUtils.consume((HttpEntity)e1);
        List cookies = cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)2L, (long)cookies.size());
        CloseableHttpResponse response2 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e2 = response2.getEntity();
        EntityUtils.consume((HttpEntity)e2);
        HttpRequest reqWrapper = context.getRequest();
        Header cookiesupport = reqWrapper.getFirstHeader("Cookie2");
        Assert.assertNotNull((Object)cookiesupport);
        Assert.assertEquals((Object)"$Version=1", (Object)cookiesupport.getValue());
    }

    @Test
    public void testCookieVersionSupportHeader3() throws Exception {
        this.localServer.register("*", new CookieVer2Service());
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        HttpGet httpget = new HttpGet("/test/");
        CloseableHttpResponse response1 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e1 = response1.getEntity();
        EntityUtils.consume((HttpEntity)e1);
        List cookies = cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        CloseableHttpResponse response2 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e2 = response2.getEntity();
        EntityUtils.consume((HttpEntity)e2);
        HttpRequest reqWrapper = context.getRequest();
        Header cookiesupport = reqWrapper.getFirstHeader("Cookie2");
        Assert.assertNotNull((Object)cookiesupport);
        Assert.assertEquals((Object)"$Version=1", (Object)cookiesupport.getValue());
    }

    @Test
    public void testSetCookieVersionMix() throws Exception {
        this.localServer.register("*", new SetCookieVersionMixService());
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        HttpGet httpget = new HttpGet("/test/");
        CloseableHttpResponse response1 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        HttpEntity e1 = response1.getEntity();
        EntityUtils.consume((HttpEntity)e1);
        List cookies = cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"right", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertTrue((boolean)(cookies.get(0) instanceof SetCookie2));
    }

    private static class SetCookieVersionMixService
    implements HttpRequestHandler {
        private SetCookieVersionMixService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion httpversion = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(httpversion, 200);
            response.addHeader((Header)new BasicHeader("Set-Cookie", "name=wrong; Path=/test"));
            response.addHeader((Header)new BasicHeader("Set-Cookie2", "name=right; Path=\"/test\"; Version=1"));
            StringEntity entity = new StringEntity("whatever");
            response.setEntity((HttpEntity)entity);
        }
    }

    private static class CookieVer2Service
    implements HttpRequestHandler {
        private CookieVer2Service() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion httpversion = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(httpversion, 200);
            response.addHeader((Header)new BasicHeader("Set-Cookie2", "name2=value2; Path=\"/test\"; Version=2"));
            StringEntity entity = new StringEntity("whatever");
            response.setEntity((HttpEntity)entity);
        }
    }

    private static class CookieVer1Service
    implements HttpRequestHandler {
        private CookieVer1Service() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion httpversion = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(httpversion, 200);
            response.addHeader((Header)new BasicHeader("Set-Cookie", "name1=value1; Path=\"/test\"; Version=1"));
            response.addHeader((Header)new BasicHeader("Set-Cookie2", "name2=value2; Path=\"/test\"; Version=1"));
            StringEntity entity = new StringEntity("whatever");
            response.setEntity((HttpEntity)entity);
        }
    }

    private static class CookieVer0Service
    implements HttpRequestHandler {
        private CookieVer0Service() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion httpversion = request.getRequestLine().getProtocolVersion();
            response.setStatusLine(httpversion, 200);
            response.addHeader((Header)new BasicHeader("Set-Cookie", "name1=value1; path=/test"));
            StringEntity entity = new StringEntity("whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

