/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientAuthenticationFakeNTLM
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
    }

    @Test
    public void testNTLMAuthenticationFailure() throws Exception {
        this.localServer.register("*", new NtlmResponseHandler());
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials("test", "test", null, null));
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testNTLMv1Type2Message() throws Exception {
        this.localServer.register("*", new NtlmType2MessageResponseHandler("TlRMTVNTUAACAAAADAAMADgAAAAzggLiASNFZ4mrze8AAAAAAAAAAAAAAAAAAAAABgBwFwAAAA9TAGUAcgB2AGUAcgA="));
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials("test", "test", null, null));
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testNTLMv2Type2Message() throws Exception {
        this.localServer.register("*", new NtlmType2MessageResponseHandler("TlRMTVNTUAACAAAADAAMADgAAAAzgoriASNFZ4mrze8AAAAAAAAAACQAJABEAAAABgBwFwAAAA9TAGUAcgB2AGUAcgACAAwARABvAG0AYQBpAG4AAQAMAFMAZQByAHYAZQByAAAAAAA="));
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials("test", "test", null, null));
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testNTLMType2MessageOnlyAuthenticationFailure() throws Exception {
        this.localServer.register("*", new NtlmType2MessageOnlyResponseHandler("TlRMTVNTUAACAAAADAAMADgAAAAzggLiASNFZ4mrze8AAAAAAAAAAAAAAAAAAAAABgBwFwAAAA9TAGUAcgB2AGUAcgA="));
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials("test", "test", null, null));
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testNTLMType2NonUnicodeMessageOnlyAuthenticationFailure() throws Exception {
        this.localServer.register("*", new NtlmType2MessageOnlyResponseHandler("TlRMTVNTUAACAAAABgAGADgAAAAyggLiASNFZ4mrze8AAAAAAAAAAAAAAAAAAAAABgBwFwAAAA9TZXJ2ZXI="));
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials("test", "test", null, null));
        this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpClientContext context = HttpClientContext.create();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
    }

    static class NtlmType2MessageOnlyResponseHandler
    implements HttpRequestHandler {
        private final String authenticateHeaderValue;

        public NtlmType2MessageOnlyResponseHandler(String type2Message) {
            this.authenticateHeaderValue = "NTLM " + type2Message;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Authentication Required"));
            response.setHeader("Connection", "Keep-Alive");
            response.setHeader("WWW-Authenticate", this.authenticateHeaderValue);
        }
    }

    static class NtlmType2MessageResponseHandler
    implements HttpRequestHandler {
        private final String authenticateHeaderValue;

        public NtlmType2MessageResponseHandler(String type2Message) {
            this.authenticateHeaderValue = "NTLM " + type2Message;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Authentication Required"));
            response.setHeader("Connection", "Keep-Alive");
            if (!request.containsHeader("Authorization")) {
                response.setHeader("WWW-Authenticate", "NTLM");
            } else {
                response.setHeader("WWW-Authenticate", this.authenticateHeaderValue);
            }
        }
    }

    static class NtlmResponseHandler
    implements HttpRequestHandler {
        NtlmResponseHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "Authentication Required"));
            response.setHeader("Connection", "Keep-Alive");
            response.setHeader("WWW-Authenticate", "NTLM");
        }
    }
}

