/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class URLEncodedUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char[] DELIM = new char[]{'&'};

    public static List<NameValuePair> parse(URI uri, String encoding) {
        String query = uri.getRawQuery();
        if (query != null && query.length() > 0) {
            return URLEncodedUtils.parse(query, encoding);
        }
        return Collections.emptyList();
    }

    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        String content;
        HeaderElement[] elems;
        List<NameValuePair> result = Collections.emptyList();
        String contentType = null;
        String charset = null;
        Header h = entity.getContentType();
        if (h != null && (elems = h.getElements()).length > 0) {
            HeaderElement elem = elems[0];
            contentType = elem.getName();
            NameValuePair param = elem.getParameterByName("charset");
            if (param != null) {
                charset = param.getValue();
            }
        }
        if (contentType != null && contentType.equalsIgnoreCase(CONTENT_TYPE) && (content = EntityUtils.toString((HttpEntity)entity, (String)"ASCII")) != null && content.length() > 0) {
            result = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(result, new Scanner(content), charset);
        }
        return result;
    }

    public static boolean isEncoded(HttpEntity entity) {
        Header h = entity.getContentType();
        if (h != null) {
            HeaderElement[] elems = h.getElements();
            if (elems.length > 0) {
                String contentType = elems[0].getName();
                return contentType.equalsIgnoreCase(CONTENT_TYPE);
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public static void parse(List<NameValuePair> parameters, Scanner scanner, String encoding) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name = URLEncodedUtils.decode(nameValue[0], encoding);
            String value = null;
            if (nameValue.length == 2) {
                value = URLEncodedUtils.decode(nameValue[1], encoding);
            }
            parameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    public static List<NameValuePair> parse(String s, String encoding) {
        if (s == null) {
            return Collections.emptyList();
        }
        BasicHeaderValueParser parser = BasicHeaderValueParser.DEFAULT;
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair nvp = parser.parseNameValuePair(buffer, cursor, DELIM);
            if (nvp.getName().length() <= 0) continue;
            list.add((NameValuePair)new BasicNameValuePair(URLEncodedUtils.decode(nvp.getName(), encoding), URLEncodedUtils.decode(nvp.getValue(), encoding)));
        }
        return list;
    }

    public static String format(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), encoding);
            String encodedValue = URLEncodedUtils.encode(nameValuePair.getValue(), encoding);
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    public static String format(Iterable<? extends NameValuePair> parameters, String charset) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), charset);
            String encodedValue = URLEncodedUtils.encode(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String decode(String content, String charset) {
        if (content == null) {
            return null;
        }
        try {
            return URLDecoder.decode(content, charset != null ? charset : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private static String encode(String content, String charset) {
        if (content == null) {
            return null;
        }
        try {
            return URLEncoder.encode(content, charset != null ? charset : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

