/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.protocol.HttpContext;

public class RequestAddCookies
implements HttpRequestInterceptor {
    private static final Log LOG = LogFactory.getLog(RequestAddCookies.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        int ver;
        URI requestURI;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            LOG.info((Object)"Cookie store not available in HTTP context");
            return;
        }
        CookieSpecRegistry registry = (CookieSpecRegistry)context.getAttribute("http.cookiespec-registry");
        if (registry == null) {
            LOG.info((Object)"CookieSpec registry not available in HTTP context");
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            throw new IllegalStateException("Target host not specified in HTTP context");
        }
        ManagedClientConnection conn = (ManagedClientConnection)context.getAttribute("http.connection");
        if (conn == null) {
            throw new IllegalStateException("Client connection not specified in HTTP context");
        }
        String policy = HttpClientParams.getCookiePolicy(request.getParams());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CookieSpec selected: " + policy));
        }
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid request URI: " + request.getRequestLine().getUri(), (Throwable)ex);
            }
        }
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            port = conn.getRemotePort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port, requestURI.getPath(), conn.isSecure());
        CookieSpec cookieSpec = registry.getCookieSpec(policy, request.getParams());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (!cookieSpec.match(cookie, cookieOrigin)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cookie " + cookie + " match " + cookieOrigin));
            }
            matchedCookies.add(cookie);
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion()) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header);
            }
        }
        context.setAttribute("http.cookie-spec", (Object)cookieSpec);
        context.setAttribute("http.cookie-origin", (Object)cookieOrigin);
    }
}

