/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.URI;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.DefaultClientRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpClient
implements HttpClient {
    private HttpContext defaultContext;
    private HttpParams defaultParams;
    private ClientConnectionManager connManager;
    private ConnectionReuseStrategy reuseStrategy;
    private CookieSpecRegistry supportedCookieSpecs;
    private AuthSchemeRegistry supportedAuthSchemes;
    private BasicHttpProcessor httpProcessor;
    private HttpRequestRetryHandler retryHandler;
    private RedirectHandler redirectHandler;
    private AuthenticationHandler targetAuthHandler;
    private AuthenticationHandler proxyAuthHandler;
    private CookieStore cookieStore;
    private CredentialsProvider credsProvider;
    private HttpRoutePlanner routePlanner;

    protected AbstractHttpClient(ClientConnectionManager conman, HttpParams params) {
        this.defaultParams = params;
        this.connManager = conman;
    }

    protected abstract HttpParams createHttpParams();

    protected abstract HttpContext createHttpContext();

    protected abstract ClientConnectionManager createClientConnectionManager();

    protected abstract AuthSchemeRegistry createAuthSchemeRegistry();

    protected abstract CookieSpecRegistry createCookieSpecRegistry();

    protected abstract ConnectionReuseStrategy createConnectionReuseStrategy();

    protected abstract BasicHttpProcessor createHttpProcessor();

    protected abstract HttpRequestRetryHandler createHttpRequestRetryHandler();

    protected abstract RedirectHandler createRedirectHandler();

    protected abstract AuthenticationHandler createTargetAuthenticationHandler();

    protected abstract AuthenticationHandler createProxyAuthenticationHandler();

    protected abstract CookieStore createCookieStore();

    protected abstract CredentialsProvider createCredentialsProvider();

    protected abstract void populateContext(HttpContext var1);

    protected abstract HttpRoutePlanner createHttpRoutePlanner();

    public final synchronized HttpRoutePlanner getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = this.createHttpRoutePlanner();
        }
        return this.routePlanner;
    }

    public synchronized void setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    @Override
    public final synchronized HttpParams getParams() {
        if (this.defaultParams == null) {
            this.defaultParams = this.createHttpParams();
        }
        return this.defaultParams;
    }

    public synchronized void setParams(HttpParams params) {
        this.defaultParams = params;
    }

    @Override
    public final synchronized ClientConnectionManager getConnectionManager() {
        if (this.connManager == null) {
            this.connManager = this.createClientConnectionManager();
        }
        return this.connManager;
    }

    public final synchronized AuthSchemeRegistry getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    public synchronized void setAuthSchemes(AuthSchemeRegistry authSchemeRegistry) {
        this.supportedAuthSchemes = authSchemeRegistry;
    }

    public final synchronized CookieSpecRegistry getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    public synchronized void setCookieSpecs(CookieSpecRegistry cookieSpecRegistry) {
        this.supportedCookieSpecs = cookieSpecRegistry;
    }

    public final synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    public synchronized void setReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    public final synchronized HttpRequestRetryHandler getHttpRequestRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = this.createHttpRequestRetryHandler();
        }
        return this.retryHandler;
    }

    public synchronized void setHttpRequestRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public final synchronized RedirectHandler getRedirectHandler() {
        if (this.redirectHandler == null) {
            this.redirectHandler = this.createRedirectHandler();
        }
        return this.redirectHandler;
    }

    public synchronized void setRedirectHandler(RedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    public final synchronized AuthenticationHandler getTargetAuthenticationHandler() {
        if (this.targetAuthHandler == null) {
            this.targetAuthHandler = this.createTargetAuthenticationHandler();
        }
        return this.targetAuthHandler;
    }

    public synchronized void setTargetAuthenticationHandler(AuthenticationHandler targetAuthHandler) {
        this.targetAuthHandler = targetAuthHandler;
    }

    public final synchronized AuthenticationHandler getProxyAuthenticationHandler() {
        if (this.proxyAuthHandler == null) {
            this.proxyAuthHandler = this.createProxyAuthenticationHandler();
        }
        return this.proxyAuthHandler;
    }

    public synchronized void setProxyAuthenticationHandler(AuthenticationHandler proxyAuthHandler) {
        this.proxyAuthHandler = proxyAuthHandler;
    }

    public final synchronized CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = this.createCookieStore();
        }
        return this.cookieStore;
    }

    public synchronized void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public final synchronized CredentialsProvider getCredentialsProvider() {
        if (this.credsProvider == null) {
            this.credsProvider = this.createCredentialsProvider();
        }
        return this.credsProvider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    protected final synchronized BasicHttpProcessor getHttpProcessor() {
        if (this.httpProcessor == null) {
            this.httpProcessor = this.createHttpProcessor();
        }
        return this.httpProcessor;
    }

    @Override
    public final synchronized HttpContext getDefaultContext() {
        if (this.defaultContext == null) {
            this.defaultContext = this.createHttpContext();
        }
        this.populateContext(this.defaultContext);
        return this.defaultContext;
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
    }

    public synchronized HttpResponseInterceptor getResponseInterceptor(int index) {
        return this.getHttpProcessor().getResponseInterceptor(index);
    }

    public synchronized int getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    public synchronized void clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
    }

    public void removeResponseInterceptorByClass(Class<HttpResponseInterceptor> clazz) {
        this.getHttpProcessor().removeResponseInterceptorByClass(clazz);
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
    }

    public synchronized HttpRequestInterceptor getRequestInterceptor(int index) {
        return this.getHttpProcessor().getRequestInterceptor(index);
    }

    public synchronized int getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    public synchronized void clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
    }

    public void removeRequestInterceptorByClass(Class<HttpRequestInterceptor> clazz) {
        this.getHttpProcessor().removeRequestInterceptorByClass(clazz);
    }

    @Override
    public final HttpResponse execute(HttpUriRequest request) throws HttpException, IOException, InterruptedException {
        return this.execute(request, null);
    }

    @Override
    public final HttpResponse execute(HttpUriRequest request, HttpContext context) throws HttpException, IOException, InterruptedException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            target = new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme());
        }
        return this.execute(target, request, context);
    }

    @Override
    public final HttpResponse execute(HttpHost target, HttpRequest request) throws HttpException, IOException, InterruptedException {
        return this.execute(target, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException, InterruptedException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        DefaultClientRequestDirector director = null;
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            if (context == null) {
                context = new BasicHttpContext(this.getDefaultContext());
            }
            director = new DefaultClientRequestDirector(this.getConnectionManager(), this.getConnectionReuseStrategy(), this.getRoutePlanner(), (HttpProcessor)this.getHttpProcessor().copy(), this.getHttpRequestRetryHandler(), this.getRedirectHandler(), this.getTargetAuthenticationHandler(), this.getProxyAuthenticationHandler(), this.determineParams(request));
        }
        HttpResponse response = director.execute(target, request, context);
        return response;
    }

    protected HttpParams determineParams(HttpRequest req) {
        return new ClientParamsStack(null, this.getParams(), req.getParams(), null);
    }
}

