/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.impl.SocketHttpClientConnection;
import org.apache.http.impl.conn.LoggingHttpDataReceiverDecorator;
import org.apache.http.impl.conn.LoggingHttpDataTransmitterDecorator;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.params.HttpParams;

public class DefaultClientConnection
extends SocketHttpClientConnection
implements OperatedClientConnection {
    private static final Log HEADERS_LOG = LogFactory.getLog((String)"org.apache.http.headers");
    private static final Log WIRE_LOG = LogFactory.getLog((String)"org.apache.http.wire");
    private static final Log LOG = LogFactory.getLog((Class)DefaultClientConnection.class);
    private volatile Socket announcedSocket;
    private HttpHost targetHost;
    private boolean connSecure;

    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    public final boolean isSecure() {
        return this.connSecure;
    }

    public final Socket getSocket() {
        return super.getSocket();
    }

    public void announce(Socket sock) {
        this.assertNotOpen();
        this.announcedSocket = sock;
    }

    public void shutdown() throws IOException {
        LOG.debug((Object)"Connection shut down");
        Socket sock = this.announcedSocket;
        if (sock != null) {
            sock.close();
        }
        super.shutdown();
    }

    public void close() throws IOException {
        LOG.debug((Object)"Connection closed");
        super.close();
    }

    protected HttpDataReceiver createHttpDataReceiver(Socket socket, int buffersize, HttpParams params) throws IOException {
        HttpDataReceiver receiver = super.createHttpDataReceiver(socket, buffersize, params);
        if (WIRE_LOG.isDebugEnabled()) {
            receiver = new LoggingHttpDataReceiverDecorator(receiver, new Wire(WIRE_LOG));
        }
        return receiver;
    }

    protected HttpDataTransmitter createHttpDataTransmitter(Socket socket, int buffersize, HttpParams params) throws IOException {
        HttpDataTransmitter transmitter = super.createHttpDataTransmitter(socket, buffersize, params);
        if (WIRE_LOG.isDebugEnabled()) {
            transmitter = new LoggingHttpDataTransmitterDecorator(transmitter, new Wire(WIRE_LOG));
        }
        return transmitter;
    }

    public void open(Socket sock, HttpHost target, boolean secure, HttpParams params) throws IOException {
        this.assertNotOpen();
        if (sock == null) {
            throw new IllegalArgumentException("Socket must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.bind(sock, params);
        this.targetHost = target;
        this.connSecure = secure;
        this.announcedSocket = null;
    }

    public void update(Socket sock, HttpHost target, boolean secure, HttpParams params) throws IOException {
        this.assertOpen();
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (sock != null) {
            this.bind(sock, params);
        }
        this.targetHost = target;
        this.connSecure = secure;
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        HttpResponse response = super.receiveResponseHeader();
        if (HEADERS_LOG.isDebugEnabled()) {
            HEADERS_LOG.debug((Object)("<< " + response.getStatusLine().toString()));
            Header[] headers = response.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERS_LOG.debug((Object)("<< " + headers[i].toString()));
            }
        }
        return response;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        super.sendRequestHeader(request);
        if (HEADERS_LOG.isDebugEnabled()) {
            HEADERS_LOG.debug((Object)(">> " + request.getRequestLine().toString()));
            Header[] headers = request.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERS_LOG.debug((Object)(">> " + headers[i].toString()));
            }
        }
    }
}

