/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncRequestProducer;

abstract class BaseHttpAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final URI requestURI;

    public BaseHttpAsyncRequestProducer(URI requestURI) {
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        this.requestURI = requestURI;
    }

    protected abstract HttpRequest createRequest(URI var1);

    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.createRequest(this.requestURI);
    }

    public HttpHost getTarget() {
        return URIUtils.extractHost((URI)this.requestURI);
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
    }

    public boolean isRepeatable() {
        return true;
    }

    public void resetRequest() {
    }
}

