/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import org.apache.hc.client5.http.ssl.TlsVersionParser;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.ParserCursor;

public enum TLS {
    V_1_0("TLSv1", new ProtocolVersion("TLS", 1, 0)),
    V_1_1("TLSv1.1", new ProtocolVersion("TLS", 1, 1)),
    V_1_2("TLSv1.2", new ProtocolVersion("TLS", 1, 2)),
    V_1_3("TLSv1.3", new ProtocolVersion("TLS", 1, 3));

    public final String ident;
    public final ProtocolVersion version;

    private TLS(String ident, ProtocolVersion version) {
        this.ident = ident;
        this.version = version;
    }

    public boolean isSame(ProtocolVersion protocolVersion) {
        return this.version.equals((Object)protocolVersion);
    }

    public boolean isComparable(ProtocolVersion protocolVersion) {
        return this.version.isComparable(protocolVersion);
    }

    public boolean greaterEquals(ProtocolVersion protocolVersion) {
        return this.version.greaterEquals(protocolVersion);
    }

    public boolean lessEquals(ProtocolVersion protocolVersion) {
        return this.version.lessEquals(protocolVersion);
    }

    public static ProtocolVersion parse(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        ParserCursor cursor = new ParserCursor(0, s.length());
        return TlsVersionParser.INSTANCE.parse(s, cursor, null);
    }
}

