/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteTracker;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import org.apache.hc.client5.http.impl.io.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.impl.sync.ClientExecChain;
import org.apache.hc.client5.http.impl.sync.ConnectionHolder;
import org.apache.hc.client5.http.impl.sync.HttpResponseProxy;
import org.apache.hc.client5.http.impl.sync.RequestAbortedException;
import org.apache.hc.client5.http.impl.sync.RequestEntityProxy;
import org.apache.hc.client5.http.impl.sync.TunnelRefusedException;
import org.apache.hc.client5.http.io.ConnectionRequest;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.methods.CloseableHttpResponse;
import org.apache.hc.client5.http.methods.HttpExecutionAware;
import org.apache.hc.client5.http.methods.HttpRequestWrapper;
import org.apache.hc.client5.http.protocol.AuthenticationStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.NonRepeatableRequestException;
import org.apache.hc.client5.http.protocol.UserTokenHandler;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.entity.EntityUtils;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.ImmutableHttpProcessor;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.util.Args;

@Immutable
public class MainClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final UserTokenHandler userTokenHandler;
    private final HttpRouteDirector routeDirector;

    public MainClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, HttpProcessor proxyHttpProcessor, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        Args.notNull((Object)requestExecutor, (String)"HTTP request executor");
        Args.notNull((Object)connManager, (String)"Client connection manager");
        Args.notNull((Object)reuseStrategy, (String)"Connection reuse strategy");
        Args.notNull((Object)keepAliveStrategy, (String)"Connection keep alive strategy");
        Args.notNull((Object)proxyHttpProcessor, (String)"Proxy HTTP processor");
        Args.notNull((Object)targetAuthStrategy, (String)"Target authentication strategy");
        Args.notNull((Object)proxyAuthStrategy, (String)"Proxy authentication strategy");
        Args.notNull((Object)userTokenHandler, (String)"User token handler");
        this.authenticator = new HttpAuthenticator();
        this.routeDirector = new BasicRouteDirector();
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
        this.proxyHttpProcessor = proxyHttpProcessor;
        this.targetAuthStrategy = targetAuthStrategy;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.userTokenHandler = userTokenHandler;
    }

    public MainClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        this(requestExecutor, connManager, reuseStrategy, keepAliveStrategy, (HttpProcessor)new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestTargetHost()}), targetAuthStrategy, proxyAuthStrategy, userTokenHandler);
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull((Object)route, (String)"HTTP route");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)((Object)context), (String)"HTTP context");
        RequestEntityProxy.enhance(request);
        Object userToken = context.getUserToken();
        ConnectionRequest connRequest = this.connManager.requestConnection(route, userToken);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        context.setAttribute("http.connection", managedConn);
        ConnectionHolder connHolder = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            HttpEntity entity;
            HttpResponse response;
            if (execAware != null) {
                execAware.setCancellable(connHolder);
            }
            AuthExchange targetAuthExchange = context.getAuthExchange(route.getTargetHost());
            AuthExchange proxyAuthExchange = route.getProxyHost() != null ? context.getAuthExchange(route.getProxyHost()) : new AuthExchange();
            int execCount = 1;
            while (true) {
                int timeout;
                if (execCount > 1 && !RequestEntityProxy.isRepeatable(request)) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (!managedConn.isOpen()) {
                    this.log.debug((Object)("Opening connection " + route));
                    try {
                        this.establishRoute(managedConn, route, request, context);
                    }
                    catch (TunnelRefusedException ex) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)ex.getMessage());
                        }
                        response = ex.getResponse();
                        break;
                    }
                }
                if ((timeout = config.getSocketTimeout()) >= 0) {
                    managedConn.setSocketTimeout(timeout);
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Executing request " + request.getRequestLine()));
                }
                if (!request.containsHeader("Authorization")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Target auth state: " + (Object)((Object)targetAuthExchange.getState())));
                    }
                    this.authenticator.addAuthResponse(route.getTargetHost(), ChallengeType.TARGET, request, targetAuthExchange, (HttpContext)context);
                }
                if (!request.containsHeader("Proxy-Authorization") && !route.isTunnelled()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Proxy auth state: " + (Object)((Object)proxyAuthExchange.getState())));
                    }
                    this.authenticator.addAuthResponse(route.getProxyHost(), ChallengeType.PROXY, request, proxyAuthExchange, (HttpContext)context);
                }
                if (this.reuseStrategy.keepAlive((HttpRequest)request, response = this.requestExecutor.execute((HttpRequest)request, managedConn, (HttpContext)context), (HttpContext)context)) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response, (HttpContext)context);
                    if (this.log.isDebugEnabled()) {
                        String s = duration > 0L ? "for " + duration + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                        this.log.debug((Object)("Connection can be kept alive " + s));
                    }
                    connHolder.setValidFor(duration, TimeUnit.MILLISECONDS);
                    connHolder.markReusable();
                } else {
                    connHolder.markNonReusable();
                }
                if (request.getMethod().equalsIgnoreCase("TRACE") || !this.needAuthentication(targetAuthExchange, proxyAuthExchange, route, response, context)) break;
                HttpEntity entity2 = (HttpEntity)response.getEntity();
                if (connHolder.isReusable()) {
                    EntityUtils.consume((HttpEntity)entity2);
                } else {
                    managedConn.close();
                    if (proxyAuthExchange.getState() == AuthExchange.State.SUCCESS && proxyAuthExchange.getAuthScheme() != null && proxyAuthExchange.getAuthScheme().isConnectionBased()) {
                        this.log.debug((Object)"Resetting proxy auth state");
                        proxyAuthExchange.reset();
                    }
                    if (targetAuthExchange.getState() == AuthExchange.State.SUCCESS && targetAuthExchange.getAuthScheme() != null && targetAuthExchange.getAuthScheme().isConnectionBased()) {
                        this.log.debug((Object)"Resetting target auth state");
                        targetAuthExchange.reset();
                    }
                }
                HttpRequest original = request.getOriginal();
                if (!original.containsHeader("Authorization")) {
                    request.removeHeaders("Authorization");
                }
                if (!original.containsHeader("Proxy-Authorization")) {
                    request.removeHeaders("Proxy-Authorization");
                }
                ++execCount;
            }
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(route, (HttpContext)context);
                context.setAttribute("http.user-token", userToken);
            }
            if (userToken != null) {
                connHolder.setState(userToken);
            }
            if ((entity = (HttpEntity)response.getEntity()) == null || !entity.isStreaming()) {
                connHolder.releaseConnection();
                return new HttpResponseProxy(response, null);
            }
            return new HttpResponseProxy(response, connHolder);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            connHolder.abortConnection();
            throw ex;
        }
    }

    void establishRoute(HttpClientConnection managedConn, HttpRoute route, HttpRequest request, HttpClientContext context) throws HttpException, IOException {
        int step;
        RequestConfig config = context.getRequestConfig();
        int timeout = config.getConnectTimeout();
        RouteTracker tracker = new RouteTracker(route);
        do {
            HttpRoute fact = tracker.toRoute();
            step = this.routeDirector.nextStep(route, fact);
            switch (step) {
                case 1: {
                    this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, (HttpContext)context);
                    tracker.connectTarget(route.isSecure());
                    break;
                }
                case 2: {
                    this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, (HttpContext)context);
                    HttpHost proxy = route.getProxyHost();
                    tracker.connectProxy(proxy, false);
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnelToTarget(managedConn, route, request, context);
                    this.log.debug((Object)"Tunnel to target created.");
                    tracker.tunnelTarget(secure);
                    break;
                }
                case 4: {
                    int hop = fact.getHopCount() - 1;
                    boolean secure = this.createTunnelToProxy(route, hop, context);
                    this.log.debug((Object)"Tunnel to proxy created.");
                    tracker.tunnelProxy(route.getHopTarget(hop), secure);
                    break;
                }
                case 5: {
                    this.connManager.upgrade(managedConn, route, (HttpContext)context);
                    tracker.layerProtocol(route.isSecure());
                    break;
                }
                case -1: {
                    throw new HttpException("Unable to establish route: planned = " + route + "; current = " + fact);
                }
                case 0: {
                    this.connManager.routeComplete(managedConn, route, (HttpContext)context);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    private boolean createTunnelToTarget(HttpClientConnection managedConn, HttpRoute route, HttpRequest request, HttpClientContext context) throws HttpException, IOException {
        HttpEntity entity;
        int status;
        RequestConfig config = context.getRequestConfig();
        int timeout = config.getConnectTimeout();
        HttpHost target = route.getTargetHost();
        HttpHost proxy = route.getProxyHost();
        AuthExchange proxyAuthExchange = context.getAuthExchange(proxy);
        HttpResponse response = null;
        String authority = target.toHostString();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", authority, request.getProtocolVersion());
        this.requestExecutor.preProcess((HttpRequest)connect, this.proxyHttpProcessor, (HttpContext)context);
        while (response == null) {
            if (!managedConn.isOpen()) {
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, (HttpContext)context);
            }
            connect.removeHeaders("Proxy-Authorization");
            this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, (HttpRequest)connect, proxyAuthExchange, (HttpContext)context);
            response = this.requestExecutor.execute((HttpRequest)connect, managedConn, (HttpContext)context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!config.isAuthenticationEnabled() || !this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, proxyAuthExchange, (HttpContext)context) || !this.authenticator.prepareAuthResponse(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, proxyAuthExchange, (HttpContext)context)) continue;
            if (this.reuseStrategy.keepAlive(request, response, (HttpContext)context)) {
                this.log.debug((Object)"Connection kept alive");
                entity = (HttpEntity)response.getEntity();
                EntityUtils.consume((HttpEntity)entity);
            } else {
                managedConn.close();
            }
            response = null;
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = (HttpEntity)response.getEntity();
            if (entity != null) {
                response.setEntity((Object)new BufferedHttpEntity(entity));
            }
            managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return false;
    }

    private boolean createTunnelToProxy(HttpRoute route, int hop, HttpClientContext context) throws HttpException {
        throw new HttpException("Proxy chains are not supported.");
    }

    private boolean needAuthentication(AuthExchange targetAuthExchange, AuthExchange proxyAuthExchange, HttpRoute route, HttpResponse response, HttpClientContext context) {
        RequestConfig config = context.getRequestConfig();
        if (config.isAuthenticationEnabled()) {
            HttpHost target = context.getTargetHost();
            if (target == null) {
                target = route.getTargetHost();
            }
            if (target.getPort() < 0) {
                target = new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
            }
            boolean targetAuthRequested = this.authenticator.isChallenged(target, ChallengeType.TARGET, response, targetAuthExchange, (HttpContext)context);
            HttpHost proxy = route.getProxyHost();
            if (proxy == null) {
                proxy = route.getTargetHost();
            }
            boolean proxyAuthRequested = this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, proxyAuthExchange, (HttpContext)context);
            if (targetAuthRequested) {
                return this.authenticator.prepareAuthResponse(target, ChallengeType.TARGET, response, this.targetAuthStrategy, targetAuthExchange, (HttpContext)context);
            }
            if (proxyAuthRequested) {
                return this.authenticator.prepareAuthResponse(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, proxyAuthExchange, (HttpContext)context);
            }
        }
        return false;
    }
}

