/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.IOException;
import org.apache.hc.client5.http.protocol.HttpResponseException;
import org.apache.hc.client5.http.sync.ResponseHandler;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.StatusLine;
import org.apache.hc.core5.http.entity.EntityUtils;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = (HttpEntity)response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume((HttpEntity)entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

