/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class WeakList<T>
extends AbstractList<T> {
    private final List<WeakReference<T>> innerList = new ArrayList<WeakReference<T>>();

    @Override
    public T get(int index) {
        return this.innerList.get(index).get();
    }

    @Override
    public int size() {
        this.checkReferences();
        return this.innerList.size();
    }

    @Override
    public boolean add(T t) {
        return this.innerList.add(new WeakReference<T>(t));
    }

    @Override
    public void clear() {
        this.innerList.clear();
    }

    private void checkReferences() {
        ListIterator<WeakReference<T>> references = this.innerList.listIterator();
        while (references.hasNext()) {
            WeakReference<T> reference = references.next();
            if (reference.get() != null) continue;
            references.remove();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new WeakIterator<T>(this.innerList.iterator());
    }

    private class WeakIterator<T>
    implements Iterator<T> {
        private final Iterator<WeakReference<T>> innerIterator;
        private WeakReference<T> next;

        public WeakIterator(Iterator<WeakReference<T>> innerIterator) {
            this.innerIterator = innerIterator;
            this.fetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next != null) {
                Object result = this.next.get();
                this.fetchNext();
                return result;
            }
            throw new NoSuchElementException();
        }

        private void fetchNext() {
            while (this.innerIterator.hasNext()) {
                WeakReference<T> ref = this.innerIterator.next();
                Object obj = ref.get();
                if (obj == null) continue;
                this.next = ref;
                return;
            }
            this.next = null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

