/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Arrays;
import org.apache.hc.core5.net.NamedEndpoint;

public class ConnectTimeoutException
extends InterruptedIOException {
    private static final long serialVersionUID = -4816682903149535989L;
    private final NamedEndpoint namedEndpoint;

    public ConnectTimeoutException() {
        this.namedEndpoint = null;
    }

    public ConnectTimeoutException(String message) {
        super(message);
        this.namedEndpoint = null;
    }

    public ConnectTimeoutException(IOException cause, NamedEndpoint namedEndpoint, InetAddress ... remoteAddresses) {
        super("Connect to " + (namedEndpoint != null ? namedEndpoint : "remote endpoint") + (remoteAddresses != null && remoteAddresses.length > 0 ? " " + Arrays.asList(remoteAddresses) : "") + (cause != null && cause.getMessage() != null ? " failed: " + cause.getMessage() : " timed out"));
        this.namedEndpoint = namedEndpoint;
        this.initCause(cause);
    }

    public NamedEndpoint getHost() {
        return this.namedEndpoint;
    }
}

