/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheEntity;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.Proxies;
import org.apache.hc.client5.http.methods.CloseableHttpResponse;
import org.apache.hc.client5.http.methods.HttpRequestWrapper;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;

@Immutable
class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy validityStrategy) {
        this.validityStrategy = validityStrategy;
    }

    CachedHttpResponseGenerator() {
        this(new CacheValidityPolicy());
    }

    CloseableHttpResponse generateResponse(HttpRequestWrapper request, HttpCacheEntry entry) {
        long age;
        Date now = new Date();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, entry.getStatusCode(), entry.getReasonPhrase());
        response.setHeaders(entry.getAllHeaders());
        if (this.responseShouldContainEntity(request, entry)) {
            CacheEntity entity = new CacheEntity(entry);
            this.addMissingContentLengthHeader((HttpResponse)response, entity);
            response.setEntity((Object)entity);
        }
        if ((age = this.validityStrategy.getCurrentAgeSecs(entry, now)) > 0L) {
            if (age >= Integer.MAX_VALUE) {
                response.setHeader("Age", (Object)"2147483648");
            } else {
                response.setHeader("Age", (Object)("" + (int)age));
            }
        }
        return Proxies.enhanceResponse((HttpResponse)response);
    }

    CloseableHttpResponse generateNotModifiedResponse(HttpCacheEntry entry) {
        Header varyHeader;
        Header cacheControlHeader;
        Header expiresHeader;
        Header contentLocationHeader;
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 304, "Not Modified");
        Header dateHeader = entry.getFirstHeader("Date");
        if (dateHeader == null) {
            dateHeader = new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        }
        response.addHeader(dateHeader);
        Header etagHeader = entry.getFirstHeader("ETag");
        if (etagHeader != null) {
            response.addHeader(etagHeader);
        }
        if ((contentLocationHeader = entry.getFirstHeader("Content-Location")) != null) {
            response.addHeader(contentLocationHeader);
        }
        if ((expiresHeader = entry.getFirstHeader("Expires")) != null) {
            response.addHeader(expiresHeader);
        }
        if ((cacheControlHeader = entry.getFirstHeader("Cache-Control")) != null) {
            response.addHeader(cacheControlHeader);
        }
        if ((varyHeader = entry.getFirstHeader("Vary")) != null) {
            response.addHeader(varyHeader);
        }
        return Proxies.enhanceResponse((HttpResponse)response);
    }

    private void addMissingContentLengthHeader(HttpResponse response, HttpEntity entity) {
        if (this.transferEncodingIsPresent(response)) {
            return;
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength == null) {
            contentLength = new BasicHeader("Content-Length", (Object)Long.toString(entity.getContentLength()));
            response.setHeader(contentLength);
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse response) {
        Header hdr = response.getFirstHeader("Transfer-Encoding");
        return hdr != null;
    }

    private boolean responseShouldContainEntity(HttpRequestWrapper request, HttpCacheEntry cacheEntry) {
        return request.getRequestLine().getMethod().equals("GET") && cacheEntry.getResource() != null;
    }
}

