/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RpcConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RpcConfiguration.class);
    public static final ImmutableSet<String> HIVE_SPARK_RSC_CONFIGS = ImmutableSet.of((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname, (Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname, (Object)HiveConf.ConfVars.SPARK_RPC_CHANNEL_LOG_LEVEL.varname, (Object)HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.varname, (Object)HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.varname, (Object)HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.varname, (Object[])new String[0]);
    public static final ImmutableSet<String> HIVE_SPARK_TIME_CONFIGS = ImmutableSet.of((Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname, (Object)HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname);
    public static final String SERVER_LISTEN_ADDRESS_KEY = "hive.spark.client.server.address";
    public static final String RPC_SASL_OPT_PREFIX = "hive.spark.client.rpc.sasl.";
    private final Map<String, String> config;
    private static final HiveConf DEFAULT_CONF = new HiveConf();

    public RpcConfiguration(Map<String, String> config) {
        this.config = config;
    }

    long getConnectTimeoutMs() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT.varname);
        return value != null ? (long)Integer.parseInt(value) : DEFAULT_CONF.getTimeVar(HiveConf.ConfVars.SPARK_RPC_CLIENT_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    int getMaxMessageSize() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_MAX_MESSAGE_SIZE.defaultIntVal;
    }

    long getServerConnectTimeoutMs() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT.varname);
        return value != null ? Long.parseLong(value) : DEFAULT_CONF.getTimeVar(HiveConf.ConfVars.SPARK_RPC_CLIENT_HANDSHAKE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    int getSecretBits() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_SECRET_RANDOM_BITS.defaultIntVal;
    }

    String getServerAddress() throws IOException {
        String value = this.config.get(SERVER_LISTEN_ADDRESS_KEY);
        if (value != null) {
            return value;
        }
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface ni = ifaces.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    LOG.warn("Your hostname, {}, resolves to a loopback address; using {}  instead (on interface {})", new Object[]{address.getHostName(), addr.getHostAddress(), ni.getName()});
                    LOG.warn("Set '{}' if you need to bind to another address.", (Object)SERVER_LISTEN_ADDRESS_KEY);
                    return addr.getHostAddress();
                }
            }
        }
        LOG.warn("Your hostname, {}, resolves to a loopback address, but we couldn't find  any external IP address!", (Object)address.getHostName());
        LOG.warn("Set {} if you need to bind to another address.", (Object)SERVER_LISTEN_ADDRESS_KEY);
        return address.getHostName();
    }

    String getRpcChannelLogLevel() {
        return this.config.get(HiveConf.ConfVars.SPARK_RPC_CHANNEL_LOG_LEVEL.varname);
    }

    public int getRpcThreadCount() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.varname);
        return value != null ? Integer.parseInt(value) : HiveConf.ConfVars.SPARK_RPC_MAX_THREADS.defaultIntVal;
    }

    public static String getValue(HiveConf conf, String key) {
        if (HIVE_SPARK_TIME_CONFIGS.contains((Object)key)) {
            HiveConf.ConfVars confVar = HiveConf.getConfVars((String)key);
            return String.valueOf(conf.getTimeVar(confVar, TimeUnit.MILLISECONDS));
        }
        return conf.get(key);
    }

    String getSaslMechanism() {
        String value = this.config.get(HiveConf.ConfVars.SPARK_RPC_SASL_MECHANISM.varname);
        return value != null ? value : HiveConf.ConfVars.SPARK_RPC_SASL_MECHANISM.defaultStrVal;
    }

    Map<String, String> getSaslOptions() {
        HashMap<String, String> opts = new HashMap<String, String>();
        ImmutableMap saslOpts = ImmutableMap.builder().put((Object)"javax.security.sasl.credentials", (Object)"credentials").put((Object)"javax.security.sasl.maxbuffer", (Object)"max_buffer").put((Object)"javax.security.sasl.policy.forward", (Object)"policy_forward_secrecy").put((Object)"javax.security.sasl.policy.noactive", (Object)"policy_noactive").put((Object)"javax.security.sasl.policy.noanonymous", (Object)"policy_noanonymous").put((Object)"javax.security.sasl.policy.nodictionary", (Object)"policy_nodictionary").put((Object)"javax.security.sasl.policy.noplaintext", (Object)"policy_noplaintext").put((Object)"javax.security.sasl.policy.credentials", (Object)"policy_pass_credentials").put((Object)"javax.security.sasl.qop", (Object)"qop").put((Object)"javax.security.sasl.rawsendsize", (Object)"raw_send_size").put((Object)"javax.security.sasl.reuse", (Object)"reuse").put((Object)"javax.security.sasl.server.authentication", (Object)"server_auth").put((Object)"javax.security.sasl.strength", (Object)"strength").build();
        for (Map.Entry e : saslOpts.entrySet()) {
            String value = this.config.get(RPC_SASL_OPT_PREFIX + (String)e.getValue());
            if (value == null) continue;
            opts.put((String)e.getKey(), value);
        }
        return opts;
    }
}

