/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.metrics.DataReadMethod;
import org.apache.hive.spark.client.metrics.InputMetrics;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.metrics.ShuffleReadMetrics;
import org.apache.hive.spark.client.metrics.ShuffleWriteMetrics;

@InterfaceAudience.Private
public class MetricsCollection {
    private final List<TaskInfo> taskMetrics = Lists.newArrayList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Metrics getAllMetrics() {
        return this.aggregate((Predicate<TaskInfo>)Predicates.alwaysTrue());
    }

    public Set<Integer> getJobIds() {
        Function<TaskInfo, Integer> fun = new Function<TaskInfo, Integer>(){

            public Integer apply(TaskInfo input) {
                return input.jobId;
            }
        };
        return this.transform((Predicate<TaskInfo>)Predicates.alwaysTrue(), fun);
    }

    public Metrics getJobMetrics(int jobId) {
        return this.aggregate(new JobFilter(jobId));
    }

    public Set<Integer> getStageIds(int jobId) {
        Function<TaskInfo, Integer> fun = new Function<TaskInfo, Integer>(){

            public Integer apply(TaskInfo input) {
                return input.stageId;
            }
        };
        return this.transform(new JobFilter(jobId), fun);
    }

    public Metrics getStageMetrics(int jobId, int stageId) {
        return this.aggregate(new StageFilter(jobId, stageId));
    }

    public Set<Long> getTaskIds(int jobId, int stageId) {
        Function<TaskInfo, Long> fun = new Function<TaskInfo, Long>(){

            public Long apply(TaskInfo input) {
                return input.taskId;
            }
        };
        return this.transform(new StageFilter(jobId, stageId), fun);
    }

    public Metrics getTaskMetrics(final int jobId, final int stageId, final long taskId) {
        Predicate<TaskInfo> filter = new Predicate<TaskInfo>(){

            public boolean apply(TaskInfo input) {
                return jobId == input.jobId && stageId == input.stageId && taskId == input.taskId;
            }
        };
        this.lock.readLock().lock();
        try {
            Iterator it = Collections2.filter(this.taskMetrics, (Predicate)filter).iterator();
            if (it.hasNext()) {
                Metrics metrics = ((TaskInfo)it.next()).metrics;
                return metrics;
            }
            throw new NoSuchElementException("Task not found.");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMetrics(int jobId, int stageId, long taskId, Metrics metrics) {
        this.lock.writeLock().lock();
        try {
            this.taskMetrics.add(new TaskInfo(jobId, stageId, taskId, metrics));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<T> transform(Predicate<TaskInfo> filter, Function<TaskInfo, T> fun) {
        this.lock.readLock().lock();
        try {
            Collection filtered = Collections2.filter(this.taskMetrics, filter);
            HashSet hashSet = Sets.newHashSet((Iterable)Collections2.transform((Collection)filtered, fun));
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metrics aggregate(Predicate<TaskInfo> filter) {
        this.lock.readLock().lock();
        try {
            long executorDeserializeTime = 0L;
            long executorRunTime = 0L;
            long resultSize = 0L;
            long jvmGCTime = 0L;
            long resultSerializationTime = 0L;
            long memoryBytesSpilled = 0L;
            long diskBytesSpilled = 0L;
            boolean hasInputMetrics = false;
            DataReadMethod readMethod = null;
            long bytesRead = 0L;
            boolean hasShuffleReadMetrics = false;
            int remoteBlocksFetched = 0;
            int localBlocksFetched = 0;
            long fetchWaitTime = 0L;
            long remoteBytesRead = 0L;
            long shuffleBytesWritten = 0L;
            long shuffleWriteTime = 0L;
            for (TaskInfo info : Collections2.filter(this.taskMetrics, filter)) {
                Metrics m = info.metrics;
                executorDeserializeTime += m.executorDeserializeTime;
                executorRunTime += m.executorRunTime;
                resultSize += m.resultSize;
                jvmGCTime += m.jvmGCTime;
                resultSerializationTime += m.resultSerializationTime;
                memoryBytesSpilled += m.memoryBytesSpilled;
                diskBytesSpilled += m.diskBytesSpilled;
                if (m.inputMetrics != null) {
                    hasInputMetrics = true;
                    if (readMethod == null) {
                        readMethod = m.inputMetrics.readMethod;
                    } else if (readMethod != m.inputMetrics.readMethod) {
                        readMethod = DataReadMethod.Multiple;
                    }
                    bytesRead += m.inputMetrics.bytesRead;
                }
                if (m.shuffleReadMetrics != null) {
                    hasShuffleReadMetrics = true;
                    remoteBlocksFetched += m.shuffleReadMetrics.remoteBlocksFetched;
                    localBlocksFetched += m.shuffleReadMetrics.localBlocksFetched;
                    fetchWaitTime += m.shuffleReadMetrics.fetchWaitTime;
                    remoteBytesRead += m.shuffleReadMetrics.remoteBytesRead;
                }
                if (m.shuffleWriteMetrics == null) continue;
                shuffleBytesWritten += m.shuffleWriteMetrics.shuffleBytesWritten;
                shuffleWriteTime += m.shuffleWriteMetrics.shuffleWriteTime;
            }
            InputMetrics inputMetrics = null;
            if (hasInputMetrics) {
                inputMetrics = new InputMetrics(readMethod, bytesRead);
            }
            ShuffleReadMetrics shuffleReadMetrics = null;
            if (hasShuffleReadMetrics) {
                shuffleReadMetrics = new ShuffleReadMetrics(remoteBlocksFetched, localBlocksFetched, fetchWaitTime, remoteBytesRead);
            }
            ShuffleWriteMetrics shuffleWriteMetrics = null;
            if (hasShuffleReadMetrics) {
                shuffleWriteMetrics = new ShuffleWriteMetrics(shuffleBytesWritten, shuffleWriteTime);
            }
            Metrics metrics = new Metrics(executorDeserializeTime, executorRunTime, resultSize, jvmGCTime, resultSerializationTime, memoryBytesSpilled, diskBytesSpilled, inputMetrics, shuffleReadMetrics, shuffleWriteMetrics);
            return metrics;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class StageFilter
    implements Predicate<TaskInfo> {
        private final int jobId;
        private final int stageId;

        StageFilter(int jobId, int stageId) {
            this.jobId = jobId;
            this.stageId = stageId;
        }

        public boolean apply(TaskInfo input) {
            return this.jobId == input.jobId && this.stageId == input.stageId;
        }
    }

    private static class JobFilter
    implements Predicate<TaskInfo> {
        private final int jobId;

        JobFilter(int jobId) {
            this.jobId = jobId;
        }

        public boolean apply(TaskInfo input) {
            return this.jobId == input.jobId;
        }
    }

    private static class TaskInfo {
        final int jobId;
        final int stageId;
        final long taskId;
        final Metrics metrics;

        TaskInfo(int jobId, int stageId, long taskId, Metrics metrics) {
            this.jobId = jobId;
            this.stageId = stageId;
            this.taskId = taskId;
            this.metrics = metrics;
        }
    }
}

