/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.PrimitiveLikeHolder;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.variants.Variant;

public interface Type
extends Serializable {
    public TypeID typeId();

    default public boolean isPrimitiveType() {
        return false;
    }

    default public PrimitiveType asPrimitiveType() {
        throw new IllegalArgumentException("Not a primitive type: " + this);
    }

    default public Types.StructType asStructType() {
        throw new IllegalArgumentException("Not a struct type: " + this);
    }

    default public Types.ListType asListType() {
        throw new IllegalArgumentException("Not a list type: " + this);
    }

    default public Types.MapType asMapType() {
        throw new IllegalArgumentException("Not a map type: " + this);
    }

    default public Types.VariantType asVariantType() {
        throw new IllegalArgumentException("Not a variant type: " + this);
    }

    default public boolean isNestedType() {
        return false;
    }

    default public boolean isStructType() {
        return false;
    }

    default public boolean isListType() {
        return false;
    }

    default public boolean isMapType() {
        return false;
    }

    default public boolean isVariantType() {
        return false;
    }

    default public NestedType asNestedType() {
        throw new IllegalArgumentException("Not a nested type: " + this);
    }

    public static abstract class NestedType
    implements Type {
        @Override
        public boolean isNestedType() {
            return true;
        }

        @Override
        public NestedType asNestedType() {
            return this;
        }

        public abstract List<Types.NestedField> fields();

        public abstract Type fieldType(String var1);

        public abstract Types.NestedField field(int var1);
    }

    public static abstract class PrimitiveType
    implements Type {
        @Override
        public boolean isPrimitiveType() {
            return true;
        }

        @Override
        public PrimitiveType asPrimitiveType() {
            return this;
        }

        Object writeReplace() throws ObjectStreamException {
            return new PrimitiveLikeHolder(this.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType that = (PrimitiveType)o;
            return this.typeId() == that.typeId();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{PrimitiveType.class, this.typeId()});
        }
    }

    public static enum TypeID {
        BOOLEAN(Boolean.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        DATE(Integer.class),
        TIME(Long.class),
        TIMESTAMP(Long.class),
        TIMESTAMP_NANO(Long.class),
        STRING(CharSequence.class),
        UUID(UUID.class),
        FIXED(ByteBuffer.class),
        BINARY(ByteBuffer.class),
        DECIMAL(BigDecimal.class),
        GEOMETRY(ByteBuffer.class),
        GEOGRAPHY(ByteBuffer.class),
        STRUCT(StructLike.class),
        LIST(List.class),
        MAP(Map.class),
        VARIANT(Variant.class),
        UNKNOWN(Object.class);

        private final Class<?> javaClass;

        private TypeID(Class<?> javaClass) {
            this.javaClass = javaClass;
        }

        public Class<?> javaClass() {
            return this.javaClass;
        }
    }
}

