/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);
    private static final long MAX_SLEEP_MILLIS = 60000L;
    private static final long BASE_SLEEP_MILLIS = 1000L;

    private RetryUtils() {
    }

    static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int quietTries, int maxTries, @Nullable CleanupAfterFailure cleanupAfterFailure, @Nullable String messageOnRetry) throws Exception {
        Preconditions.checkArgument((maxTries > 0 ? 1 : 0) != 0, (Object)"maxTries > 0");
        Preconditions.checkArgument((quietTries >= 0 ? 1 : 0) != 0, (Object)"quietTries >= 0");
        int nTry = 0;
        int maxRetries = maxTries - 1;
        while (true) {
            try {
                ++nTry;
                return f.perform();
            }
            catch (Throwable e) {
                if (cleanupAfterFailure != null) {
                    cleanupAfterFailure.cleanup();
                }
                if (nTry < maxTries && shouldRetry.test(e)) {
                    RetryUtils.awaitNextRetry(e, messageOnRetry, nTry, maxRetries, nTry <= quietTries);
                    continue;
                }
                Throwables.propagateIfInstanceOf((Throwable)e, Exception.class);
                throw Throwables.propagate((Throwable)e);
            }
            break;
        }
    }

    static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int maxTries) throws Exception {
        return RetryUtils.retry(f, shouldRetry, 0, maxTries);
    }

    static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int quietTries, int maxTries) throws Exception {
        return RetryUtils.retry(f, shouldRetry, quietTries, maxTries, null, null);
    }

    public static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, CleanupAfterFailure onEachFailure, int maxTries, String messageOnRetry) throws Exception {
        return RetryUtils.retry(f, shouldRetry, 0, maxTries, onEachFailure, messageOnRetry);
    }

    private static void awaitNextRetry(Throwable e, @Nullable String messageOnRetry, int nTry, int maxRetries, boolean quiet) throws InterruptedException {
        long sleepMillis = RetryUtils.nextRetrySleepMillis(nTry);
        String fullMessage = messageOnRetry == null ? String.format("Retrying (%d of %d) in %,dms.", nTry, maxRetries, sleepMillis) : String.format("%s, retrying (%d of %d) in %,dms.", messageOnRetry, nTry, maxRetries, sleepMillis);
        if (quiet) {
            LOG.debug(fullMessage, e);
        } else {
            LOG.warn(fullMessage, e);
        }
        Thread.sleep(sleepMillis);
    }

    private static long nextRetrySleepMillis(int nTry) {
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * ThreadLocalRandom.current().nextGaussian(), 0.0), 2.0);
        return (long)(Math.min(60000.0, 1000.0 * Math.pow(2.0, nTry - 1)) * fuzzyMultiplier);
    }

    public static interface Task<T> {
        public T perform() throws Exception;
    }

    public static interface CleanupAfterFailure {
        public void cleanup();
    }
}

