/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.clients.producer;

import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafkaesqueesque.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafkaesqueesque.clients.consumer.OffsetAndMetadata;
import org.apache.kafkaesqueesque.clients.producer.Callback;
import org.apache.kafkaesqueesque.clients.producer.ProducerRecord;
import org.apache.kafkaesqueesque.clients.producer.RecordMetadata;
import org.apache.kafkaesqueesque.common.Metric;
import org.apache.kafkaesqueesque.common.MetricName;
import org.apache.kafkaesqueesque.common.PartitionInfo;
import org.apache.kafkaesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesque.common.errors.ProducerFencedException;

public interface Producer<K, V>
extends Closeable {
    public void initTransactions();

    public void beginTransaction() throws ProducerFencedException;

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2) throws ProducerFencedException;

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, ConsumerGroupMetadata var2) throws ProducerFencedException;

    public void commitTransaction() throws ProducerFencedException;

    public void abortTransaction() throws ProducerFencedException;

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1);

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1, Callback var2);

    public void flush();

    public List<PartitionInfo> partitionsFor(String var1);

    public Map<MetricName, ? extends Metric> metrics();

    @Override
    public void close();

    @Deprecated
    default public void close(long timeout, TimeUnit unit) {
        this.close(Duration.ofMillis(unit.toMillis(timeout)));
    }

    public void close(Duration var1);
}

