/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.clients.consumer.internals;

import org.apache.kafkaesqueesque.clients.ClientResponse;
import org.apache.kafkaesqueesque.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafkaesqueesque.clients.consumer.internals.RequestFuture;
import org.apache.kafkaesqueesque.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafkaesqueesque.common.Node;
import org.apache.kafkaesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesque.common.utils.LogContext;
import org.slf4j.Logger;

public abstract class AsyncClient<T1, Req extends AbstractRequest, Resp extends AbstractResponse, T2> {
    private final Logger log;
    private final ConsumerNetworkClient client;

    AsyncClient(ConsumerNetworkClient client, LogContext logContext) {
        this.client = client;
        this.log = logContext.logger(this.getClass());
    }

    public RequestFuture<T2> sendAsyncRequest(final Node node, final T1 requestData) {
        AbstractRequest.Builder<Req> requestBuilder = this.prepareRequest(node, requestData);
        return this.client.send(node, requestBuilder).compose(new RequestFutureAdapter<ClientResponse, T2>(){

            @Override
            public void onSuccess(ClientResponse value, RequestFuture<T2> future) {
                block4: {
                    AbstractResponse resp;
                    try {
                        resp = value.responseBody();
                    }
                    catch (ClassCastException cce) {
                        AsyncClient.this.log.error("Could not cast response body", (Throwable)cce);
                        future.raise(cce);
                        return;
                    }
                    AsyncClient.this.log.trace("Received {} {} from broker {}", new Object[]{resp.getClass().getSimpleName(), resp, node});
                    try {
                        future.complete(AsyncClient.this.handleResponse(node, requestData, resp));
                    }
                    catch (RuntimeException e) {
                        if (future.isDone()) break block4;
                        future.raise(e);
                    }
                }
            }

            @Override
            public void onFailure(RuntimeException e, RequestFuture<T2> future1) {
                future1.raise(e);
            }
        });
    }

    protected Logger logger() {
        return this.log;
    }

    protected abstract AbstractRequest.Builder<Req> prepareRequest(Node var1, T1 var2);

    protected abstract T2 handleResponse(Node var1, T1 var2, Resp var3);
}

