/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.resource;

import java.util.Objects;
import org.apache.kafkaesque.common.annotation.InterfaceStability;
import org.apache.kafkaesque.common.resource.PatternType;
import org.apache.kafkaesque.common.resource.ResourcePattern;
import org.apache.kafkaesque.common.resource.ResourceType;

@InterfaceStability.Evolving
public class ResourcePatternFilter {
    public static final ResourcePatternFilter ANY = new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY);
    private final ResourceType resourceType;
    private final String name;
    private final PatternType patternType;

    public ResourcePatternFilter(ResourceType resourceType, String name, PatternType patternType) {
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
        this.name = name;
        this.patternType = Objects.requireNonNull(patternType, "patternType");
    }

    public boolean isUnknown() {
        return this.resourceType.isUnknown() || this.patternType.isUnknown();
    }

    public ResourceType resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public PatternType patternType() {
        return this.patternType;
    }

    public boolean matches(ResourcePattern pattern) {
        if (!this.resourceType.equals((Object)ResourceType.ANY) && !this.resourceType.equals((Object)pattern.resourceType())) {
            return false;
        }
        if (!(this.patternType.equals((Object)PatternType.ANY) || this.patternType.equals((Object)PatternType.MATCH) || this.patternType.equals((Object)pattern.patternType()))) {
            return false;
        }
        if (this.name == null) {
            return true;
        }
        if (this.patternType.equals((Object)PatternType.ANY) || this.patternType.equals((Object)pattern.patternType())) {
            return this.name.equals(pattern.name());
        }
        switch (pattern.patternType()) {
            case LITERAL: {
                return this.name.equals(pattern.name()) || pattern.name().equals("*");
            }
            case PREFIXED: {
                return this.name.startsWith(pattern.name());
            }
        }
        throw new IllegalArgumentException("Unsupported PatternType: " + (Object)((Object)pattern.patternType()));
    }

    public boolean matchesAtMostOne() {
        return this.findIndefiniteField() == null;
    }

    public String findIndefiniteField() {
        if (this.resourceType == ResourceType.ANY) {
            return "Resource type is ANY.";
        }
        if (this.resourceType == ResourceType.UNKNOWN) {
            return "Resource type is UNKNOWN.";
        }
        if (this.name == null) {
            return "Resource name is NULL.";
        }
        if (this.patternType == PatternType.MATCH) {
            return "Resource pattern type is MATCH.";
        }
        if (this.patternType == PatternType.UNKNOWN) {
            return "Resource pattern type is UNKNOWN.";
        }
        return null;
    }

    public String toString() {
        return "ResourcePattern(resourceType=" + (Object)((Object)this.resourceType) + ", name=" + (this.name == null ? "<any>" : this.name) + ", patternType=" + (Object)((Object)this.patternType) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePatternFilter resource = (ResourcePatternFilter)o;
        return this.resourceType == resource.resourceType && Objects.equals(this.name, resource.name) && this.patternType == resource.patternType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceType, this.name, this.patternType});
    }
}

