/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class LlapStatusOptionsProcessor {
    private static final String LLAPSTATUS_CONSTANT = "llapstatus";
    private static final long FIND_YARN_APP_TIMEOUT_MS = 20000L;
    private static final long DEFAULT_STATUS_REFRESH_INTERVAL_MS = 1000L;
    private static final long DEFAULT_WATCH_MODE_TIMEOUT_MS = 300000L;
    private static final float DEFAULT_RUNNING_NODES_THRESHOLD = 1.0f;
    private final Options options = new Options();
    private CommandLine commandLine;

    public LlapStatusOptionsProcessor() {
        for (OptionConstants optionConstant : OptionConstants.values()) {
            OptionBuilder.hasArgs((int)optionConstant.getNumArgs());
            OptionBuilder.withArgName((String)optionConstant.getArgName());
            OptionBuilder.withLongOpt((String)optionConstant.getLongOpt());
            OptionBuilder optionBuilder = OptionBuilder.withDescription((String)optionConstant.getDescription());
            if (optionConstant.getShortOpt() == null) {
                this.options.addOption(optionBuilder.create());
                continue;
            }
            this.options.addOption(OptionBuilder.create((char)optionConstant.getShortOpt().charValue()));
        }
    }

    public LlapStatusOptions processOptions(String[] args) throws ParseException {
        this.commandLine = new GnuParser().parse(this.options, args);
        if (this.commandLine.hasOption(OptionConstants.HELP.getShortOpt().charValue())) {
            LlapStatusOptionsProcessor.printUsage();
            return null;
        }
        String name = this.commandLine.getOptionValue(OptionConstants.NAME.getLongOpt());
        long findAppTimeoutMs = 20000L;
        if (this.commandLine.hasOption(OptionConstants.FIND_APP_TIMEOUT.getLongOpt())) {
            findAppTimeoutMs = TimeUnit.MILLISECONDS.convert(Long.parseLong(this.commandLine.getOptionValue(OptionConstants.FIND_APP_TIMEOUT.getLongOpt())), TimeUnit.SECONDS);
        }
        Properties hiveConf = this.commandLine.hasOption(OptionConstants.HIVECONF.getLongOpt()) ? this.commandLine.getOptionProperties(OptionConstants.HIVECONF.getLongOpt()) : new Properties();
        String outputFile = null;
        if (this.commandLine.hasOption(OptionConstants.OUTPUT_FILE.getLongOpt())) {
            outputFile = this.commandLine.getOptionValue(OptionConstants.OUTPUT_FILE.getLongOpt());
        }
        long refreshIntervalMs = 1000L;
        if (this.commandLine.hasOption(OptionConstants.STATUS_REFRESH_INTERVAL.getLongOpt())) {
            long refreshIntervalSec = Long.parseLong(this.commandLine.getOptionValue(OptionConstants.STATUS_REFRESH_INTERVAL.getLongOpt()));
            if (refreshIntervalSec <= 0L) {
                throw new IllegalArgumentException("Refresh interval should be >0");
            }
            refreshIntervalMs = TimeUnit.MILLISECONDS.convert(refreshIntervalSec, TimeUnit.SECONDS);
        }
        boolean watchMode = this.commandLine.hasOption(OptionConstants.WATCH_MODE.getLongOpt());
        long watchTimeoutMs = 300000L;
        if (this.commandLine.hasOption(OptionConstants.WATCH_MODE_TIMEOUT.getLongOpt())) {
            long watchTimeoutSec = Long.parseLong(this.commandLine.getOptionValue(OptionConstants.WATCH_MODE_TIMEOUT.getLongOpt()));
            if (watchTimeoutSec <= 0L) {
                throw new IllegalArgumentException("Watch timeout should be >0");
            }
            watchTimeoutMs = TimeUnit.MILLISECONDS.convert(watchTimeoutSec, TimeUnit.SECONDS);
        }
        boolean isLaunched = !this.commandLine.hasOption(OptionConstants.NOT_LAUNCHED.getLongOpt());
        float runningNodesThreshold = 1.0f;
        if (this.commandLine.hasOption(OptionConstants.RUNNING_NODES_THRESHOLD.getLongOpt()) && ((runningNodesThreshold = Float.parseFloat(this.commandLine.getOptionValue(OptionConstants.RUNNING_NODES_THRESHOLD.getLongOpt()))) < 0.0f || runningNodesThreshold > 1.0f)) {
            throw new IllegalArgumentException("Running nodes threshold value should be between 0.0 and 1.0 (inclusive)");
        }
        return new LlapStatusOptions(name, hiveConf, findAppTimeoutMs, outputFile, refreshIntervalMs, watchMode, watchTimeoutMs, runningNodesThreshold, isLaunched);
    }

    public static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalFactory.get().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable width) {
            // empty catch block
        }
        LlapStatusOptionsProcessor optionsProcessor = new LlapStatusOptionsProcessor();
        hf.printHelp(LLAPSTATUS_CONSTANT, optionsProcessor.options);
    }

    public static class LlapStatusOptions {
        private final String name;
        private final Properties conf;
        private final long findAppTimeoutMs;
        private final String outputFile;
        private final long refreshIntervalMs;
        private final boolean watchMode;
        private final long watchTimeout;
        private final float runningNodesThreshold;
        private final boolean isLaunched;

        public LlapStatusOptions(String name) {
            this(name, new Properties(), 20000L, null, 1000L, false, 300000L, 1.0f, true);
        }

        public LlapStatusOptions(String name, Properties hiveProperties, long findAppTimeoutMs, String outputFile, long refreshIntervalMs, boolean watchMode, long watchTimeoutMs, float runningNodesThreshold, boolean isLaunched) {
            this.name = name;
            this.conf = hiveProperties;
            this.findAppTimeoutMs = findAppTimeoutMs;
            this.outputFile = outputFile;
            this.refreshIntervalMs = refreshIntervalMs;
            this.watchMode = watchMode;
            this.watchTimeout = watchTimeoutMs;
            this.runningNodesThreshold = runningNodesThreshold;
            this.isLaunched = isLaunched;
        }

        public String getName() {
            return this.name;
        }

        public Properties getConf() {
            return this.conf;
        }

        public long getFindAppTimeoutMs() {
            return this.findAppTimeoutMs;
        }

        public String getOutputFile() {
            return this.outputFile;
        }

        public long getRefreshIntervalMs() {
            return this.refreshIntervalMs;
        }

        public boolean isWatchMode() {
            return this.watchMode;
        }

        public boolean isLaunched() {
            return this.isLaunched;
        }

        public long getWatchTimeoutMs() {
            return this.watchTimeout;
        }

        public float getRunningNodesThreshold() {
            return this.runningNodesThreshold;
        }
    }

    static enum OptionConstants {
        NAME("name", 'n', "LLAP cluster name", true),
        FIND_APP_TIMEOUT("findAppTimeout", 'f', "Amount of time(s) that the tool will sleep to wait for the YARN application to start. negative values=wait forever, 0=Do not wait. default=" + TimeUnit.SECONDS.convert(20000L, TimeUnit.MILLISECONDS) + "s", true),
        OUTPUT_FILE("outputFile", 'o', "File to which output should be written (Default stdout)", true),
        WATCH_MODE("watch", 'w', "Watch mode waits until all LLAP daemons are running or subset of the nodes are running (threshold can be specified via -r option) (Default wait until all nodes are running)", false),
        NOT_LAUNCHED("notlaunched", 'l', "In watch mode, do not assume that the application was already launched if there's doubt (e.g. if the last application instance has failed).", false),
        RUNNING_NODES_THRESHOLD("runningNodesThreshold", 'r', "When watch mode is enabled (-w), wait until the specified threshold of nodes are running (Default 1.0 which means 100% nodes are running)", true),
        STATUS_REFRESH_INTERVAL("refreshInterval", 'i', "Amount of time in seconds to wait until subsequent status checks in watch mode. Valid only for watch mode. (Default " + TimeUnit.SECONDS.convert(1000L, TimeUnit.MILLISECONDS) + "s)", true),
        WATCH_MODE_TIMEOUT("watchTimeout", 't', "Exit watch mode if the desired state is not attained until the specified timeout. (Default " + TimeUnit.SECONDS.convert(300000L, TimeUnit.MILLISECONDS) + "s)", true),
        HIVECONF("hiveconf", null, "Use value for given property. Overridden by explicit parameters", "property=value", 2),
        HELP("help", 'H', "Print help information", false);

        private final String longOpt;
        private final Character shortOpt;
        private final String description;
        private final String argName;
        private final int numArgs;

        private OptionConstants(String longOpt, char shortOpt, String description, boolean hasArgs) {
            this(longOpt, Character.valueOf(shortOpt), description, longOpt, hasArgs ? 1 : 0);
        }

        private OptionConstants(String longOpt, Character shortOpt, String description, String argName, int numArgs) {
            this.longOpt = longOpt;
            this.shortOpt = shortOpt;
            this.description = description;
            this.argName = argName;
            this.numArgs = numArgs;
        }

        public String getLongOpt() {
            return this.longOpt;
        }

        public Character getShortOpt() {
            return this.shortOpt;
        }

        public String getDescription() {
            return this.description;
        }

        public String getArgName() {
            return this.argName;
        }

        public int getNumArgs() {
            return this.numArgs;
        }
    }
}

