/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.util.concurrent.Callable;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hive.common.util.FixedSizedObjectPool;

public abstract class EncodedDataConsumer<BatchKey, BatchType extends EncodedColumnBatch<BatchKey>>
implements Consumer<BatchType>,
ReadPipeline {
    private volatile boolean isStopped = false;
    private ConsumerFeedback<BatchType> upstreamFeedback;
    private final Consumer<ColumnVectorBatch> downstreamConsumer;
    private Callable<Void> readCallable;
    private final LlapDaemonIOMetrics ioMetrics;
    private static final int CVB_POOL_SIZE = 128;
    protected final FixedSizedObjectPool<ColumnVectorBatch> cvbPool;

    public EncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, final int colCount, LlapDaemonIOMetrics ioMetrics) {
        this.downstreamConsumer = consumer;
        this.ioMetrics = ioMetrics;
        this.cvbPool = new FixedSizedObjectPool(128, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<ColumnVectorBatch>(){

            public ColumnVectorBatch create() {
                return new ColumnVectorBatch(colCount);
            }

            public void resetBeforeOffer(ColumnVectorBatch t) {
            }
        });
    }

    public void init(ConsumerFeedback<BatchType> upstreamFeedback, Callable<Void> readCallable) {
        this.upstreamFeedback = upstreamFeedback;
        this.readCallable = readCallable;
    }

    @Override
    public Callable<Void> getReadCallable() {
        return this.readCallable;
    }

    public void consumeData(BatchType data) {
        if (this.isStopped) {
            this.returnSourceData(data);
            return;
        }
        long start = System.currentTimeMillis();
        this.decodeBatch(data, this.downstreamConsumer);
        long end = System.currentTimeMillis();
        this.ioMetrics.addDecodeBatchTime(end - start);
        this.returnSourceData(data);
    }

    private void returnSourceData(BatchType data) {
        this.upstreamFeedback.returnData(data);
    }

    protected abstract void decodeBatch(BatchType var1, Consumer<ColumnVectorBatch> var2);

    public void setDone() {
        this.downstreamConsumer.setDone();
    }

    public void setError(Throwable t) {
        this.downstreamConsumer.setError(t);
    }

    @Override
    public void returnData(ColumnVectorBatch data) {
        this.cvbPool.offer((Object)data);
    }

    @Override
    public void stop() {
        this.upstreamFeedback.stop();
        this.isStopped = true;
    }

    @Override
    public void pause() {
        this.upstreamFeedback.pause();
    }

    @Override
    public void unpause() {
        this.upstreamFeedback.unpause();
    }
}

