/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.VariantObjectInspector;
import org.apache.iceberg.variants.Variant;

public final class IcebergVariantObjectInspector
extends VariantObjectInspector {
    private static final ObjectInspector INSTANCE = new IcebergVariantObjectInspector();

    private IcebergVariantObjectInspector() {
    }

    public static ObjectInspector get() {
        return INSTANCE;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        Variant variant = (Variant)data;
        StandardStructObjectInspector.MyField field = (StandardStructObjectInspector.MyField)fieldRef;
        switch (field.getFieldID()) {
            case 0: {
                ByteBuffer metadata = ByteBuffer.allocate(variant.metadata().sizeInBytes());
                variant.metadata().writeTo(metadata, 0);
                return metadata.array();
            }
            case 1: {
                ByteBuffer value = ByteBuffer.allocate(variant.value().sizeInBytes());
                variant.value().writeTo(value, 0);
                return value.array();
            }
        }
        throw new IllegalArgumentException("Unknown field position: " + field.getFieldID());
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        Variant variant = (Variant)data;
        ByteBuffer metadata = ByteBuffer.allocate(variant.metadata().sizeInBytes());
        variant.metadata().writeTo(metadata, 0);
        ByteBuffer value = ByteBuffer.allocate(variant.value().sizeInBytes());
        variant.value().writeTo(value, 0);
        return List.of(metadata.array(), value.array());
    }
}

