/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.CatalogUtils;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.MetastoreLock;
import org.apache.iceberg.hive.NoLock;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.BaseHiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructProjection;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergMetaHook
extends BaseHiveIcebergMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergMetaHook.class);
    static final EnumSet<AlterTableType> SUPPORTED_ALTER_OPS = EnumSet.of(AlterTableType.ADDCOLS, new AlterTableType[]{AlterTableType.REPLACE_COLUMNS, AlterTableType.RENAME_COLUMN, AlterTableType.DROP_COLUMN, AlterTableType.ADDPROPS, AlterTableType.DROPPROPS, AlterTableType.SETPARTITIONSPEC, AlterTableType.UPDATE_COLUMNS, AlterTableType.RENAME, AlterTableType.EXECUTE, AlterTableType.CREATE_BRANCH, AlterTableType.CREATE_TAG, AlterTableType.DROP_BRANCH, AlterTableType.RENAME_BRANCH, AlterTableType.DROPPARTITION, AlterTableType.DROP_TAG, AlterTableType.COMPACT, AlterTableType.REPLACE_SNAPSHOTREF});
    private static final List<String> MIGRATION_ALLOWED_SOURCE_FORMATS = ImmutableList.of(BaseHiveIcebergMetaHook.FileFormat.PARQUET.name().toLowerCase(), BaseHiveIcebergMetaHook.FileFormat.ORC.name().toLowerCase(), BaseHiveIcebergMetaHook.FileFormat.AVRO.name().toLowerCase());
    private static final PartitionDropOptions DROP_OPTIONS = new PartitionDropOptions().deleteData(false).ifExists(true);
    private static final List<org.apache.commons.lang3.tuple.Pair<Integer, byte[]>> EMPTY_FILTER = Lists.newArrayList(org.apache.commons.lang3.tuple.Pair.of((Object)1, (Object)new byte[0]));
    static final String MIGRATED_TO_ICEBERG = "MIGRATED_TO_ICEBERG";
    static final String DECIMAL64_VECTORIZATION = "iceberg.decimal64.vectorization";
    static final String MANUAL_ICEBERG_METADATA_LOCATION_CHANGE = "MANUAL_ICEBERG_METADATA_LOCATION_CHANGE";
    private boolean deleteIcebergTable;
    private FileIO deleteIo;
    private TableMetadata deleteMetadata;
    private boolean isTableMigration;
    private PreAlterTableProperties preAlterTableProperties;
    private UpdateSchema updateSchema;
    private Transaction transaction;
    private AlterTableType currentAlterTableOp;
    private HiveLock commitLock;
    private List<SQLDefaultConstraint> sqlDefaultConstraints;

    public HiveIcebergMetaHook(Configuration conf) {
        super(conf);
    }

    @Override
    public void rollbackCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    @Override
    public void commitCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (this.icebergTable == null) {
            this.setFileFormat(this.catalogProperties.getProperty("write.format.default"));
            String metadataLocation = (String)hmsTable.getParameters().get("metadata_location");
            Table table = metadataLocation != null ? Catalogs.registerTable(this.conf, this.catalogProperties, metadataLocation) : Catalogs.createTable(this.conf, this.catalogProperties);
            if (!HiveTableUtil.isCtas(this.catalogProperties)) {
                return;
            }
            String tableIdentifier = this.catalogProperties.getProperty("name");
            SessionStateUtil.addResource((Configuration)this.conf, (String)"iceberg.mr.ctas.table.name", (Object)tableIdentifier);
            SessionStateUtil.addResource((Configuration)this.conf, (String)tableIdentifier, (Object)table);
            HiveTableUtil.createFileForTableObject(table, this.conf);
        }
    }

    @Override
    public void preDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void preDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean deleteData) {
        this.catalogProperties = CatalogUtils.getCatalogProperties(hmsTable);
        boolean bl = this.deleteIcebergTable = hmsTable.getParameters() != null && "TRUE".equalsIgnoreCase((String)hmsTable.getParameters().get("external.table.purge"));
        if (this.deleteIcebergTable && Catalogs.hiveCatalog(this.conf, this.catalogProperties) && deleteData) {
            try {
                String metadataLocation = (String)hmsTable.getParameters().get("metadata_location");
                this.deleteIo = Catalogs.loadTable(this.conf, this.catalogProperties).io();
                this.deleteMetadata = TableMetadataParser.read(this.deleteIo, metadataLocation);
            }
            catch (Exception e) {
                LOG.error("preDropTable: Error during loading Iceberg table or parsing its metadata for HMS table: {}.{}. In some cases, this might lead to undeleted metadata files under the table directory: {}. Please double check and, if needed, manually delete any dangling files/folders, if any. In spite of this error, the HMS table drop operation should proceed as normal.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), hmsTable.getSd().getLocation(), e});
            }
        }
    }

    @Override
    public void rollbackDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    @Override
    public void commitDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean deleteData) {
        if (deleteData && this.deleteIcebergTable) {
            try {
                if (!Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
                    LOG.info("Dropping with purge all the data for table {}.{}", (Object)hmsTable.getDbName(), (Object)hmsTable.getTableName());
                    Catalogs.dropTable(this.conf, this.catalogProperties);
                } else if (this.deleteMetadata != null && this.deleteIo.newInputFile(this.deleteMetadata.location()).exists()) {
                    CatalogUtil.dropTableData(this.deleteIo, this.deleteMetadata);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception during commitDropTable operation for table {}.{}.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), e});
            }
        }
    }

    public void preAlterTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context) throws MetaException {
        this.catalogProperties = CatalogUtils.getCatalogProperties(hmsTable);
        this.setupAlterOperationType(hmsTable, context);
        if (AlterTableType.RENAME.equals((Object)this.currentAlterTableOp)) {
            this.catalogProperties.put("name", TableIdentifier.of((String)context.getProperties().get("old_db_name"), (String)context.getProperties().get("old_table_name")).toString());
        }
        if (this.commitLock == null) {
            this.commitLock = this.lockObject(hmsTable);
        }
        try {
            this.commitLock.lock();
            this.doPreAlterTable(hmsTable, context);
        }
        catch (Exception e) {
            this.commitLock.unlock();
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
    }

    private HiveLock lockObject(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (!HiveTableOperations.hiveLockEnabled(hmsTable.getParameters(), this.conf) || SessionStateUtil.getQueryState((Configuration)this.conf).map(QueryState::getHiveOperation).filter(opType -> HiveOperation.QUERY == opType).isPresent()) {
            return new NoLock();
        }
        return new MetastoreLock(this.conf, new CachedClientPool(this.conf, Maps.fromProperties(this.catalogProperties)), this.catalogProperties.getProperty("name"), hmsTable.getDbName(), hmsTable.getTableName());
    }

    private void doPreAlterTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context) throws MetaException {
        try {
            this.icebergTable = IcebergTableUtil.getTable(this.conf, this.catalogProperties, true);
        }
        catch (NoSuchTableException nte) {
            context.getProperties().put("migrate_hive_to_iceberg", "true");
            this.assertTableCanBeMigrated(hmsTable);
            this.isTableMigration = true;
            this.setOrcOnlyFilesParam(hmsTable);
            StorageDescriptor sd = hmsTable.getSd();
            this.preAlterTableProperties = new PreAlterTableProperties();
            this.preAlterTableProperties.tableLocation = sd.getLocation();
            this.preAlterTableProperties.format = sd.getInputFormat();
            this.preAlterTableProperties.schema = this.schema(this.catalogProperties, hmsTable, Collections.emptySet(), Collections.emptyList());
            this.preAlterTableProperties.partitionKeys = hmsTable.getPartitionKeys();
            context.getProperties().put("allow_partition_key_change", "true");
            try {
                Hive db = SessionState.get().getHiveDb();
                this.preAlterTableProperties.partitionSpecProxy = db.getMSC().listPartitionSpecs(hmsTable.getCatName(), hmsTable.getDbName(), hmsTable.getTableName(), Integer.MAX_VALUE);
                if (hmsTable.isSetPartitionKeys() && !hmsTable.getPartitionKeys().isEmpty()) {
                    db.dropPartitions(hmsTable.getDbName(), hmsTable.getTableName(), EMPTY_FILTER, DROP_OPTIONS);
                    List spec = PartitionTransform.getPartitionTransformSpec((List)hmsTable.getPartitionKeys());
                    SessionStateUtil.addResourceOrThrow((Configuration)this.conf, (String)"partition_transform_spec", (Object)spec);
                    hmsTable.getSd().getCols().addAll(hmsTable.getPartitionKeys());
                    hmsTable.setPartitionKeysIsSet(false);
                }
            }
            catch (MetaException me) {
                throw me;
            }
            catch (HiveException | TException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            this.preAlterTableProperties.spec = HiveIcebergMetaHook.spec(this.conf, this.preAlterTableProperties.schema, hmsTable);
            sd.setInputFormat(HiveIcebergInputFormat.class.getCanonicalName());
            sd.setOutputFormat(HiveIcebergOutputFormat.class.getCanonicalName());
            sd.setSerdeInfo(new SerDeInfo("icebergSerde", HiveIcebergSerDe.class.getCanonicalName(), Collections.emptyMap()));
            this.setCommonHmsTablePropertiesForIceberg(hmsTable);
            hmsTable.getParameters().put(MIGRATED_TO_ICEBERG, "true");
            NameMapping nameMapping = MappingUtil.create(this.preAlterTableProperties.schema);
            hmsTable.getParameters().put("schema.name-mapping.default", NameMappingParser.toJson(nameMapping));
        }
        if (AlterTableType.ADDCOLS.equals((Object)this.currentAlterTableOp)) {
            this.handleAddColumns(hmsTable);
        } else if (AlterTableType.REPLACE_COLUMNS.equals((Object)this.currentAlterTableOp)) {
            this.assertNotMigratedTable(hmsTable.getParameters(), this.currentAlterTableOp.getName().toUpperCase());
            this.handleReplaceColumns(hmsTable);
        } else if (AlterTableType.DROP_COLUMN.equals((Object)this.currentAlterTableOp)) {
            this.assertNotMigratedTable(hmsTable.getParameters(), this.currentAlterTableOp.getName().toUpperCase());
            this.handleDropColumn(hmsTable);
        } else if (AlterTableType.RENAME_COLUMN.equals((Object)this.currentAlterTableOp)) {
            this.assertNotMigratedTable(hmsTable.getParameters(), "CHANGE COLUMN");
            this.handleChangeColumn(hmsTable);
        } else {
            this.setWriteModeDefaults(this.icebergTable, hmsTable.getParameters(), context);
            this.assertNotCrossTableMetadataLocationChange(hmsTable.getParameters(), context);
        }
        if (!this.isTableMigration) {
            this.setOrcOnlyFilesParam(hmsTable);
        }
    }

    private void assertNotCrossTableMetadataLocationChange(Map<String, String> tblParams, EnvironmentContext context) {
        if (tblParams.containsKey("metadata_location")) {
            Preconditions.checkArgument(this.icebergTable != null, "Cannot perform table migration to Iceberg and setting the snapshot location in one step. Please migrate the table first");
            String newMetadataLocation = tblParams.get("metadata_location");
            FileIO io = ((BaseTable)this.icebergTable).operations().io();
            TableMetadata newMetadata = TableMetadataParser.read(io, newMetadataLocation);
            TableMetadata currentMetadata = ((BaseTable)this.icebergTable).operations().current();
            if (!currentMetadata.uuid().equals(newMetadata.uuid())) {
                throw new UnsupportedOperationException(String.format("Cannot change iceberg table %s metadata location pointing to another table's metadata %s", this.icebergTable.name(), newMetadataLocation));
            }
            if (!currentMetadata.metadataFileLocation().equals(newMetadataLocation) && !context.getProperties().containsKey(MANUAL_ICEBERG_METADATA_LOCATION_CHANGE)) {
                tblParams.put("metadata_location", currentMetadata.metadataFileLocation());
                LOG.warn("Detected an alter table operation attempting to do alterations on an Iceberg table with a stale metadata_location. Considered base metadata_location: {}, Actual metadata_location: {}. Will override this request with the refreshed metadata_location in order to preserve the concurrent commit.", (Object)newMetadataLocation, (Object)currentMetadata.metadataFileLocation());
            }
        }
    }

    private void assertNotMigratedTable(Map<String, String> tblParams, String opType) {
        if (Boolean.parseBoolean(tblParams.get(MIGRATED_TO_ICEBERG))) {
            throw new UnsupportedOperationException(String.format("Cannot perform %s operation on a migrated Iceberg table.", opType));
        }
    }

    private void assertTableCanBeMigrated(org.apache.hadoop.hive.metastore.api.Table hmsTable) throws MetaException {
        boolean hasCorrectTableType;
        StorageDescriptor sd = hmsTable.getSd();
        boolean bl = hasCorrectTableType = MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)hmsTable) && !hmsTable.isTemporary() && !AcidUtils.isTransactionalTable((org.apache.hadoop.hive.metastore.api.Table)hmsTable);
        if (!hasCorrectTableType) {
            throw new MetaException("Converting non-external, temporary or transactional hive table to iceberg table is not allowed.");
        }
        boolean hasCorrectFileFormat = MIGRATION_ALLOWED_SOURCE_FORMATS.stream().anyMatch(f -> sd.getInputFormat().toLowerCase().contains((CharSequence)f));
        if (!hasCorrectFileFormat) {
            throw new MetaException("Cannot convert hive table to iceberg with input format: " + sd.getInputFormat());
        }
        List<TypeInfo> typeInfos = hmsTable.getSd().getCols().stream().map(f -> TypeInfoUtils.getTypeInfoFromTypeString((String)f.getType())).toList();
        for (TypeInfo typeInfo : typeInfos) {
            this.validateColumnType(typeInfo);
        }
    }

    private void validateColumnType(TypeInfo typeInfo) throws MetaException {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                if (!primitiveCategory.equals((Object)PrimitiveObjectInspector.PrimitiveCategory.CHAR) && !primitiveCategory.equals((Object)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR)) break;
                throw new MetaException(String.format("Cannot convert hive table to iceberg that contains column type %s. Use string type columns instead", primitiveCategory));
            }
            case STRUCT: {
                List structTypeInfos = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos();
                for (TypeInfo structTypeInfo : structTypeInfos) {
                    this.validateColumnType(structTypeInfo);
                }
                break;
            }
            case LIST: {
                this.validateColumnType(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                break;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                this.validateColumnType(mapTypeInfo.getMapKeyTypeInfo());
                this.validateColumnType(mapTypeInfo.getMapValueTypeInfo());
            }
        }
    }

    public void commitAlterTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context) throws MetaException {
        if (this.commitLock == null) {
            throw new IllegalStateException("Hive commit lock should already be set");
        }
        this.commitLock.unlock();
        if (this.isTableMigration) {
            this.catalogProperties = CatalogUtils.getCatalogProperties(hmsTable);
            this.catalogProperties.put("iceberg.mr.table.schema", SchemaParser.toJson(this.preAlterTableProperties.schema));
            this.catalogProperties.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(this.preAlterTableProperties.spec));
            this.setFileFormat(this.preAlterTableProperties.format);
            HiveTableUtil.importFiles(this.preAlterTableProperties.tableLocation, this.preAlterTableProperties.format, this.preAlterTableProperties.partitionSpecProxy, this.preAlterTableProperties.partitionKeys, this.catalogProperties, this.conf);
        } else if (this.currentAlterTableOp != null) {
            switch (this.currentAlterTableOp) {
                case DROP_COLUMN: 
                case REPLACE_COLUMNS: 
                case RENAME_COLUMN: 
                case ADDCOLS: {
                    if (this.transaction != null) {
                        this.transaction.commitTransaction();
                    }
                    this.setSqlDefaultConstraints();
                    break;
                }
                case ADDPROPS: 
                case DROPPROPS: {
                    this.alterTableProperties(hmsTable, context.getProperties());
                    break;
                }
                case SETPARTITIONSPEC: {
                    IcebergTableUtil.updateSpec(this.conf, this.icebergTable);
                    break;
                }
                case RENAME: {
                    Catalogs.renameTable(this.conf, this.catalogProperties, TableIdentifier.of(hmsTable.getDbName(), hmsTable.getTableName()));
                }
            }
        }
    }

    private void setSqlDefaultConstraints() {
        try {
            if (this.sqlDefaultConstraints != null && !this.sqlDefaultConstraints.isEmpty()) {
                SessionState.get().getHiveDb().addDefaultConstraint(this.sqlDefaultConstraints);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackAlterTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context) {
        if (this.commitLock == null) {
            throw new IllegalStateException("Hive commit lock should already be set");
        }
        this.commitLock.unlock();
        if (Boolean.parseBoolean(context.getProperties().getOrDefault("migrate_hive_to_iceberg", "false"))) {
            LOG.debug("Initiating rollback for table {} at location {}", (Object)hmsTable.getTableName(), (Object)hmsTable.getSd().getLocation());
            context.getProperties().put("initialize_rollback_migration", "true");
            this.catalogProperties = CatalogUtils.getCatalogProperties(hmsTable);
            try {
                this.icebergTable = Catalogs.loadTable(this.conf, this.catalogProperties);
            }
            catch (NoSuchTableException nte) {
                return;
            }
            String metadataLocation = ((BaseTable)this.icebergTable).operations().current().metadataFileLocation();
            try {
                Path path = new Path(metadataLocation).getParent();
                FileSystem.get((URI)path.toUri(), (Configuration)this.conf).delete(path, true);
                LOG.debug("Metadata directory of iceberg table {} at location {} was deleted", (Object)this.icebergTable.name(), (Object)path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void preTruncateTable(org.apache.hadoop.hive.metastore.api.Table table, EnvironmentContext context, List<String> partNames) throws MetaException {
        Expression finalExp;
        this.catalogProperties = CatalogUtils.getCatalogProperties(table);
        this.icebergTable = Catalogs.loadTable(this.conf, this.catalogProperties);
        Map partitionFieldMap = this.icebergTable.spec().fields().stream().collect(Collectors.toMap(PartitionField::name, Function.identity()));
        Expression expression = finalExp = CollectionUtils.isEmpty(partNames) ? Expressions.alwaysTrue() : Expressions.alwaysFalse();
        if (partNames != null) {
            for (String partName : partNames) {
                LinkedHashMap specMap = Warehouse.makeSpecFromName((String)partName);
                Expression subExp = Expressions.alwaysTrue();
                for (Map.Entry entry : specMap.entrySet()) {
                    String partColValue = URLDecoder.decode((String)entry.getValue(), StandardCharsets.UTF_8);
                    if (partitionFieldMap.containsKey(entry.getKey())) {
                        PartitionField partitionField = (PartitionField)partitionFieldMap.get(entry.getKey());
                        Type resultType = partitionField.transform().getResultType(this.icebergTable.schema().findField(partitionField.sourceId()).type());
                        TransformSpec.TransformType transformType = TransformSpec.fromString((String)partitionField.transform().toString());
                        Object value = Conversions.fromPartitionString(resultType, partColValue);
                        Iterable iterable = () -> Collections.singletonList(value).iterator();
                        if (TransformSpec.TransformType.IDENTITY.equals((Object)transformType)) {
                            UnboundPredicate boundPredicate = Expressions.in(partitionField.name(), iterable);
                            subExp = Expressions.and(subExp, boundPredicate);
                            continue;
                        }
                        throw new MetaException(String.format("Partition transforms are not supported via truncate operation: %s", entry.getKey()));
                    }
                    throw new MetaException(String.format("No partition column/transform name by the name: %s", entry.getKey()));
                }
                finalExp = Expressions.or(finalExp, subExp);
            }
        }
        DeleteFiles delete = this.icebergTable.newDelete();
        String branchName = (String)context.getProperties().get("snapshot_ref");
        if (branchName != null) {
            delete.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
        }
        delete.deleteFromRowFilter(finalExp);
        delete.commit();
        context.putToProperties("truncateSkipDataDeletion", "true");
    }

    @Override
    public boolean createHMSTableInHook() {
        return this.createHMSTableInHook;
    }

    private void alterTableProperties(org.apache.hadoop.hive.metastore.api.Table hmsTable, Map<String, String> contextProperties) {
        Map hmsTableParameters = hmsTable.getParameters();
        Splitter splitter = Splitter.on("'");
        UpdateProperties icebergUpdateProperties = this.icebergTable.updateProperties();
        if (contextProperties.containsKey("set_properties")) {
            splitter.splitToList(contextProperties.get("set_properties")).forEach(k -> icebergUpdateProperties.set((String)k, (String)hmsTableParameters.get(k)));
        } else if (contextProperties.containsKey("unset_properties")) {
            splitter.splitToList(contextProperties.get("unset_properties")).forEach(icebergUpdateProperties::remove);
        }
        icebergUpdateProperties.commit();
    }

    private void setupAlterOperationType(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context) throws MetaException {
        TableName tableName = new TableName(hmsTable.getCatName(), hmsTable.getDbName(), hmsTable.getTableName());
        if (context == null || context.getProperties() == null) {
            throw new MetaException("ALTER TABLE operation type on Iceberg table " + String.valueOf(tableName) + " could not be determined.");
        }
        String stringOpType = (String)context.getProperties().get("alterTableOpType");
        if (stringOpType != null) {
            this.currentAlterTableOp = AlterTableType.valueOf((String)stringOpType);
            if (SUPPORTED_ALTER_OPS.stream().noneMatch(op -> op.equals((Object)this.currentAlterTableOp))) {
                throw new MetaException("Unsupported ALTER TABLE operation type on Iceberg table " + String.valueOf(tableName) + ", must be one of: " + String.valueOf(SUPPORTED_ALTER_OPS));
            }
            if (this.currentAlterTableOp != AlterTableType.ADDPROPS && Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
                context.getProperties().put("skip_metastore_alter", "true");
            }
        }
    }

    private void setFileFormat(String format) {
        if (format == null) {
            return;
        }
        String lowerCaseFormat = format.toLowerCase();
        for (BaseHiveIcebergMetaHook.FileFormat fileFormat : BaseHiveIcebergMetaHook.FileFormat.values()) {
            if (!lowerCaseFormat.contains(fileFormat.getLabel())) continue;
            this.catalogProperties.put("write.format.default", fileFormat.getLabel());
        }
    }

    private void handleAddColumns(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        List<FieldSchema> addedCols = HiveSchemaUtil.getSchemaDiff(hmsTable.getSd().getCols(), HiveSchemaUtil.convert(this.icebergTable.schema()), null, null, false).getMissingFromSecond();
        if (!addedCols.isEmpty()) {
            this.transaction = this.icebergTable.newTransaction();
            this.updateSchema = this.transaction.updateSchema();
        }
        this.sqlDefaultConstraints = SessionStateUtil.getResource((Configuration)this.conf, (String)"columnDefaults").orElse(null);
        Map<String, String> defaultValues = Stream.ofNullable(this.sqlDefaultConstraints).flatMap(Collection::stream).collect(Collectors.toMap(SQLDefaultConstraint::getColumn_name, SQLDefaultConstraint::getDefault_value));
        for (FieldSchema addedCol : addedCols) {
            String defaultValue = defaultValues.get(addedCol.getName());
            Type type = HiveSchemaUtil.convert(TypeInfoUtils.getTypeInfoFromTypeString((String)addedCol.getType()), defaultValue);
            Literal defaultVal = Optional.ofNullable(defaultValue).filter(v -> !type.isStructType()).map(v -> Expressions.lit(HiveSchemaUtil.getDefaultValue(v, type))).orElse(null);
            this.updateSchema.addColumn(addedCol.getName(), type, addedCol.getComment(), defaultVal);
        }
        this.updateSchema.commit();
    }

    private void handleDropColumn(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        List hmsCols = hmsTable.getSd().getCols();
        List<FieldSchema> icebergCols = HiveSchemaUtil.convert(this.icebergTable.schema());
        List<FieldSchema> removedCols = HiveSchemaUtil.getSchemaDiff(icebergCols, hmsCols, null, null, false).getMissingFromSecond();
        if (removedCols.isEmpty()) {
            return;
        }
        this.transaction = this.icebergTable.newTransaction();
        this.transaction.updateSchema().deleteColumn(removedCols.getFirst().getName()).commit();
        LOG.info("handleDropColumn: Dropping the following column for Iceberg table {}, col: {}", (Object)hmsTable.getTableName(), removedCols);
    }

    private void handleReplaceColumns(org.apache.hadoop.hive.metastore.api.Table hmsTable) throws MetaException {
        List hmsCols = hmsTable.getSd().getCols();
        List<FieldSchema> icebergCols = HiveSchemaUtil.convert(this.icebergTable.schema());
        List defaultConstraints = SessionStateUtil.getResource((Configuration)this.conf, (String)"columnDefaults").orElse(null);
        Map<String, String> defaultValues = Optional.ofNullable(defaultConstraints).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(SQLDefaultConstraint::getColumn_name, SQLDefaultConstraint::getDefault_value));
        HiveSchemaUtil.SchemaDifference schemaDifference = HiveSchemaUtil.getSchemaDiff(hmsCols, icebergCols, this.icebergTable.schema(), defaultValues, true);
        if (!schemaDifference.getMissingFromFirst().isEmpty()) {
            schemaDifference.getMissingFromFirst().forEach(icebergCols::remove);
        }
        Pair<String, Optional<String>> outOfOrder = HiveSchemaUtil.getReorderedColumn(hmsCols, icebergCols, ImmutableMap.of());
        if (!(schemaDifference.getMissingFromSecond().isEmpty() && schemaDifference.getTypeChanged().isEmpty() && schemaDifference.getCommentChanged().isEmpty() && outOfOrder == null && schemaDifference.getDefaultChanged().isEmpty())) {
            throw new MetaException("Unsupported operation to use REPLACE COLUMNS for adding a column, changing a column type, column comment, column default or reordering columns. Only use REPLACE COLUMNS for dropping columns. For the other operations, consider using the ADD COLUMNS or CHANGE COLUMN commands.");
        }
        if (schemaDifference.getMissingFromFirst().isEmpty()) {
            throw new MetaException("No schema change detected from REPLACE COLUMNS operations. For rectifying any schema mismatches between HMS and Iceberg, please consider the UPDATE COLUMNS command.");
        }
        this.transaction = this.icebergTable.newTransaction();
        this.updateSchema = this.transaction.updateSchema();
        LOG.info("handleReplaceColumns: Dropping the following columns for Iceberg table {}, cols: {}", (Object)hmsTable.getTableName(), schemaDifference.getMissingFromFirst());
        for (FieldSchema droppedCol : schemaDifference.getMissingFromFirst()) {
            this.updateSchema.deleteColumn(droppedCol.getName());
        }
        this.updateSchema.commit();
    }

    private void handleChangeColumn(org.apache.hadoop.hive.metastore.api.Table hmsTable) throws MetaException {
        List hmsCols = hmsTable.getSd().getCols();
        List<FieldSchema> icebergCols = HiveSchemaUtil.convert(this.icebergTable.schema());
        List defaultConstraints = SessionStateUtil.getResource((Configuration)this.conf, (String)"columnDefaults").orElse(null);
        Map<String, String> defaultValues = Optional.ofNullable(defaultConstraints).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(SQLDefaultConstraint::getColumn_name, SQLDefaultConstraint::getDefault_value));
        HiveSchemaUtil.SchemaDifference schemaDifference = HiveSchemaUtil.getSchemaDiff(hmsCols, icebergCols, null, null, true);
        ImmutableMap<String, String> renameMapping = ImmutableMap.of();
        if (!schemaDifference.getMissingFromSecond().isEmpty()) {
            renameMapping = ImmutableMap.of(schemaDifference.getMissingFromSecond().getFirst().getName(), schemaDifference.getMissingFromFirst().getFirst().getName());
        }
        Pair<String, Optional<String>> outOfOrder = HiveSchemaUtil.getReorderedColumn(hmsCols, icebergCols, renameMapping);
        if (schemaDifference.isEmpty() && outOfOrder == null && defaultValues.isEmpty()) {
            LOG.info("Found no difference between new and old schema for ALTER TABLE CHANGE COLUMN for table: {}. There will be no Iceberg commit.", (Object)hmsTable.getTableName());
            return;
        }
        this.transaction = this.icebergTable.newTransaction();
        this.updateSchema = this.transaction.updateSchema();
        if (!schemaDifference.getMissingFromSecond().isEmpty()) {
            FieldSchema updatedField = schemaDifference.getMissingFromSecond().getFirst();
            FieldSchema oldField = schemaDifference.getMissingFromFirst().getFirst();
            this.updateSchema.renameColumn(oldField.getName(), updatedField.getName());
            if (!Objects.equals(oldField.getType(), updatedField.getType())) {
                this.updateSchema.updateColumn(oldField.getName(), this.getPrimitiveTypeOrThrow(updatedField), updatedField.getComment());
            } else if (!Objects.equals(oldField.getComment(), updatedField.getComment())) {
                this.updateSchema.updateColumnDoc(oldField.getName(), updatedField.getComment());
            }
        } else if (!schemaDifference.getTypeChanged().isEmpty()) {
            FieldSchema updatedField = schemaDifference.getTypeChanged().getFirst();
            this.updateSchema.updateColumn(updatedField.getName(), this.getPrimitiveTypeOrThrow(updatedField), updatedField.getComment());
        } else if (!schemaDifference.getCommentChanged().isEmpty()) {
            FieldSchema updatedField = schemaDifference.getCommentChanged().getFirst();
            this.updateSchema.updateColumnDoc(updatedField.getName(), updatedField.getComment());
        }
        if (outOfOrder != null) {
            if (outOfOrder.second().isPresent()) {
                this.updateSchema.moveAfter(outOfOrder.first(), outOfOrder.second().get());
            } else {
                this.updateSchema.moveFirst(outOfOrder.first());
            }
        }
        this.handleDefaultValues(defaultValues, renameMapping, this.icebergTable.schema().columns(), "");
        this.updateSchema.commit();
        this.handlePartitionRename(schemaDifference);
    }

    private void handleDefaultValues(Map<String, String> defaultValues, Map<String, String> renameMapping, List<Types.NestedField> columns, String prefix) {
        if (!defaultValues.isEmpty()) {
            for (Map.Entry<String, String> field : defaultValues.entrySet()) {
                String simpleName = renameMapping.containsKey(field.getKey()) ? renameMapping.get(field.getKey()) : field.getKey();
                String qualifiedName = prefix + simpleName;
                Type fieldType = columns.stream().filter(col -> col.name().equalsIgnoreCase(simpleName)).findFirst().get().type();
                if (fieldType.isStructType()) {
                    Map<String, String> structDefaults = HiveSchemaUtil.getDefaultValuesMap(field.getValue());
                    this.handleDefaultValues(structDefaults, renameMapping, fieldType.asStructType().fields(), qualifiedName + ".");
                    continue;
                }
                this.updateSchema.updateColumnDefault(qualifiedName, Expressions.lit(HiveSchemaUtil.getDefaultValue(field.getValue(), fieldType)));
            }
        }
    }

    private void handlePartitionRename(HiveSchemaUtil.SchemaDifference schemaDifference) {
        if (!schemaDifference.getMissingFromSecond().isEmpty()) {
            FieldSchema oldField = schemaDifference.getMissingFromFirst().getFirst();
            FieldSchema updatedField = schemaDifference.getMissingFromSecond().getFirst();
            if (this.icebergTable.spec().fields().stream().anyMatch(pf -> pf.name().equals(oldField.getName()))) {
                UpdatePartitionSpec updatePartitionSpec = this.transaction.updateSpec();
                updatePartitionSpec.renameField(oldField.getName(), updatedField.getName());
                updatePartitionSpec.commit();
            }
        }
    }

    private Type.PrimitiveType getPrimitiveTypeOrThrow(FieldSchema field) throws MetaException {
        Type newType = HiveSchemaUtil.convert(TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType()), null);
        if (!(newType instanceof Type.PrimitiveType)) {
            throw new MetaException(String.format("Cannot promote type of column: '%s' to a non-primitive type: %s.", field.getName(), newType));
        }
        return (Type.PrimitiveType)newType;
    }

    public void preDropPartitions(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context, List<org.apache.commons.lang3.tuple.Pair<Integer, byte[]>> partExprs) throws MetaException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, hmsTable);
        DeleteFiles deleteFiles = icebergTbl.newDelete();
        List<Expression> expressions = partExprs.stream().map(partExpr -> {
            ExprNodeDesc exprNodeDesc = (ExprNodeDesc)SerializationUtilities.deserializeObjectWithTypeInformation((byte[])((byte[])partExpr.getRight()), (boolean)true);
            SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)((ExprNodeGenericFuncDesc)exprNodeDesc));
            HiveIcebergMetaHook.validatePartitionSpec(sarg, icebergTbl.spec());
            return HiveIcebergFilterFactory.generateFilterExpression(sarg);
        }).toList();
        PartitionsTable partitionsTable = (PartitionsTable)MetadataTableUtils.createMetadataTableInstance(icebergTbl, MetadataTableType.PARTITIONS);
        ArrayList<PartitionData> partitionList = Lists.newArrayList();
        Expression finalExpr = Expressions.alwaysFalse();
        PartitionSpec pSpec = icebergTbl.spec();
        for (Expression expr : expressions) {
            finalExpr = Expressions.or(finalExpr, expr);
        }
        ResidualEvaluator resEval = ResidualEvaluator.of(icebergTbl.spec(), finalExpr, false);
        try (CloseableIterable<FileScanTask> fileScanTasks = partitionsTable.newScan().planFiles();){
            fileScanTasks.forEach(task -> {
                CloseableIterable<PartitionData> partitionData = CloseableIterable.transform(task.asDataTask().rows(), row -> {
                    StructProjection data = row.get(0, StructProjection.class);
                    return IcebergTableUtil.toPartitionData(data, pSpec.partitionType());
                });
                partitionData = CloseableIterable.filter(partitionData, pd -> resEval.residualFor((StructLike)pd).isEquivalentTo(Expressions.alwaysTrue()));
                partitionList.addAll(Sets.newHashSet(partitionData));
            });
            Expression partitionSetFilter = Expressions.alwaysFalse();
            for (PartitionData partitionData : partitionList) {
                Expression partFilter = Expressions.alwaysTrue();
                for (int index = 0; index < pSpec.fields().size(); ++index) {
                    PartitionField field = icebergTbl.spec().fields().get(index);
                    UnboundPredicate<Object> equal = HiveIcebergMetaHook.getPartitionPredicate(partitionData, field, index, icebergTbl.schema());
                    partFilter = Expressions.and(partFilter, equal);
                }
                partitionSetFilter = Expressions.or(partitionSetFilter, partFilter);
            }
            deleteFiles.deleteFromRowFilter(partitionSetFilter);
            deleteFiles.commit();
        }
        catch (IOException e) {
            throw new MetaException(String.format("Error while fetching the partitions due to: %s", e));
        }
    }

    public void preDropPartitions(org.apache.hadoop.hive.metastore.api.Table hmsTable, EnvironmentContext context, RequestPartsSpec partsSpec) throws MetaException {
        if (partsSpec.isSetExprs()) {
            List exprs = partsSpec.getExprs();
            ArrayList<org.apache.commons.lang3.tuple.Pair<Integer, byte[]>> partExprs = Lists.newArrayList();
            for (DropPartitionsExpr expr : exprs) {
                partExprs.add((org.apache.commons.lang3.tuple.Pair<Integer, byte[]>)org.apache.commons.lang3.tuple.Pair.of((Object)expr.getPartArchiveLevel(), (Object)expr.getExpr()));
            }
            this.preDropPartitions(hmsTable, context, partExprs);
        } else if (partsSpec.isSetNames()) {
            this.preTruncateTable(hmsTable, context, partsSpec.getNames());
        }
        context.putToProperties("dropPartitionSkip", "true");
    }

    private static void validatePartitionSpec(SearchArgument sarg, PartitionSpec partitionSpec) {
        for (PredicateLeaf leaf : sarg.getLeaves()) {
            TransformSpec transformSpec = TransformSpec.fromStringWithColumnName((String)leaf.getColumnName());
            Types.NestedField column = partitionSpec.schema().findField(transformSpec.getColumnName());
            PartitionField partitionColumn = partitionSpec.fields().stream().filter(pf -> pf.sourceId() == column.fieldId()).findFirst().get();
            if (partitionColumn.transform() == null && transformSpec.transformTypeString() == null || partitionColumn.transform().toString().equalsIgnoreCase(transformSpec.transformTypeString())) continue;
            throw new UnsupportedOperationException("Invalid transform for column: " + transformSpec.getColumnName() + " Expected: " + String.valueOf(partitionColumn.transform()) + " Found: " + String.valueOf(transformSpec.getTransformType()));
        }
    }

    private static UnboundPredicate<Object> getPartitionPredicate(PartitionData partitionData, PartitionField field, int index, Schema schema) {
        String columName = schema.findField(field.sourceId()).name();
        TransformSpec transformSpec = TransformSpec.fromString((String)field.transform().toString(), (String)columName);
        UnboundTerm partitionColumn = (UnboundTerm)ObjectUtils.defaultIfNull(HiveIcebergFilterFactory.toTerm(columName, transformSpec), Expressions.ref(field.name()));
        return Expressions.equal(partitionColumn, partitionData.get(index, Object.class));
    }

    private static class PreAlterTableProperties {
        private String tableLocation;
        private String format;
        private Schema schema;
        private PartitionSpec spec;
        private List<FieldSchema> partitionKeys;
        private PartitionSpecProxy partitionSpecProxy;

        private PreAlterTableProperties() {
        }
    }
}

