/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum DistributionMode {
    NONE("none"),
    HASH("hash"),
    RANGE("range");

    private final String modeName;

    private DistributionMode(String modeName) {
        this.modeName = modeName;
    }

    public String modeName() {
        return this.modeName;
    }

    public static DistributionMode fromName(String modeName) {
        Preconditions.checkArgument(null != modeName, "Invalid distribution mode: null");
        try {
            return DistributionMode.valueOf(modeName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid distribution mode: %s", modeName));
        }
    }
}

