/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing;

import java.nio.ByteBuffer;
import org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing.HotSpotPrior7u6StringHash;
import org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing.ModernCompactStringHash;
import org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing.ModernHotSpotStringHash;
import org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing.StringHash;
import org.apache.hive.iceberg.shaded.parquet.net.openhft.hashing.UnknownJvmStringHash;
import org.jetbrains.annotations.NotNull;
import sun.nio.ch.DirectBuffer;

final class Util {
    @NotNull
    static final StringHash VALID_STRING_HASH;

    Util() {
    }

    private static boolean isHotSpotVM(@NotNull String name) {
        return name.contains("HotSpot") || name.contains("OpenJDK");
    }

    private static boolean isJ9VM(@NotNull String name) {
        return name.contains("Eclipse OpenJ9") || name.contains("IBM J9");
    }

    private static boolean isZing(@NotNull String name) {
        return name.startsWith("Zing");
    }

    static void checkArrayOffs(int arrayLength, int off, int len) {
        if (len < 0 || off < 0 || off + len > arrayLength || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    static long getDirectBufferAddress(@NotNull ByteBuffer buff) {
        return ((DirectBuffer)((Object)buff)).address();
    }

    static {
        Enum stringHash = null;
        try {
            String javaVersion;
            String vmName = System.getProperty("java.vm.name");
            stringHash = Util.isHotSpotVM(vmName) || Util.isJ9VM(vmName) || Util.isZing(vmName) ? ((javaVersion = System.getProperty("java.version")).compareTo("1.7.0_06") >= 0 ? (javaVersion.compareTo("1.9") >= 0 ? ModernCompactStringHash.INSTANCE : ModernHotSpotStringHash.INSTANCE) : HotSpotPrior7u6StringHash.INSTANCE) : HotSpotPrior7u6StringHash.INSTANCE;
        }
        catch (Throwable throwable) {
        }
        finally {
            VALID_STRING_HASH = null == stringHash ? UnknownJvmStringHash.INSTANCE : stringHash;
        }
    }
}

