/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hive.hplsql.ArityException;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.BuiltinFunctions;
import org.apache.hive.hplsql.functions.FunctionRegistry;
import org.apache.hive.hplsql.objects.TableClass;

public class InMemoryFunctionRegistry
implements FunctionRegistry {
    Exec exec;
    private BuiltinFunctions builtinFunctions;
    HashMap<String, HplsqlParser.Create_function_stmtContext> funcMap = new HashMap();
    HashMap<String, HplsqlParser.Create_procedure_stmtContext> procMap = new HashMap();
    boolean trace = false;

    public InMemoryFunctionRegistry(Exec e, BuiltinFunctions builtinFunctions) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.builtinFunctions = builtinFunctions;
    }

    @Override
    public boolean exists(String name) {
        return this.funcMap.containsKey(name) || this.procMap.containsKey(name);
    }

    @Override
    public void remove(String name) {
        this.funcMap.remove(name);
        this.procMap.remove(name);
    }

    @Override
    public boolean exec(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        if (this.builtinFunctions.exec(name, ctx)) {
            return true;
        }
        if (this.execFunction(name, ctx)) {
            return true;
        }
        return this.procMap.get(name) != null && this.execProc(name, ctx);
    }

    private boolean execFunction(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        HplsqlParser.Create_function_stmtContext userCtx = this.funcMap.get(name);
        if (userCtx == null) {
            return false;
        }
        if (this.trace) {
            this.trace(ctx, "EXEC FUNCTION " + name);
        }
        ArrayList<Var> actualParams = this.getActualCallParameters(ctx);
        this.exec.enterScope(Scope.Type.ROUTINE);
        InMemoryFunctionRegistry.setCallParameters(name, ctx, actualParams, userCtx.create_routine_params(), null, this.exec);
        if (userCtx.declare_block_inplace() != null) {
            this.visit(userCtx.declare_block_inplace());
        }
        this.visit(userCtx.single_block_stmt());
        this.exec.leaveScope();
        return true;
    }

    private boolean execProc(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        HplsqlParser.Create_procedure_stmtContext procCtx;
        if (this.trace) {
            this.trace(ctx == null ? null : ctx.getParent(), "EXEC PROCEDURE " + name);
        }
        if ((procCtx = this.procMap.get(name)) == null) {
            this.trace(ctx.getParent(), "Procedure not found");
            return false;
        }
        ArrayList<Var> actualParams = this.getActualCallParameters(ctx);
        HashMap<String, Var> out = new HashMap<String, Var>();
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.exec.callStackPush(name);
        if (procCtx.declare_block_inplace() != null) {
            this.visit(procCtx.declare_block_inplace());
        }
        if (procCtx.create_routine_params() != null) {
            InMemoryFunctionRegistry.setCallParameters(name, ctx, actualParams, procCtx.create_routine_params(), out, this.exec);
        }
        this.visit(procCtx.proc_block());
        this.exec.callStackPop();
        this.exec.leaveScope();
        for (Map.Entry<String, Var> i : out.entrySet()) {
            this.exec.setVariable(i.getKey(), i.getValue());
        }
        return true;
    }

    public static void setCallParameters(String procName, HplsqlParser.Expr_func_paramsContext actual, ArrayList<Var> actualValues, HplsqlParser.Create_routine_paramsContext formal, HashMap<String, Var> out, Exec exec) {
        HplsqlParser.Create_routine_param_itemContext paramItemContext;
        ParserRuleContext ruleContext;
        if (actual == null && formal == null) {
            return;
        }
        int actualCnt = actualValues == null ? 0 : actualValues.size();
        List<HplsqlParser.Create_routine_param_itemContext> routineParamItem = formal.create_routine_param_item();
        int formalCnt = routineParamItem.size();
        ParserRuleContext parserRuleContext = ruleContext = actual == null ? null : actual.getParent();
        if (actualCnt > formalCnt) {
            throw new ArityException(ruleContext, procName, formalCnt, actualCnt);
        }
        HashMap<String, Integer> defaultParamNamesVsIndexes = new HashMap<String, Integer>();
        if (actualCnt != formalCnt) {
            InMemoryFunctionRegistry.populateDefaultParamDetails(routineParamItem, defaultParamNamesVsIndexes);
        }
        for (int i = 0; i < actualCnt; ++i) {
            HplsqlParser.ExprContext exprContext = actual.func_param(i).expr();
            paramItemContext = InMemoryFunctionRegistry.getCallParameter(actual, formal, i);
            Var value = actualValues.get(i);
            defaultParamNamesVsIndexes.remove(paramItemContext.ident().getText());
            InMemoryFunctionRegistry.setCallParameter(actual, out, exec, exprContext, paramItemContext, value);
        }
        Iterator iterator = defaultParamNamesVsIndexes.values().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            paramItemContext = formal.create_routine_param_item().get(index);
            HplsqlParser.ExprContext exprContext = paramItemContext.dtype_default().expr();
            Var value = exec.evalPop(paramItemContext.dtype_default().expr());
            InMemoryFunctionRegistry.setCallParameter(actual, out, exec, exprContext, paramItemContext, value);
        }
        if (actualCnt + defaultParamNamesVsIndexes.size() != formalCnt) {
            throw new ArityException(ruleContext, procName, formalCnt, actualCnt);
        }
    }

    private static void populateDefaultParamDetails(List<HplsqlParser.Create_routine_param_itemContext> routineParamItem, Map<String, Integer> defaultParamNamesVsIndexes) {
        int formalCnt = routineParamItem.size();
        for (int i = 0; i < formalCnt; ++i) {
            HplsqlParser.Create_routine_param_itemContext routineParamItemContext = routineParamItem.get(i);
            if (routineParamItemContext.dtype_default() == null) continue;
            defaultParamNamesVsIndexes.put(routineParamItemContext.ident().getText(), i);
        }
    }

    private static void setCallParameter(HplsqlParser.Expr_func_paramsContext actual, HashMap<String, Var> out, Exec exec, HplsqlParser.ExprContext a, HplsqlParser.Create_routine_param_itemContext p, Var value) {
        String actualName;
        String name = p.ident().getText();
        String type = p.dtype().getText();
        String len = null;
        String scale = null;
        if (p.dtype_len() != null) {
            len = p.dtype_len().L_INT(0).getText();
            if (p.dtype_len().L_INT(1) != null) {
                scale = p.dtype_len().L_INT(1).getText();
            }
        }
        Var variable = InMemoryFunctionRegistry.setCallParameter(name, type, len, scale, value, exec);
        exec.trace(actual, "SET PARAM " + name + " = " + variable.toString());
        if (out != null && a.expr_atom() != null && a.expr_atom().qident() != null && (p.T_OUT() != null || p.T_INOUT() != null) && (actualName = a.expr_atom().qident().getText()) != null) {
            out.put(actualName, variable);
        }
    }

    static Var setCallParameter(String name, String typeName, String len, String scale, Var value, Exec exec) {
        TableClass hplClass = exec.getType(typeName);
        Var var = new Var(name, hplClass == null ? typeName : Var.Type.HPL_OBJECT.name(), len, scale, null);
        if (hplClass != null) {
            var.setValue(hplClass.newInstance());
        }
        var.cast(value);
        exec.addVariable(var);
        return var;
    }

    static HplsqlParser.Create_routine_param_itemContext getCallParameter(HplsqlParser.Expr_func_paramsContext actual, HplsqlParser.Create_routine_paramsContext formal, int pos) {
        int out_pos = pos;
        if (actual.func_param(pos).ident() != null) {
            String named = actual.func_param(pos).ident().getText();
            int cnt = formal.create_routine_param_item().size();
            for (int i = 0; i < cnt; ++i) {
                if (!named.equalsIgnoreCase(formal.create_routine_param_item(i).ident().getText())) continue;
                out_pos = i;
                break;
            }
        }
        return formal.create_routine_param_item(out_pos);
    }

    public ArrayList<Var> getActualCallParameters(HplsqlParser.Expr_func_paramsContext actual) {
        if (actual == null || actual.func_param() == null) {
            return null;
        }
        int cnt = actual.func_param().size();
        ArrayList<Var> values = new ArrayList<Var>(cnt);
        for (int i = 0; i < cnt; ++i) {
            values.add(this.evalPop(actual.func_param(i).expr()));
        }
        return values;
    }

    @Override
    public void addUserFunction(HplsqlParser.Create_function_stmtContext ctx) {
        String name = ctx.ident().getText().toUpperCase();
        if (this.builtinFunctions.exists(name)) {
            this.exec.info(ctx, name + " is a built-in function which cannot be redefined.");
            return;
        }
        if (this.trace) {
            this.trace(ctx, "CREATE FUNCTION " + name);
        }
        this.funcMap.put(name.toUpperCase(), ctx);
    }

    @Override
    public void addUserProcedure(HplsqlParser.Create_procedure_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        if (this.builtinFunctions.exists(name)) {
            this.exec.info(ctx, name + " is a built-in function which cannot be redefined.");
            return;
        }
        if (this.trace) {
            this.trace(ctx, "CREATE PROCEDURE " + name);
        }
        this.procMap.put(name.toUpperCase(), ctx);
    }

    private Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        return this.exec.stackPop();
    }

    private Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    private void trace(ParserRuleContext ctx, String message) {
        if (this.trace) {
            this.exec.trace(ctx, message);
        }
    }
}

