/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;

public class Cursor {
    private String sql;
    private ParserRuleContext sqlExpr;
    private ParserRuleContext sqlSelect;
    private boolean withReturn = false;
    private QueryResult queryResult;
    State state = State.CLOSE;

    public Cursor(String sql) {
        this.sql = sql;
    }

    public void setExprCtx(ParserRuleContext sqlExpr) {
        this.sqlExpr = sqlExpr;
    }

    public void setSelectCtx(ParserRuleContext sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    public void setWithReturn(boolean withReturn) {
        this.withReturn = withReturn;
    }

    public ParserRuleContext getSqlExpr() {
        return this.sqlExpr;
    }

    public ParserRuleContext getSqlSelect() {
        return this.sqlSelect;
    }

    public boolean isWithReturn() {
        return this.withReturn;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void open(QueryExecutor queryExecutor, HplsqlParser.Open_stmtContext ctx) {
        this.queryResult = queryExecutor.executeQuery(this.sql, ctx);
        this.state = State.OPEN;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setFetch(boolean ok) {
        this.state = ok ? State.FETCHED_OK : State.FETCHED_NODATA;
    }

    public Boolean isFound() {
        if (this.state == State.OPEN || this.state == State.CLOSE) {
            return null;
        }
        if (this.state == State.FETCHED_OK) {
            return true;
        }
        return false;
    }

    public Boolean isNotFound() {
        if (this.state == State.OPEN || this.state == State.CLOSE) {
            return null;
        }
        if (this.state == State.FETCHED_NODATA) {
            return true;
        }
        return false;
    }

    public void close() {
        if (this.queryResult != null) {
            this.queryResult.close();
            this.state = State.CLOSE;
        }
    }

    public boolean isOpen() {
        return this.state != State.CLOSE;
    }

    public static enum State {
        OPEN,
        FETCHED_OK,
        FETCHED_NODATA,
        CLOSE;

    }
}

