/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateStatsProcCtx;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsRulesProcFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatsRulesProcFactory.class.getName());

    public static NodeProcessor getTableScanRule() {
        return new TableScanStatsRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectStatsRule();
    }

    public static NodeProcessor getFilterRule() {
        return new FilterStatsRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByStatsRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinStatsRule();
    }

    public static NodeProcessor getLimitRule() {
        return new LimitStatsRule();
    }

    public static NodeProcessor getReduceSinkRule() {
        return new ReduceSinkStatsRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultStatsRule();
    }

    static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op) {
        StatsRulesProcFactory.updateStats(stats, newNumRows, useColStats, op, true);
    }

    static void updateStats(Statistics stats, long newNumRows, boolean useColStats, Operator<? extends OperatorDesc> op, boolean updateNDV) {
        if (newNumRows < 0L) {
            LOG.debug("STATS-" + op.toString() + ": Overflow in number of rows. " + newNumRows + " rows will be set to Long.MAX_VALUE");
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
        }
        if (newNumRows == 0L) {
            LOG.debug("STATS-" + op.toString() + ": Equals 0 in number of rows. " + newNumRows + " rows will be set to 1");
            newNumRows = 1L;
        }
        long oldRowCount = stats.getNumRows();
        double ratio = (double)newNumRows / (double)oldRowCount;
        stats.setNumRows(newNumRows);
        if (useColStats) {
            List<ColStatistics> colStats = stats.getColumnStats();
            for (ColStatistics cs : colStats) {
                long oldNumNulls = cs.getNumNulls();
                long oldDV = cs.getCountDistint();
                long newNumNulls = Math.round(ratio * (double)oldNumNulls);
                cs.setNumNulls(newNumNulls);
                if (!updateNDV) continue;
                long newDV = oldDV;
                if (ratio <= 1.0) {
                    newDV = (long)Math.ceil(ratio * (double)oldDV);
                }
                cs.setCountDistint(newDV);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        } else {
            long newDataSize = (long)(ratio * (double)stats.getDataSize());
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
        }
    }

    static boolean satisfyPrecondition(Statistics stats) {
        return stats != null && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE) && !stats.getColumnStatsState().equals((Object)Statistics.State.NONE);
    }

    private static Statistics applyRuntimeStats(Context context, Statistics stats, Operator<?> op) {
        if (!((HiveConf)context.getConf()).getBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED)) {
            return stats;
        }
        PlanMapper pm = context.getPlanMapper();
        OpTreeSignature treeSig = pm.getSignatureOf(op);
        pm.link(op, treeSig);
        StatsSource statsSource = context.getStatsSource();
        if (!statsSource.canProvideStatsFor(op.getClass())) {
            return stats;
        }
        Optional<OperatorStats> os = statsSource.lookup(treeSig);
        if (!os.isPresent()) {
            return stats;
        }
        LOG.debug("using runtime stats for {}; {}", op, (Object)os.get());
        Statistics outStats = stats.clone();
        outStats = outStats.scaleToRowCount(os.get().getOutputRecords(), false);
        outStats.setRuntimeStats(true);
        return outStats;
    }

    public static class DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Statistics stats;
            Operator op = (Operator)nd;
            Object conf = op.getConf();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf hconf = aspCtx.getConf();
            if (conf != null && (stats = conf.getStatistics()) == null && op.getParentOperators() != null && this.isAllParentsContainStatistics(op)) {
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    Statistics parentStats = parent.getStatistics();
                    if (stats == null) {
                        stats = parentStats.clone();
                    } else {
                        stats.addBasicStats(parentStats);
                    }
                    stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(hconf, parentStats, op.getColumnExprMap(), op.getSchema());
                    stats.addToColumnStats(colStats);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("[0] STATS-" + op.toString() + ": " + stats.extendedToString());
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, op);
                op.getConf().setStatistics(stats);
            }
            return null;
        }

        private boolean isAllParentsContainStatistics(Operator<? extends OperatorDesc> op) {
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                if (parent.getStatistics() != null) continue;
                return false;
            }
            return true;
        }
    }

    public static class ReduceSinkStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            Operator<OperatorDesc> parent = rop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats != null) {
                AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
                HiveConf conf = aspCtx.getConf();
                ArrayList<String> outKeyColNames = ((ReduceSinkDesc)rop.getConf()).getOutputKeyColumnNames();
                ArrayList<String> outValueColNames = ((ReduceSinkDesc)rop.getConf()).getOutputValueColumnNames();
                Map<String, ExprNodeDesc> colExprMap = rop.getColumnExprMap();
                Statistics outStats = parentStats.clone();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    ColStatistics cs;
                    ExprNodeDesc end;
                    ArrayList<ColStatistics> colStats = Lists.newArrayList();
                    for (String key : outKeyColNames) {
                        String prefixedKey = Utilities.ReduceField.KEY.toString() + "." + key;
                        end = colExprMap.get(prefixedKey);
                        if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                        cs.setColumnName(prefixedKey);
                        colStats.add(cs);
                    }
                    for (String val : outValueColNames) {
                        String prefixedVal = Utilities.ReduceField.VALUE.toString() + "." + val;
                        end = colExprMap.get(prefixedVal);
                        if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                        cs.setColumnName(prefixedVal);
                        colStats.add(cs);
                    }
                    outStats.setColumnStats(colStats);
                }
                outStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), outStats, rop);
                rop.setStatistics(outStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + rop.toString() + ": " + outStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class LimitStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            LimitOperator lop = (LimitOperator)nd;
            Operator<OperatorDesc> parent = lop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            long limit = -1L;
            limit = ((LimitDesc)lop.getConf()).getLimit();
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                Statistics stats = parentStats.clone();
                List<ColStatistics> colStats = StatsUtils.getColStatisticsUpdatingTableAlias(parentStats, lop.getSchema());
                stats.setColumnStats(colStats);
                if (limit <= parentStats.getNumRows()) {
                    StatsRulesProcFactory.updateStats(stats, limit, true, lop);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, lop);
                lop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + lop.toString() + ": " + stats.extendedToString());
                }
            } else if (parentStats != null) {
                limit = StatsUtils.getMaxIfOverflow(limit);
                Statistics wcStats = parentStats.scaleToRowCount(limit, true);
                wcStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), wcStats, lop);
                lop.setStatistics(wcStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + lop.toString() + ": " + wcStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class JoinStatsRule
    extends FilterStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long newNumRows = 0L;
            CommonJoinOperator jop = (CommonJoinOperator)nd;
            List<Operator<? extends OperatorDesc>> parents = jop.getParentOperators();
            int numAttr = 1;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            boolean allSatisfyPreCondition = true;
            for (Operator<OperatorDesc> operator : parents) {
                if (operator.getStatistics() != null) continue;
                return null;
            }
            for (Operator<OperatorDesc> operator : parents) {
                if (StatsRulesProcFactory.satisfyPrecondition(operator.getStatistics())) continue;
                allSatisfyPreCondition = false;
                break;
            }
            if (allSatisfyPreCondition) {
                for (int pos = 0; pos < parents.size(); ++pos) {
                    if (jop.getParentOperators().get(pos) instanceof ReduceSinkOperator) continue;
                    allSatisfyPreCondition = false;
                    break;
                }
            }
            if (allSatisfyPreCondition) {
                ExprNodeDesc pred;
                int pos;
                Statistics stats = new Statistics();
                int n = parents.size();
                HashMap<Integer, Long> rowCountParents = Maps.newHashMap();
                HashMap<Integer, Statistics> joinStats = Maps.newHashMap();
                HashMap<Integer, List<String>> joinKeys = Maps.newHashMap();
                ArrayList<Long> rowCounts = Lists.newArrayList();
                ReduceSinkOperator rsOp = (ReduceSinkOperator)jop.getParentOperators().get(0);
                List<String> keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
                numAttr = keyExprs.size();
                long inferredRowCount = this.inferPKFKRelationship(numAttr, parents, jop);
                for (pos = 0; pos < parents.size(); ++pos) {
                    ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                    Statistics statistics = parent.getStatistics().clone();
                    keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)parent.getConf()).getOutputKeyColumnNames());
                    rowCountParents.put(pos, statistics.getNumRows());
                    rowCounts.add(statistics.getNumRows());
                    joinKeys.put(pos, keyExprs);
                    joinStats.put(pos, statistics);
                    stats.updateColumnStatsState(statistics.getColumnStatsState());
                }
                if (numAttr == 0) {
                    inferredRowCount = 1L;
                    for (pos = 0; pos < parents.size(); ++pos) {
                        inferredRowCount = StatsUtils.safeMult(((Statistics)joinStats.get(pos)).getNumRows(), inferredRowCount);
                    }
                }
                ArrayList<Long> distinctVals = Lists.newArrayList();
                long denom = 1L;
                if (inferredRowCount == -1L) {
                    ArrayList<Long> perAttrDVs = Lists.newArrayList();
                    for (int idx = 0; idx < numAttr; ++idx) {
                        for (Object i : joinKeys.keySet()) {
                            String col = (String)((List)joinKeys.get(i)).get(idx);
                            ColStatistics cs = ((Statistics)joinStats.get(i)).getColumnStatisticsFromColName(col);
                            if (cs == null) continue;
                            perAttrDVs.add(cs.getCountDistint());
                        }
                        distinctVals.add(this.getDenominator(perAttrDVs));
                        perAttrDVs.clear();
                    }
                    if (numAttr > 1 && conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_CORRELATED_MULTI_KEY_JOINS)) {
                        denom = Collections.max(distinctVals);
                    } else if (numAttr > n) {
                        denom = StatsUtils.addWithExpDecay(distinctVals);
                    } else {
                        for (Long l : distinctVals) {
                            denom = StatsUtils.safeMult(denom, l);
                        }
                    }
                }
                this.updateJoinColumnsNDV(joinKeys, joinStats, numAttr);
                Map<String, ExprNodeDesc> colExprMap = jop.getColumnExprMap();
                RowSchema rs = jop.getSchema();
                ArrayList<ColStatistics> outColStats = Lists.newArrayList();
                for (ColumnInfo ci : rs.getSignature()) {
                    String key = ci.getInternalName();
                    ExprNodeDesc end = colExprMap.get(key);
                    if (!(end instanceof ExprNodeColumnDesc)) continue;
                    String colName = ((ExprNodeColumnDesc)end).getColumn();
                    byte pos2 = ((JoinDesc)jop.getConf()).getReversedExprs().get(key);
                    ColStatistics cs = ((Statistics)joinStats.get(pos2)).getColumnStatisticsFromColName(colName);
                    String outColName = key;
                    if (cs != null) {
                        cs.setColumnName(outColName);
                    }
                    outColStats.add(cs);
                }
                stats.setColumnStats(outColStats);
                long interimRowCount = inferredRowCount != -1L ? inferredRowCount : this.computeRowCountAssumingInnerJoin(rowCounts, denom, jop);
                long joinRowCount = inferredRowCount != -1L ? inferredRowCount : this.computeFinalRowCount(rowCounts, interimRowCount, jop);
                this.updateColStats(conf, stats, interimRowCount, joinRowCount, jop, rowCountParents);
                if (joinRowCount != -1L && ((JoinDesc)jop.getConf()).getNoOuterJoin() && ((JoinDesc)jop.getConf()).getResidualFilterExprs() != null && !((JoinDesc)jop.getConf()).getResidualFilterExprs().isEmpty() && (newNumRows = this.evaluateExpression(stats, pred = ((JoinDesc)jop.getConf()).getResidualFilterExprs().size() > 1 ? new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), ((JoinDesc)jop.getConf()).getResidualFilterExprs()) : ((JoinDesc)jop.getConf()).getResidualFilterExprs().get(0), aspCtx, jop.getSchema().getColumnNames(), jop, stats.getNumRows())) <= joinRowCount) {
                    StatsRulesProcFactory.updateStats(stats, newNumRows, true, jop);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, jop);
                jop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + jop.toString() + ": " + stats.extendedToString());
                }
            } else {
                long newDataSize;
                List<Object> keyExprs;
                float joinFactor = HiveConf.getFloatVar(conf, HiveConf.ConfVars.HIVE_STATS_JOIN_FACTOR);
                int n = parents.size();
                long crossRowCount = 1L;
                long crossDataSize = 1L;
                long maxRowCount = 0L;
                long maxDataSize = 0L;
                Statistics.State statsState = Statistics.State.NONE;
                for (Operator<OperatorDesc> operator : parents) {
                    Statistics ps = operator.getStatistics();
                    statsState = Statistics.inferColumnStatsState(statsState, ps.getBasicStatsState());
                    long rowCount = ps.getNumRows();
                    long dataSize = ps.getDataSize();
                    long newCrossRowCount = StatsUtils.safeMult(crossRowCount, rowCount);
                    long newCrossDataSize = StatsUtils.safeAdd(StatsUtils.safeMult(crossDataSize, rowCount), StatsUtils.safeMult(dataSize, crossRowCount));
                    crossRowCount = newCrossRowCount;
                    crossDataSize = newCrossDataSize;
                    if (rowCount <= maxRowCount) continue;
                    maxRowCount = rowCount;
                    maxDataSize = dataSize;
                }
                boolean cartesianProduct = false;
                if (jop.getParentOperators().get(0) instanceof ReduceSinkOperator) {
                    ReduceSinkOperator rsOp = (ReduceSinkOperator)jop.getParentOperators().get(0);
                    keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
                    cartesianProduct = keyExprs.size() == 0;
                } else if (jop instanceof AbstractMapJoinOperator) {
                    AbstractMapJoinOperator mjop = (AbstractMapJoinOperator)jop;
                    keyExprs = ((MapJoinDesc)mjop.getConf()).getKeys().values().iterator().next();
                    boolean bl = cartesianProduct = keyExprs.size() == 0;
                }
                if (cartesianProduct) {
                    newNumRows = crossRowCount;
                    newDataSize = crossDataSize;
                } else if (n > 1) {
                    newNumRows = StatsUtils.safeMult(StatsUtils.safeMult(maxRowCount, n - 1), (double)joinFactor);
                    newDataSize = StatsUtils.safeMult(StatsUtils.safeMult(maxDataSize, n - 1), (double)joinFactor);
                } else {
                    newNumRows = StatsUtils.safeMult(maxRowCount, (double)joinFactor);
                    newDataSize = StatsUtils.safeMult(maxDataSize, (double)joinFactor);
                }
                Statistics wcStats = new Statistics(newNumRows, newDataSize);
                wcStats.setBasicStatsState(statsState);
                if (((JoinDesc)jop.getConf()).getNoOuterJoin() && ((JoinDesc)jop.getConf()).getResidualFilterExprs() != null && !((JoinDesc)jop.getConf()).getResidualFilterExprs().isEmpty()) {
                    long joinRowCount = newNumRows;
                    ExprNodeDesc pred = ((JoinDesc)jop.getConf()).getResidualFilterExprs().size() > 1 ? new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), ((JoinDesc)jop.getConf()).getResidualFilterExprs()) : ((JoinDesc)jop.getConf()).getResidualFilterExprs().get(0);
                    newNumRows = this.evaluateExpression(wcStats, pred, aspCtx, jop.getSchema().getColumnNames(), jop, wcStats.getNumRows());
                    if (newNumRows <= joinRowCount) {
                        StatsRulesProcFactory.updateStats(wcStats, newNumRows, false, jop);
                    }
                }
                wcStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), wcStats, jop);
                jop.setStatistics(wcStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + jop.toString() + ": " + wcStats.extendedToString());
                }
            }
            return null;
        }

        private long inferPKFKRelationship(int numAttr, List<Operator<? extends OperatorDesc>> parents, CommonJoinOperator<? extends JoinDesc> jop) {
            long newNumRows = -1L;
            if (numAttr != 1) {
                return newNumRows;
            }
            Map<Integer, ColStatistics> parentsWithPK = this.getPrimaryKeyCandidates(parents);
            if (parentsWithPK.size() != 1) {
                LOG.debug("STATS-" + jop.toString() + ": detects none/multiple PK parents.");
                return newNumRows;
            }
            Integer pkPos = parentsWithPK.keySet().iterator().next();
            ColStatistics csPK = parentsWithPK.values().iterator().next();
            Map<Integer, ColStatistics> csFKs = this.getForeignKeyCandidates(parents, csPK);
            if (csFKs.size() + 1 == parents.size()) {
                newNumRows = this.getCardinality(parents, pkPos, csPK, csFKs, jop);
                if (LOG.isDebugEnabled()) {
                    ArrayList<String> parentIds = Lists.newArrayList();
                    for (Integer i : parentsWithPK.keySet()) {
                        parentIds.add(parents.get(i).toString());
                    }
                    LOG.debug("STATS-" + jop.toString() + ": PK parent id(s) - " + parentIds);
                    parentIds.clear();
                    for (Integer i : csFKs.keySet()) {
                        parentIds.add(parents.get(i).toString());
                    }
                    LOG.debug("STATS-" + jop.toString() + ": FK parent id(s) - " + parentIds);
                }
            }
            return newNumRows;
        }

        private long getCardinality(List<Operator<? extends OperatorDesc>> ops, Integer pkPos, ColStatistics csPK, Map<Integer, ColStatistics> csFKs, CommonJoinOperator<? extends JoinDesc> jop) {
            long newNumRows;
            double pkfkSelectivity = Double.MAX_VALUE;
            int fkInd = -1;
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                int pos = entry.getKey();
                Operator<? extends OperatorDesc> opWithPK = ops.get(pkPos);
                double selectivity = this.getSelectivitySimpleTree(opWithPK);
                double selectivityAdjustment = StatsUtils.getScaledSelectivity(csPK, entry.getValue());
                double d = selectivityAdjustment * selectivity > 1.0 ? selectivity : selectivityAdjustment * selectivity;
                selectivity = d;
                if (!(selectivity < pkfkSelectivity)) continue;
                pkfkSelectivity = selectivity;
                fkInd = pos;
            }
            long newrows = 1L;
            ArrayList<Long> rowCounts = Lists.newArrayList();
            ArrayList<Long> distinctVals = Lists.newArrayList();
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                int pos = entry.getKey();
                ColStatistics csFK = entry.getValue();
                ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                Statistics parentStats = parent.getStatistics();
                if (fkInd == pos) {
                    newrows = (long)Math.ceil((double)parentStats.getNumRows() * pkfkSelectivity);
                    rowCounts.add(newrows);
                    distinctVals.add(Math.min(csFK.getCountDistint(), csPK.getCountDistint()));
                    continue;
                }
                rowCounts.add(parentStats.getNumRows());
                distinctVals.add(csFK.getCountDistint());
            }
            if (csFKs.size() == 1) {
                newNumRows = newrows;
            } else {
                newNumRows = this.computeRowCountAssumingInnerJoin(rowCounts, this.getDenominator(distinctVals), jop);
                newNumRows = this.computeFinalRowCount(rowCounts, newNumRows, jop);
            }
            return newNumRows;
        }

        private float getSelectivitySimpleTree(Operator<? extends OperatorDesc> op) {
            TableScanOperator tsOp = OperatorUtils.findSingleOperatorUpstream(op, TableScanOperator.class);
            if (tsOp == null) {
                return this.getSelectivityComplexTree(op);
            }
            long inputRow = tsOp.getStatistics().getNumRows();
            long outputRow = op.getStatistics().getNumRows();
            return (float)outputRow / (float)inputRow;
        }

        private float getSelectivityComplexTree(Operator<? extends OperatorDesc> op) {
            Operator<? extends OperatorDesc> multiParentOp = null;
            Operator<? extends OperatorDesc> currentOp = op;
            while (multiParentOp == null) {
                if (op.getParentOperators().size() > 1) {
                    multiParentOp = op;
                    continue;
                }
                op = op.getParentOperators().get(0);
            }
            float selMultiParent = 1.0f;
            boolean isSelComputed = false;
            if (multiParentOp instanceof JoinOperator) {
                JoinOperator jop = (JoinOperator)multiParentOp;
                isSelComputed = true;
                if (((JoinDesc)jop.getConf()).getConds().length == 1) {
                    switch (((JoinDesc)jop.getConf()).getCondsList().get(0).getType()) {
                        case 1: {
                            selMultiParent *= this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(0));
                            break;
                        }
                        case 2: {
                            selMultiParent *= this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(1));
                            break;
                        }
                        default: {
                            float f = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(0));
                            float selMultiParentRight = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(1));
                            selMultiParent = Math.min(f, selMultiParentRight);
                        }
                    }
                }
            }
            if (!isSelComputed) {
                for (Operator operator : multiParentOp.getParentOperators()) {
                    selMultiParent *= this.getSelectivitySimpleTree(operator);
                }
            }
            float selCurrOp = (float)currentOp.getStatistics().getNumRows() / (float)multiParentOp.getStatistics().getNumRows() * selMultiParent;
            return selCurrOp;
        }

        private Map<Integer, ColStatistics> getForeignKeyCandidates(List<Operator<? extends OperatorDesc>> ops, ColStatistics csPK) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (csPK == null || ops == null) {
                return result;
            }
            for (int i = 0; i < ops.size(); ++i) {
                ColStatistics cs;
                ReduceSinkOperator rsOp;
                List<String> keys;
                Operator<? extends OperatorDesc> op = ops.get(i);
                if (op == null || !(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                String joinCol = keys.get(0);
                if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || cs.isPrimaryKey() || !StatsUtils.inferForeignKey(csPK, cs)) continue;
                result.put(i, cs);
            }
            return result;
        }

        private Map<Integer, ColStatistics> getPrimaryKeyCandidates(List<Operator<? extends OperatorDesc>> ops) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (ops != null && !ops.isEmpty()) {
                for (int i = 0; i < ops.size(); ++i) {
                    ColStatistics cs;
                    ReduceSinkOperator rsOp;
                    List<String> keys;
                    Operator<? extends OperatorDesc> op = ops.get(i);
                    if (!(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                    String joinCol = keys.get(0);
                    if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || !cs.isPrimaryKey()) continue;
                    result.put(i, cs);
                }
            }
            return result;
        }

        private boolean isJoinKey(String columnName, ExprNodeDesc[][] joinKeys) {
            for (int i = 0; i < joinKeys.length; ++i) {
                for (ExprNodeDesc expr : Arrays.asList(joinKeys[i])) {
                    if (!(expr instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)expr).getColumn().equals(columnName)) continue;
                    return true;
                }
            }
            return false;
        }

        private void updateNumNulls(ColStatistics colStats, long interimNumRows, long newNumRows, long pos, CommonJoinOperator<? extends JoinDesc> jop) {
            if (((JoinDesc)jop.getConf()).getConds().length != 1) {
                return;
            }
            long oldNumNulls = colStats.getNumNulls();
            long newNumNulls = Math.min(newNumRows, oldNumNulls);
            JoinCondDesc joinCond = ((JoinDesc)jop.getConf()).getConds()[0];
            switch (joinCond.getType()) {
                case 1: {
                    if (pos != (long)joinCond.getRight() || interimNumRows == newNumRows) break;
                    assert (newNumRows > interimNumRows);
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, newNumRows - interimNumRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + (newNumRows - interimNumRows));
                    break;
                }
                case 2: {
                    if (pos != (long)joinCond.getLeft() || interimNumRows == newNumRows) break;
                    assert (newNumRows > interimNumRows);
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, newNumRows - interimNumRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + (newNumRows - interimNumRows));
                    break;
                }
                case 3: {
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, newNumRows - interimNumRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + (newNumRows - interimNumRows));
                    break;
                }
            }
            colStats.setNumNulls(newNumNulls);
        }

        private void updateColStats(HiveConf conf, Statistics stats, long interimNumRows, long newNumRows, CommonJoinOperator<? extends JoinDesc> jop, Map<Integer, Long> rowCountParents) {
            if (newNumRows < 0L) {
                LOG.debug("STATS-" + jop.toString() + ": Overflow in number of rows. " + newNumRows + " rows will be set to Long.MAX_VALUE");
            }
            if (newNumRows == 0L) {
                LOG.debug("STATS-" + jop.toString() + ": Equals 0 in number of rows. " + newNumRows + " rows will be set to 1");
                newNumRows = 1L;
            }
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
            stats.setNumRows(newNumRows);
            List<ColStatistics> colStats = stats.getColumnStats();
            HashSet<String> colNameStatsAvailable = new HashSet<String>();
            for (ColStatistics cs : colStats) {
                long oldDV;
                colNameStatsAvailable.add(cs.getColumnName());
                byte pos = ((JoinDesc)jop.getConf()).getReversedExprs().get(cs.getColumnName());
                long oldRowCount = rowCountParents.get(pos);
                double ratio = (double)newNumRows / (double)oldRowCount;
                long newDV = oldDV = cs.getCountDistint();
                if (ratio <= 1.0) {
                    newDV = (long)Math.ceil(ratio * (double)oldDV);
                }
                cs.setCountDistint(newDV);
                this.updateNumNulls(cs, interimNumRows, newNumRows, pos, jop);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            ArrayList<String> neededColumns = new ArrayList<String>();
            for (String colName : jop.getSchema().getColumnNames()) {
                if (colNameStatsAvailable.contains(colName)) continue;
                neededColumns.add(colName);
            }
            if (neededColumns.size() != 0) {
                int restColumnsDefaultSize = StatsUtils.estimateRowSizeFromSchema(conf, jop.getSchema().getSignature(), neededColumns);
                newDataSize = StatsUtils.safeAdd(newDataSize, StatsUtils.safeMult((long)restColumnsDefaultSize, newNumRows));
            }
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
            stats.setBasicStatsState(Statistics.State.COMPLETE);
        }

        private long computeFinalRowCount(List<Long> rowCountParents, long interimRowCount, CommonJoinOperator<? extends JoinDesc> join) {
            long result = interimRowCount;
            if (((JoinDesc)join.getConf()).getConds().length == 1) {
                JoinCondDesc joinCond = ((JoinDesc)join.getConf()).getConds()[0];
                switch (joinCond.getType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result = Math.max(rowCountParents.get(joinCond.getLeft()), result);
                        break;
                    }
                    case 2: {
                        result = Math.max(rowCountParents.get(joinCond.getRight()), result);
                        break;
                    }
                    case 3: {
                        result = Math.max(StatsUtils.safeAdd(rowCountParents.get(joinCond.getRight()), rowCountParents.get(joinCond.getLeft())), result);
                        break;
                    }
                    case 5: {
                        result = Math.min(rowCountParents.get(joinCond.getLeft()), result);
                        break;
                    }
                    default: {
                        LOG.debug("Unhandled join type in stats estimation: " + joinCond.getType());
                    }
                }
            }
            return result;
        }

        private long computeRowCountAssumingInnerJoin(List<Long> rowCountParents, long denom, CommonJoinOperator<? extends JoinDesc> join) {
            int i;
            double factor = 0.0;
            long result = 1L;
            long max = rowCountParents.get(0);
            long maxIdx = 0L;
            for (i = 1; i < rowCountParents.size(); ++i) {
                if (rowCountParents.get(i) <= max) continue;
                max = rowCountParents.get(i);
                maxIdx = i;
            }
            denom = denom == 0L ? 1L : denom;
            factor = (double)max / (double)denom;
            for (i = 0; i < rowCountParents.size(); ++i) {
                if ((long)i == maxIdx) continue;
                result = StatsUtils.safeMult(result, rowCountParents.get(i));
            }
            result = (long)((double)result * factor);
            return result;
        }

        private void updateJoinColumnsNDV(Map<Integer, List<String>> joinKeys, Map<Integer, Statistics> joinStats, int numAttr) {
            int joinColIdx = 0;
            while (numAttr > 0) {
                ColStatistics cs;
                String key;
                int pos;
                long minNDV = Long.MAX_VALUE;
                for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                    pos = entry.getKey();
                    key = entry.getValue().get(joinColIdx);
                    cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                    if (cs == null || cs.getCountDistint() >= minNDV) continue;
                    minNDV = cs.getCountDistint();
                }
                if (minNDV != Long.MAX_VALUE) {
                    for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                        pos = entry.getKey();
                        key = entry.getValue().get(joinColIdx);
                        cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                        if (cs == null) continue;
                        cs.setCountDistint(minNDV);
                    }
                }
                ++joinColIdx;
                --numAttr;
            }
        }

        private long getDenominator(List<Long> distinctVals) {
            if (distinctVals.isEmpty()) {
                return 2L;
            }
            if (distinctVals.size() <= 2) {
                return Collections.max(distinctVals);
            }
            long minNDV = distinctVals.get(0);
            int minIdx = 0;
            for (int i = 1; i < distinctVals.size(); ++i) {
                if (distinctVals.get(i) >= minNDV) continue;
                minNDV = distinctVals.get(i);
                minIdx = i;
            }
            long denom = 1L;
            for (int i = 0; i < distinctVals.size(); ++i) {
                if (i == minIdx) continue;
                denom = StatsUtils.safeMult(denom, distinctVals.get(i));
            }
            return denom;
        }
    }

    public static class GroupByStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long cardinality;
            long sizeOfGroupingSet;
            GroupByOperator gop = (GroupByOperator)nd;
            Operator<OperatorDesc> parent = gop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats == null) {
                return null;
            }
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            long maxSplitSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            ArrayList<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            Map<String, ExprNodeDesc> colExprMap = gop.getColumnExprMap();
            RowSchema rs = gop.getSchema();
            Statistics stats = null;
            List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, colExprMap, rs);
            long parallelism = 1L;
            boolean interReduction = false;
            boolean hashAgg = false;
            long inputSize = 1L;
            boolean containsGroupingSet = ((GroupByDesc)gop.getConf()).isGroupingSetsPresent();
            long l = sizeOfGroupingSet = containsGroupingSet ? (long)((GroupByDesc)gop.getConf()).getListGroupingSets().size() : 1L;
            if (!(((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.MERGEPARTIAL) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.COMPLETE) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.FINAL))) {
                interReduction = true;
                TableScanOperator top = OperatorUtils.findSingleOperatorUpstream(gop, TableScanOperator.class);
                if (top == null) {
                    inputSize = parentStats.getDataSize();
                    maxSplitSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.BYTESPERREDUCER);
                } else {
                    inputSize = ((TableScanDesc)top.getConf()).getStatistics().getDataSize();
                }
                parallelism = (int)Math.ceil((double)inputSize / (double)maxSplitSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("STATS-" + gop.toString() + ": inputSize: " + inputSize + " maxSplitSize: " + maxSplitSize + " parallelism: " + parallelism + " containsGroupingSet: " + containsGroupingSet + " sizeOfGroupingSet: " + sizeOfGroupingSet);
            }
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                hashAgg = this.checkMapSideAggregation(gop, colStats, conf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("STATS-" + gop.toString() + " hashAgg: " + hashAgg);
                }
                stats = parentStats.clone();
                stats.setColumnStats(colStats);
                long ndvProduct = 1L;
                long parentNumRows = stats.getNumRows();
                for (ColStatistics cs : colStats) {
                    if (cs != null) {
                        long ndv = cs.getCountDistint();
                        if (cs.getNumNulls() > 0L) {
                            ndv = StatsUtils.safeAdd(ndv, 1L);
                        }
                        ndvProduct = StatsUtils.safeMult(ndvProduct, ndv);
                        continue;
                    }
                    if (parentStats.getColumnStatsState().equals((Object)Statistics.State.COMPLETE)) continue;
                    ndvProduct = 0L;
                    break;
                }
                if (ndvProduct == 0L) {
                    ndvProduct = parentNumRows / 2L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("STATS-" + gop.toString() + ": ndvProduct became 0 as some column does not" + " have stats. ndvProduct changed to: " + ndvProduct);
                    }
                }
                if (interReduction) {
                    if (hashAgg) {
                        if (containsGroupingSet) {
                            cardinality = Math.min(StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet) / 2L, StatsUtils.safeMult(StatsUtils.safeMult(ndvProduct, parallelism), sizeOfGroupingSet));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("[Case 4] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        } else {
                            cardinality = Math.min(parentNumRows / 2L, StatsUtils.safeMult(ndvProduct, parallelism));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("[Case 3] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        }
                    } else if (containsGroupingSet) {
                        cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 6] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = parentNumRows;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 5] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                } else {
                    GroupByOperator mGop = OperatorUtils.findSingleOperatorUpstream(parent, GroupByOperator.class);
                    if (mGop != null) {
                        containsGroupingSet = ((GroupByDesc)mGop.getConf()).isGroupingSetsPresent();
                    }
                    if (containsGroupingSet) {
                        sizeOfGroupingSet = ((GroupByDesc)mGop.getConf()).getListGroupingSets().size();
                        cardinality = Math.min(parentNumRows, StatsUtils.safeMult(ndvProduct, sizeOfGroupingSet));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 8] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = Math.min(parentNumRows, ndvProduct);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 9] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                }
                StatsRulesProcFactory.updateStats(stats, cardinality, true, gop, false);
            } else if (parentStats != null) {
                stats = parentStats.clone();
                long parentNumRows = stats.getNumRows();
                if (interReduction) {
                    if (containsGroupingSet) {
                        cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 2] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = parentNumRows;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 1] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                } else {
                    cardinality = parentNumRows / 2L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[Case 7] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                    }
                }
                StatsRulesProcFactory.updateStats(stats, cardinality, false, gop);
            }
            if (!aggDesc.isEmpty() && stats != null) {
                ArrayList<ColStatistics> aggColStats = Lists.newArrayList();
                for (ColumnInfo ci : rs.getSignature()) {
                    ColStatistics cs;
                    if (colExprMap.containsKey(ci.getInternalName())) continue;
                    String colName = ci.getInternalName();
                    String colType = ci.getTypeName();
                    cs = new ColStatistics(colName, colType);
                    cs.setCountDistint(stats.getNumRows());
                    cs.setNumNulls(0L);
                    cs.setAvgColLen(StatsUtils.getAvgColLenOf(conf, ci.getObjectInspector(), colType));
                    aggColStats.add(cs);
                }
                if (aggColStats.size() > 0) {
                    stats.addToColumnStats(aggColStats);
                    if (!stats.getColumnStatsState().equals((Object)Statistics.State.NONE)) {
                        StatsRulesProcFactory.updateStats(stats, stats.getNumRows(), true, gop);
                    }
                }
                if (colExprMap.isEmpty()) {
                    StatsRulesProcFactory.updateStats(stats, 1L, true, gop);
                }
            }
            stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, gop);
            gop.setStatistics(stats);
            if (LOG.isDebugEnabled() && stats != null) {
                LOG.debug("[0] STATS-" + gop.toString() + ": " + stats.extendedToString());
            }
            return null;
        }

        private boolean checkMapSideAggregation(GroupByOperator gop, List<ColStatistics> colStats, HiveConf conf) {
            ArrayList<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            GroupByDesc desc = (GroupByDesc)gop.getConf();
            GroupByDesc.Mode mode = desc.getMode();
            if (mode.equals((Object)GroupByDesc.Mode.HASH)) {
                Object agg;
                int i;
                float hashAggMem = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
                float hashAggMaxThreshold = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
                long totalMemory = StatsUtils.getAvailableMemory(conf) * 1000L * 1000L;
                long maxMemHashAgg = Math.round((float)totalMemory * hashAggMem * hashAggMaxThreshold);
                long numEstimatedRows = 1L;
                long avgKeySize = 0L;
                for (ColStatistics cs : colStats) {
                    if (cs == null) continue;
                    numEstimatedRows = StatsUtils.safeMult(numEstimatedRows, cs.getCountDistint());
                    avgKeySize = (long)((double)avgKeySize + Math.ceil(cs.getAvgColLen()));
                }
                long avgValSize = 0L;
                GenericUDAFEvaluator[] aggregationEvaluators = new GenericUDAFEvaluator[aggDesc.size()];
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    agg = (AggregationDesc)aggDesc.get(i);
                    aggregationEvaluators[i] = ((AggregationDesc)agg).getGenericUDAFEvaluator();
                }
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    Field[] fArr;
                    avgValSize += 64L;
                    agg = null;
                    int evaluatorEstimate = aggregationEvaluators[i].estimate();
                    if (evaluatorEstimate > 0) {
                        avgValSize += (long)evaluatorEstimate;
                        continue;
                    }
                    try {
                        agg = aggregationEvaluators[i].getNewAggregationBuffer();
                    }
                    catch (HiveException e) {
                        avgValSize += 256L;
                    }
                    if (agg == null) continue;
                    if (GenericUDAFEvaluator.isEstimable((GenericUDAFEvaluator.AggregationBuffer)agg)) {
                        avgValSize += (long)((GenericUDAFEvaluator.AbstractAggregationBuffer)agg).estimate();
                        continue;
                    }
                    for (Field f : fArr = ObjectInspectorUtils.getDeclaredNonStaticFields(agg.getClass())) {
                        long avgSize = StatsUtils.getAvgColLenOfFixedLengthTypes(f.getType().getName());
                        avgValSize += avgSize == 0L ? 256L : avgSize;
                    }
                }
                long hashEntrySize = 64L + avgKeySize + avgValSize;
                long estHashTableSize = StatsUtils.safeMult(numEstimatedRows, hashEntrySize);
                if (estHashTableSize < maxMemHashAgg) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class FilterStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<OperatorDesc> parent = fop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            List<String> neededCols = null;
            if (parent instanceof TableScanOperator) {
                TableScanOperator tsop = (TableScanOperator)parent;
                neededCols = tsop.getNeededColumns();
            }
            if (parentStats != null) {
                ExprNodeDesc pred = ((FilterDesc)fop.getConf()).getPredicate();
                long newNumRows = this.evaluateExpression(parentStats, pred, aspCtx, neededCols, fop, parentStats.getNumRows());
                Statistics st = parentStats.clone();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    if (newNumRows <= parentStats.getNumRows()) {
                        StatsRulesProcFactory.updateStats(st, newNumRows, true, fop);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[0] STATS-" + fop.toString() + ": " + st.extendedToString());
                    }
                } else {
                    if (newNumRows <= parentStats.getNumRows()) {
                        StatsRulesProcFactory.updateStats(st, newNumRows, false, fop);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[1] STATS-" + fop.toString() + ": " + st.extendedToString());
                    }
                }
                st = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), st, fop);
                fop.setStatistics(st);
                aspCtx.setAndExprStats(null);
            }
            return null;
        }

        protected long evaluateExpression(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op, long currNumRows) throws SemanticException {
            long newNumRows = 0L;
            Statistics andStats = null;
            if (currNumRows <= 1L || stats.getDataSize() <= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Estimating row count for " + pred + " Original num rows: " + currNumRows + " Original data size: " + stats.getDataSize() + " New num rows: 1");
                }
                return 1L;
            }
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPAnd) {
                    andStats = stats.clone();
                    aspCtx.setAndExprStats(andStats);
                    long evaluatedRowCount = currNumRows;
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = evaluatedRowCount = this.evaluateChildExpr(aspCtx.getAndExprStats(), child, aspCtx, neededCols, op, evaluatedRowCount);
                        if (StatsRulesProcFactory.satisfyPrecondition(aspCtx.getAndExprStats())) {
                            StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, true, op);
                            continue;
                        }
                        StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, false, op);
                    }
                } else if (udf instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = StatsUtils.safeAdd(this.evaluateChildExpr(stats, child, aspCtx, neededCols, op, currNumRows), newNumRows);
                    }
                    if (newNumRows > currNumRows) {
                        newNumRows = currNumRows;
                    }
                } else if (udf instanceof GenericUDFIn) {
                    newNumRows = this.evaluateInExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else if (udf instanceof GenericUDFBetween) {
                    newNumRows = this.evaluateBetweenExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else if (udf instanceof GenericUDFOPNot) {
                    newNumRows = this.evaluateNotExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else {
                    if (udf instanceof GenericUDFOPNotNull) {
                        return this.evaluateNotNullExpr(stats, genFunc, currNumRows);
                    }
                    newNumRows = this.evaluateChildExpr(stats, pred, aspCtx, neededCols, op, currNumRows);
                }
            } else if (pred instanceof ExprNodeColumnDesc) {
                ColStatistics cs;
                ExprNodeColumnDesc encd = (ExprNodeColumnDesc)pred;
                String colName = encd.getColumn();
                String colType = encd.getTypeString();
                newNumRows = colType.equalsIgnoreCase("boolean") ? ((cs = stats.getColumnStatisticsFromColName(colName)) != null ? cs.getNumTrues() : stats.getNumRows() / 2L) : stats.getNumRows() / 2L;
            } else if (pred instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc encd = (ExprNodeConstantDesc)pred;
                newNumRows = Boolean.FALSE.equals(encd.getValue()) ? 0L : stats.getNumRows();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Estimating row count for " + pred + " Original num rows: " + stats.getNumRows() + " New num rows: " + newNumRows);
            }
            return newNumRows;
        }

        private long evaluateInExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            boolean multiColumn;
            long numRows = currNumRows;
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)pred;
            List<ExprNodeDesc> children = fd.getChildren();
            ArrayList<ExprNodeDesc> columns = Lists.newArrayList();
            ArrayList<ColStatistics> columnStats = Lists.newArrayList();
            ArrayList values = Lists.newArrayList();
            ExprNodeDesc columnsChild = children.get(0);
            if (columnsChild instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)columnsChild).getGenericUDF() instanceof GenericUDFStruct) {
                for (int j = 0; j < columnsChild.getChildren().size(); ++j) {
                    ExprNodeDesc columnChild = columnsChild.getChildren().get(j);
                    if (!(columnChild instanceof ExprNodeColumnDesc)) {
                        return numRows / 2L;
                    }
                    columns.add(columnChild);
                    String columnName = ((ExprNodeColumnDesc)columnChild).getColumn();
                    if (neededCols != null && !neededCols.contains(columnName)) {
                        return numRows / 2L;
                    }
                    columnStats.add(stats.getColumnStatisticsFromColName(columnName));
                    values.add(Sets.newHashSet());
                }
                multiColumn = true;
            } else {
                if (!(columnsChild instanceof ExprNodeColumnDesc)) {
                    return numRows / 2L;
                }
                columns.add(columnsChild);
                String columnName = ((ExprNodeColumnDesc)columnsChild).getColumn();
                if (neededCols != null && !neededCols.contains(columnName)) {
                    return numRows / 2L;
                }
                columnStats.add(stats.getColumnStatisticsFromColName(columnName));
                values.add(Sets.newHashSet());
                multiColumn = false;
            }
            for (int i = 1; i < children.size(); ++i) {
                ExprNodeDesc child = children.get(i);
                if (!(child instanceof ExprNodeConstantDesc)) {
                    return numRows / 2L;
                }
                if (multiColumn) {
                    ExprNodeConstantDesc constantChild = (ExprNodeConstantDesc)child;
                    List items = (List)constantChild.getWritableObjectInspector().getWritableConstantValue();
                    ArrayList<TypeInfo> structTypes = ((StructTypeInfo)constantChild.getTypeInfo()).getAllStructFieldTypeInfos();
                    for (int j = 0; j < structTypes.size(); ++j) {
                        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)structTypes.get(j), items.get(j));
                        ((Set)values.get(j)).add(new ExprNodeDesc.ExprNodeDescEqualityWrapper(constant));
                    }
                    continue;
                }
                ((Set)values.get(0)).add(new ExprNodeDesc.ExprNodeDescEqualityWrapper(child));
            }
            boolean allColsFilteredByStats = true;
            for (int i = 0; i < columnStats.size(); ++i) {
                ValuePruner vp = new ValuePruner((ColStatistics)columnStats.get(i));
                allColsFilteredByStats &= vp.isValid();
                HashSet<ExprNodeDesc.ExprNodeDescEqualityWrapper> newValues = Sets.newHashSet();
                for (ExprNodeDesc.ExprNodeDescEqualityWrapper v : (Set)values.get(i)) {
                    if (!vp.accept(v)) continue;
                    newValues.add(v);
                }
                values.set(i, newValues);
            }
            double factor = 1.0;
            for (int i = 0; i < columnStats.size(); ++i) {
                long dvs = columnStats.get(i) == null ? 0L : ((ColStatistics)columnStats.get(i)).getCountDistint();
                double columnFactor = dvs == 0L ? 0.5 : (double)((Set)values.get(i)).size() / (double)dvs;
                factor *= columnFactor > 1.0 ? 1.0 : columnFactor;
            }
            if (!allColsFilteredByStats) {
                factor = Double.max(factor, HiveConf.getFloatVar(aspCtx.getConf(), HiveConf.ConfVars.HIVE_STATS_IN_MIN_RATIO));
            }
            float inFactor = HiveConf.getFloatVar(aspCtx.getConf(), HiveConf.ConfVars.HIVE_STATS_IN_CLAUSE_FACTOR);
            return Math.round((double)numRows * factor * (double)inFactor);
        }

        private long evaluateBetweenExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)pred;
            boolean invert = Boolean.TRUE.equals(((ExprNodeConstantDesc)fd.getChildren().get(0)).getValue());
            ExprNodeDesc comparisonExpression = fd.getChildren().get(1);
            ExprNodeDesc leftExpression = fd.getChildren().get(2);
            ExprNodeDesc rightExpression = fd.getChildren().get(3);
            if (leftExpression instanceof ExprNodeDynamicValueDesc) {
                return currNumRows;
            }
            ExprNodeGenericFuncDesc leftComparator = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Lists.newArrayList(comparisonExpression, leftExpression));
            ExprNodeGenericFuncDesc rightComparator = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Lists.newArrayList(comparisonExpression, rightExpression));
            ExprNodeGenericFuncDesc newExpression = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), Lists.newArrayList(leftComparator, rightComparator));
            if (invert) {
                newExpression = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPNot(), Lists.newArrayList(newExpression));
            }
            return this.evaluateExpression(stats, newExpression, aspCtx, neededCols, op, currNumRows);
        }

        private long evaluateNotExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            long numRows = currNumRows;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ColStatistics cs;
                    if (leaf instanceof ExprNodeGenericFuncDesc) {
                        long newNumRows = 0L;
                        for (ExprNodeDesc child : genFunc.getChildren()) {
                            newNumRows = this.evaluateChildExpr(stats, child, aspCtx, neededCols, op, numRows);
                        }
                        return numRows - newNumRows;
                    }
                    if (leaf instanceof ExprNodeConstantDesc) {
                        ExprNodeConstantDesc encd = (ExprNodeConstantDesc)leaf;
                        if (Boolean.TRUE.equals(encd.getValue())) {
                            return 0L;
                        }
                        return numRows;
                    }
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc encd = (ExprNodeColumnDesc)leaf;
                    String colName = encd.getColumn();
                    String colType = encd.getTypeString();
                    if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsFromColName(colName)) != null) {
                        return cs.getNumFalses();
                    }
                    return numRows / 2L;
                }
            }
            return numRows / 2L;
        }

        private long evaluateColEqualsNullExpr(Statistics stats, ExprNodeDesc pred, long currNumRows) {
            long numRows = currNumRows;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ExprNodeColumnDesc colDesc;
                    String colName;
                    ColStatistics cs;
                    if (!(leaf instanceof ExprNodeColumnDesc) || (cs = stats.getColumnStatisticsFromColName(colName = (colDesc = (ExprNodeColumnDesc)leaf).getColumn())) == null) continue;
                    return cs.getNumNulls();
                }
            }
            return numRows / 2L;
        }

        private long evaluateNotNullExpr(Statistics parentStats, ExprNodeGenericFuncDesc pred, long currNumRows) {
            long parentCardinality;
            long noOfNulls = this.getMaxNulls(parentStats, pred);
            long newPredCardinality = parentCardinality = currNumRows;
            if (parentCardinality > noOfNulls) {
                newPredCardinality = parentCardinality - noOfNulls;
            } else {
                LOG.error("Invalid column stats: No of nulls > cardinality");
            }
            return newPredCardinality;
        }

        private long getMaxNulls(Statistics stats, ExprNodeDesc pred) {
            long tmpNoNulls = 0L;
            long maxNoNulls = 0L;
            if (pred instanceof ExprNodeColumnDesc) {
                ColStatistics cs = stats.getColumnStatisticsFromColName(((ExprNodeColumnDesc)pred).getColumn());
                if (cs != null) {
                    tmpNoNulls = cs.getNumNulls();
                }
            } else if (pred instanceof ExprNodeGenericFuncDesc || pred instanceof ExprNodeColumnListDesc) {
                long noNullsOfChild = 0L;
                for (ExprNodeDesc childExpr : pred.getChildren()) {
                    noNullsOfChild = this.getMaxNulls(stats, childExpr);
                    if (noNullsOfChild <= tmpNoNulls) continue;
                    tmpNoNulls = noNullsOfChild;
                }
            } else if (pred instanceof ExprNodeConstantDesc) {
                tmpNoNulls = ExprNodeDescUtils.isNullConstant(pred) ? stats.getNumRows() : 0L;
            } else if (pred instanceof ExprNodeDynamicListDesc) {
                tmpNoNulls = 0L;
            } else if (pred instanceof ExprNodeFieldDesc) {
                tmpNoNulls = this.getMaxNulls(stats, ((ExprNodeFieldDesc)pred).getDesc());
            }
            if (tmpNoNulls > maxNoNulls) {
                maxNoNulls = tmpNoNulls;
            }
            return maxNoNulls;
        }

        private long evaluateComparator(Statistics stats, ExprNodeGenericFuncDesc genFunc, long currNumRows) {
            boolean upperBound;
            ExprNodeColumnDesc columnDesc;
            long numRows = currNumRows;
            GenericUDF udf = genFunc.getGenericUDF();
            String boundValue = null;
            if (genFunc.getChildren().get(0) instanceof ExprNodeColumnDesc && genFunc.getChildren().get(1) instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)genFunc.getChildren().get(0);
                ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)genFunc.getChildren().get(1);
                if (constantDesc.getValue() == null) {
                    return 0L;
                }
                if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPGreaterThan) {
                    boundValue = constantDesc.getValue().toString();
                    upperBound = false;
                } else {
                    boundValue = constantDesc.getValue().toString();
                    upperBound = true;
                }
            } else if (genFunc.getChildren().get(1) instanceof ExprNodeColumnDesc && genFunc.getChildren().get(0) instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)genFunc.getChildren().get(1);
                ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)genFunc.getChildren().get(0);
                if (constantDesc.getValue() == null) {
                    return 0L;
                }
                if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPGreaterThan) {
                    boundValue = constantDesc.getValue().toString();
                    upperBound = true;
                } else {
                    boundValue = constantDesc.getValue().toString();
                    upperBound = false;
                }
            } else {
                return numRows / 3L;
            }
            ColStatistics cs = stats.getColumnStatisticsFromColName(columnDesc.getColumn());
            if (cs != null && cs.getRange() != null && cs.getRange().maxValue != null && cs.getRange().minValue != null) {
                String colTypeLowerCase = columnDesc.getTypeString().toLowerCase();
                try {
                    if (colTypeLowerCase.equals("tinyint")) {
                        byte value = new Byte(boundValue);
                        byte maxValue = cs.getRange().maxValue.byteValue();
                        byte minValue = cs.getRange().minValue.byteValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    } else if (colTypeLowerCase.equals("smallint")) {
                        short value = new Short(boundValue);
                        short maxValue = cs.getRange().maxValue.shortValue();
                        short minValue = cs.getRange().minValue.shortValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    } else if (colTypeLowerCase.equals("int") || colTypeLowerCase.equals("date")) {
                        int value;
                        if (colTypeLowerCase == "date") {
                            DateWritable writableVal = new DateWritable(Date.valueOf(boundValue));
                            value = writableVal.getDays();
                        } else {
                            value = new Integer(boundValue);
                        }
                        int maxValue = cs.getRange().maxValue.intValue();
                        int minValue = cs.getRange().minValue.intValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    } else if (colTypeLowerCase.equals("bigint")) {
                        long value = new Long(boundValue);
                        long maxValue = cs.getRange().maxValue.longValue();
                        long minValue = cs.getRange().minValue.longValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    } else if (colTypeLowerCase.equals("float")) {
                        float value = new Float(boundValue).floatValue();
                        float maxValue = cs.getRange().maxValue.floatValue();
                        float minValue = cs.getRange().minValue.floatValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    } else if (colTypeLowerCase.equals("double")) {
                        double value = new Double(boundValue);
                        double maxValue = cs.getRange().maxValue.doubleValue();
                        double minValue = cs.getRange().minValue.doubleValue();
                        if (upperBound) {
                            if (maxValue < value) {
                                return numRows;
                            }
                            if (minValue > value) {
                                return 0L;
                            }
                        } else {
                            if (minValue >= value) {
                                return numRows;
                            }
                            if (maxValue < value) {
                                return 0L;
                            }
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    return numRows / 3L;
                }
            }
            return numRows / 3L;
        }

        private long evaluateChildExpr(Statistics stats, ExprNodeDesc child, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op, long currNumRows) throws SemanticException {
            long numRows = currNumRows;
            if (child instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)child;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPEqual || udf instanceof GenericUDFOPEqualNS) {
                    String colName = null;
                    boolean isConst = false;
                    Object prevConst = null;
                    for (ExprNodeDesc leaf : genFunc.getChildren()) {
                        if (leaf instanceof ExprNodeConstantDesc) {
                            if (isConst) {
                                if (prevConst != null && !prevConst.equals(((ExprNodeConstantDesc)leaf).getValue())) {
                                    return 0L;
                                }
                                return numRows;
                            }
                            if (colName == null) {
                                isConst = true;
                                prevConst = ((ExprNodeConstantDesc)leaf).getValue();
                                continue;
                            }
                            if (neededCols != null && !neededCols.contains(colName)) {
                                return numRows;
                            }
                            ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                            if (cs == null) continue;
                            long dvs = cs.getCountDistint();
                            numRows = dvs == 0L ? numRows / 2L : Math.round((double)numRows / (double)dvs);
                            return numRows;
                        }
                        if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                        ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                        colName = colDesc.getColumn();
                        if (!isConst) continue;
                        if (neededCols != null && neededCols.indexOf(colName) == -1) {
                            return numRows;
                        }
                        ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                        if (cs == null) continue;
                        long dvs = cs.getCountDistint();
                        numRows = dvs == 0L ? numRows / 2L : Math.round((double)numRows / (double)dvs);
                        return numRows;
                    }
                } else {
                    if (udf instanceof GenericUDFOPNotEqual) {
                        return numRows;
                    }
                    if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPEqualOrLessThan || udf instanceof GenericUDFOPGreaterThan || udf instanceof GenericUDFOPLessThan) {
                        return this.evaluateComparator(stats, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPNotNull) {
                        return this.evaluateNotNullExpr(stats, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPNull) {
                        return this.evaluateColEqualsNullExpr(stats, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPAnd || udf instanceof GenericUDFOPOr || udf instanceof GenericUDFIn || udf instanceof GenericUDFBetween || udf instanceof GenericUDFOPNot) {
                        return this.evaluateExpression(stats, genFunc, aspCtx, neededCols, op, numRows);
                    }
                    if (udf instanceof GenericUDFInBloomFilter && genFunc.getChildren().get(1) instanceof ExprNodeDynamicValueDesc) {
                        return numRows;
                    }
                }
            } else if (child instanceof ExprNodeConstantDesc) {
                if (Boolean.FALSE.equals(((ExprNodeConstantDesc)child).getValue())) {
                    return 0L;
                }
                return numRows;
            }
            return numRows / 2L;
        }

        private static class ValuePruner {
            private boolean valid;
            private RangeOps colRange;

            ValuePruner(ColStatistics colStatistics) {
                if (colStatistics == null) {
                    this.valid = false;
                    return;
                }
                this.colRange = RangeOps.build(colStatistics.getColumnType(), colStatistics.getRange());
                if (this.colRange == null) {
                    this.valid = false;
                    return;
                }
                this.valid = true;
            }

            public boolean isValid() {
                return this.valid;
            }

            public boolean accept(ExprNodeDesc.ExprNodeDescEqualityWrapper e) {
                return !this.valid || this.colRange.contains(e.getExprNodeDesc());
            }
        }

        static class RangeOps {
            private String colType;
            private ColStatistics.Range range;

            public RangeOps(String colType, ColStatistics.Range range) {
                this.colType = colType;
                this.range = range;
            }

            public static RangeOps build(String colType, ColStatistics.Range range) {
                if (range == null || range.minValue == null || range.maxValue == null) {
                    return null;
                }
                return new RangeOps(colType, range);
            }

            public boolean contains(ExprNodeDesc exprNode) {
                RangeResult intersection = this.intersect(exprNode);
                return intersection != RangeResult.ABOVE && intersection != RangeResult.BELOW;
            }

            public RangeResult intersect(ExprNodeDesc exprNode) {
                if (!(exprNode instanceof ExprNodeConstantDesc)) {
                    return null;
                }
                try {
                    String stringVal;
                    ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)exprNode;
                    String boundValue = stringVal = constantDesc.getValue().toString();
                    switch (this.colType) {
                        case "tinyint": {
                            byte value = new Byte(stringVal);
                            byte maxValue = this.range.maxValue.byteValue();
                            byte minValue = this.range.minValue.byteValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "smallint": {
                            short value = new Short(boundValue);
                            short maxValue = this.range.maxValue.shortValue();
                            short minValue = this.range.minValue.shortValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "date": {
                            DateWritable dateWriteable = new DateWritable(Date.valueOf(boundValue));
                            int value = dateWriteable.getDays();
                            int maxValue = this.range.maxValue.intValue();
                            int minValue = this.range.minValue.intValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "int": {
                            int value = new Integer(boundValue);
                            int maxValue = this.range.maxValue.intValue();
                            int minValue = this.range.minValue.intValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "bigint": {
                            long value = new Long(boundValue);
                            long maxValue = this.range.maxValue.longValue();
                            long minValue = this.range.minValue.longValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "float": {
                            float value = new Float(boundValue).floatValue();
                            float maxValue = this.range.maxValue.floatValue();
                            float minValue = this.range.minValue.floatValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "double": {
                            double value = new Double(boundValue);
                            double maxValue = this.range.maxValue.doubleValue();
                            double minValue = this.range.minValue.doubleValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }

            static enum RangeResult {
                BELOW,
                AT_MIN,
                BETWEEN,
                AT_MAX,
                ABOVE;


                public static RangeResult of(boolean ltMin, boolean ltMax, boolean eqMin, boolean eqMax) {
                    if (ltMin) {
                        return BELOW;
                    }
                    if (eqMin) {
                        return AT_MIN;
                    }
                    if (ltMax) {
                        return BETWEEN;
                    }
                    if (eqMax) {
                        return AT_MAX;
                    }
                    return ABOVE;
                }
            }
        }
    }

    public static class SelectStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sop = (SelectOperator)nd;
            Operator<OperatorDesc> parent = sop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            Statistics stats = null;
            if (parentStats != null) {
                stats = parentStats.clone();
            }
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, sop.getColumnExprMap(), sop.getSchema());
                stats.setColumnStats(colStats);
                if (!((SelectDesc)sop.getConf()).isSelectStar() && !((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                    long dataSize = StatsUtils.getDataSizeFromColumnStats(stats.getNumRows(), colStats);
                    stats.setDataSize(dataSize);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, sop);
                sop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + sop.toString() + ": " + stats.extendedToString());
                }
            } else if (parentStats != null) {
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, sop);
                sop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + sop.toString() + ": " + parentStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class TableScanStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsop = (TableScanOperator)nd;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            PrunedPartitionList partList = aspCtx.getParseContext().getPrunedPartitions(tsop);
            ColumnStatsList colStatsCached = aspCtx.getParseContext().getColStatsCached(partList);
            Table table = ((TableScanDesc)tsop.getConf()).getTableMetadata();
            try {
                Statistics stats = StatsUtils.collectStatistics(aspCtx.getConf(), partList, colStatsCached, table, tsop);
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, tsop);
                tsop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + tsop.toString() + " (" + table.getTableName() + "): " + stats.extendedToString());
                }
            }
            catch (HiveException e) {
                LOG.debug("Failed to retrieve stats ", (Throwable)e);
                throw new SemanticException(e);
            }
            return null;
        }
    }
}

