/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hive.com.google.common.collect.LinkedListMultimap;
import org.apache.hive.com.google.common.collect.Multimap;

class CustomEdgeConfiguration
implements Writable {
    boolean vertexInited = false;
    int numBuckets = -1;
    Multimap<Integer, Integer> bucketToTaskMap = null;

    public CustomEdgeConfiguration() {
    }

    public CustomEdgeConfiguration(int numBuckets, Multimap<Integer, Integer> routingTable) {
        this.bucketToTaskMap = routingTable;
        this.numBuckets = numBuckets;
        if (routingTable != null) {
            this.vertexInited = true;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.vertexInited);
        out.writeInt(this.numBuckets);
        if (this.bucketToTaskMap == null) {
            return;
        }
        out.writeInt(this.bucketToTaskMap.size());
        for (Map.Entry<Integer, Collection<Integer>> entry : this.bucketToTaskMap.asMap().entrySet()) {
            int bucketNum = entry.getKey();
            for (Integer taskId : entry.getValue()) {
                out.writeInt(bucketNum);
                out.writeInt(taskId);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.vertexInited = in.readBoolean();
        this.numBuckets = in.readInt();
        if (!this.vertexInited) {
            return;
        }
        int count = in.readInt();
        this.bucketToTaskMap = LinkedListMultimap.create();
        for (int i = 0; i < count; ++i) {
            this.bucketToTaskMap.put(in.readInt(), in.readInt());
        }
        if (count != this.bucketToTaskMap.size()) {
            throw new IOException("Was not a clean translation. Some records are missing");
        }
    }

    public Multimap<Integer, Integer> getRoutingTable() {
        return this.bucketToTaskMap;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }
}

