/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.hbase.HBaseFilterPlanUtil;
import org.apache.hadoop.hive.metastore.hbase.HBaseReadWrite;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;
import org.apache.hadoop.hive.metastore.hbase.HbaseMetastoreProto;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.cache.CacheLoader;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStore
implements RawStore {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseStore.class.getName());
    private HBaseReadWrite hbase = null;
    private Configuration conf;
    private int txnNestLevel = 0;
    private PartitionExpressionProxy expressionProxy = null;
    private Map<FileMetadataExprType, FileMetadataHandler> fmHandlers;

    @Override
    public void shutdown() {
        try {
            if (this.txnNestLevel != 0) {
                this.rollbackTransaction();
            }
            this.getHBase().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean openTransaction() {
        if (this.txnNestLevel++ <= 0) {
            LOG.debug("Opening HBase transaction");
            this.getHBase().begin();
            this.txnNestLevel = 1;
        }
        return true;
    }

    @Override
    public boolean commitTransaction() {
        if (--this.txnNestLevel == 0) {
            LOG.debug("Committing HBase transaction");
            this.getHBase().commit();
        }
        return true;
    }

    @Override
    public boolean isActiveTransaction() {
        return this.txnNestLevel != 0;
    }

    @Override
    public void rollbackTransaction() {
        this.txnNestLevel = 0;
        LOG.debug("Rolling back HBase transaction");
        this.getHBase().rollback();
    }

    @Override
    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Database dbCopy = db.deepCopy();
            dbCopy.setName(HiveStringUtils.normalizeIdentifier(dbCopy.getName()));
            this.getHBase().putDb(dbCopy);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to create database ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            Database db = this.getHBase().getDb(HiveStringUtils.normalizeIdentifier(name));
            if (db == null) {
                throw new NoSuchObjectException("Unable to find db " + name);
            }
            commit = true;
            Database database = db;
            return database;
        }
        catch (IOException e) {
            LOG.error("Unable to get db", e);
            throw new NoSuchObjectException("Error reading db " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean dropDatabase(String dbname) throws NoSuchObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteDb(HiveStringUtils.normalizeIdentifier(dbname));
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to delete db" + e);
            throw new MetaException("Unable to drop database " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean alterDatabase(String dbname, Database db) throws NoSuchObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Database dbCopy = db.deepCopy();
            dbCopy.setName(HiveStringUtils.normalizeIdentifier(dbCopy.getName()));
            this.getHBase().putDb(dbCopy);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to alter database ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getDatabases(String pattern) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Database> dbs = this.getHBase().scanDatabases(pattern == null ? null : HiveStringUtils.normalizeIdentifier(this.likeToRegex(pattern)));
            ArrayList<String> dbNames = new ArrayList<String>(dbs.size());
            for (Database db : dbs) {
                dbNames.add(db.getName());
            }
            commit = true;
            ArrayList<String> arrayList = dbNames;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Unable to get databases ", e);
            throw new MetaException("Unable to get databases, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        return this.getDatabases(null);
    }

    @Override
    public int getDatabaseCount() throws MetaException {
        try {
            return this.getHBase().getDatabaseCount();
        }
        catch (IOException e) {
            LOG.error("Unable to get database count", e);
            throw new MetaException("Error scanning databases");
        }
    }

    @Override
    public boolean createType(Type type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getType(String typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dropType(String typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Table tblCopy = tbl.deepCopy();
            tblCopy.setDbName(HiveStringUtils.normalizeIdentifier(tblCopy.getDbName()));
            tblCopy.setTableName(HiveStringUtils.normalizeIdentifier(tblCopy.getTableName()));
            this.normalizeColumnNames(tblCopy);
            this.getHBase().putTable(tblCopy);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to create table ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    private void normalizeColumnNames(Table tbl) {
        if (tbl.getSd().getCols() != null) {
            tbl.getSd().setCols(this.normalizeFieldSchemaList(tbl.getSd().getCols()));
        }
        if (tbl.getPartitionKeys() != null) {
            tbl.setPartitionKeys(this.normalizeFieldSchemaList(tbl.getPartitionKeys()));
        }
    }

    private List<FieldSchema> normalizeFieldSchemaList(List<FieldSchema> fieldschemas) {
        ArrayList<FieldSchema> ret = new ArrayList<FieldSchema>();
        for (FieldSchema fieldSchema : fieldschemas) {
            ret.add(new FieldSchema(fieldSchema.getName().toLowerCase(), fieldSchema.getType(), fieldSchema.getComment()));
        }
        return ret;
    }

    @Override
    public boolean dropTable(String dbName, String tableName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteTable(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName));
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to delete db" + e);
            throw new MetaException("Unable to drop table " + this.tableNameForErrorMsg(dbName, tableName));
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public Table getTable(String dbName, String tableName) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Table table = this.getHBase().getTable(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName));
            if (table == null) {
                LOG.debug("Unable to find table " + this.tableNameForErrorMsg(dbName, tableName));
            }
            commit = true;
            Table table2 = table;
            return table2;
        }
        catch (IOException e) {
            LOG.error("Unable to get table", e);
            throw new MetaException("Error reading table " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Partition partCopy = part.deepCopy();
            partCopy.setDbName(HiveStringUtils.normalizeIdentifier(part.getDbName()));
            partCopy.setTableName(HiveStringUtils.normalizeIdentifier(part.getTableName()));
            this.getHBase().putPartition(partCopy);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to add partition", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            ArrayList<Partition> partsCopy = new ArrayList<Partition>();
            for (int i = 0; i < parts.size(); ++i) {
                Partition partCopy = parts.get(i).deepCopy();
                partCopy.setDbName(HiveStringUtils.normalizeIdentifier(partCopy.getDbName()));
                partCopy.setTableName(HiveStringUtils.normalizeIdentifier(partCopy.getTableName()));
                partsCopy.add(i, partCopy);
            }
            this.getHBase().putPartitions(partsCopy);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to add partitions", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean addPartitions(String dbName, String tblName, PartitionSpecProxy partitionSpec, boolean ifNotExists) throws InvalidObjectException, MetaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Partition getPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            Partition part = this.getHBase().getPartition(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName), part_vals);
            if (part == null) {
                throw new NoSuchObjectException("Unable to find partition " + this.partNameForErrorMsg(dbName, tableName, part_vals));
            }
            commit = true;
            Partition partition = part;
            return partition;
        }
        catch (IOException e) {
            LOG.error("Unable to get partition", e);
            throw new MetaException("Error reading partition " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean doesPartitionExist(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            boolean exists = this.getHBase().getPartition(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName), part_vals) != null;
            commit = true;
            boolean bl = exists;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to get partition", e);
            throw new MetaException("Error reading partition " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, List<String> part_vals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean commit = false;
        this.openTransaction();
        try {
            dbName = HiveStringUtils.normalizeIdentifier(dbName);
            tableName = HiveStringUtils.normalizeIdentifier(tableName);
            this.getHBase().deletePartition(dbName, tableName, HBaseUtils.getPartitionKeyTypes(this.getTable(dbName, tableName).getPartitionKeys()), part_vals);
            this.getHBase().getStatsCache().invalidate(dbName, tableName, this.buildExternalPartName(dbName, tableName, part_vals));
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to delete db" + e);
            throw new MetaException("Unable to drop partition " + this.partNameForErrorMsg(dbName, tableName, part_vals));
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<Partition> getPartitions(String dbName, String tableName, int max) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Partition> parts = this.getHBase().scanPartitionsInTable(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName), max);
            commit = true;
            List<Partition> list = parts;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get partitions", e);
            throw new MetaException("Error scanning partitions");
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void alterTable(String dbName, String tableName, Table newTable) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Table newTableCopy = newTable.deepCopy();
            newTableCopy.setDbName(HiveStringUtils.normalizeIdentifier(newTableCopy.getDbName()));
            List<String> oldPartTypes = this.getTable(dbName, tableName).getPartitionKeys() == null ? null : HBaseUtils.getPartitionKeyTypes(this.getTable(dbName, tableName).getPartitionKeys());
            newTableCopy.setTableName(HiveStringUtils.normalizeIdentifier(newTableCopy.getTableName()));
            this.getHBase().replaceTable(this.getHBase().getTable(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tableName)), newTableCopy);
            if (newTable.getPartitionKeys() != null && newTable.getPartitionKeys().size() > 0 && !tableName.equals(newTable.getTableName())) {
                try {
                    List<Partition> oldParts = this.getPartitions(dbName, tableName, -1);
                    ArrayList<Partition> newParts = new ArrayList<Partition>(oldParts.size());
                    for (Partition oldPart : oldParts) {
                        Partition newPart = oldPart.deepCopy();
                        newPart.setTableName(newTable.getTableName());
                        newParts.add(newPart);
                    }
                    this.getHBase().replacePartitions(oldParts, newParts, oldPartTypes);
                }
                catch (NoSuchObjectException e) {
                    LOG.debug("No partitions found for old table so not worrying about it");
                }
            }
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to alter table " + this.tableNameForErrorMsg(dbName, tableName), e);
            throw new MetaException("Unable to alter table " + this.tableNameForErrorMsg(dbName, tableName));
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getTables(String dbName, String pattern) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<String> tableNames = this.getTableNamesInTx(dbName, pattern);
            commit = true;
            List<String> list = tableNames;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get tables ", e);
            throw new MetaException("Unable to get tables, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getTables(String dbName, String pattern, TableType tableType) throws MetaException {
        throw new UnsupportedOperationException();
    }

    private List<String> getTableNamesInTx(String dbName, String pattern) throws IOException {
        List<Table> tables = this.getHBase().scanTables(HiveStringUtils.normalizeIdentifier(dbName), pattern == null ? null : HiveStringUtils.normalizeIdentifier(this.likeToRegex(pattern)));
        ArrayList<String> tableNames = new ArrayList<String>(tables.size());
        for (Table table : tables) {
            tableNames.add(table.getTableName());
        }
        return tableNames;
    }

    @Override
    public List<TableMeta> getTableMeta(String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            ArrayList<TableMeta> metas = new ArrayList<TableMeta>();
            for (String dbName : this.getDatabases(dbNames)) {
                for (Table table : this.getTableObjectsByName(dbName, this.getTableNamesInTx(dbName, tableNames))) {
                    if (tableTypes != null && !tableTypes.contains(table.getTableType())) continue;
                    TableMeta metaData = new TableMeta(table.getDbName(), table.getTableName(), table.getTableType());
                    metaData.setComments(table.getParameters().get("comment"));
                    metas.add(metaData);
                }
            }
            commit = true;
            ArrayList<TableMeta> arrayList = metas;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Unable to get tables ", e);
            throw new MetaException("Unable to get tables, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<Table> getTableObjectsByName(String dbname, List<String> tableNames) throws MetaException, UnknownDBException {
        boolean commit = false;
        this.openTransaction();
        try {
            ArrayList<String> normalizedTableNames = new ArrayList<String>(tableNames.size());
            for (String tableName : tableNames) {
                normalizedTableNames.add(HiveStringUtils.normalizeIdentifier(tableName));
            }
            List<Table> tables = this.getHBase().getTables(HiveStringUtils.normalizeIdentifier(dbname), normalizedTableNames);
            commit = true;
            List<Table> list = tables;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get tables ", e);
            throw new MetaException("Unable to get tables, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getAllTables(String dbName) throws MetaException {
        return this.getTables(dbName, null);
    }

    @Override
    public int getTableCount() throws MetaException {
        try {
            return this.getHBase().getTableCount();
        }
        catch (IOException e) {
            LOG.error("Unable to get table count", e);
            throw new MetaException("Error scanning tables");
        }
    }

    @Override
    public List<String> listTableNamesByFilter(String dbName, String filter, short max_tables) throws MetaException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Partition> parts = this.getHBase().scanPartitionsInTable(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), max_parts);
            if (parts == null) {
                List<String> list = null;
                return list;
            }
            ArrayList<String> names = new ArrayList<String>(parts.size());
            Table table = this.getHBase().getTable(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name));
            for (Partition p : parts) {
                names.add(this.buildExternalPartName(table, p));
            }
            commit = true;
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Unable to get partitions", e);
            throw new MetaException("Error scanning partitions");
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public PartitionValuesResponse listPartitionValues(String db_name, String tbl_name, List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending, List<FieldSchema> order, long maxParts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listPartitionNamesByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void alterPartition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Partition new_partCopy = new_part.deepCopy();
            new_partCopy.setDbName(HiveStringUtils.normalizeIdentifier(new_partCopy.getDbName()));
            new_partCopy.setTableName(HiveStringUtils.normalizeIdentifier(new_partCopy.getTableName()));
            Partition oldPart = this.getHBase().getPartition(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), part_vals);
            this.getHBase().replacePartition(oldPart, new_partCopy, HBaseUtils.getPartitionKeyTypes(this.getTable(db_name, tbl_name).getPartitionKeys()));
            this.getHBase().getStatsCache().invalidate(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), this.buildExternalPartName(db_name, tbl_name, part_vals));
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to add partition", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void alterPartitions(String db_name, String tbl_name, List<List<String>> part_vals_list, List<Partition> new_parts) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            ArrayList<Partition> new_partsCopy = new ArrayList<Partition>();
            for (int i = 0; i < new_parts.size(); ++i) {
                Partition newPartCopy = new_parts.get(i).deepCopy();
                newPartCopy.setDbName(HiveStringUtils.normalizeIdentifier(newPartCopy.getDbName()));
                newPartCopy.setTableName(HiveStringUtils.normalizeIdentifier(newPartCopy.getTableName()));
                new_partsCopy.add(i, newPartCopy);
            }
            List<Partition> oldParts = this.getHBase().getPartitions(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), HBaseUtils.getPartitionKeyTypes(this.getTable(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name)).getPartitionKeys()), part_vals_list);
            this.getHBase().replacePartitions(oldParts, new_partsCopy, HBaseUtils.getPartitionKeyTypes(this.getTable(db_name, tbl_name).getPartitionKeys()));
            for (List<String> part_vals : part_vals_list) {
                this.getHBase().getStatsCache().invalidate(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), this.buildExternalPartName(db_name, tbl_name, part_vals));
            }
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to add partition", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean addIndex(Index index) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            index.setDbName(HiveStringUtils.normalizeIdentifier(index.getDbName()));
            index.setOrigTableName(HiveStringUtils.normalizeIdentifier(index.getOrigTableName()));
            index.setIndexName(HiveStringUtils.normalizeIdentifier(index.getIndexName()));
            index.setIndexTableName(HiveStringUtils.normalizeIdentifier(index.getIndexTableName()));
            this.getHBase().putIndex(index);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to create index ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
        return commit;
    }

    @Override
    public Index getIndex(String dbName, String origTableName, String indexName) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Index index = this.getHBase().getIndex(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(origTableName), HiveStringUtils.normalizeIdentifier(indexName));
            if (index == null) {
                LOG.debug("Unable to find index " + this.indexNameForErrorMsg(dbName, origTableName, indexName));
            }
            commit = true;
            Index index2 = index;
            return index2;
        }
        catch (IOException e) {
            LOG.error("Unable to get index", e);
            throw new MetaException("Error reading index " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean dropIndex(String dbName, String origTableName, String indexName) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteIndex(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(origTableName), HiveStringUtils.normalizeIdentifier(indexName));
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to delete index" + e);
            throw new MetaException("Unable to drop index " + this.indexNameForErrorMsg(dbName, origTableName, indexName));
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<Index> getIndexes(String dbName, String origTableName, int max) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Index> indexes = this.getHBase().scanIndexes(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(origTableName), max);
            commit = true;
            List<Index> list = indexes;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get indexes", e);
            throw new MetaException("Error scanning indexxes");
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> listIndexNames(String dbName, String origTableName, short max) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Index> indexes = this.getHBase().scanIndexes(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(origTableName), max);
            if (indexes == null) {
                List<String> list = null;
                return list;
            }
            ArrayList<String> names = new ArrayList<String>(indexes.size());
            for (Index index : indexes) {
                names.add(index.getIndexName());
            }
            commit = true;
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Unable to get indexes", e);
            throw new MetaException("Error scanning indexes");
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void alterIndex(String dbname, String baseTblName, String name, Index newIndex) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Index newIndexCopy = newIndex.deepCopy();
            newIndexCopy.setDbName(HiveStringUtils.normalizeIdentifier(newIndexCopy.getDbName()));
            newIndexCopy.setOrigTableName(HiveStringUtils.normalizeIdentifier(newIndexCopy.getOrigTableName()));
            newIndexCopy.setIndexName(HiveStringUtils.normalizeIdentifier(newIndexCopy.getIndexName()));
            this.getHBase().replaceIndex(this.getHBase().getIndex(HiveStringUtils.normalizeIdentifier(dbname), HiveStringUtils.normalizeIdentifier(baseTblName), HiveStringUtils.normalizeIdentifier(name)), newIndexCopy);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to alter index " + this.indexNameForErrorMsg(dbname, baseTblName, name), e);
            throw new MetaException("Unable to alter index " + this.indexNameForErrorMsg(dbname, baseTblName, name));
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Partition> getPartitionsByFilter(String dbName, String tblName, String filter, short maxParts) throws MetaException, NoSuchObjectException {
        ExpressionTree exprTree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        ArrayList<Partition> result = new ArrayList<Partition>();
        boolean commit = false;
        this.openTransaction();
        try {
            this.getPartitionsByExprInternal(HiveStringUtils.normalizeIdentifier(dbName), HiveStringUtils.normalizeIdentifier(tblName), exprTree, maxParts, result);
            ArrayList<Partition> arrayList = result;
            return arrayList;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPartitionsByExpr(String dbName, String tblName, byte[] expr, String defaultPartitionName, short maxParts, List<Partition> result) throws TException {
        ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree(this.expressionProxy, expr);
        dbName = HiveStringUtils.normalizeIdentifier(dbName);
        tblName = HiveStringUtils.normalizeIdentifier(tblName);
        Table table = this.getTable(dbName, tblName);
        boolean commit = false;
        this.openTransaction();
        try {
            if (exprTree == null) {
                LinkedList<String> partNames = new LinkedList<String>();
                boolean hasUnknownPartitions = this.getPartitionNamesPrunedByExprNoTxn(table, expr, defaultPartitionName, maxParts, partNames);
                result.addAll(this.getPartitionsByNames(dbName, tblName, partNames));
                boolean bl = hasUnknownPartitions;
                return bl;
            }
            boolean bl = this.getPartitionsByExprInternal(dbName, tblName, exprTree, maxParts, result);
            return bl;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPartitionsByFilter(String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException {
        ExpressionTree exprTree = filter != null && !filter.isEmpty() ? PartFilterExprUtil.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        ArrayList result = new ArrayList();
        boolean commit = false;
        this.openTransaction();
        try {
            int n = this.getPartitionsByFilter(dbName, tblName, filter, (short)Short.MAX_VALUE).size();
            return n;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPartitionsByExpr(String dbName, String tblName, byte[] expr) throws MetaException, NoSuchObjectException {
        ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree(this.expressionProxy, expr);
        ArrayList<Partition> result = new ArrayList<Partition>();
        boolean commit = false;
        this.openTransaction();
        try {
            this.getPartitionsByExprInternal(dbName, tblName, exprTree, (short)Short.MAX_VALUE, result);
            int n = result.size();
            return n;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    private boolean getPartitionNamesPrunedByExprNoTxn(Table table, byte[] expr, String defaultPartName, short maxParts, List<String> result) throws MetaException, NoSuchObjectException {
        List<Partition> parts = this.getPartitions(table.getDbName(), table.getTableName(), maxParts);
        for (Partition part : parts) {
            result.add(Warehouse.makePartName(table.getPartitionKeys(), part.getValues()));
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> typeInfos = new ArrayList<PrimitiveTypeInfo>();
        for (FieldSchema fs : table.getPartitionKeys()) {
            columnNames.add(fs.getName());
            typeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo(fs.getType()));
        }
        if (defaultPartName == null || defaultPartName.isEmpty()) {
            defaultPartName = HiveConf.getVar(this.getConf(), HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        }
        return this.expressionProxy.filterPartitionsByExpr(columnNames, typeInfos, expr, defaultPartName, result);
    }

    private boolean getPartitionsByExprInternal(String dbName, String tblName, ExpressionTree exprTree, short maxParts, List<Partition> result) throws MetaException, NoSuchObjectException {
        Table table = this.getTable(dbName = HiveStringUtils.normalizeIdentifier(dbName), tblName = HiveStringUtils.normalizeIdentifier(tblName));
        if (table == null) {
            throw new NoSuchObjectException("Unable to find table " + dbName + "." + tblName);
        }
        HBaseFilterPlanUtil.PlanResult planRes = HBaseFilterPlanUtil.getFilterPlan(exprTree, table.getPartitionKeys());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hbase Filter Plan generated : " + planRes.plan);
        }
        HashMap<List<String>, Partition> mergedParts = new HashMap<List<String>, Partition>();
        for (HBaseFilterPlanUtil.ScanPlan scanPlan : planRes.plan.getPlans()) {
            try {
                List<Partition> parts = this.getHBase().scanPartitions(dbName, tblName, scanPlan.getStartRowSuffix(dbName, tblName, table.getPartitionKeys()), scanPlan.getEndRowSuffix(dbName, tblName, table.getPartitionKeys()), scanPlan.getFilter(table.getPartitionKeys()), -1);
                boolean reachedMax = false;
                for (Partition part : parts) {
                    mergedParts.put(part.getValues(), part);
                    if (mergedParts.size() != maxParts) continue;
                    reachedMax = true;
                    break;
                }
                if (!reachedMax) continue;
                break;
            }
            catch (IOException e) {
                LOG.error("Unable to get partitions", e);
                throw new MetaException("Error scanning partitions" + this.tableNameForErrorMsg(dbName, tblName) + ": " + e);
            }
        }
        for (Map.Entry entry : mergedParts.entrySet()) {
            result.add((Partition)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matched partitions " + result);
        }
        return !planRes.hasUnsupportedCondition;
    }

    @Override
    public List<Partition> getPartitionsByNames(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        ArrayList<Partition> parts = new ArrayList<Partition>();
        for (String partName : partNames) {
            parts.add(this.getPartition(dbName, tblName, HBaseStore.partNameToVals(partName)));
        }
        return parts;
    }

    @Override
    public Table markPartitionForEvent(String dbName, String tblName, Map<String, String> partVals, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPartitionCount() throws MetaException {
        try {
            return this.getHBase().getPartitionCount();
        }
        catch (IOException e) {
            LOG.error("Unable to get partition count", e);
            throw new MetaException("Error scanning partitions");
        }
    }

    @Override
    public boolean addRole(String roleName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
        int now = (int)(System.currentTimeMillis() / 1000L);
        Role role = new Role(roleName, now, ownerName);
        boolean commit = false;
        this.openTransaction();
        try {
            if (this.getHBase().getRole(roleName) != null) {
                throw new InvalidObjectException("Role " + roleName + " already exists");
            }
            this.getHBase().putRole(role);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to create role ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            Set<String> usersInRole = this.getHBase().findAllUsersInRole(roleName);
            this.getHBase().deleteRole(roleName);
            this.getHBase().removeRoleGrants(roleName);
            for (String user : usersInRole) {
                this.getHBase().buildRoleMapForUser(user);
            }
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to delete role" + e);
            throw new MetaException("Unable to drop role " + roleName);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException, InvalidObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            Set<String> usersToRemap = this.findUsersToRemapRolesFor(role, userName, principalType);
            HbaseMetastoreProto.RoleGrantInfo.Builder builder = HbaseMetastoreProto.RoleGrantInfo.newBuilder();
            if (userName != null) {
                builder.setPrincipalName(userName);
            }
            if (principalType != null) {
                builder.setPrincipalType(HBaseUtils.convertPrincipalTypes(principalType));
            }
            builder.setAddTime((int)(System.currentTimeMillis() / 1000L));
            if (grantor != null) {
                builder.setGrantor(grantor);
            }
            if (grantorType != null) {
                builder.setGrantorType(HBaseUtils.convertPrincipalTypes(grantorType));
            }
            builder.setGrantOption(grantOption);
            this.getHBase().addPrincipalToRole(role.getRoleName(), builder.build());
            for (String user : usersToRemap) {
                this.getHBase().buildRoleMapForUser(user);
            }
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to grant role", e);
            throw new MetaException("Unable to grant role " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean revokeRole(Role role, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            if (grantOption) {
                this.getHBase().dropPrincipalFromRole(role.getRoleName(), userName, principalType, grantOption);
            } else {
                Set<String> usersToRemap = this.findUsersToRemapRolesFor(role, userName, principalType);
                this.getHBase().dropPrincipalFromRole(role.getRoleName(), userName, principalType, grantOption);
                for (String user : usersToRemap) {
                    this.getHBase().buildRoleMapForUser(user);
                }
            }
            commit = true;
            boolean usersToRemap = true;
            return usersToRemap;
        }
        catch (IOException e) {
            LOG.error("Unable to revoke role " + role.getRoleName() + " from " + userName, e);
            throw new MetaException("Unable to revoke role " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<String> roles;
            List<PrivilegeGrantInfo> pgi;
            PrincipalPrivilegeSet pps = new PrincipalPrivilegeSet();
            PrincipalPrivilegeSet global = this.getHBase().getGlobalPrivs();
            if (global == null) {
                PrincipalPrivilegeSet principalPrivilegeSet = null;
                return principalPrivilegeSet;
            }
            if (global.getUserPrivileges() != null && (pgi = global.getUserPrivileges().get(userName)) != null) {
                pps.putToUserPrivileges(userName, pgi);
            }
            if (global.getRolePrivileges() != null && (roles = this.getHBase().getUserRoles(userName)) != null) {
                for (String role : roles) {
                    pgi = global.getRolePrivileges().get(role);
                    if (pgi == null) continue;
                    pps.putToRolePrivileges(role, pgi);
                }
            }
            commit = true;
            PrincipalPrivilegeSet principalPrivilegeSet = pps;
            return principalPrivilegeSet;
        }
        catch (IOException e) {
            LOG.error("Unable to get db privileges for user", e);
            throw new MetaException("Unable to get db privileges for user, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public PrincipalPrivilegeSet getDBPrivilegeSet(String dbName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            PrincipalPrivilegeSet pps = new PrincipalPrivilegeSet();
            Database db = this.getHBase().getDb(dbName);
            if (db.getPrivileges() != null) {
                List<String> roles;
                List<PrivilegeGrantInfo> pgi;
                if (db.getPrivileges().getUserPrivileges() != null && (pgi = db.getPrivileges().getUserPrivileges().get(userName)) != null) {
                    pps.putToUserPrivileges(userName, pgi);
                }
                if (db.getPrivileges().getRolePrivileges() != null && (roles = this.getHBase().getUserRoles(userName)) != null) {
                    for (String role : roles) {
                        pgi = db.getPrivileges().getRolePrivileges().get(role);
                        if (pgi == null) continue;
                        pps.putToRolePrivileges(role, pgi);
                    }
                }
            }
            commit = true;
            PrincipalPrivilegeSet principalPrivilegeSet = pps;
            return principalPrivilegeSet;
        }
        catch (IOException e) {
            LOG.error("Unable to get db privileges for user", e);
            throw new MetaException("Unable to get db privileges for user, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public PrincipalPrivilegeSet getTablePrivilegeSet(String dbName, String tableName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            PrincipalPrivilegeSet pps = new PrincipalPrivilegeSet();
            Table table = this.getHBase().getTable(dbName, tableName);
            if (table.getPrivileges() != null) {
                List<String> roles;
                List<PrivilegeGrantInfo> pgi;
                if (table.getPrivileges().getUserPrivileges() != null && (pgi = table.getPrivileges().getUserPrivileges().get(userName)) != null) {
                    pps.putToUserPrivileges(userName, pgi);
                }
                if (table.getPrivileges().getRolePrivileges() != null && (roles = this.getHBase().getUserRoles(userName)) != null) {
                    for (String role : roles) {
                        pgi = table.getPrivileges().getRolePrivileges().get(role);
                        if (pgi == null) continue;
                        pps.putToRolePrivileges(role, pgi);
                    }
                }
            }
            commit = true;
            PrincipalPrivilegeSet principalPrivilegeSet = pps;
            return principalPrivilegeSet;
        }
        catch (IOException e) {
            LOG.error("Unable to get db privileges for user", e);
            throw new MetaException("Unable to get db privileges for user, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String dbName, String tableName, String partition, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return null;
    }

    @Override
    public PrincipalPrivilegeSet getColumnPrivilegeSet(String dbName, String tableName, String partitionName, String columnName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return null;
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName, PrincipalType principalType) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            Map<String, List<PrivilegeGrantInfo>> map;
            PrincipalPrivilegeSet pps = this.getHBase().getGlobalPrivs();
            if (pps == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            switch (principalType) {
                case USER: {
                    map = pps.getUserPrivileges();
                    break;
                }
                case ROLE: {
                    map = pps.getRolePrivileges();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown or unsupported principal type " + principalType.toString());
                }
            }
            if (map == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            List<PrivilegeGrantInfo> grants = map.get(principalName);
            if (grants == null || grants.size() == 0) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            for (PrivilegeGrantInfo pgi : grants) {
                privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), principalName, principalType, pgi));
            }
            commit = true;
            ArrayList<HiveObjectPrivilege> arrayList = privileges;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName, PrincipalType principalType, String dbName) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            Map<String, List<PrivilegeGrantInfo>> map;
            Database db = this.getHBase().getDb(dbName);
            if (db == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            PrincipalPrivilegeSet pps = db.getPrivileges();
            if (pps == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            switch (principalType) {
                case USER: {
                    map = pps.getUserPrivileges();
                    break;
                }
                case ROLE: {
                    map = pps.getRolePrivileges();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown or unsupported principal type " + principalType.toString());
                }
            }
            if (map == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            List<PrivilegeGrantInfo> grants = map.get(principalName);
            if (grants == null || grants.size() == 0) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            for (PrivilegeGrantInfo pgi : grants) {
                privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), principalName, principalType, pgi));
            }
            commit = true;
            ArrayList<HiveObjectPrivilege> arrayList = privileges;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listAllTableGrants(String principalName, PrincipalType principalType, String dbName, String tableName) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            Map<String, List<PrivilegeGrantInfo>> map;
            Table table = this.getHBase().getTable(dbName, tableName);
            if (table == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            PrincipalPrivilegeSet pps = table.getPrivileges();
            if (pps == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            switch (principalType) {
                case USER: {
                    map = pps.getUserPrivileges();
                    break;
                }
                case ROLE: {
                    map = pps.getRolePrivileges();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown or unsupported principal type " + principalType.toString());
                }
            }
            if (map == null) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            List<PrivilegeGrantInfo> grants = map.get(principalName);
            if (grants == null || grants.size() == 0) {
                ArrayList<HiveObjectPrivilege> arrayList = privileges;
                return arrayList;
            }
            for (PrivilegeGrantInfo pgi : grants) {
                privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null), principalName, principalType, pgi));
            }
            commit = true;
            ArrayList<HiveObjectPrivilege> arrayList = privileges;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String partName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, String columnName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partVals, String partName, String columnName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
                PrivilegeInfo privilegeInfo = this.findPrivilegeToGrantOrRevoke(priv);
                for (PrivilegeGrantInfo info : privilegeInfo.grants) {
                    if (!info.getPrivilege().equals(priv.getGrantInfo().getPrivilege())) continue;
                    throw new InvalidObjectException(priv.getPrincipalName() + " already has " + priv.getGrantInfo().getPrivilege() + " on " + privilegeInfo.typeErrMsg);
                }
                privilegeInfo.grants.add(priv.getGrantInfo());
                this.writeBackGrantOrRevoke(priv, privilegeInfo);
            }
            commit = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws InvalidObjectException, MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            for (HiveObjectPrivilege priv : privileges.getPrivileges()) {
                PrivilegeInfo privilegeInfo = this.findPrivilegeToGrantOrRevoke(priv);
                for (int i = 0; i < privilegeInfo.grants.size(); ++i) {
                    if (!privilegeInfo.grants.get(i).getPrivilege().equals(priv.getGrantInfo().getPrivilege())) continue;
                    if (grantOption) {
                        privilegeInfo.grants.get(i).setGrantOption(false);
                        break;
                    }
                    privilegeInfo.grants.remove(i);
                    break;
                }
                this.writeBackGrantOrRevoke(priv, privilegeInfo);
            }
            commit = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    private PrivilegeInfo findPrivilegeToGrantOrRevoke(HiveObjectPrivilege privilege) throws MetaException, NoSuchObjectException, InvalidObjectException {
        Map<String, List<PrivilegeGrantInfo>> grantInfos;
        PrivilegeInfo result = new PrivilegeInfo();
        switch (privilege.getHiveObject().getObjectType()) {
            case GLOBAL: {
                try {
                    result.privSet = this.createOnNull(this.getHBase().getGlobalPrivs());
                }
                catch (IOException e) {
                    LOG.error("Unable to fetch global privileges", e);
                    throw new MetaException("Unable to fetch global privileges, " + e.getMessage());
                }
                result.typeErrMsg = "global";
                break;
            }
            case DATABASE: {
                result.db = this.getDatabase(privilege.getHiveObject().getDbName());
                result.typeErrMsg = "database " + result.db.getName();
                result.privSet = this.createOnNull(result.db.getPrivileges());
                break;
            }
            case TABLE: {
                result.table = this.getTable(privilege.getHiveObject().getDbName(), privilege.getHiveObject().getObjectName());
                result.typeErrMsg = "table " + result.table.getTableName();
                result.privSet = this.createOnNull(result.table.getPrivileges());
                break;
            }
            case PARTITION: 
            case COLUMN: {
                throw new RuntimeException("HBase metastore does not support partition or column permissions");
            }
            default: {
                throw new RuntimeException("Woah bad, unknown object type " + privilege.getHiveObject().getObjectType());
            }
        }
        switch (privilege.getPrincipalType()) {
            case USER: {
                grantInfos = result.privSet.getUserPrivileges();
                result.typeErrMsg = "user";
                break;
            }
            case GROUP: {
                throw new RuntimeException("HBase metastore does not support group permissions");
            }
            case ROLE: {
                grantInfos = result.privSet.getRolePrivileges();
                result.typeErrMsg = "role";
                break;
            }
            default: {
                throw new RuntimeException("Woah bad, unknown principal type " + privilege.getPrincipalType());
            }
        }
        result.grants = grantInfos.get(privilege.getPrincipalName());
        if (result.grants == null) {
            result.grants = new ArrayList<PrivilegeGrantInfo>();
            grantInfos.put(privilege.getPrincipalName(), result.grants);
        }
        return result;
    }

    private PrincipalPrivilegeSet createOnNull(PrincipalPrivilegeSet pps) {
        if (pps == null) {
            pps = new PrincipalPrivilegeSet();
        }
        if (pps.getUserPrivileges() == null) {
            pps.setUserPrivileges(new HashMap<String, List<PrivilegeGrantInfo>>());
        }
        if (pps.getRolePrivileges() == null) {
            pps.setRolePrivileges(new HashMap<String, List<PrivilegeGrantInfo>>());
        }
        return pps;
    }

    private void writeBackGrantOrRevoke(HiveObjectPrivilege priv, PrivilegeInfo pi) throws MetaException, NoSuchObjectException, InvalidObjectException {
        switch (priv.getHiveObject().getObjectType()) {
            case GLOBAL: {
                try {
                    this.getHBase().putGlobalPrivs(pi.privSet);
                    break;
                }
                catch (IOException e) {
                    LOG.error("Unable to write global privileges", e);
                    throw new MetaException("Unable to write global privileges, " + e.getMessage());
                }
            }
            case DATABASE: {
                pi.db.setPrivileges(pi.privSet);
                this.alterDatabase(pi.db.getName(), pi.db);
                break;
            }
            case TABLE: {
                pi.table.setPrivileges(pi.privSet);
                this.alterTable(pi.table.getDbName(), pi.table.getTableName(), pi.table);
                break;
            }
            default: {
                throw new RuntimeException("Dude, you missed the second switch!");
            }
        }
    }

    @Override
    public Role getRole(String roleName) throws NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            Role role = this.getHBase().getRole(roleName);
            if (role == null) {
                throw new NoSuchObjectException("Unable to find role " + roleName);
            }
            commit = true;
            Role role2 = role;
            return role2;
        }
        catch (IOException e) {
            LOG.error("Unable to get role", e);
            throw new NoSuchObjectException("Error reading table " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> listRoleNames() {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Role> roles = this.getHBase().scanRoles();
            ArrayList<String> roleNames = new ArrayList<String>(roles.size());
            for (Role role : roles) {
                roleNames.add(role.getRoleName());
            }
            commit = true;
            ArrayList<String> arrayList = roleNames;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        ArrayList<Role> roles = new ArrayList<Role>();
        boolean commit = false;
        this.openTransaction();
        try {
            try {
                roles.addAll(this.getHBase().getPrincipalDirectRoles(principalName, principalType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (principalType == PrincipalType.USER) {
                roles.add(new Role("public", 0, null));
            }
            commit = true;
            ArrayList<Role> arrayList = roles;
            return arrayList;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<RolePrincipalGrant> listRolesWithGrants(String principalName, PrincipalType principalType) {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Role> roles = this.listRoles(principalName, principalType);
            ArrayList<RolePrincipalGrant> rpgs = new ArrayList<RolePrincipalGrant>(roles.size());
            for (Role role : roles) {
                HbaseMetastoreProto.RoleGrantInfoList grants = this.getHBase().getRolePrincipals(role.getRoleName());
                if (grants == null) continue;
                for (HbaseMetastoreProto.RoleGrantInfo grant : grants.getGrantInfoList()) {
                    if (grant.getPrincipalType() != HBaseUtils.convertPrincipalTypes(principalType) || !grant.getPrincipalName().equals(principalName)) continue;
                    rpgs.add(new RolePrincipalGrant(role.getRoleName(), principalName, principalType, grant.getGrantOption(), (int)grant.getAddTime(), grant.getGrantor(), HBaseUtils.convertPrincipalTypes(grant.getGrantorType())));
                }
            }
            commit = true;
            ArrayList<RolePrincipalGrant> arrayList = rpgs;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<RolePrincipalGrant> listRoleMembers(String roleName) {
        boolean commit = false;
        this.openTransaction();
        try {
            HbaseMetastoreProto.RoleGrantInfoList gil = this.getHBase().getRolePrincipals(roleName);
            ArrayList<RolePrincipalGrant> roleMaps = new ArrayList<RolePrincipalGrant>(gil.getGrantInfoList().size());
            for (HbaseMetastoreProto.RoleGrantInfo giw : gil.getGrantInfoList()) {
                roleMaps.add(new RolePrincipalGrant(roleName, giw.getPrincipalName(), HBaseUtils.convertPrincipalTypes(giw.getPrincipalType()), giw.getGrantOption(), (int)giw.getAddTime(), giw.getGrantor(), HBaseUtils.convertPrincipalTypes(giw.getGrantorType())));
            }
            commit = true;
            ArrayList<RolePrincipalGrant> arrayList = roleMaps;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public Partition getPartitionWithAuth(String dbName, String tblName, List<String> partVals, String user_name, List<String> group_names) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return this.getPartition(dbName, tblName, partVals);
    }

    @Override
    public List<Partition> getPartitionsWithAuth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return this.getPartitions(dbName, tblName, maxParts);
    }

    @Override
    public List<String> listPartitionNamesPs(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, NoSuchObjectException {
        List<Partition> parts = this.listPartitionsPsWithAuth(db_name, tbl_name, part_vals, max_parts, null, null);
        ArrayList<String> partNames = new ArrayList<String>(parts.size());
        for (Partition part : parts) {
            partNames.add(this.buildExternalPartName(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), part.getValues()));
        }
        return partNames;
    }

    @Override
    public List<Partition> listPartitionsPsWithAuth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Partition> parts = this.getHBase().scanPartitions(HiveStringUtils.normalizeIdentifier(db_name), HiveStringUtils.normalizeIdentifier(tbl_name), part_vals, max_parts);
            commit = true;
            List<Partition> list = parts;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to list partition names", e);
            throw new MetaException("Failed to list part names, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean updateTableColumnStatistics(ColumnStatistics colStats) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colNames.add(statsObj.getColName());
            }
            String dbName = colStats.getStatsDesc().getDbName();
            String tableName = colStats.getStatsDesc().getTableName();
            Table newTable = this.getTable(dbName, tableName);
            Table newTableCopy = newTable.deepCopy();
            StatsSetupConst.setColumnStatsState(newTableCopy.getParameters(), colNames);
            this.getHBase().replaceTable(newTable, newTableCopy);
            this.getHBase().updateStatistics(colStats.getStatsDesc().getDbName(), colStats.getStatsDesc().getTableName(), null, colStats);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to update column statistics", e);
            throw new MetaException("Failed to update column statistics, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean updatePartitionColumnStatistics(ColumnStatistics colStats, List<String> partVals) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        boolean commit = false;
        this.openTransaction();
        try {
            String db_name = colStats.getStatsDesc().getDbName();
            String tbl_name = colStats.getStatsDesc().getTableName();
            Partition oldPart = this.getHBase().getPartition(db_name, tbl_name, partVals);
            Partition new_partCopy = oldPart.deepCopy();
            ArrayList<String> colNames = new ArrayList<String>();
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            for (ColumnStatisticsObj statsObj : statsObjs) {
                colNames.add(statsObj.getColName());
            }
            StatsSetupConst.setColumnStatsState(new_partCopy.getParameters(), colNames);
            this.getHBase().replacePartition(oldPart, new_partCopy, HBaseUtils.getPartitionKeyTypes(this.getTable(db_name, tbl_name).getPartitionKeys()));
            this.getHBase().updateStatistics(colStats.getStatsDesc().getDbName(), colStats.getStatsDesc().getTableName(), partVals, colStats);
            this.getHBase().getStatsCache().invalidate(colStats.getStatsDesc().getDbName(), colStats.getStatsDesc().getTableName(), colStats.getStatsDesc().getPartName());
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Unable to update column statistics", e);
            throw new MetaException("Failed to update column statistics, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public ColumnStatistics getTableColumnStatistics(String dbName, String tableName, List<String> colName) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            ColumnStatistics cs = this.getHBase().getTableStatistics(dbName, tableName, colName);
            commit = true;
            ColumnStatistics columnStatistics = cs;
            return columnStatistics;
        }
        catch (IOException e) {
            LOG.error("Unable to fetch column statistics", e);
            throw new MetaException("Failed to fetch column statistics, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<ColumnStatistics> getPartitionColumnStatistics(String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(partNames.size());
        for (String partName : partNames) {
            partVals.add(HBaseStore.partNameToVals(partName));
        }
        boolean commit = false;
        this.openTransaction();
        try {
            List<ColumnStatistics> cs = this.getHBase().getPartitionStatistics(dbName, tblName, partNames, partVals, colNames);
            commit = true;
            List<ColumnStatistics> list = cs;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to fetch column statistics", e);
            throw new MetaException("Failed fetching column statistics, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, List<String> partVals, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return true;
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return true;
    }

    @Override
    public AggrStats get_aggr_stats_for(String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        ArrayList<List<String>> partVals = new ArrayList<List<String>>(partNames.size());
        for (String partName : partNames) {
            partVals.add(HBaseStore.partNameToVals(partName));
        }
        boolean commit = false;
        boolean hasAnyStats = false;
        this.openTransaction();
        try {
            AggrStats aggrStats = new AggrStats();
            aggrStats.setPartsFound(0L);
            for (String colName : colNames) {
                try {
                    AggrStats oneCol = this.getHBase().getStatsCache().get(dbName, tblName, partNames, colName);
                    if (oneCol.getColStatsSize() <= 0) continue;
                    assert (oneCol.getColStatsSize() == 1);
                    aggrStats.setPartsFound(oneCol.getPartsFound());
                    aggrStats.addToColStats(oneCol.getColStats().get(0));
                    hasAnyStats = true;
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    LOG.debug("Found no stats for column " + colName);
                }
            }
            commit = true;
            if (!hasAnyStats) {
                aggrStats.setColStats(new ArrayList<ColumnStatisticsObj>());
            }
            AggrStats aggrStats2 = aggrStats;
            return aggrStats2;
        }
        catch (IOException e) {
            LOG.error("Unable to fetch aggregate column statistics", e);
            throw new MetaException("Failed fetching aggregate column statistics, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public long cleanupEvents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addToken(String tokenIdentifier, String delegationToken) {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().putDelegationToken(tokenIdentifier, delegationToken);
            boolean bl = commit = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean removeToken(String tokenIdentifier) {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteDelegationToken(tokenIdentifier);
            boolean bl = commit = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public String getToken(String tokenIdentifier) {
        boolean commit = false;
        this.openTransaction();
        try {
            String token = this.getHBase().getDelegationToken(tokenIdentifier);
            commit = true;
            String string = token;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getAllTokenIdentifiers() {
        boolean commit = false;
        this.openTransaction();
        try {
            List<String> ids = this.getHBase().scanDelegationTokenIdentifiers();
            commit = true;
            List<String> list = ids;
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public int addMasterKey(String key) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            long seq = this.getHBase().getNextSequence(HBaseReadWrite.MASTER_KEY_SEQUENCE);
            this.getHBase().putMasterKey((int)seq, key);
            commit = true;
            int n = (int)seq;
            return n;
        }
        catch (IOException e) {
            LOG.error("Unable to add master key", e);
            throw new MetaException("Failed adding master key, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            if (this.getHBase().getMasterKey(seqNo) == null) {
                throw new NoSuchObjectException("No key found with keyId: " + seqNo);
            }
            this.getHBase().putMasterKey(seqNo, key);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to update master key", e);
            throw new MetaException("Failed updating master key, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public boolean removeMasterKey(Integer keySeq) {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteMasterKey(keySeq);
            commit = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public String[] getMasterKeys() {
        boolean commit = false;
        this.openTransaction();
        try {
            List<String> keys = this.getHBase().scanMasterKeys();
            commit = true;
            String[] stringArray = keys.toArray(new String[keys.size()]);
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void verifySchema() throws MetaException {
    }

    @Override
    public String getMetaStoreSchemaVersion() throws MetaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMetaStoreSchemaVersion(String version, String comment) throws MetaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropPartitions(String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            for (String partName : partNames) {
                this.dropPartition(dbName, tblName, HBaseStore.partNameToVals(partName));
            }
            commit = true;
        }
        catch (Exception e) {
            LOG.error("Unable to drop partitions", e);
            throw new NoSuchObjectException("Failure dropping partitions, " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName, PrincipalType principalType) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            List<Database> dbs = this.getHBase().scanDatabases(null);
            for (Database db : dbs) {
                List<PrivilegeGrantInfo> grants;
                Map<String, List<PrivilegeGrantInfo>> map;
                PrincipalPrivilegeSet pps = db.getPrivileges();
                if (pps == null) continue;
                switch (principalType) {
                    case USER: {
                        map = pps.getUserPrivileges();
                        break;
                    }
                    case ROLE: {
                        map = pps.getRolePrivileges();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown or unsupported principal type " + principalType.toString());
                    }
                }
                if (map == null || (grants = map.get(principalName)) == null || grants.size() == 0) continue;
                for (PrivilegeGrantInfo pgi : grants) {
                    privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, db.getName(), null, null, null), principalName, principalType, pgi));
                }
            }
            commit = true;
            ArrayList<HiveObjectPrivilege> arrayList = privileges;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName, PrincipalType principalType) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            List<Table> tables = this.getHBase().scanTables(null, null);
            for (Table table : tables) {
                List<PrivilegeGrantInfo> grants;
                Map<String, List<PrivilegeGrantInfo>> map;
                PrincipalPrivilegeSet pps = table.getPrivileges();
                if (pps == null) continue;
                switch (principalType) {
                    case USER: {
                        map = pps.getUserPrivileges();
                        break;
                    }
                    case ROLE: {
                        map = pps.getRolePrivileges();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown or unsupported principal type " + principalType.toString());
                    }
                }
                if (map == null || (grants = map.get(principalName)) == null || grants.size() == 0) continue;
                for (PrivilegeGrantInfo pgi : grants) {
                    privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, table.getDbName(), table.getTableName(), null, null), principalName, principalType, pgi));
                }
            }
            commit = true;
            ArrayList<HiveObjectPrivilege> arrayList = privileges;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            PrincipalPrivilegeSet pps = this.getHBase().getGlobalPrivs();
            if (pps != null) {
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getUserPrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : (List)e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), e.getKey(), PrincipalType.USER, pgi));
                    }
                }
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getRolePrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), e.getKey(), PrincipalType.ROLE, pgi));
                    }
                }
            }
            commit = true;
            Iterator<Map.Entry<String, List<PrivilegeGrantInfo>>> iterator = privileges;
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listDBGrantsAll(String dbName) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            Database db = this.getHBase().getDb(dbName);
            PrincipalPrivilegeSet pps = db.getPrivileges();
            if (pps != null) {
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getUserPrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : (List)e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), e.getKey(), PrincipalType.USER, pgi));
                    }
                }
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getRolePrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), e.getKey(), PrincipalType.ROLE, pgi));
                    }
                }
            }
            commit = true;
            Iterator<Map.Entry<String, List<PrivilegeGrantInfo>>> iterator = privileges;
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String dbName, String tableName, String partitionName, String columnName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listTableGrantsAll(String dbName, String tableName) {
        ArrayList<HiveObjectPrivilege> privileges = new ArrayList<HiveObjectPrivilege>();
        boolean commit = false;
        this.openTransaction();
        try {
            Table table = this.getHBase().getTable(dbName, tableName);
            PrincipalPrivilegeSet pps = table.getPrivileges();
            if (pps != null) {
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getUserPrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : (List)e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null), e.getKey(), PrincipalType.USER, pgi));
                    }
                }
                for (Map.Entry<String, List<PrivilegeGrantInfo>> e : pps.getRolePrivileges().entrySet()) {
                    for (PrivilegeGrantInfo pgi : e.getValue()) {
                        privileges.add(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tableName, null, null), e.getKey(), PrincipalType.ROLE, pgi));
                    }
                }
            }
            commit = true;
            Iterator<Map.Entry<String, List<PrivilegeGrantInfo>>> iterator = privileges;
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<HiveObjectPrivilege> listPartitionGrantsAll(String dbName, String tableName, String partitionName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String dbName, String tableName, String columnName) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    @Override
    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().putFunction(func);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to create function", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().putFunction(newFunction);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to alter function ", e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.getHBase().deleteFunction(dbName, funcName);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Unable to delete function" + e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public Function getFunction(String dbName, String funcName) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            Function func = this.getHBase().getFunction(dbName, funcName);
            commit = true;
            Function function = func;
            return function;
        }
        catch (IOException e) {
            LOG.error("Unable to get function" + e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<Function> getAllFunctions() throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Function> funcs = this.getHBase().scanFunctions(null, ".*");
            commit = true;
            List<Function> list = funcs;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get functions" + e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<String> getFunctions(String dbName, String pattern) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<Function> funcs = this.getHBase().scanFunctions(dbName, this.likeToRegex(pattern));
            ArrayList<String> funcNames = new ArrayList<String>(funcs.size());
            for (Function func : funcs) {
                funcNames.add(func.getFunctionName());
            }
            commit = true;
            ArrayList<String> arrayList = funcNames;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Unable to get functions" + e);
            throw new MetaException("Unable to read from or write to hbase " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNotificationEvent(NotificationEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanNotificationEvents(int olderThan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CurrentNotificationEventId getCurrentNotificationEventId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flushCache() {
        this.getHBase().flushCatalogCache();
    }

    public void setConf(Configuration configuration) {
        Configuration oldConf = this.conf;
        this.conf = configuration;
        if (this.expressionProxy != null && this.conf != oldConf) {
            LOG.warn("Unexpected setConf when we were already configured");
        }
        if (this.expressionProxy == null || this.conf != oldConf) {
            this.expressionProxy = PartFilterExprUtil.createExpressionProxy(this.conf);
        }
        if (this.conf != oldConf) {
            this.fmHandlers = HiveMetaStore.createHandlerMap();
            this.configureFileMetadataHandlers(this.fmHandlers.values());
        }
    }

    private void configureFileMetadataHandlers(Collection<FileMetadataHandler> fmHandlers) {
        for (FileMetadataHandler fmh : fmHandlers) {
            fmh.configure(this.conf, this.expressionProxy, this.getHBase());
        }
    }

    @Override
    public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType type) {
        return this.fmHandlers.get(type);
    }

    public Configuration getConf() {
        return this.conf;
    }

    private HBaseReadWrite getHBase() {
        if (this.hbase == null) {
            HBaseReadWrite.setConf(this.conf);
            this.hbase = HBaseReadWrite.getInstance();
        }
        return this.hbase;
    }

    private String tableNameForErrorMsg(String dbName, String tableName) {
        return dbName + "." + tableName;
    }

    private String partNameForErrorMsg(String dbName, String tableName, List<String> partVals) {
        return this.tableNameForErrorMsg(dbName, tableName) + "." + StringUtils.join(partVals, ':');
    }

    private String indexNameForErrorMsg(String dbName, String origTableName, String indexName) {
        return this.tableNameForErrorMsg(dbName, origTableName) + "." + indexName;
    }

    private String buildExternalPartName(Table table, Partition part) {
        return HBaseStore.buildExternalPartName(table, part.getValues());
    }

    private String buildExternalPartName(String dbName, String tableName, List<String> partVals) throws MetaException {
        return HBaseStore.buildExternalPartName(this.getTable(dbName, tableName), partVals);
    }

    private Set<String> findUsersToRemapRolesFor(Role role, String principalName, PrincipalType type) throws IOException, NoSuchObjectException {
        HashSet<String> usersToRemap;
        switch (type) {
            case USER: {
                usersToRemap = new HashSet<String>();
                usersToRemap.add(principalName);
                break;
            }
            case ROLE: {
                usersToRemap = this.getHBase().findAllUsersInRole(role.getRoleName());
                break;
            }
            default: {
                throw new RuntimeException("Unknown principal type " + type);
            }
        }
        return usersToRemap;
    }

    static String buildExternalPartName(Table table, List<String> partVals) {
        ArrayList<String> partCols = new ArrayList<String>();
        for (FieldSchema pc : table.getPartitionKeys()) {
            partCols.add(pc.getName());
        }
        return FileUtils.makePartName(partCols, partVals);
    }

    private static List<String> partNameToVals(String name) {
        String[] kvp;
        if (name == null) {
            return null;
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (String kv : kvp = name.split("/")) {
            vals.add(FileUtils.unescapePathName(kv.substring(kv.indexOf(61) + 1)));
        }
        return vals;
    }

    static List<List<String>> partNameListToValsList(List<String> partNames) {
        ArrayList<List<String>> valLists = new ArrayList<List<String>>(partNames.size());
        for (String partName : partNames) {
            valLists.add(HBaseStore.partNameToVals(partName));
        }
        return valLists;
    }

    private String likeToRegex(String like) {
        if (like == null) {
            return null;
        }
        return like.replace("*", ".*");
    }

    private void commitOrRoleBack(boolean commit) {
        if (commit) {
            LOG.debug("Committing transaction");
            this.commitTransaction();
        } else {
            LOG.debug("Rolling back transaction");
            this.rollbackTransaction();
        }
    }

    @VisibleForTesting
    HBaseReadWrite backdoor() {
        return this.getHBase();
    }

    @Override
    public boolean isFileMetadataSupported() {
        return true;
    }

    @Override
    public ByteBuffer[] getFileMetadata(List<Long> fileIds) throws MetaException {
        this.openTransaction();
        boolean commit = true;
        try {
            ByteBuffer[] byteBufferArray = this.getHBase().getFileMetadata(fileIds);
            return byteBufferArray;
        }
        catch (IOException e) {
            commit = false;
            LOG.error("Unable to get file metadata", e);
            throw new MetaException("Error reading file metadata " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void getFileMetadataByExpr(List<Long> fileIds, FileMetadataExprType type, byte[] expr, ByteBuffer[] metadatas, ByteBuffer[] results, boolean[] eliminated) throws MetaException {
        FileMetadataHandler fmh = this.fmHandlers.get(type);
        boolean commit = true;
        try {
            fmh.getFileMetadataByExpr(fileIds, expr, metadatas, results, eliminated);
        }
        catch (IOException e) {
            LOG.error("Unable to get file metadata by expr", e);
            commit = false;
            throw new MetaException("Error reading file metadata by expr" + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata, FileMetadataExprType type) throws MetaException {
        this.openTransaction();
        boolean commit = false;
        try {
            FileMetadataHandler fmh;
            ByteBuffer[][] addedVals = null;
            ByteBuffer[] addedCols = null;
            if (type != null && (addedCols = (fmh = this.fmHandlers.get(type)).createAddedCols()) != null) {
                addedVals = fmh.createAddedColVals(metadata);
            }
            this.getHBase().storeFileMetadata(fileIds, metadata, addedCols, addedVals);
            commit = true;
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Unable to store file metadata", e);
            throw new MetaException("Error storing file metadata " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(String db_name, String tbl_name) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<SQLPrimaryKey> pk = this.getHBase().getPrimaryKey(db_name, tbl_name);
            commit = true;
            List<SQLPrimaryKey> list = pk;
            return list;
        }
        catch (IOException e) {
            LOG.error("Unable to get primary key", e);
            throw new MetaException("Error reading db " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public List<SQLForeignKey> getForeignKeys(String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<SQLForeignKey> fks = this.getHBase().getForeignKeys(foreign_db_name, foreign_tbl_name);
            if (fks == null || fks.size() == 0) {
                List<SQLForeignKey> list = null;
                return list;
            }
            ArrayList<SQLForeignKey> result = new ArrayList<SQLForeignKey>(fks.size());
            for (SQLForeignKey fkcol : fks) {
                if (parent_db_name != null && !fkcol.getPktable_db().equals(parent_db_name) || parent_tbl_name != null && !fkcol.getPktable_name().equals(parent_tbl_name)) continue;
                result.add(fkcol);
            }
            commit = true;
            ArrayList<SQLForeignKey> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error("Unable to get foreign key", e);
            throw new MetaException("Error reading db " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            this.createTable(tbl);
            if (primaryKeys != null) {
                this.addPrimaryKeys(primaryKeys);
            }
            if (foreignKeys != null) {
                this.addForeignKeys(foreignKeys);
            }
            commit = true;
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void dropConstraint(String dbName, String tableName, String constraintName) throws NoSuchObjectException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<SQLPrimaryKey> pk = this.getHBase().getPrimaryKey(dbName, tableName);
            if (pk != null && pk.size() > 0 && pk.get(0).getPk_name().equals(constraintName)) {
                this.getHBase().deletePrimaryKey(dbName, tableName);
                commit = true;
                return;
            }
            List<SQLForeignKey> fks = this.getHBase().getForeignKeys(dbName, tableName);
            if (fks != null && fks.size() > 0) {
                ArrayList<SQLForeignKey> newKeyList = new ArrayList<SQLForeignKey>(fks.size());
                for (SQLForeignKey fkcol : fks) {
                    if (fkcol.getFk_name().equals(constraintName)) continue;
                    newKeyList.add(fkcol);
                }
                if (newKeyList.size() > 0) {
                    this.getHBase().putForeignKeys(newKeyList);
                } else {
                    this.getHBase().deleteForeignKeys(dbName, tableName);
                }
                commit = true;
                return;
            }
            try {
                commit = true;
                throw new NoSuchObjectException("Unable to find constraint named " + constraintName + " on table " + this.tableNameForErrorMsg(dbName, tableName));
            }
            catch (IOException e) {
                LOG.error("Error fetching primary key for table " + this.tableNameForErrorMsg(dbName, tableName), e);
                throw new NoSuchObjectException("Error fetching primary key for table " + this.tableNameForErrorMsg(dbName, tableName) + " : " + e.getMessage());
            }
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<SQLPrimaryKey> currentPk = this.getHBase().getPrimaryKey(pks.get(0).getTable_db(), pks.get(0).getTable_name());
            if (currentPk != null) {
                throw new MetaException(" Primary key already exists for: " + this.tableNameForErrorMsg(pks.get(0).getTable_db(), pks.get(0).getTable_name()));
            }
            this.getHBase().putPrimaryKey(pks);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Error writing primary key", e);
            throw new MetaException("Error writing primary key: " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    @Override
    public void addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        boolean commit = false;
        this.openTransaction();
        try {
            List<SQLForeignKey> existing = this.getHBase().getForeignKeys(fks.get(0).getFktable_db(), fks.get(0).getFktable_name());
            if (existing == null) {
                existing = new ArrayList<SQLForeignKey>(fks.size());
            }
            existing.addAll(fks);
            this.getHBase().putForeignKeys(existing);
            commit = true;
        }
        catch (IOException e) {
            LOG.error("Error writing foreign keys", e);
            throw new MetaException("Error writing foreign keys: " + e.getMessage());
        }
        finally {
            this.commitOrRoleBack(commit);
        }
    }

    private static class PrivilegeInfo {
        Database db;
        Table table;
        List<PrivilegeGrantInfo> grants;
        String typeErrMsg;
        PrincipalPrivilegeSet privSet;

        private PrivilegeInfo() {
        }
    }
}

