/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.registry.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.hive.llap.registry.ServiceRegistry;
import org.apache.hadoop.hive.llap.registry.impl.LlapFixedRegistryImpl;
import org.apache.hadoop.hive.llap.registry.impl.LlapZookeeperRegistryImpl;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hive.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapRegistryService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(LlapRegistryService.class);
    private ServiceRegistry registry = null;
    private final boolean isDaemon;
    private boolean isDynamic = false;
    private String identity = "(pending)";
    private static final Map<String, LlapRegistryService> yarnRegistries = new HashMap<String, LlapRegistryService>();

    public LlapRegistryService(boolean isDaemon) {
        super("LlapRegistryService");
        this.isDaemon = isDaemon;
    }

    public static synchronized LlapRegistryService getClient(Configuration conf) {
        LlapRegistryService registry;
        String hosts = HiveConf.getTrimmedVar(conf, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        Preconditions.checkNotNull(hosts, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.toString() + " must be defined");
        if (hosts.startsWith("@")) {
            String appName = hosts.substring(1);
            String userName = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_ZK_REGISTRY_USER, RegistryUtils.currentUser());
            String key = appName + "-" + userName;
            registry = yarnRegistries.get(key);
            if (registry == null || !registry.isInState(Service.STATE.STARTED)) {
                registry = new LlapRegistryService(false);
                registry.init(conf);
                registry.start();
                yarnRegistries.put(key, registry);
            }
        } else {
            registry = new LlapRegistryService(false);
            registry.init(conf);
            registry.start();
        }
        LOG.info("Using LLAP registry (client) type: " + (Object)((Object)registry));
        return registry;
    }

    public void serviceInit(Configuration conf) {
        String hosts = HiveConf.getTrimmedVar(conf, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        if (hosts.startsWith("@")) {
            this.registry = new LlapZookeeperRegistryImpl(hosts.substring(1), conf);
            this.isDynamic = true;
        } else {
            this.registry = new LlapFixedRegistryImpl(hosts, conf);
            this.isDynamic = false;
        }
        LOG.info("Using LLAP registry type " + this.registry);
    }

    public void serviceStart() throws Exception {
        if (this.registry != null) {
            this.registry.start();
        }
        if (this.isDaemon) {
            this.registerWorker();
        }
    }

    public void serviceStop() throws Exception {
        if (this.isDaemon) {
            this.unregisterWorker();
        }
        if (this.registry != null) {
            this.registry.stop();
        } else {
            LOG.warn("Stopping non-existent registry service");
        }
    }

    private void registerWorker() throws IOException {
        if (this.registry != null) {
            this.identity = this.registry.register();
        }
    }

    private void unregisterWorker() throws IOException {
        if (this.registry != null) {
            this.registry.unregister();
        }
    }

    public ServiceInstanceSet getInstances() throws IOException {
        return this.getInstances(0L);
    }

    public ServiceInstanceSet getInstances(long clusterReadyTimeoutMs) throws IOException {
        return this.registry.getInstances("LLAP", clusterReadyTimeoutMs);
    }

    public void registerStateChangeListener(ServiceInstanceStateChangeListener listener) throws IOException {
        this.registry.registerStateChangeListener(listener);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String getWorkerIdentity() {
        return this.identity;
    }

    public ApplicationId getApplicationId() throws IOException {
        return this.registry.getApplicationId();
    }
}

