/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class RelOptPredicateList {
    private static final ImmutableList<RexNode> EMPTY_LIST = ImmutableList.of();
    public static final RelOptPredicateList EMPTY = new RelOptPredicateList(EMPTY_LIST, EMPTY_LIST, EMPTY_LIST);
    public final ImmutableList<RexNode> pulledUpPredicates;
    public final ImmutableList<RexNode> leftInferredPredicates;
    public final ImmutableList<RexNode> rightInferredPredicates;

    private RelOptPredicateList(Iterable<RexNode> pulledUpPredicates, Iterable<RexNode> leftInferredPredicates, Iterable<RexNode> rightInferredPredicates) {
        this.pulledUpPredicates = ImmutableList.copyOf(pulledUpPredicates);
        this.leftInferredPredicates = ImmutableList.copyOf(leftInferredPredicates);
        this.rightInferredPredicates = ImmutableList.copyOf(rightInferredPredicates);
    }

    public static RelOptPredicateList of(Iterable<RexNode> pulledUpPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        if (pulledUpPredicatesList.isEmpty()) {
            return EMPTY;
        }
        return new RelOptPredicateList(pulledUpPredicatesList, EMPTY_LIST, EMPTY_LIST);
    }

    public static RelOptPredicateList of(Iterable<RexNode> pulledUpPredicates, Iterable<RexNode> leftInferredPredicates, Iterable<RexNode> rightInferredPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        ImmutableList<RexNode> leftInferredPredicateList = ImmutableList.copyOf(leftInferredPredicates);
        ImmutableList<RexNode> rightInferredPredicatesList = ImmutableList.copyOf(rightInferredPredicates);
        if (pulledUpPredicatesList.isEmpty() && leftInferredPredicateList.isEmpty() && rightInferredPredicatesList.isEmpty()) {
            return EMPTY;
        }
        return new RelOptPredicateList(pulledUpPredicatesList, leftInferredPredicateList, rightInferredPredicatesList);
    }

    public RelOptPredicateList union(RelOptPredicateList list) {
        return RelOptPredicateList.of(RelOptPredicateList.concat(this.pulledUpPredicates, list.pulledUpPredicates), RelOptPredicateList.concat(this.leftInferredPredicates, list.leftInferredPredicates), RelOptPredicateList.concat(this.rightInferredPredicates, list.rightInferredPredicates));
    }

    private static <E> ImmutableList<E> concat(ImmutableList<E> list1, ImmutableList<E> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(list1)).addAll(list2)).build();
    }

    public RelOptPredicateList shift(int offset) {
        return RelOptPredicateList.of(RexUtil.shift(this.pulledUpPredicates, offset), RexUtil.shift(this.leftInferredPredicates, offset), RexUtil.shift(this.rightInferredPredicates, offset));
    }
}

