/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.EventUtils;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IOUtils;

public class ReplicationSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private String dbNameOrPattern;
    private String tblNameOrPattern;
    private Long eventFrom;
    private Long eventTo;
    private Integer maxEventLimit;
    private String path;
    private static String testInjectDumpDir = null;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";
    public static final String DUMPMETADATA = "_dumpmetadata";

    public ReplicationSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAanalyzer: analyzeInternal");
        this.LOG.debug(ast.getName() + ":" + ast.getToken().getText() + "=" + ast.getText());
        switch (ast.getToken().getType()) {
            case 883: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: dump");
                this.initReplDump(ast);
                this.analyzeReplDump(ast);
                break;
            }
            case 884: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: load");
                this.initReplLoad(ast);
                this.analyzeReplLoad(ast);
                break;
            }
            case 885: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: status");
                this.initReplStatus(ast);
                this.analyzeReplStatus(ast);
                break;
            }
            default: {
                throw new SemanticException("Unexpected root token");
            }
        }
    }

    private void initReplDump(ASTNode ast) {
        int numChildren = ast.getChildCount();
        this.dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        for (int currNode = 1; currNode < numChildren; ++currNode) {
            if (ast.getChild(currNode).getType() != 761) {
                this.tblNameOrPattern = PlanUtils.stripQuotes(ast.getChild(currNode).getText());
                continue;
            }
            Tree fromNode = ast.getChild(currNode);
            this.eventFrom = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild(0).getText()));
            for (int numChild = 1; numChild < fromNode.getChildCount(); ++numChild) {
                if (fromNode.getChild(numChild).getType() == 987) {
                    this.eventTo = Long.parseLong(PlanUtils.stripQuotes(fromNode.getChild(numChild + 1).getText()));
                    ++numChild;
                    continue;
                }
                if (fromNode.getChild(numChild).getType() != 809) continue;
                this.maxEventLimit = Integer.parseInt(PlanUtils.stripQuotes(fromNode.getChild(numChild + 1).getText()));
                ++numChild;
            }
            break;
        }
    }

    private void analyzeReplDump(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplDump: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern) + " from " + String.valueOf(this.eventFrom) + " to " + String.valueOf(this.eventTo) + " maxEventLimit " + String.valueOf(this.maxEventLimit));
        String replRoot = this.conf.getVar(HiveConf.ConfVars.REPLDIR);
        Path dumpRoot = new Path(replRoot, this.getNextDumpDir());
        DumpMetaData dmd = new DumpMetaData(dumpRoot);
        Path cmRoot = new Path(this.conf.getVar(HiveConf.ConfVars.REPLCMDIR));
        try {
            Long lastReplId;
            if (this.eventFrom == null) {
                Long bootDumpBeginReplId = this.db.getMSC().getCurrentNotificationEventId().getEventId();
                for (String string : this.matchesDb(this.dbNameOrPattern)) {
                    this.LOG.debug("ReplicationSemanticAnalyzer: analyzeReplDump dumping db: " + string);
                    Path dbRoot = this.dumpDbMetadata(string, dumpRoot);
                    for (String string2 : this.matchesTbl(string, this.tblNameOrPattern)) {
                        this.LOG.debug("ReplicationSemanticAnalyzer: analyzeReplDump dumping table: " + string2 + " to db root " + dbRoot.toUri());
                        this.dumpTbl(ast, string, string2, dbRoot);
                    }
                }
                Long bootDumpEndReplId = this.db.getMSC().getCurrentNotificationEventId().getEventId();
                this.LOG.info("Bootstrap object dump phase took from {} to {}", (Object)bootDumpBeginReplId, (Object)bootDumpEndReplId);
                IMetaStoreClient.NotificationFilter notificationFilter = EventUtils.getDbTblNotificationFilter(this.dbNameOrPattern, this.tblNameOrPattern);
                EventUtils.MSClientNotificationFetcher evFetcher = new EventUtils.MSClientNotificationFetcher(this.db.getMSC());
                EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator(evFetcher, bootDumpBeginReplId, Ints.checkedCast(bootDumpEndReplId - bootDumpBeginReplId) + 1, notificationFilter);
                while (evIter.hasNext()) {
                    NotificationEvent notificationEvent = evIter.next();
                    Path path = new Path(dumpRoot, String.valueOf(notificationEvent.getEventId()));
                }
                this.LOG.info("Consolidation done, preparing to return {},{}->{}", new Object[]{dumpRoot.toUri(), bootDumpBeginReplId, bootDumpEndReplId});
                dmd.setDump(DUMPTYPE.BOOTSTRAP, bootDumpBeginReplId, bootDumpEndReplId, cmRoot);
                dmd.write();
                lastReplId = bootDumpEndReplId;
            } else {
                if (this.eventTo == null) {
                    this.eventTo = this.db.getMSC().getCurrentNotificationEventId().getEventId();
                    this.LOG.debug("eventTo not specified, using current event id : {}", (Object)this.eventTo);
                } else if (this.eventTo < this.eventFrom) {
                    throw new Exception("Invalid event ID input received in TO clause");
                }
                Integer maxRange = Ints.checkedCast(this.eventTo - this.eventFrom + 1L);
                if (this.maxEventLimit == null || this.maxEventLimit > maxRange) {
                    this.maxEventLimit = maxRange;
                }
                IMetaStoreClient.NotificationFilter evFilter = EventUtils.andFilter(EventUtils.getDbTblNotificationFilter(this.dbNameOrPattern, this.tblNameOrPattern), EventUtils.getEventBoundaryFilter(this.eventFrom, this.eventTo), EventUtils.restrictByMessageFormat(MessageFactory.getInstance().getMessageFormat()));
                EventUtils.MSClientNotificationFetcher mSClientNotificationFetcher = new EventUtils.MSClientNotificationFetcher(this.db.getMSC());
                EventUtils.NotificationEventIterator evIter = new EventUtils.NotificationEventIterator(mSClientNotificationFetcher, this.eventFrom, this.maxEventLimit, evFilter);
                lastReplId = this.eventTo;
                while (evIter.hasNext()) {
                    NotificationEvent ev = evIter.next();
                    lastReplId = ev.getEventId();
                    Path path = new Path(dumpRoot, String.valueOf(lastReplId));
                    this.dumpEvent(ev, path, cmRoot);
                }
                this.LOG.info("Done dumping events, preparing to return {},{}", (Object)dumpRoot.toUri(), (Object)lastReplId);
                this.writeOutput(Arrays.asList("incremental", String.valueOf(this.eventFrom), String.valueOf(lastReplId)), dmd.getDumpFilePath());
                dmd.setDump(DUMPTYPE.INCREMENTAL, this.eventFrom, lastReplId, cmRoot);
                dmd.write();
            }
            this.prepareReturnValues(Arrays.asList(dumpRoot.toUri().toString(), String.valueOf(lastReplId)), dumpSchema);
            this.setFetchTask(this.createFetchTask(dumpSchema));
        }
        catch (Exception e) {
            this.LOG.warn("Error during analyzeReplDump", (Throwable)e);
            throw new SemanticException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpEvent(NotificationEvent ev, Path evRoot, Path cmRoot) throws Exception {
        long evid = ev.getEventId();
        String evidStr = String.valueOf(evid);
        ReplicationSpec replicationSpec = this.getNewEventOnlyReplicationSpec(evidStr);
        MessageDeserializer md = MessageFactory.getInstance().getDeserializer();
        switch (ev.getEventType()) {
            case "CREATE_TABLE": {
                CreateTableMessage ctm = md.getCreateTableMessage(ev.getMessage());
                this.LOG.info("Processing#{} CREATE_TABLE message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                Table tobj = ctm.getTableObj();
                if (tobj == null) {
                    this.LOG.debug("Event#{} was a CREATE_TABLE_EVENT with no table listed");
                    break;
                }
                org.apache.hadoop.hive.ql.metadata.Table qlMdTable = new org.apache.hadoop.hive.ql.metadata.Table(tobj);
                if (qlMdTable.isView()) {
                    replicationSpec.setIsMetadataOnly(true);
                }
                Path metaDataPath = new Path(evRoot, "_metadata");
                EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)this.conf), metaDataPath, qlMdTable, null, replicationSpec);
                Path dataPath = new Path(evRoot, "data");
                Iterable<String> files = ctm.getFiles();
                if (files != null) {
                    FileSystem fs = dataPath.getFileSystem((Configuration)this.conf);
                    Path filesPath = new Path(dataPath, "_files");
                    try (BufferedWriter fileListWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));){
                        for (String file : files) {
                            fileListWriter.write(file + "\n");
                        }
                    }
                }
                new DumpMetaData(evRoot, DUMPTYPE.EVENT_CREATE_TABLE, evid, evid, cmRoot).write();
                break;
            }
            case "ADD_PARTITION": {
                AddPartitionMessage apm = md.getAddPartitionMessage(ev.getMessage());
                this.LOG.info("Processing#{} ADD_PARTITION message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                Iterable<org.apache.hadoop.hive.metastore.api.Partition> ptns = apm.getPartitionObjs();
                if (ptns == null || !ptns.iterator().hasNext()) {
                    this.LOG.debug("Event#{} was an ADD_PTN_EVENT with no partitions");
                    break;
                }
                Table tobj = apm.getTableObj();
                if (tobj == null) {
                    this.LOG.debug("Event#{} was a ADD_PTN_EVENT with no table listed");
                    break;
                }
                final org.apache.hadoop.hive.ql.metadata.Table qlMdTable = new org.apache.hadoop.hive.ql.metadata.Table(tobj);
                Iterable<Partition> qlPtns = Iterables.transform(ptns, new Function<org.apache.hadoop.hive.metastore.api.Partition, Partition>(){

                    @Override
                    @Nullable
                    public Partition apply(@Nullable org.apache.hadoop.hive.metastore.api.Partition input) {
                        if (input == null) {
                            return null;
                        }
                        try {
                            return new Partition(qlMdTable, input);
                        }
                        catch (HiveException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                });
                Path metaDataPath = new Path(evRoot, "_metadata");
                EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)this.conf), metaDataPath, qlMdTable, qlPtns, replicationSpec);
                Iterator<PartitionFiles> partitionFilesIter = apm.getPartitionFilesIter().iterator();
                for (Partition qlPtn : qlPtns) {
                    PartitionFiles partitionFiles = partitionFilesIter.next();
                    Iterable<String> files = partitionFiles.getFiles();
                    if (files == null) continue;
                    Path ptnDataPath = new Path(evRoot, qlPtn.getName());
                    FileSystem fs = ptnDataPath.getFileSystem((Configuration)this.conf);
                    Path filesPath = new Path(ptnDataPath, "_files");
                    try (BufferedWriter fileListWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));){
                        for (String file : files) {
                            fileListWriter.write(file + "\n");
                        }
                    }
                }
                new DumpMetaData(evRoot, DUMPTYPE.EVENT_ADD_PARTITION, evid, evid, cmRoot).write();
                break;
            }
            case "DROP_TABLE": {
                this.LOG.info("Processing#{} DROP_TABLE message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_DROP_TABLE, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
                break;
            }
            case "DROP_PARTITION": {
                this.LOG.info("Processing#{} DROP_PARTITION message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_DROP_PARTITION, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
                break;
            }
            case "ALTER_TABLE": {
                this.LOG.info("Processing#{} ALTER_TABLE message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                AlterTableMessage atm = md.getAlterTableMessage(ev.getMessage());
                Table tobjBefore = atm.getTableObjBefore();
                Table tobjAfter = atm.getTableObjAfter();
                if (tobjBefore.getDbName().equals(tobjAfter.getDbName()) && tobjBefore.getTableName().equals(tobjAfter.getTableName())) {
                    replicationSpec.setIsMetadataOnly(true);
                    org.apache.hadoop.hive.ql.metadata.Table qlMdTableAfter = new org.apache.hadoop.hive.ql.metadata.Table(tobjAfter);
                    Path metaDataPath = new Path(evRoot, "_metadata");
                    EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)this.conf), metaDataPath, qlMdTableAfter, null, replicationSpec);
                    DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_ALTER_TABLE, evid, evid, cmRoot);
                    dmd.setPayload(ev.getMessage());
                    dmd.write();
                    break;
                }
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_RENAME_TABLE, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
                break;
            }
            case "ALTER_PARTITION": {
                this.LOG.info("Processing#{} ALTER_PARTITION message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                AlterPartitionMessage apm = md.getAlterPartitionMessage(ev.getMessage());
                Table tblObj = apm.getTableObj();
                org.apache.hadoop.hive.metastore.api.Partition pobjBefore = apm.getPtnObjBefore();
                org.apache.hadoop.hive.metastore.api.Partition pobjAfter = apm.getPtnObjAfter();
                boolean renameScenario = false;
                Iterator<String> beforeValIter = pobjBefore.getValuesIterator();
                Iterator<String> afterValIter = pobjAfter.getValuesIterator();
                while (beforeValIter.hasNext()) {
                    if (beforeValIter.next().equals(afterValIter.next())) continue;
                    renameScenario = true;
                    break;
                }
                if (!renameScenario) {
                    replicationSpec.setIsMetadataOnly(true);
                    org.apache.hadoop.hive.ql.metadata.Table qlMdTable = new org.apache.hadoop.hive.ql.metadata.Table(tblObj);
                    ArrayList<Partition> qlPtns = new ArrayList<Partition>();
                    qlPtns.add(new Partition(qlMdTable, pobjAfter));
                    Path metaDataPath = new Path(evRoot, "_metadata");
                    EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)this.conf), metaDataPath, qlMdTable, qlPtns, replicationSpec);
                    DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_ALTER_PARTITION, evid, evid, cmRoot);
                    dmd.setPayload(ev.getMessage());
                    dmd.write();
                    break;
                }
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_RENAME_PARTITION, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
                break;
            }
            case "INSERT": {
                InsertMessage insertMsg = md.getInsertMessage(ev.getMessage());
                String dbName = insertMsg.getDB();
                String tblName = insertMsg.getTable();
                Table tobj = this.db.getMSC().getTable(dbName, tblName);
                org.apache.hadoop.hive.ql.metadata.Table qlMdTable = new org.apache.hadoop.hive.ql.metadata.Table(tobj);
                Map<String, String> partSpec = insertMsg.getPartitionKeyValues();
                List<Partition> qlPtns = null;
                if (qlMdTable.isPartitioned() && !partSpec.isEmpty()) {
                    qlPtns = Arrays.asList(this.db.getPartition(qlMdTable, partSpec, false));
                }
                Path metaDataPath = new Path(evRoot, "_metadata");
                replicationSpec.setIsInsert(true);
                EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)this.conf), metaDataPath, qlMdTable, qlPtns, replicationSpec);
                Iterable<String> files = insertMsg.getFiles();
                if (files != null) {
                    Path dataPath = new Path(evRoot, "data");
                    Path filesPath = new Path(dataPath, "_files");
                    FileSystem fs = dataPath.getFileSystem((Configuration)this.conf);
                    try (BufferedWriter fileListWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));){
                        for (String file : files) {
                            fileListWriter.write(file + "\n");
                        }
                    }
                }
                this.LOG.info("Processing#{} INSERT message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_INSERT, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
                break;
            }
            default: {
                this.LOG.info("Dummy processing#{} message : {}", (Object)ev.getEventId(), (Object)ev.getMessage());
                DumpMetaData dmd = new DumpMetaData(evRoot, DUMPTYPE.EVENT_UNKNOWN, evid, evid, cmRoot);
                dmd.setPayload(ev.getMessage());
                dmd.write();
            }
        }
    }

    public static void injectNextDumpDirForTest(String dumpdir) {
        testInjectDumpDir = dumpdir;
    }

    String getNextDumpDir() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            if (testInjectDumpDir == null) {
                return "next";
            }
            return testInjectDumpDir;
        }
        return String.valueOf(System.currentTimeMillis());
    }

    private Path dumpDbMetadata(String dbName, Path dumpRoot) throws SemanticException {
        Path dbRoot = new Path(dumpRoot, dbName);
        try {
            FileSystem fs = dbRoot.getFileSystem((Configuration)this.conf);
            Path dumpPath = new Path(dbRoot, "_metadata");
            Database dbObj = this.db.getDatabase(dbName);
            EximUtil.createDbExportDump(fs, dumpPath, dbObj, this.getNewReplicationSpec());
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        return dbRoot;
    }

    private Path dumpTbl(ASTNode ast, String dbName, String tblName, Path dbRoot) throws SemanticException {
        Path tableRoot = new Path(dbRoot, tblName);
        try {
            URI toURI = EximUtil.getValidatedURI(this.conf, tableRoot.toUri().toString());
            BaseSemanticAnalyzer.TableSpec ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, dbName + "." + tblName, null);
            ExportSemanticAnalyzer.prepareExport(ast, toURI, ts, this.getNewReplicationSpec(), this.db, this.conf, this.ctx, this.rootTasks, this.inputs, this.outputs, this.LOG);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        return tableRoot;
    }

    private void initReplLoad(ASTNode ast) {
        int numChildren = ast.getChildCount();
        this.path = PlanUtils.stripQuotes(ast.getChild(0).getText());
        if (numChildren > 1) {
            this.dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(1).getText());
        }
        if (numChildren > 2) {
            this.tblNameOrPattern = PlanUtils.stripQuotes(ast.getChild(2).getText());
        }
    }

    private void analyzeReplLoad(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplSemanticAnalyzer.analyzeReplLoad: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern) + " from " + String.valueOf(this.path));
        try {
            Path loadPath = new Path(this.path);
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            if (!fs.exists(loadPath)) {
                throw new FileNotFoundException(loadPath.toUri().toString());
            }
            DumpMetaData dmd = new DumpMetaData(loadPath);
            boolean evDump = false;
            if (dmd.isIncrementalDump()) {
                this.LOG.debug("{} contains an incremental dump", (Object)loadPath);
                evDump = true;
            } else {
                this.LOG.debug("{} contains an bootstrap dump", (Object)loadPath);
            }
            if (!evDump && this.tblNameOrPattern != null && !this.tblNameOrPattern.isEmpty()) {
                this.rootTasks.addAll(this.analyzeTableLoad(this.dbNameOrPattern, this.tblNameOrPattern, this.path, null, null, null));
                return;
            }
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(fs, loadPath);
            if (srcs == null || srcs.length == 0) {
                this.LOG.warn("Nothing to load at {}", (Object)loadPath.toUri().toString());
                return;
            }
            Object[] dirsInLoadPath = fs.listStatus(loadPath, EximUtil.getDirectoryFilter(fs));
            if (dirsInLoadPath == null || dirsInLoadPath.length == 0) {
                throw new IllegalArgumentException("No data to load in path " + loadPath.toUri().toString());
            }
            if (!evDump) {
                if (this.dbNameOrPattern != null && dirsInLoadPath.length > 1) {
                    this.LOG.debug("Found multiple dirs when we expected 1:");
                    for (Object d : dirsInLoadPath) {
                        this.LOG.debug("> " + d.getPath().toUri().toString());
                    }
                    throw new IllegalArgumentException("Multiple dirs in " + loadPath.toUri().toString() + " does not correspond to REPL LOAD expecting to load to a singular destination point.");
                }
                for (Object dir : dirsInLoadPath) {
                    this.analyzeDatabaseLoad(this.dbNameOrPattern, fs, (FileStatus)dir);
                }
            } else {
                Task<DDLWork> updateReplIdTask;
                Arrays.sort(dirsInLoadPath);
                Task<DependencyCollectionWork> evTaskRoot = TaskFactory.get(new DependencyCollectionWork(), this.conf, new Task[0]);
                Task<Serializable> taskChainTail = evTaskRoot;
                int evstage = 0;
                Long lastEvid = null;
                ReplicationSpec.ReplStateMap<String, Long> dbsUpdated = new ReplicationSpec.ReplStateMap<String, Long>();
                ReplicationSpec.ReplStateMap<String, Long> tablesUpdated = new ReplicationSpec.ReplStateMap<String, Long>();
                for (Object dir : dirsInLoadPath) {
                    this.LOG.debug("Loading event from {} to {}.{}", new Object[]{dir.getPath().toUri(), this.dbNameOrPattern, this.tblNameOrPattern});
                    String locn = dir.getPath().toUri().toString();
                    DumpMetaData eventDmd = new DumpMetaData(new Path(locn));
                    List<Task<? extends Serializable>> evTasks = this.analyzeEventLoad(this.dbNameOrPattern, this.tblNameOrPattern, locn, taskChainTail, dbsUpdated, tablesUpdated, eventDmd);
                    this.LOG.debug("evstage#{} got {} tasks", (Object)evstage, (Object)(evTasks != null ? evTasks.size() : 0));
                    if (evTasks == null || evTasks.isEmpty()) continue;
                    Task<DependencyCollectionWork> barrierTask = TaskFactory.get(new DependencyCollectionWork(), this.conf, new Task[0]);
                    for (Task<? extends Serializable> t : evTasks) {
                        t.addDependentTask(barrierTask);
                        this.LOG.debug("Added {}:{} as a precursor of barrier task {}:{}", new Object[]{t.getClass(), t.getId(), barrierTask.getClass(), barrierTask.getId()});
                    }
                    this.LOG.debug("Updated taskChainTail from {}{} to {}{}", new Object[]{taskChainTail.getClass(), taskChainTail.getId(), barrierTask.getClass(), barrierTask.getId()});
                    taskChainTail = barrierTask;
                    ++evstage;
                    lastEvid = dmd.eventTo;
                }
                if (evstage > 0) {
                    if (this.tblNameOrPattern != null && !this.tblNameOrPattern.isEmpty()) {
                        dbsUpdated.clear();
                        tablesUpdated.clear();
                        tablesUpdated.put(this.dbNameOrPattern + "." + this.tblNameOrPattern, lastEvid);
                    } else if (this.dbNameOrPattern != null && !this.dbNameOrPattern.isEmpty()) {
                        dbsUpdated.clear();
                        dbsUpdated.put(this.dbNameOrPattern, lastEvid);
                    }
                }
                for (String tableName : tablesUpdated.keySet()) {
                    HashMap<String, String> mapProp = new HashMap<String, String>();
                    mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), ((Long)tablesUpdated.get(tableName)).toString());
                    AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, null, false);
                    alterTblDesc.setProps(mapProp);
                    alterTblDesc.setOldName(tableName);
                    updateReplIdTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, alterTblDesc), this.conf, new Task[0]);
                    taskChainTail.addDependentTask(updateReplIdTask);
                    taskChainTail = updateReplIdTask;
                }
                for (String dbName : dbsUpdated.keySet()) {
                    HashMap<String, String> mapProp = new HashMap<String, String>();
                    mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), ((Long)dbsUpdated.get(dbName)).toString());
                    AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbName, mapProp);
                    updateReplIdTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, alterDbDesc), this.conf, new Task[0]);
                    taskChainTail.addDependentTask(updateReplIdTask);
                    taskChainTail = updateReplIdTask;
                }
                this.rootTasks.add(evTaskRoot);
            }
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Task<? extends Serializable>> analyzeEventLoad(String dbName, String tblName, String locn, Task<? extends Serializable> precursor, Map<String, Long> dbsUpdated, Map<String, Long> tablesUpdated, DumpMetaData dmd) throws SemanticException {
        MessageDeserializer md = MessageFactory.getInstance().getDeserializer();
        switch (dmd.getDumpType()) {
            case EVENT_CREATE_TABLE: {
                return this.analyzeTableLoad(dbName, tblName, locn, precursor, dbsUpdated, tablesUpdated);
            }
            case EVENT_ADD_PARTITION: {
                return this.analyzeTableLoad(dbName, tblName, locn, precursor, dbsUpdated, tablesUpdated);
            }
            case EVENT_DROP_TABLE: {
                DropTableMessage dropTableMessage = md.getDropTableMessage(dmd.getPayload());
                String actualDbName = dbName == null || dbName.isEmpty() ? dropTableMessage.getDB() : dbName;
                String actualTblName = tblName == null || tblName.isEmpty() ? dropTableMessage.getTable() : tblName;
                DropTableDesc dropTableDesc = new DropTableDesc(actualDbName + "." + actualTblName, null, true, true, this.getNewEventOnlyReplicationSpec(String.valueOf(dmd.getEventFrom())));
                Task<DDLWork> dropTableTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, dropTableDesc), this.conf, new Task[0]);
                if (precursor != null) {
                    precursor.addDependentTask(dropTableTask);
                }
                ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
                tasks.add(dropTableTask);
                this.LOG.debug("Added drop tbl task : {}:{}", (Object)dropTableTask.getId(), (Object)dropTableDesc.getTableName());
                dbsUpdated.put(actualDbName, dmd.getEventTo());
                return tasks;
            }
            case EVENT_DROP_PARTITION: {
                try {
                    DropPartitionMessage dropPartitionMessage = md.getDropPartitionMessage(dmd.getPayload());
                    String actualDbName = dbName == null || dbName.isEmpty() ? dropPartitionMessage.getDB() : dbName;
                    String actualTblName = tblName == null || tblName.isEmpty() ? dropPartitionMessage.getTable() : tblName;
                    Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = this.genPartSpecs(new org.apache.hadoop.hive.ql.metadata.Table(dropPartitionMessage.getTableObj()), dropPartitionMessage.getPartitions());
                    if (partSpecs.size() > 0) {
                        DropTableDesc dropPtnDesc = new DropTableDesc(actualDbName + "." + actualTblName, partSpecs, null, true, this.getNewEventOnlyReplicationSpec(String.valueOf(dmd.getEventFrom())));
                        Task<DDLWork> dropPtnTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, dropPtnDesc), this.conf, new Task[0]);
                        if (precursor != null) {
                            precursor.addDependentTask(dropPtnTask);
                        }
                        ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
                        tasks.add(dropPtnTask);
                        this.LOG.debug("Added drop ptn task : {}:{},{}", new Object[]{dropPtnTask.getId(), dropPtnDesc.getTableName(), dropPartitionMessage.getPartitions()});
                        dbsUpdated.put(actualDbName, dmd.getEventTo());
                        tablesUpdated.put(actualDbName + "." + actualTblName, dmd.getEventTo());
                        return tasks;
                    }
                    throw new SemanticException("DROP PARTITION EVENT does not return any part descs for event message :" + dmd.getPayload());
                }
                catch (Exception e) {
                    if (!(e instanceof SemanticException)) {
                        throw new SemanticException("Error reading message members", e);
                    }
                    throw (SemanticException)e;
                }
            }
            case EVENT_ALTER_TABLE: {
                return this.analyzeTableLoad(dbName, tblName, locn, precursor, dbsUpdated, tablesUpdated);
            }
            case EVENT_RENAME_TABLE: {
                AlterTableMessage renameTableMessage = md.getAlterTableMessage(dmd.getPayload());
                if (tblName != null && !tblName.isEmpty()) {
                    throw new SemanticException("RENAMES of tables are not supported for table-level replication");
                }
                try {
                    String oldDbName = renameTableMessage.getTableObjBefore().getDbName();
                    String newDbName = renameTableMessage.getTableObjAfter().getDbName();
                    if (dbName != null && !dbName.isEmpty()) {
                        if (!oldDbName.equalsIgnoreCase(newDbName)) {
                            throw new SemanticException("Cannot replicate an event renaming a table across databases into a db level load " + oldDbName + "->" + newDbName);
                        }
                        oldDbName = dbName;
                        newDbName = dbName;
                    }
                    String oldName = oldDbName + "." + renameTableMessage.getTableObjBefore().getTableName();
                    String newName = newDbName + "." + renameTableMessage.getTableObjAfter().getTableName();
                    AlterTableDesc renameTableDesc = new AlterTableDesc(oldName, newName, false);
                    Task<DDLWork> renameTableTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, renameTableDesc), this.conf, new Task[0]);
                    if (precursor != null) {
                        precursor.addDependentTask(renameTableTask);
                    }
                    ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
                    tasks.add(renameTableTask);
                    this.LOG.debug("Added rename table task : {}:{}->{}", new Object[]{renameTableTask.getId(), oldName, newName});
                    dbsUpdated.put(newDbName, dmd.getEventTo());
                    tablesUpdated.remove(oldName);
                    tablesUpdated.put(newName, dmd.getEventTo());
                    return tasks;
                }
                catch (Exception e) {
                    if (!(e instanceof SemanticException)) {
                        throw new SemanticException("Error reading message members", e);
                    }
                    throw (SemanticException)e;
                }
            }
            case EVENT_ALTER_PARTITION: {
                return this.analyzeTableLoad(dbName, tblName, locn, precursor, dbsUpdated, tablesUpdated);
            }
            case EVENT_RENAME_PARTITION: {
                AlterPartitionMessage renamePtnMessage = md.getAlterPartitionMessage(dmd.getPayload());
                String actualDbName = dbName == null || dbName.isEmpty() ? renamePtnMessage.getDB() : dbName;
                String actualTblName = tblName == null || tblName.isEmpty() ? renamePtnMessage.getTable() : tblName;
                LinkedHashMap<String, String> newPartSpec = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> oldPartSpec = new LinkedHashMap<String, String>();
                String tableName = actualDbName + "." + actualTblName;
                try {
                    Table tblObj = renamePtnMessage.getTableObj();
                    org.apache.hadoop.hive.metastore.api.Partition pobjBefore = renamePtnMessage.getPtnObjBefore();
                    org.apache.hadoop.hive.metastore.api.Partition pobjAfter = renamePtnMessage.getPtnObjAfter();
                    Iterator<String> beforeValIter = pobjBefore.getValuesIterator();
                    Iterator<String> afterValIter = pobjAfter.getValuesIterator();
                    for (FieldSchema fs : tblObj.getPartitionKeys()) {
                        oldPartSpec.put(fs.getName(), beforeValIter.next());
                        newPartSpec.put(fs.getName(), afterValIter.next());
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SemanticException)) {
                        throw new SemanticException("Error reading message members", e);
                    }
                    throw (SemanticException)e;
                }
                RenamePartitionDesc renamePtnDesc = new RenamePartitionDesc(tableName, oldPartSpec, newPartSpec);
                Task<DDLWork> renamePtnTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, renamePtnDesc), this.conf, new Task[0]);
                if (precursor != null) {
                    precursor.addDependentTask(renamePtnTask);
                }
                ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
                tasks.add(renamePtnTask);
                this.LOG.debug("Added rename ptn task : {}:{}->{}", new Object[]{renamePtnTask.getId(), oldPartSpec, newPartSpec});
                dbsUpdated.put(actualDbName, dmd.getEventTo());
                tablesUpdated.put(tableName, dmd.getEventTo());
                return tasks;
            }
            case EVENT_INSERT: {
                md = MessageFactory.getInstance().getDeserializer();
                InsertMessage insertMessage = md.getInsertMessage(dmd.getPayload());
                String actualDbName = dbName == null || dbName.isEmpty() ? insertMessage.getDB() : dbName;
                String actualTblName = tblName == null || tblName.isEmpty() ? insertMessage.getTable() : tblName;
                return this.analyzeTableLoad(actualDbName, actualTblName, locn, precursor, dbsUpdated, tablesUpdated);
            }
            case EVENT_UNKNOWN: {
                break;
            }
        }
        return null;
    }

    private Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(org.apache.hadoop.hive.ql.metadata.Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions != null && partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> ptnDescs = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo(type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pti, key, null, true);
                ExprNodeGenericFuncDesc op = DDLSemanticAnalyzer.makeBinaryPredicate("=", column, new ExprNodeConstantDesc(pti, val));
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            ptnDescs.add(expr);
        }
        if (ptnDescs.size() > 0) {
            partSpecs.put(partPrefixLength, ptnDescs);
        }
        return partSpecs;
    }

    private void analyzeDatabaseLoad(String dbName, FileSystem fs, FileStatus dir) throws SemanticException {
        try {
            FileStatus[] dirsInDbPath;
            EximUtil.ReadMetaData rv = new EximUtil.ReadMetaData();
            try {
                rv = EximUtil.readMetaData(fs, new Path(dir.getPath(), "_metadata"));
            }
            catch (IOException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
            }
            Database dbObj = rv.getDatabase();
            if (dbObj == null) {
                throw new IllegalArgumentException("_metadata file read did not contain a db object - invalid dump.");
            }
            if (dbName == null || dbName.isEmpty()) {
                dbName = dbObj.getName();
            }
            CreateDatabaseDesc createDbDesc = new CreateDatabaseDesc();
            createDbDesc.setName(dbName);
            createDbDesc.setComment(dbObj.getDescription());
            createDbDesc.setDatabaseProperties(dbObj.getParameters());
            createDbDesc.setIfNotExists(false);
            Task<DDLWork> createDbTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.inputs, (HashSet<WriteEntity>)this.outputs, createDbDesc), this.conf, new Task[0]);
            this.rootTasks.add(createDbTask);
            for (FileStatus tableDir : dirsInDbPath = fs.listStatus(dir.getPath(), EximUtil.getDirectoryFilter(fs))) {
                this.analyzeTableLoad(dbName, null, tableDir.getPath().toUri().toString(), createDbTask, null, null);
            }
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Task<? extends Serializable>> analyzeTableLoad(String dbName, String tblName, String locn, Task<? extends Serializable> precursor, Map<String, Long> dbsUpdated, Map<String, Long> tablesUpdated) throws SemanticException {
        if (dbName == null || dbName.isEmpty()) {
            throw new SemanticException("Database name cannot be null for a table load");
        }
        try {
            boolean isLocationSet = false;
            boolean isExternalSet = false;
            boolean isPartSpecSet = false;
            LinkedHashMap<String, String> parsedPartSpec = null;
            String parsedLocation = null;
            ArrayList<Task<? extends Serializable>> importTasks = new ArrayList<Task<? extends Serializable>>();
            EximUtil.SemanticAnalyzerWrapperContext x = new EximUtil.SemanticAnalyzerWrapperContext(this.conf, this.db, this.inputs, this.outputs, importTasks, this.LOG, this.ctx);
            ImportSemanticAnalyzer.prepareImport(isLocationSet, isExternalSet, isPartSpecSet, precursor != null, parsedLocation, tblName, dbName, parsedPartSpec, locn, x, dbsUpdated, tablesUpdated);
            if (precursor != null) {
                for (Task task : importTasks) {
                    precursor.addDependentTask(task);
                    this.LOG.debug("Added {}:{} as a precursor of {}:{}", new Object[]{precursor.getClass(), precursor.getId(), task.getClass(), task.getId()});
                }
            }
            return importTasks;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void initReplStatus(ASTNode ast) {
        int numChildren = ast.getChildCount();
        this.dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        if (numChildren > 1) {
            this.tblNameOrPattern = PlanUtils.stripQuotes(ast.getChild(1).getText());
        }
    }

    private void analyzeReplStatus(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: " + String.valueOf(this.dbNameOrPattern) + "." + String.valueOf(this.tblNameOrPattern));
        String replLastId = null;
        try {
            if (this.tblNameOrPattern != null) {
                org.apache.hadoop.hive.ql.metadata.Table tbl = this.db.getTable(this.dbNameOrPattern, this.tblNameOrPattern);
                if (tbl != null) {
                    this.inputs.add(new ReadEntity(tbl));
                    Map<String, String> params = tbl.getParameters();
                    if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                        replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                    }
                }
            } else {
                Database database = this.db.getDatabase(this.dbNameOrPattern);
                if (database != null) {
                    this.inputs.add(new ReadEntity(database));
                    Map<String, String> params = database.getParameters();
                    if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString())) {
                        replLastId = params.get(ReplicationSpec.KEY.CURR_STATE_ID.toString());
                    }
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        this.prepareReturnValues(Collections.singletonList(replLastId), "last_repl_id#string");
        this.setFetchTask(this.createFetchTask("last_repl_id#string"));
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: writing repl.last.id={} out to {}", (Object)String.valueOf(replLastId), (Object)this.ctx.getResFile());
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        this.writeOutput(values, this.ctx.getResFile());
    }

    private void writeOutput(List<String> values, Path outputFile) throws SemanticException {
        FileSystem fs = null;
        FSDataOutputStream outStream = null;
        try {
            fs = outputFile.getFileSystem((Configuration)this.conf);
            outStream = fs.create(outputFile);
            outStream.writeBytes(values.get(0) == null ? "NULL" : values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                outStream.write(9);
                outStream.writeBytes(values.get(i) == null ? "NULL" : values.get(i));
            }
            outStream.write(10);
        }
        catch (IOException e) {
            try {
                throw new SemanticException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(outStream);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)outStream);
    }

    private ReplicationSpec getNewReplicationSpec() throws SemanticException {
        try {
            ReplicationSpec rspec = this.getNewReplicationSpec("replv2", "will-be-set");
            rspec.setCurrentReplicationState(String.valueOf(this.db.getMSC().getCurrentNotificationEventId().getEventId()));
            return rspec;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private ReplicationSpec getNewReplicationSpec(String evState, String objState) throws SemanticException {
        return new ReplicationSpec(true, false, evState, objState, false, true, false);
    }

    private ReplicationSpec getNewEventOnlyReplicationSpec(String evState) throws SemanticException {
        return this.getNewReplicationSpec(evState, evState);
    }

    private Iterable<? extends String> matchesTbl(String dbName, String tblPattern) throws HiveException {
        if (tblPattern == null) {
            return this.db.getAllTables(dbName);
        }
        return this.db.getTablesByPattern(dbName, tblPattern);
    }

    private Iterable<? extends String> matchesDb(String dbPattern) throws HiveException {
        if (dbPattern == null) {
            return this.db.getAllDatabases();
        }
        return this.db.getDatabasesByPattern(dbPattern);
    }

    public class DumpMetaData {
        private DUMPTYPE dumpType;
        private Long eventFrom = null;
        private Long eventTo = null;
        private String payload = null;
        private boolean initialized = false;
        private final Path dumpRoot;
        private final Path dumpFile;
        private Path cmRoot;

        public DumpMetaData(Path dumpRoot) {
            this.dumpRoot = dumpRoot;
            this.dumpFile = new Path(dumpRoot, ReplicationSemanticAnalyzer.DUMPMETADATA);
        }

        public DumpMetaData(Path dumpRoot, DUMPTYPE lvl, Long eventFrom, Long eventTo, Path cmRoot) {
            this(dumpRoot);
            this.setDump(lvl, eventFrom, eventTo, cmRoot);
        }

        public void setDump(DUMPTYPE lvl, Long eventFrom, Long eventTo, Path cmRoot) {
            this.dumpType = lvl;
            this.eventFrom = eventFrom;
            this.eventTo = eventTo;
            this.initialized = true;
            this.cmRoot = cmRoot;
        }

        public void loadDumpFromFile() throws SemanticException {
            try {
                FileSystem fs = this.dumpFile.getFileSystem((Configuration)ReplicationSemanticAnalyzer.this.conf);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.dumpFile)));
                String line = null;
                line = br.readLine();
                if (line == null) {
                    throw new IOException("Unable to read valid values from dumpFile:" + this.dumpFile.toUri().toString());
                }
                String[] lineContents = line.split("\t", 5);
                this.setDump(DUMPTYPE.valueOf(lineContents[0]), Long.valueOf(lineContents[1]), Long.valueOf(lineContents[2]), new Path(lineContents[3]));
                this.setPayload(lineContents[4].equals("NULL") ? null : lineContents[4]);
                ReplChangeManager.setCmRoot(this.cmRoot);
            }
            catch (IOException ioe) {
                throw new SemanticException(ioe);
            }
        }

        public DUMPTYPE getDumpType() throws SemanticException {
            this.initializeIfNot();
            return this.dumpType;
        }

        public String getPayload() throws SemanticException {
            this.initializeIfNot();
            return this.payload;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public Long getEventFrom() throws SemanticException {
            this.initializeIfNot();
            return this.eventFrom;
        }

        public Long getEventTo() throws SemanticException {
            this.initializeIfNot();
            return this.eventTo;
        }

        public Path getCmRoot() {
            return this.cmRoot;
        }

        public void setCmRoot(Path cmRoot) {
            this.cmRoot = cmRoot;
        }

        public Path getDumpFilePath() {
            return this.dumpFile;
        }

        public boolean isIncrementalDump() throws SemanticException {
            this.initializeIfNot();
            return this.dumpType == DUMPTYPE.INCREMENTAL;
        }

        private void initializeIfNot() throws SemanticException {
            if (!this.initialized) {
                this.loadDumpFromFile();
            }
        }

        public void write() throws SemanticException {
            ReplicationSemanticAnalyzer.this.writeOutput(Arrays.asList(this.dumpType.toString(), this.eventFrom.toString(), this.eventTo.toString(), this.cmRoot.toString(), this.payload), this.dumpFile);
        }
    }

    public static enum DUMPTYPE {
        BOOTSTRAP("BOOTSTRAP"),
        INCREMENTAL("INCREMENTAL"),
        EVENT_CREATE_TABLE("EVENT_CREATE_TABLE"),
        EVENT_ADD_PARTITION("EVENT_ADD_PARTITION"),
        EVENT_DROP_TABLE("EVENT_DROP_TABLE"),
        EVENT_DROP_PARTITION("EVENT_DROP_PARTITION"),
        EVENT_ALTER_TABLE("EVENT_ALTER_TABLE"),
        EVENT_RENAME_TABLE("EVENT_RENAME_TABLE"),
        EVENT_ALTER_PARTITION("EVENT_ALTER_PARTITION"),
        EVENT_RENAME_PARTITION("EVENT_RENAME_PARTITION"),
        EVENT_INSERT("EVENT_INSERT"),
        EVENT_UNKNOWN("EVENT_UNKNOWN");

        String type = null;

        private DUMPTYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

