/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeGenericFuncDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ExprNodeGenericFuncDesc.class.getName());
    private GenericUDF genericUDF;
    private List<ExprNodeDesc> chidren;
    private transient String funcText;
    private transient ObjectInspector writableObjectInspector;
    private boolean isSortedExpr;

    public ExprNodeGenericFuncDesc() {
    }

    public ExprNodeGenericFuncDesc(TypeInfo typeInfo, GenericUDF genericUDF, String funcText, List<ExprNodeDesc> children) {
        this(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo), genericUDF, funcText, children);
    }

    public ExprNodeGenericFuncDesc(ObjectInspector oi, GenericUDF genericUDF, String funcText, List<ExprNodeDesc> children) {
        super(TypeInfoUtils.getTypeInfoFromObjectInspector(oi));
        this.writableObjectInspector = ObjectInspectorUtils.getWritableObjectInspector(oi);
        assert (genericUDF != null);
        this.genericUDF = genericUDF;
        this.chidren = children;
        this.funcText = funcText;
    }

    public ExprNodeGenericFuncDesc(TypeInfo typeInfo, GenericUDF genericUDF, List<ExprNodeDesc> children) {
        this(typeInfo, genericUDF, null, children);
    }

    public ExprNodeGenericFuncDesc(ObjectInspector oi, GenericUDF genericUDF, List<ExprNodeDesc> children) {
        this(oi, genericUDF, null, children);
    }

    @Override
    public ObjectInspector getWritableObjectInspector() {
        return this.writableObjectInspector;
    }

    public GenericUDF getGenericUDF() {
        return this.genericUDF;
    }

    public void setGenericUDF(GenericUDF genericUDF) {
        this.genericUDF = genericUDF;
    }

    public void setChildren(List<ExprNodeDesc> children) {
        this.chidren = children;
    }

    @Override
    public List<ExprNodeDesc> getChildren() {
        return this.chidren;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genericUDF.getClass().getSimpleName());
        if (this.genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge genericUDFBridge = (GenericUDFBridge)this.genericUDF;
            sb.append(" ==> ");
            sb.append(genericUDFBridge.getUdfName());
            sb.append(" ");
        }
        sb.append("(");
        if (this.chidren != null) {
            for (int i = 0; i < this.chidren.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.chidren.get(i));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getExprString() {
        String[] childrenExprStrings = new String[this.chidren.size()];
        for (int i = 0; i < childrenExprStrings.length; ++i) {
            childrenExprStrings[i] = this.chidren.get(i).getExprString();
        }
        return this.genericUDF.getDisplayString(childrenExprStrings);
    }

    @Override
    public List<String> getCols() {
        List<String> colList = new ArrayList<String>();
        if (this.chidren != null) {
            for (int pos = 0; pos < this.chidren.size(); ++pos) {
                List<String> colCh = this.chidren.get(pos).getCols();
                colList = Utilities.mergeUniqElems(colList, colCh);
            }
        }
        return colList;
    }

    @Override
    public ExprNodeDesc clone() {
        ArrayList<ExprNodeDesc> cloneCh = new ArrayList<ExprNodeDesc>(this.chidren.size());
        for (ExprNodeDesc ch : this.chidren) {
            cloneCh.add(ch.clone());
        }
        ExprNodeGenericFuncDesc clone = new ExprNodeGenericFuncDesc(this.typeInfo, FunctionRegistry.cloneGenericUDF(this.genericUDF), this.funcText, cloneCh);
        return clone;
    }

    public static ExprNodeGenericFuncDesc newInstance(GenericUDF genericUDF, String funcText, List<ExprNodeDesc> children) throws UDFArgumentException {
        SessionState.ResourceType t;
        ObjectInspector[] childrenOIs = new ObjectInspector[children.size()];
        for (int i = 0; i < childrenOIs.length; ++i) {
            childrenOIs[i] = children.get(i).getWritableObjectInspector();
        }
        if (genericUDF instanceof GenericUDFBaseCompare && children.size() == 2) {
            String error;
            TypeInfo oiTypeInfo0 = children.get(0).getTypeInfo();
            TypeInfo oiTypeInfo1 = children.get(1).getTypeInfo();
            SessionState ss = SessionState.get();
            HiveConf conf = ss != null ? ss.getConf() : new Configuration();
            SessionState.LogHelper console = new SessionState.LogHelper(LOG);
            if (oiTypeInfo0.equals(TypeInfoFactory.stringTypeInfo) && oiTypeInfo1.equals(TypeInfoFactory.longTypeInfo) || oiTypeInfo0.equals(TypeInfoFactory.longTypeInfo) && oiTypeInfo1.equals(TypeInfoFactory.stringTypeInfo)) {
                error = HiveConf.StrictChecks.checkTypeSafety(conf);
                if (error != null) {
                    throw new UDFArgumentException(error);
                }
                console.printError("WARNING: Comparing a bigint and a string may result in a loss of precision.");
            } else if (oiTypeInfo0.equals(TypeInfoFactory.doubleTypeInfo) && oiTypeInfo1.equals(TypeInfoFactory.longTypeInfo) || oiTypeInfo0.equals(TypeInfoFactory.longTypeInfo) && oiTypeInfo1.equals(TypeInfoFactory.doubleTypeInfo)) {
                error = HiveConf.StrictChecks.checkTypeSafety(conf);
                if (error != null) {
                    throw new UDFArgumentException(error);
                }
                console.printError("WARNING: Comparing a bigint and a double may result in a loss of precision.");
            }
        }
        ObjectInspector oi = genericUDF.initializeAndFoldConstants(childrenOIs);
        String[] requiredJars = genericUDF.getRequiredJars();
        String[] requiredFiles = genericUDF.getRequiredFiles();
        SessionState ss = SessionState.get();
        if (requiredJars != null) {
            t = SessionState.find_resource_type("JAR");
            try {
                ss.add_resources(t, Arrays.asList(requiredJars));
            }
            catch (Exception e) {
                throw new UDFArgumentException(e);
            }
        }
        if (requiredFiles != null) {
            t = SessionState.find_resource_type("FILE");
            try {
                ss.add_resources(t, Arrays.asList(requiredFiles));
            }
            catch (Exception e) {
                throw new UDFArgumentException(e);
            }
        }
        return new ExprNodeGenericFuncDesc(oi, genericUDF, funcText, children);
    }

    public static ExprNodeGenericFuncDesc newInstance(GenericUDF genericUDF, List<ExprNodeDesc> children) throws UDFArgumentException {
        return ExprNodeGenericFuncDesc.newInstance(genericUDF, null, children);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        ExprNodeGenericFuncDesc dest = (ExprNodeGenericFuncDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo()) || !this.genericUDF.getClass().equals(dest.getGenericUDF().getClass())) {
            return false;
        }
        if (this.genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)this.genericUDF;
            GenericUDFBridge bridge2 = (GenericUDFBridge)dest.getGenericUDF();
            if (!bridge.getUdfClassName().equals(bridge2.getUdfClassName()) || !bridge.getUdfName().equals(bridge2.getUdfName()) || bridge.isOperator() != bridge2.isOperator()) {
                return false;
            }
        }
        if (this.genericUDF instanceof GenericUDFMacro && (((GenericUDFMacro)this.genericUDF).getMacroName() == null || !((GenericUDFMacro)this.genericUDF).getMacroName().equals(((GenericUDFMacro)dest.genericUDF).getMacroName()))) {
            return false;
        }
        if (this.chidren.size() != dest.getChildren().size()) {
            return false;
        }
        for (int pos = 0; pos < this.chidren.size(); ++pos) {
            if (this.chidren.get(pos).isSame(dest.getChildren().get(pos))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.chidren);
        return builder.toHashCode();
    }

    public boolean isSortedExpr() {
        return this.isSortedExpr;
    }

    public void setSortedExpr(boolean isSortedExpr) {
        this.isSortedExpr = isSortedExpr;
    }

    public String getFuncText() {
        return this.funcText;
    }
}

