/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReloadFunctionDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionSemanticAnalyzer.class);

    public FunctionSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getType() == 708) {
            this.analyzeCreateFunction(ast);
        } else if (ast.getType() == 741) {
            this.analyzeDropFunction(ast);
        } else if (ast.getType() == 880) {
            this.rootTasks.add(TaskFactory.get(new FunctionWork(new ReloadFunctionDesc()), this.conf, new Task[0]));
        }
        LOG.info("analyze done");
    }

    private void analyzeCreateFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText().toLowerCase();
        boolean isTemporaryFunction = ast.getFirstChildWithType(982) != null;
        String className = FunctionSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        if (isTemporaryFunction && FunctionUtils.isQualifiedFunctionName(functionName)) {
            throw new SemanticException("Temporary function cannot be created with a qualified name.");
        }
        List<ResourceUri> resources = this.getResourceList(ast);
        CreateFunctionDesc desc = new CreateFunctionDesc(functionName, isTemporaryFunction, className, resources);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
        this.addEntities(functionName, isTemporaryFunction, resources);
    }

    private void analyzeDropFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        boolean ifExists = ast.getFirstChildWithType(776) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        FunctionInfo info = FunctionRegistry.getFunctionInfo(functionName);
        if (info == null) {
            if (throwException) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
            }
            return;
        }
        if (info.isBuiltIn()) {
            throw new SemanticException(ErrorMsg.DROP_NATIVE_FUNCTION.getMsg(functionName));
        }
        boolean isTemporaryFunction = ast.getFirstChildWithType(982) != null;
        DropFunctionDesc desc = new DropFunctionDesc(functionName, isTemporaryFunction);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
        this.addEntities(functionName, isTemporaryFunction, null);
    }

    private ResourceType getResourceType(ASTNode token) throws SemanticException {
        switch (token.getType()) {
            case 801: {
                return ResourceType.JAR;
            }
            case 757: {
                return ResourceType.FILE;
            }
            case 694: {
                return ResourceType.ARCHIVE;
            }
        }
        throw new SemanticException("Unexpected token " + token.toString());
    }

    private List<ResourceUri> getResourceList(ASTNode ast) throws SemanticException {
        ArrayList<ResourceUri> resources = null;
        ASTNode resourcesNode = (ASTNode)ast.getFirstChildWithType(887);
        if (resourcesNode != null) {
            resources = new ArrayList<ResourceUri>();
            for (int idx = 0; idx < resourcesNode.getChildCount(); ++idx) {
                ASTNode resNode = (ASTNode)resourcesNode.getChild(idx);
                if (resNode.getToken().getType() != 888) {
                    throw new SemanticException("Expected token type TOK_RESOURCE_URI but found " + resNode.getToken().toString());
                }
                if (resNode.getChildCount() != 2) {
                    throw new SemanticException("Expected 2 child nodes of TOK_RESOURCE_URI but found " + resNode.getChildCount());
                }
                ASTNode resTypeNode = (ASTNode)resNode.getChild(0);
                ASTNode resUriNode = (ASTNode)resNode.getChild(1);
                ResourceType resourceType = this.getResourceType(resTypeNode);
                resources.add(new ResourceUri(resourceType, PlanUtils.stripQuotes(resUriNode.getText())));
            }
        }
        return resources;
    }

    private void addEntities(String functionName, boolean isTemporaryFunction, List<ResourceUri> resources) throws SemanticException {
        Database database = null;
        if (!isTemporaryFunction) {
            try {
                String[] qualifiedNameParts = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                String dbName = qualifiedNameParts[0];
                functionName = qualifiedNameParts[1];
                database = this.getDatabase(dbName);
            }
            catch (HiveException e) {
                LOG.error("Failed to get database ", e);
                throw new SemanticException(e);
            }
        }
        if (database != null) {
            this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        }
        this.outputs.add(new WriteEntity(database, functionName, Entity.Type.FUNCTION, WriteEntity.WriteType.DDL_NO_LOCK));
        if (resources != null) {
            for (ResourceUri resource : resources) {
                String uriPath = resource.getUri();
                this.outputs.add(this.toWriteEntity(uriPath));
            }
        }
    }
}

