/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidRules;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.SemiJoinFilterTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinJoinTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinProjectTransposeRule;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteViewSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveDefaultRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexExecutorImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveAlgorithmsConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveVolcanoPlanner;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExcept;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateJoinTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregatePullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExceptRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExpandDistinctAggregatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterAggregateTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTSTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSetOpTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInsertExchange4JoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinAddNotNullRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinCommuteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinPushTransitivePredicatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinToMultiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePartitionPruneRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePreFilteringRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectFilterPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectOverIntersectRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsWithStatsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelDecorrelator;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortJoinReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortLimitPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortUnionReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSubQueryRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveWindowingFixRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewFilterScanRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinCondTypeCheckProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierForReturnPath;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.NamedJoinInfo;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;

public class CalcitePlanner
extends SemanticAnalyzer {
    private final AtomicInteger noColsMissingStats = new AtomicInteger(0);
    private SemanticException semanticException;
    private boolean runCBO = true;
    private boolean disableSemJoinReordering = true;
    private EnumSet<ExtendedCBOProfile> profilesCBO;

    public CalcitePlanner(QueryState queryState) throws SemanticException {
        super(queryState);
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = false;
            this.disableSemJoinReordering = false;
        }
    }

    public void resetCalciteConfiguration() {
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = true;
            this.disableSemJoinReordering = true;
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (this.runCBO) {
            PreCboCtx cboCtx = new PreCboCtx();
            super.analyzeInternal(ast, cboCtx);
        } else {
            super.analyzeInternal(ast);
        }
    }

    public RelNode genLogicalPlan(ASTNode ast) throws SemanticException {
        this.LOG.info("Starting generating logical plan");
        PreCboCtx cboCtx = new PreCboCtx();
        this.processPositionAlias(ast);
        if (!this.genResolvedParseTree(ast, cboCtx)) {
            return null;
        }
        ASTNode queryForCbo = ast;
        if (cboCtx.type == PreCboCtx.Type.CTAS || cboCtx.type == PreCboCtx.Type.VIEW) {
            queryForCbo = cboCtx.nodeOfInterest;
        }
        this.runCBO = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
        if (!this.runCBO) {
            return null;
        }
        this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
        this.disableJoinMerge = true;
        RelNode resPlan = this.logicalPlan();
        this.LOG.info("Finished generating logical plan");
        return resPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    Operator genOPTree(ASTNode ast, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        sinkOp = null;
        skipCalcitePlan = false;
        if (!this.runCBO) {
            skipCalcitePlan = true;
        } else {
            cboCtx = (PreCboCtx)plannerCtx;
            queryForCbo = ast;
            if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.CTAS || PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW) {
                queryForCbo = PreCboCtx.access$100(cboCtx);
            }
            this.runCBO = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
            if (this.queryProperties.hasMultiDestQuery()) {
                this.handleMultiDestQuery(ast, cboCtx);
            }
            if (this.runCBO) {
                this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
                this.disableJoinMerge = true;
                reAnalyzeAST = false;
                materializedView = this.getQB().isMaterializedView();
                try {
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                        if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && !materializedView) {
                            throw new SemanticException("Create view is not supported in cbo return path.");
                        }
                        sinkOp = this.getOptimizedHiveOPDag();
                        this.LOG.info("CBO Succeeded; optimized logical plan.");
                        this.ctx.setCboInfo("Plan optimized by CBO.");
                        this.ctx.setCboSucceeded(true);
                    }
                    newAST = this.getOptimizedAST();
                    newAST = this.fixUpAfterCbo(ast, newAST, cboCtx);
                    if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && !materializedView) {
                        try {
                            this.handleCreateViewDDL(newAST);
                        }
                        catch (SemanticException e) {
                            throw new CalciteViewSemanticException(e.getMessage());
                        }
                    } else {
                        this.init(false);
                        if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && materializedView) {
                            this.setAST(newAST);
                            newAST = this.reAnalyzeViewAfterCbo(newAST);
                            originalText = this.ctx.getTokenRewriteStream().toString(PreCboCtx.access$100(cboCtx).getTokenStartIndex(), PreCboCtx.access$100(cboCtx).getTokenStopIndex());
                            this.createVwDesc.setViewOriginalText(originalText);
                            this.viewSelect = newAST;
                            this.viewsExpanded = new ArrayList<E>();
                            this.viewsExpanded.add(this.createVwDesc.getViewName());
                        } else if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.CTAS) {
                            this.setAST(newAST);
                            newAST = this.reAnalyzeCTASAfterCbo(newAST);
                        }
                    }
                    ctx_1 = this.initPhase1Ctx();
                    if (!this.doPhase1(newAST, this.getQB(), ctx_1, null)) {
                        throw new RuntimeException("Couldn't do phase1 on CBO optimized query plan");
                    }
                    this.getMetaData(this.getQB());
                    this.disableJoinMerge = this.defaultJoinMerge;
                    sinkOp = this.genPlan(this.getQB());
                    this.LOG.info("CBO Succeeded; optimized logical plan.");
                    this.ctx.setCboInfo("Plan optimized by CBO.");
                    this.ctx.setCboSucceeded(true);
                    if (!this.LOG.isTraceEnabled()) ** GOTO lbl103
                    this.LOG.trace(newAST.dump());
                }
                catch (Exception e) {
                    v0 = isMissingStats = this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        this.LOG.error("CBO failed due to missing column stats (see previous errors), skipping CBO");
                        this.ctx.setCboInfo("Plan not optimized by CBO due to missing statistics. Please check log for more details.");
                    } else {
                        this.LOG.error("CBO failed, skipping CBO. ", e);
                        if (e instanceof CalciteSemanticException) {
                            calciteSemanticException = (CalciteSemanticException)e;
                            unsupportedFeature = calciteSemanticException.getUnsupportedFeature();
                            if (unsupportedFeature != null) {
                                this.ctx.setCboInfo("Plan not optimized by CBO due to missing feature [" + (Object)unsupportedFeature + "].");
                            } else {
                                this.ctx.setCboInfo("Plan not optimized by CBO.");
                            }
                        } else {
                            this.ctx.setCboInfo("Plan not optimized by CBO.");
                        }
                    }
                    if (e instanceof CalciteSubquerySemanticException) {
                        throw new SemanticException(e);
                    }
                    if (e instanceof CalciteViewSemanticException) {
                        throw new SemanticException(e);
                    }
                    if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || isMissingStats || e instanceof CalciteSemanticException) {
                        reAnalyzeAST = true;
                    }
                    if (e instanceof SemanticException) {
                        reAnalyzeAST = true;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new SemanticException(e);
                }
                finally {
                    this.runCBO = false;
                    this.disableJoinMerge = this.defaultJoinMerge;
                    this.disableSemJoinReordering = false;
                    if (reAnalyzeAST) {
                        this.init(true);
                        this.prunedPartitions.clear();
                        super.genResolvedParseTree(ast, new SemanticAnalyzer.PlannerContext());
                        skipCalcitePlan = true;
                    }
                }
            } else {
                this.ctx.setCboInfo("Plan not optimized by CBO.");
                skipCalcitePlan = true;
            }
        }
lbl103:
        // 7 sources

        if (skipCalcitePlan) {
            sinkOp = super.genOPTree(ast, plannerCtx);
        }
        return sinkOp;
    }

    private void handleCreateViewDDL(ASTNode newAST) throws SemanticException {
        this.saveViewDefinition();
        String originalText = this.createVwDesc.getViewOriginalText();
        String expandedText = this.createVwDesc.getViewExpandedText();
        List<FieldSchema> schema = this.createVwDesc.getSchema();
        List<FieldSchema> partitionColumns = this.createVwDesc.getPartCols();
        this.init(false);
        this.setAST(newAST);
        newAST = this.reAnalyzeViewAfterCbo(newAST);
        this.createVwDesc.setViewOriginalText(originalText);
        this.createVwDesc.setViewExpandedText(expandedText);
        this.createVwDesc.setSchema(schema);
        this.createVwDesc.setPartCols(partitionColumns);
    }

    private void handleMultiDestQuery(ASTNode ast, PreCboCtx cboCtx) throws SemanticException {
        if (!this.runCBO) {
            return;
        }
        if (CalcitePlanner.isJoinToken(cboCtx.nodeOfInterest)) {
            ASTNode subq = this.rewriteASTForMultiInsert(ast, cboCtx.nodeOfInterest);
            if (subq != null) {
                cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
                QB newQB = new QB(null, "", false);
                SemanticAnalyzer.Phase1Ctx ctx_1 = this.initPhase1Ctx();
                this.doPhase1(cboCtx.nodeOfInterest, newQB, ctx_1, null);
                this.setQB(newQB);
                this.getMetaData(this.getQB());
            } else {
                this.runCBO = false;
            }
        } else if (cboCtx.nodeOfInterest.getToken().getType() == 941) {
            ASTNode subq = cboCtx.nodeOfInterest;
            cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
            String subQAlias = CalcitePlanner.unescapeIdentifier(subq.getChild(1).getText());
            QB newQB = this.getQB().getSubqForAlias(subQAlias).getQB();
            newQB.getParseInfo().setAlias("");
            newQB.getParseInfo().setIsSubQ(false);
            this.setQB(newQB);
        } else {
            this.runCBO = false;
        }
    }

    private ASTNode rewriteASTForMultiInsert(ASTNode query, ASTNode nodeOfInterest) {
        final ArrayListMultimap aliasNodes = ArrayListMultimap.create();
        final AtomicBoolean notSupported = new AtomicBoolean(false);
        TreeVisitorAction action = new TreeVisitorAction(){

            public Object pre(Object t) {
                if (!notSupported.get()) {
                    Object p;
                    if (ParseDriver.adaptor.getType(t) == 651) {
                        notSupported.set(true);
                    } else if (ParseDriver.adaptor.getType(t) == 16) {
                        Object c = ParseDriver.adaptor.getChild(t, 0);
                        if (c != null && ParseDriver.adaptor.getType(c) == 973) {
                            aliasNodes.put(((ASTNode)t).toStringTree(), t);
                        }
                    } else if (ParseDriver.adaptor.getType(t) == 973 && ((p = ParseDriver.adaptor.getParent(t)) == null || ParseDriver.adaptor.getType(p) != 16)) {
                        aliasNodes.put(((ASTNode)t).toStringTree(), t);
                    }
                }
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        };
        TreeVisitor tv = new TreeVisitor(ParseDriver.adaptor);
        for (int i = 0; i < query.getChildCount(); ++i) {
            ASTNode child = (ASTNode)query.getChild(i);
            if (ParseDriver.adaptor.getType((Object)child) != 782) continue;
            tv.visit((Object)child, action);
        }
        if (notSupported.get()) {
            return null;
        }
        ASTNode from = new ASTNode((Token)new CommonToken(761, "TOK_FROM"));
        from.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)nodeOfInterest)));
        ASTNode destination = new ASTNode((Token)new CommonToken(734, "TOK_DESTINATION"));
        ASTNode dir = new ASTNode((Token)new CommonToken(736, "TOK_DIR"));
        ASTNode tmpFile = new ASTNode((Token)new CommonToken(986, "TOK_TMP_FILE"));
        dir.addChild((Tree)tmpFile);
        destination.addChild((Tree)dir);
        ASTNode select = new ASTNode((Token)new CommonToken(899, "TOK_SELECT"));
        int num = 0;
        for (Collection selectIdentifier : aliasNodes.asMap().values()) {
            Iterator it = selectIdentifier.iterator();
            ASTNode node = (ASTNode)it.next();
            ASTNode selectExpr = new ASTNode((Token)new CommonToken(901, "TOK_SELEXPR"));
            selectExpr.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)node)));
            String colAlias = "col" + num;
            selectExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            select.addChild((Tree)selectExpr);
            ASTNode colExpr = new ASTNode((Token)new CommonToken(973, "TOK_TABLE_OR_COL"));
            colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            CalcitePlanner.replaceASTChild(node, colExpr);
            while (it.hasNext()) {
                node = (ASTNode)it.next();
                colExpr = new ASTNode((Token)new CommonToken(973, "TOK_TABLE_OR_COL"));
                colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
                CalcitePlanner.replaceASTChild(node, colExpr);
            }
            ++num;
        }
        ASTNode insert = new ASTNode((Token)new CommonToken(782, "TOK_INSERT"));
        insert.addChild((Tree)destination);
        insert.addChild((Tree)select);
        ASTNode newQuery = new ASTNode((Token)new CommonToken(876, "TOK_QUERY"));
        newQuery.addChild((Tree)from);
        newQuery.addChild((Tree)insert);
        ASTNode subq = new ASTNode((Token)new CommonToken(941, "TOK_SUBQUERY"));
        subq.addChild((Tree)newQuery);
        subq.addChild((Tree)new ASTNode((Token)new CommonToken(24, "subq")));
        CalcitePlanner.replaceASTChild(nodeOfInterest, subq);
        return subq;
    }

    boolean canCBOHandleAst(ASTNode ast, QB qb, PreCboCtx cboCtx) {
        boolean result;
        int root = ast.getToken().getType();
        boolean needToLogMessage = STATIC_LOG.isInfoEnabled();
        boolean isSupportedRoot = root == 876 || root == 751 || qb.isCTAS() || qb.isMaterializedView();
        boolean isSupportedType = qb.getIsQuery() && !qb.containsQueryWithoutSourceTable() || qb.isCTAS() || qb.isMaterializedView() || cboCtx.type == PreCboCtx.Type.INSERT || cboCtx.type == PreCboCtx.Type.MULTI_INSERT;
        boolean noBadTokens = HiveCalciteUtil.validateASTForUnsupportedTokens(ast);
        boolean bl = result = isSupportedRoot && isSupportedType && noBadTokens;
        if (!result) {
            if (needToLogMessage) {
                String msg = "";
                if (!isSupportedRoot) {
                    msg = msg + "doesn't have QUERY or EXPLAIN as root and not a CTAS; ";
                }
                if (!isSupportedType) {
                    msg = msg + "is not a query with at least one source table  or there is a subquery without a source table, or CTAS, or insert; ";
                }
                if (!noBadTokens) {
                    msg = msg + "has unsupported tokens; ";
                }
                if (msg.isEmpty()) {
                    msg = msg + "has some unspecified limitations; ";
                }
                STATIC_LOG.info("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2));
            }
            return false;
        }
        String msg = CalcitePlanner.canHandleQbForCbo(this.queryProperties, this.conf, true, needToLogMessage, qb);
        if (msg == null) {
            return true;
        }
        if (needToLogMessage) {
            STATIC_LOG.info("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2));
        }
        return false;
    }

    static String canHandleQbForCbo(QueryProperties queryProperties, HiveConf conf, boolean topLevelQB, boolean verbose, QB qb) {
        if (!(queryProperties.hasClusterBy() || queryProperties.hasDistributeBy() || queryProperties.hasSortBy() || queryProperties.hasPTF() || queryProperties.usesScript() || queryProperties.hasLateralViews())) {
            return null;
        }
        String msg = "";
        if (verbose) {
            if (queryProperties.hasClusterBy()) {
                msg = msg + "has cluster by; ";
            }
            if (queryProperties.hasDistributeBy()) {
                msg = msg + "has distribute by; ";
            }
            if (queryProperties.hasSortBy()) {
                msg = msg + "has sort by; ";
            }
            if (queryProperties.hasPTF()) {
                msg = msg + "has PTF; ";
            }
            if (queryProperties.usesScript()) {
                msg = msg + "uses scripts; ";
            }
            if (queryProperties.hasLateralViews()) {
                msg = msg + "has lateral views; ";
            }
            if (msg.isEmpty()) {
                msg = msg + "has some unspecified limitations; ";
            }
        }
        return msg;
    }

    private static EnumSet<ExtendedCBOProfile> obtainCBOProfiles(QueryProperties queryProperties) {
        EnumSet<ExtendedCBOProfile> profilesCBO = EnumSet.noneOf(ExtendedCBOProfile.class);
        if (queryProperties.getJoinCount() > 1) {
            profilesCBO.add(ExtendedCBOProfile.JOIN_REORDERING);
        }
        if (queryProperties.hasWindowing()) {
            profilesCBO.add(ExtendedCBOProfile.WINDOWING_POSTPROCESSING);
        }
        return profilesCBO;
    }

    @Override
    boolean isCBOExecuted() {
        return this.runCBO;
    }

    @Override
    boolean continueJoinMerge() {
        return !this.runCBO || !this.disableSemJoinReordering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Table materializeCTE(String cteName, SemanticAnalyzer.CTEClause cte) throws HiveException {
        ASTNode createTable = new ASTNode((Token)new ClassicToken(713));
        ASTNode tableName = new ASTNode((Token)new ClassicToken(976));
        tableName.addChild((Tree)new ASTNode((Token)new ClassicToken(24, cteName)));
        ASTNode temporary = new ASTNode((Token)new ClassicToken(284, "$MATERIALIZATION"));
        createTable.addChild((Tree)tableName);
        createTable.addChild((Tree)temporary);
        createTable.addChild((Tree)cte.cteNode);
        CalcitePlanner analyzer = new CalcitePlanner(this.queryState);
        analyzer.initCtx(this.ctx);
        analyzer.init(false);
        analyzer.aliasToCTEs.putAll(this.aliasToCTEs);
        HiveOperation operation = this.queryState.getHiveOperation();
        try {
            analyzer.analyzeInternal(createTable);
        }
        finally {
            this.queryState.setCommandType(operation);
        }
        Table table = analyzer.tableDesc.toTable(this.conf);
        Path location = table.getDataLocation();
        try {
            location.getFileSystem((Configuration)this.conf).mkdirs(location);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        table.setMaterializedTable(true);
        this.LOG.info(cteName + " will be materialized into " + location);
        cte.table = table;
        cte.source = analyzer;
        this.ctx.addMaterializedTable(cteName, table);
        this.ctx.addMaterializedTable(table.getDbName() + "." + table.getTableName(), table);
        return table;
    }

    @Override
    String fixCtasColumnName(String colName) {
        if (this.runCBO) {
            int lastDot = colName.lastIndexOf(46);
            if (lastDot < 0) {
                return colName;
            }
            String nqColumnName = colName.substring(lastDot + 1);
            STATIC_LOG.debug("Replacing " + colName + " (produced by CBO) by " + nqColumnName);
            return nqColumnName;
        }
        return super.fixCtasColumnName(colName);
    }

    ASTNode fixUpAfterCbo(ASTNode originalAst, ASTNode newAst, PreCboCtx cboCtx) throws SemanticException {
        switch (cboCtx.type) {
            case NONE: {
                return newAst;
            }
            case CTAS: 
            case VIEW: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
            case INSERT: {
                ASTNode newDest = new ASTSearcher().simpleBreadthFirstSearch(newAst, 876, 782, 734);
                if (newDest == null) {
                    this.LOG.error("Cannot find destination after CBO; new ast is " + newAst.dump());
                    throw new SemanticException("Cannot find destination after CBO");
                }
                CalcitePlanner.replaceASTChild(newDest, cboCtx.nodeOfInterest);
                return newAst;
            }
            case MULTI_INSERT: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
        }
        throw new AssertionError((Object)("Unexpected type " + (Object)((Object)cboCtx.type)));
    }

    ASTNode reAnalyzeCTASAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateTable(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize CTAS after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize CTAS after CBO");
        }
        return newAst;
    }

    ASTNode reAnalyzeViewAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateView(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize materialized view after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize materialized view after CBO");
        }
        return newAst;
    }

    private static void replaceASTChild(ASTNode child, ASTNode newChild) {
        ASTNode parent = (ASTNode)child.parent;
        int childIndex = child.childIndex;
        parent.deleteChild(childIndex);
        parent.insertChild(childIndex, newChild);
    }

    RelNode logicalPlan() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = null;
        if (this.columnAccessInfo == null) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions, this.columnAccessInfo);
        try {
            optimizedOptiqPlan = Frameworks.withPlanner(calcitePlannerAction, Frameworks.newConfigBuilder().typeSystem(new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        return optimizedOptiqPlan;
    }

    ASTNode getOptimizedAST() throws SemanticException {
        RelNode optimizedOptiqPlan = this.logicalPlan();
        ASTNode optiqOptimizedAST = ASTConverter.convert(optimizedOptiqPlan, this.resultSchema, HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_COLUMN_ALIGNMENT));
        return optiqOptimizedAST;
    }

    Operator getOptimizedHiveOPDag() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = null;
        if (this.columnAccessInfo == null) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions, this.columnAccessInfo);
        try {
            optimizedOptiqPlan = Frameworks.withPlanner(calcitePlannerAction, Frameworks.newConfigBuilder().typeSystem(new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        RelNode modifiedOptimizedOptiqPlan = PlanModifierForReturnPath.convertOpTree(optimizedOptiqPlan, this.resultSchema, this.getQB().getTableDesc() != null);
        this.LOG.debug("Translating the following plan:\n" + RelOptUtil.toString(modifiedOptimizedOptiqPlan));
        Operator hiveRoot = new HiveOpConverter(this, this.conf, this.unparseTranslator, this.topOps).convert(modifiedOptimizedOptiqPlan);
        RowResolver hiveRootRR = this.genRowResolver(hiveRoot, this.getQB());
        this.opParseCtx.put(hiveRoot, new OpParseContext(hiveRootRR));
        String dest = this.getQB().getParseInfo().getClauseNames().iterator().next();
        if (this.getQB().getParseInfo().getDestSchemaForClause(dest) != null && this.getQB().getTableDesc() == null) {
            Operator<?> selOp = this.handleInsertStatement(dest, hiveRoot, hiveRootRR, this.getQB());
            return this.genFileSinkPlan(dest, this.getQB(), selOp);
        }
        return this.genFileSinkPlan(dest, this.getQB(), hiveRoot);
    }

    Operator<?> handleInsertStatement(String dest, Operator<?> input, RowResolver inputRR, QB qb) throws SemanticException {
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new ExprNodeColumnDesc(col));
        }
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        RowResolver out_rwsch = this.handleInsertStatementSpec(colList, dest, inputRR, inputRR, qb, selExprList);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < colList.size(); ++i) {
            String outputCol = CalcitePlanner.getColumnInternalName(i);
            colExprMap.put(outputCol, colList.get(i));
            columnNames.add(outputCol);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private void rethrowCalciteException(Exception e) throws SemanticException {
        Throwable first = this.semanticException != null ? this.semanticException : e;
        Throwable current = first;
        Throwable cause = current.getCause();
        while (cause != null) {
            Throwable causeOfCause = cause.getCause();
            if (current == first && causeOfCause == null && this.isUselessCause(first)) {
                first = cause;
                break;
            }
            if (causeOfCause != null && this.isUselessCause(cause) && ExceptionHelper.resetCause(current, causeOfCause)) {
                cause = causeOfCause;
                continue;
            }
            current = cause;
            cause = current.getCause();
        }
        if (first instanceof RuntimeException) {
            throw (RuntimeException)first;
        }
        if (first instanceof SemanticException) {
            throw (SemanticException)first;
        }
        throw new RuntimeException(first);
    }

    private boolean isUselessCause(Throwable t) {
        return t instanceof RuntimeException || t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException;
    }

    private RowResolver genRowResolver(Operator op, QB qb) {
        RowResolver rr = new RowResolver();
        String subqAlias = qb.getAliases().size() == 1 && qb.getSubqAliases().size() == 1 ? qb.getAliases().get(0) : null;
        for (ColumnInfo ci : op.getSchema().getSignature()) {
            try {
                rr.putWithCheck(subqAlias != null ? subqAlias : ci.getTabAlias(), ci.getAlias() != null ? ci.getAlias() : ci.getInternalName(), ci.getInternalName(), new ColumnInfo(ci));
            }
            catch (SemanticException e) {
                throw new RuntimeException(e);
            }
        }
        return rr;
    }

    private static enum TableType {
        DRUID,
        NATIVE;

    }

    private class CalcitePlannerAction
    implements Frameworks.PlannerAction<RelNode> {
        private RelOptCluster cluster;
        private RelOptSchema relOptSchema;
        private final Map<String, PrunedPartitionList> partitionCache;
        private final ColumnAccessInfo columnAccessInfo;
        private Map<HiveProject, Table> viewProjectToTableSchema;
        private int subqueryId;
        Set<RelNode> corrScalarRexSQWithAgg = new HashSet<RelNode>();
        LinkedHashMap<RelNode, RowResolver> relToHiveRR = new LinkedHashMap();
        LinkedHashMap<RelNode, ImmutableMap<String, Integer>> relToHiveColNameCalcitePosMap = new LinkedHashMap();

        CalcitePlannerAction(Map<String, PrunedPartitionList> partitionCache, ColumnAccessInfo columnAccessInfo) {
            this.partitionCache = partitionCache;
            this.columnAccessInfo = columnAccessInfo;
        }

        @Override
        public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
            RelOptCluster optCluster;
            RelNode calciteGenPlan = null;
            RelNode calcitePreCboPlan = null;
            RelNode calciteOptimizedPlan = null;
            this.subqueryId = 0;
            Double maxSplitSize = HiveConf.getLongVar(CalcitePlanner.this.conf, HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            Double maxMemory = HiveConf.getLongVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
            HiveAlgorithmsConf algorithmsConf = new HiveAlgorithmsConf(maxSplitSize, maxMemory);
            HiveRulesRegistry registry = new HiveRulesRegistry();
            HivePlannerContext confContext = new HivePlannerContext(algorithmsConf, registry, this.corrScalarRexSQWithAgg);
            RelOptPlanner planner = HiveVolcanoPlanner.createPlanner(confContext);
            RexBuilder rexBuilder = cluster.getRexBuilder();
            this.cluster = optCluster = RelOptCluster.create(planner, rexBuilder);
            this.relOptSchema = relOptSchema;
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            try {
                calciteGenPlan = this.genLogicalPlan(CalcitePlanner.this.getQB(), true, null, null);
                CalcitePlanner.this.resultSchema = SemanticAnalyzer.convertRowSchemaToResultSetSchema(this.relToHiveRR.get(calciteGenPlan), CalcitePlanner.this.getQB().isView() ? false : HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
            }
            catch (SemanticException e) {
                CalcitePlanner.this.semanticException = e;
                throw new RuntimeException(e);
            }
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Plan generation");
            HiveRelFieldTrimmer fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(optCluster, null), this.columnAccessInfo, this.viewProjectToTableSchema);
            fieldTrimmer.trim(calciteGenPlan);
            HiveDefaultRelMetadataProvider mdProvider = new HiveDefaultRelMetadataProvider(CalcitePlanner.this.conf);
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of(mdProvider.getMetadataProvider()));
            HiveRexExecutorImpl executorProvider = new HiveRexExecutorImpl(optCluster);
            CalcitePlanner.this.LOG.debug("Plan before removing subquery:\n" + RelOptUtil.toString(calciteGenPlan));
            calciteGenPlan = this.hepPlan(calciteGenPlan, false, mdProvider.getMetadataProvider(), null, HiveSubQueryRemoveRule.FILTER, HiveSubQueryRemoveRule.PROJECT);
            CalcitePlanner.this.LOG.debug("Plan just after removing subquery:\n" + RelOptUtil.toString(calciteGenPlan));
            calciteGenPlan = HiveRelDecorrelator.decorrelateQuery(calciteGenPlan);
            CalcitePlanner.this.LOG.debug("Plan after decorrelation:\n" + RelOptUtil.toString(calciteGenPlan));
            calcitePreCboPlan = this.applyPreJoinOrderingTransforms(calciteGenPlan, mdProvider.getMetadataProvider(), executorProvider);
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.JOIN_REORDERING)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                try {
                    ArrayList<RelMetadataProvider> list = Lists.newArrayList();
                    list.add(mdProvider.getMetadataProvider());
                    RelTraitSet desiredTraits = optCluster.traitSetOf(HiveRelNode.CONVENTION, RelCollations.EMPTY);
                    HepProgramBuilder hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
                    hepPgmBldr.addRuleInstance(new JoinToMultiJoinRule(HiveJoin.class));
                    hepPgmBldr.addRuleInstance(new LoptOptimizeJoinRule(HiveRelFactories.HIVE_BUILDER));
                    HepProgram hepProgram = hepPgmBldr.build();
                    HepPlanner hepPlanner = new HepPlanner(hepProgram);
                    hepPlanner.registerMetadataProviders(list);
                    RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of(list);
                    optCluster.setMetadataProvider(new CachingRelMetadataProvider(chainedProvider, hepPlanner));
                    RelNode rootRel = calcitePreCboPlan;
                    hepPlanner.setRoot(rootRel);
                    if (!calcitePreCboPlan.getTraitSet().equals(desiredTraits)) {
                        rootRel = hepPlanner.changeTraits(calcitePreCboPlan, desiredTraits);
                    }
                    hepPlanner.setRoot(rootRel);
                    calciteOptimizedPlan = hepPlanner.findBestExp();
                }
                catch (Exception e) {
                    boolean isMissingStats;
                    boolean bl = isMissingStats = CalcitePlanner.this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        CalcitePlanner.this.LOG.warn("Missing column stats (see previous messages), skipping join reordering in CBO");
                        CalcitePlanner.this.noColsMissingStats.set(0);
                        calciteOptimizedPlan = calcitePreCboPlan;
                        CalcitePlanner.this.disableSemJoinReordering = false;
                    }
                    throw e;
                }
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Join Reordering");
            } else {
                calciteOptimizedPlan = calcitePreCboPlan;
                CalcitePlanner.this.disableSemJoinReordering = false;
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, ProjectRemoveRule.INSTANCE, UnionMergeRule.INSTANCE, HiveProjectMergeRule.INSTANCE_NO_FORCE, HiveAggregateProjectMergeRule.INSTANCE, HiveJoinCommuteRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Optimizations without stats");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING) && !CalcitePlanner.this.getQB().isMaterializedView() && !CalcitePlanner.this.getQB().isCTAS()) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                DefaultRelMetadataProvider calciteMdProvider = DefaultRelMetadataProvider.INSTANCE;
                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of(calciteMdProvider));
                planner.registerMetadataProviders(Lists.newArrayList(calciteMdProvider));
                List<Object> materializations = new ArrayList();
                try {
                    materializations = Hive.get().getRewritingMaterializedViews();
                    materializations = Lists.transform(materializations, new Function<RelOptMaterialization, RelOptMaterialization>(){

                        @Override
                        public RelOptMaterialization apply(RelOptMaterialization materialization) {
                            AbstractRelNode newViewScan;
                            RelNode viewScan = materialization.tableRel;
                            if (viewScan instanceof DruidQuery) {
                                DruidQuery dq = (DruidQuery)viewScan;
                                newViewScan = DruidQuery.create(optCluster, optCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), viewScan.getTable(), dq.getDruidTable(), ImmutableList.of(dq.getTableScan()));
                            } else {
                                newViewScan = new HiveTableScan(optCluster, optCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), (RelOptHiveTable)viewScan.getTable(), viewScan.getTable().getQualifiedName().get(0), null, false, false);
                            }
                            return new RelOptMaterialization(newViewScan, materialization.queryRel, null);
                        }
                    });
                }
                catch (HiveException e) {
                    CalcitePlanner.this.LOG.warn("Exception loading materialized views", e);
                }
                if (!materializations.isEmpty()) {
                    for (RelOptMaterialization relOptMaterialization : materializations) {
                        planner.addMaterialization(relOptMaterialization);
                    }
                    planner.addRule(HiveMaterializedViewFilterScanRule.INSTANCE);
                    planner.setRoot(calciteOptimizedPlan);
                    calciteOptimizedPlan = planner.findBestExp();
                    planner.clear();
                }
                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of(mdProvider.getMetadataProvider()));
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: View-based rewriting");
            }
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                try {
                    calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveAggregateJoinTransposeRule.INSTANCE);
                }
                catch (Exception e) {
                    boolean isMissingStats;
                    boolean bl = isMissingStats = CalcitePlanner.this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        CalcitePlanner.this.LOG.warn("Missing column stats (see previous messages), skipping aggregate-join transpose in CBO");
                        CalcitePlanner.this.noColsMissingStats.set(0);
                    }
                    throw e;
                }
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Aggregate join transpose");
            }
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.SEMIJOIN_CONVERSION)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HiveSemiJoinRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Semijoin conversion");
            }
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.WINDOWING_POSTPROCESSING)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveWindowingFixRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Window fixing rule");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, DruidRules.FILTER, DruidRules.PROJECT_AGGREGATE, DruidRules.PROJECT, DruidRules.AGGREGATE, DruidRules.PROJECT_SORT, DruidRules.SORT, DruidRules.SORT_PROJECT);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Druid transformation rules");
            if (HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, true, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveJoinProjectTransposeRule.BOTH_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.LEFT_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.RIGHT_PROJECT_INCLUDE_OUTER, HiveJoinToMultiJoinRule.INSTANCE, HiveProjectMergeRule.INSTANCE);
                fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(optCluster, null));
                calciteOptimizedPlan = fieldTrimmer.trim(calciteOptimizedPlan);
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, ProjectRemoveRule.INSTANCE, new ProjectMergeRule(false, HiveRelFactories.HIVE_BUILDER));
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, true, mdProvider.getMetadataProvider(), null, HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE);
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveInsertExchange4JoinRule.EXCHANGE_BELOW_JOIN, HiveInsertExchange4JoinRule.EXCHANGE_BELOW_MULTIJOIN);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Translation from Calcite tree to Hive tree");
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled() && !CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                CalcitePlanner.this.LOG.debug("CBO Planning details:\n");
                CalcitePlanner.this.LOG.debug("Original Plan:\n" + RelOptUtil.toString(calciteGenPlan));
                CalcitePlanner.this.LOG.debug("Plan After PPD, PartPruning, ColumnPruning:\n" + RelOptUtil.toString(calcitePreCboPlan));
                CalcitePlanner.this.LOG.debug("Plan After Join Reordering:\n" + RelOptUtil.toString(calciteOptimizedPlan, SqlExplainLevel.ALL_ATTRIBUTES));
            }
            return calciteOptimizedPlan;
        }

        private RelNode applyPreJoinOrderingTransforms(RelNode basePlan, RelMetadataProvider mdProvider, RelOptPlanner.Executor executorProvider) {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            int maxCNFNodeCount = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_CBO_CNF_NODES_LIMIT);
            int minNumORClauses = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVEPOINTLOOKUPOPTIMIZERMIN);
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, null, HepMatchOrder.BOTTOM_UP, HiveProjectOverIntersectRemoveRule.INSTANCE, HiveIntersectMergeRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveProjectOverIntersectRemoveRule and HiveIntersectMerge rules");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, null, HepMatchOrder.BOTTOM_UP, HiveIntersectRewriteRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveIntersectRewrite rule");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, null, HepMatchOrder.BOTTOM_UP, HiveExceptRewriteRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveExceptRewrite rule");
            if (!CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("mr") && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTIMIZEDISTINCTREWRITE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                basePlan = this.hepPlan(basePlan, true, mdProvider, null, HiveExpandDistinctAggregatesRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Distinct aggregate rewrite");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, null, HepMatchOrder.ARBITRARY, new HivePreFilteringRule(maxCNFNodeCount));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, factor out common filter elements and separating deterministic vs non-deterministic UDF");
            ArrayList<RelOptRule> rules = Lists.newArrayList();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_WINDOWING)) {
                rules.add(HiveFilterProjectTransposeRule.INSTANCE_DETERMINISTIC_WINDOWING);
            } else {
                rules.add(HiveFilterProjectTransposeRule.INSTANCE_DETERMINISTIC);
            }
            rules.add(HiveFilterSetOpTransposeRule.INSTANCE);
            rules.add(HiveFilterSortTransposeRule.INSTANCE);
            rules.add(HiveFilterJoinRule.JOIN);
            rules.add(HiveFilterJoinRule.FILTER_ON_JOIN);
            rules.add(new HiveFilterAggregateTransposeRule(Filter.class, HiveRelFactories.HIVE_FILTER_FACTORY, Aggregate.class));
            rules.add(new FilterMergeRule(HiveRelFactories.HIVE_BUILDER));
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_REDUCE_WITH_STATS)) {
                rules.add(HiveReduceExpressionsWithStatsRule.INSTANCE);
            }
            rules.add(HiveProjectFilterPullUpConstantsRule.INSTANCE);
            rules.add(HiveReduceExpressionsRule.PROJECT_INSTANCE);
            rules.add(HiveReduceExpressionsRule.FILTER_INSTANCE);
            rules.add(HiveReduceExpressionsRule.JOIN_INSTANCE);
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEPOINTLOOKUPOPTIMIZER)) {
                rules.add(new HivePointLookupOptimizerRule(minNumORClauses));
            }
            rules.add(HiveJoinAddNotNullRule.INSTANCE_JOIN);
            rules.add(HiveJoinAddNotNullRule.INSTANCE_SEMIJOIN);
            rules.add(HiveJoinPushTransitivePredicatesRule.INSTANCE_JOIN);
            rules.add(HiveJoinPushTransitivePredicatesRule.INSTANCE_SEMIJOIN);
            rules.add(HiveSortMergeRule.INSTANCE);
            rules.add(HiveSortLimitPullUpConstantsRule.INSTANCE);
            rules.add(HiveUnionPullUpConstantsRule.INSTANCE);
            rules.add(HiveAggregatePullUpConstantsRule.INSTANCE);
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, HepMatchOrder.BOTTOM_UP, rules.toArray(new RelOptRule[rules.size()]));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, PPD, not null predicates, transitive inference, constant folding");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                float reductionProportion = HiveConf.getFloatVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_PERCENTAGE);
                long reductionTuples = HiveConf.getLongVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_TUPLES);
                basePlan = this.hepPlan(basePlan, true, mdProvider, null, HiveSortMergeRule.INSTANCE, HiveSortProjectTransposeRule.INSTANCE, HiveSortJoinReduceRule.INSTANCE, HiveSortUnionReduceRule.INSTANCE);
                basePlan = this.hepPlan(basePlan, true, mdProvider, null, HepMatchOrder.BOTTOM_UP, new HiveSortRemoveRule(reductionProportion, reductionTuples), HiveProjectSortTransposeRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Push down limit through outer join");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, null, SemiJoinJoinTransposeRule.INSTANCE, SemiJoinFilterTransposeRule.INSTANCE, SemiJoinProjectTransposeRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Push Down Semi Joins");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, null, new HivePartitionPruneRule(CalcitePlanner.this.conf));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Partition Pruning");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            HiveRelFieldTrimmer fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(this.cluster, null), CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.JOIN_REORDERING));
            basePlan = fieldTrimmer.trim(basePlan);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Projection Pruning");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, null, HiveProjectMergeRule.INSTANCE, ProjectRemoveRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Merge Project-Project");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, null, HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Rerun PPD");
            return basePlan;
        }

        private RelNode hepPlan(RelNode basePlan, boolean followPlanChanges, RelMetadataProvider mdProvider, RelOptPlanner.Executor executorProvider, RelOptRule ... rules) {
            return this.hepPlan(basePlan, followPlanChanges, mdProvider, executorProvider, HepMatchOrder.TOP_DOWN, rules);
        }

        private RelNode hepPlan(RelNode basePlan, boolean followPlanChanges, RelMetadataProvider mdProvider, RelOptPlanner.Executor executorProvider, HepMatchOrder order, RelOptRule ... rules) {
            RelNode optimizedRelNode = basePlan;
            HepProgramBuilder programBuilder = new HepProgramBuilder();
            if (followPlanChanges) {
                programBuilder.addMatchOrder(order);
                programBuilder = programBuilder.addRuleCollection(ImmutableList.copyOf(rules));
            } else {
                for (RelOptRule r : rules) {
                    programBuilder.addRuleInstance(r);
                }
            }
            HepPlanner planner = new HepPlanner(programBuilder.build(), basePlan.getCluster().getPlanner().getContext());
            ArrayList<RelMetadataProvider> list = Lists.newArrayList();
            list.add(mdProvider);
            planner.registerMetadataProviders(list);
            RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of(list);
            basePlan.getCluster().setMetadataProvider(new CachingRelMetadataProvider(chainedProvider, planner));
            if (executorProvider != null) {
                basePlan.getCluster().getPlanner().setExecutor(executorProvider);
            }
            planner.setRoot(basePlan);
            optimizedRelNode = planner.findBestExp();
            return optimizedRelNode;
        }

        private RelNode genSetOpLogicalPlan(QBExpr.Opcode opcode, String alias, String leftalias, RelNode leftRel, String rightalias, RelNode rightRel) throws SemanticException {
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            LinkedHashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
            LinkedHashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
            if (leftmap.size() != rightmap.size()) {
                throw new SemanticException("Schema of both sides of union should match.");
            }
            ASTNode tabref = CalcitePlanner.this.getQB().getAliases().isEmpty() ? null : CalcitePlanner.this.getQB().getParseInfo().getSrcForAlias(CalcitePlanner.this.getQB().getAliases().get(0));
            RowResolver setOpOutRR = new RowResolver();
            Iterator lIter = ((HashMap)leftmap).entrySet().iterator();
            Iterator rIter = ((HashMap)rightmap).entrySet().iterator();
            while (lIter.hasNext()) {
                Map.Entry lEntry = lIter.next();
                Map.Entry rEntry = rIter.next();
                ColumnInfo lInfo = (ColumnInfo)lEntry.getValue();
                ColumnInfo rInfo = (ColumnInfo)rEntry.getValue();
                String field = (String)lEntry.getKey();
                TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
                if (commonTypeInfo == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of setop should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
                }
                ColumnInfo setOpColInfo = new ColumnInfo(lInfo);
                setOpColInfo.setType(commonTypeInfo);
                setOpOutRR.put(alias, field, setOpColInfo);
            }
            boolean leftNeedsTypeCast = false;
            boolean rightNeedsTypeCast = false;
            ArrayList<RexNode> leftProjs = new ArrayList<RexNode>();
            ArrayList<RexNode> rightProjs = new ArrayList<RexNode>();
            List<RelDataTypeField> leftRowDT = leftRel.getRowType().getFieldList();
            List<RelDataTypeField> rightRowDT = rightRel.getRowType().getFieldList();
            for (int i = 0; i < leftRowDT.size(); ++i) {
                RelDataType rightFieldDT;
                RelDataType leftFieldDT = leftRowDT.get(i).getType();
                if (!leftFieldDT.equals(rightFieldDT = rightRowDT.get(i).getType())) {
                    RelDataType unionFieldDT = TypeConverter.convert(setOpOutRR.getColumnInfos().get(i).getType(), this.cluster.getTypeFactory());
                    if (!unionFieldDT.equals(leftFieldDT)) {
                        leftNeedsTypeCast = true;
                    }
                    leftProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                    if (!unionFieldDT.equals(rightFieldDT)) {
                        rightNeedsTypeCast = true;
                    }
                    rightProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
                    continue;
                }
                leftProjs.add(this.cluster.getRexBuilder().ensureType(leftFieldDT, this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                rightProjs.add(this.cluster.getRexBuilder().ensureType(rightFieldDT, this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
            }
            RelNode setOpLeftInput = leftRel;
            RelNode setOpRightInput = rightRel;
            if (leftNeedsTypeCast) {
                setOpLeftInput = HiveProject.create(leftRel, leftProjs, leftRel.getRowType().getFieldNames());
            }
            if (rightNeedsTypeCast) {
                setOpRightInput = HiveProject.create(rightRel, rightProjs, rightRel.getRowType().getFieldNames());
            }
            ImmutableList.Builder bldr = new ImmutableList.Builder();
            bldr.add(setOpLeftInput);
            bldr.add(setOpRightInput);
            SetOp setOpRel = null;
            switch (opcode) {
                case UNION: {
                    setOpRel = new HiveUnion(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()));
                    break;
                }
                case INTERSECT: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()), false);
                    break;
                }
                case INTERSECTALL: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()), true);
                    break;
                }
                case EXCEPT: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()), false);
                    break;
                }
                case EXCEPTALL: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)((Object)bldr.build()), true);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SET_OPERATOR.getMsg(opcode.toString()));
                }
            }
            this.relToHiveRR.put(setOpRel, setOpOutRR);
            this.relToHiveColNameCalcitePosMap.put(setOpRel, this.buildHiveToCalciteColumnMap(setOpOutRR, setOpRel));
            return setOpRel;
        }

        private RelNode genJoinRelNode(RelNode leftRel, String leftTableAlias, RelNode rightRel, String rightTableAlias, JoinType hiveJoinType, ASTNode joinCond) throws SemanticException {
            JoinRelType calciteJoinType;
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            RexNode calciteJoinCond = null;
            ArrayList<String> namedColumns = null;
            if (joinCond != null) {
                JoinTypeCheckCtx jCtx = new JoinTypeCheckCtx(leftRR, rightRR, hiveJoinType);
                RowResolver input = RowResolver.getCombinedRR(leftRR, rightRR);
                if (joinCond.getType() == 952 && !hiveJoinType.equals((Object)JoinType.LEFTSEMI)) {
                    namedColumns = new ArrayList<String>();
                    ASTNode and = (ASTNode)ParseDriver.adaptor.create(33, "and");
                    ASTNode equal = null;
                    int count = 0;
                    for (Node child : joinCond.getChildren()) {
                        String columnName = ((ASTNode)child).getText();
                        if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child);
                        }
                        namedColumns.add(columnName);
                        ASTNode left = ASTBuilder.qualifiedName(leftTableAlias, columnName);
                        ASTNode right = ASTBuilder.qualifiedName(rightTableAlias, columnName);
                        equal = (ASTNode)ParseDriver.adaptor.create(18, "=");
                        ParseDriver.adaptor.addChild((Object)equal, (Object)left);
                        ParseDriver.adaptor.addChild((Object)equal, (Object)right);
                        ParseDriver.adaptor.addChild((Object)and, (Object)equal);
                        ++count;
                    }
                    joinCond = count > 1 ? and : equal;
                } else if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                    CalcitePlanner.this.genAllExprNodeDesc(joinCond, input, jCtx);
                }
                Map<ASTNode, ExprNodeDesc> exprNodes = JoinCondTypeCheckProcFactory.genExprNode(joinCond, jCtx);
                if (jCtx.getError() != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(jCtx.getErrorSrcNode(), jCtx.getError()));
                }
                ExprNodeDesc joinCondnExprNode = exprNodes.get(joinCond);
                ArrayList<RelNode> inputRels = new ArrayList<RelNode>();
                inputRels.add(leftRel);
                inputRels.add(rightRel);
                calciteJoinCond = RexNodeConverter.convert(this.cluster, joinCondnExprNode, inputRels, this.relToHiveRR, this.relToHiveColNameCalcitePosMap, false);
            } else {
                calciteJoinCond = this.cluster.getRexBuilder().makeLiteral(true);
            }
            boolean leftSemiJoin = false;
            switch (hiveJoinType) {
                case LEFTOUTER: {
                    calciteJoinType = JoinRelType.LEFT;
                    break;
                }
                case RIGHTOUTER: {
                    calciteJoinType = JoinRelType.RIGHT;
                    break;
                }
                case FULLOUTER: {
                    calciteJoinType = JoinRelType.FULL;
                    break;
                }
                case LEFTSEMI: {
                    calciteJoinType = JoinRelType.INNER;
                    leftSemiJoin = true;
                    break;
                }
                default: {
                    calciteJoinType = JoinRelType.INNER;
                }
            }
            RelNode topRel = null;
            RowResolver topRR = null;
            if (leftSemiJoin) {
                ArrayList<RelDataTypeField> sysFieldList = new ArrayList<RelDataTypeField>();
                ArrayList<RexNode> leftJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                RexNode nonEquiConds = RelOptUtil.splitJoinCondition(sysFieldList, leftRel, rightRel, calciteJoinCond, leftJoinKeys, rightJoinKeys, null, null);
                if (!nonEquiConds.isAlwaysTrue()) {
                    throw new SemanticException("Non equality condition not supported in Semi-Join" + nonEquiConds);
                }
                RelNode[] inputRels = new RelNode[]{leftRel, rightRel};
                ArrayList<Integer> leftKeys = new ArrayList<Integer>();
                ArrayList<Integer> rightKeys = new ArrayList<Integer>();
                calciteJoinCond = HiveCalciteUtil.projectNonColumnEquiConditions(HiveRelFactories.HIVE_PROJECT_FACTORY, inputRels, leftJoinKeys, rightJoinKeys, 0, leftKeys, rightKeys);
                topRel = HiveSemiJoin.getSemiJoin(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), inputRels[0], inputRels[1], calciteJoinCond, ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
                if (inputRels[0] != leftRel) {
                    RowResolver newLeftRR = new RowResolver();
                    if (!RowResolver.add(newLeftRR, leftRR)) {
                        CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                    }
                    for (int i = leftRel.getRowType().getFieldCount(); i < inputRels[0].getRowType().getFieldCount(); ++i) {
                        ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(i), TypeConverter.convert(inputRels[0].getRowType().getFieldList().get(i).getType()), null, false);
                        newLeftRR.put(oColInfo.getTabAlias(), oColInfo.getInternalName(), oColInfo);
                    }
                    RowResolver joinRR = new RowResolver();
                    if (!RowResolver.add(joinRR, newLeftRR)) {
                        CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                    }
                    this.relToHiveColNameCalcitePosMap.put(topRel, this.buildHiveToCalciteColumnMap(joinRR, topRel));
                    this.relToHiveRR.put(topRel, joinRR);
                    ArrayList<RexInputRef> topFields = new ArrayList<RexInputRef>();
                    ArrayList<String> topFieldNames = new ArrayList<String>();
                    for (int i = 0; i < leftRel.getRowType().getFieldCount(); ++i) {
                        RelDataTypeField field = leftRel.getRowType().getFieldList().get(i);
                        topFields.add(leftRel.getCluster().getRexBuilder().makeInputRef(field.getType(), i));
                        topFieldNames.add(field.getName());
                    }
                    topRel = HiveRelFactories.HIVE_PROJECT_FACTORY.createProject(topRel, topFields, topFieldNames);
                }
                if (!RowResolver.add(topRR = new RowResolver(), leftRR)) {
                    CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                }
            } else {
                topRel = HiveJoin.getJoin(this.cluster, leftRel, rightRel, calciteJoinCond, calciteJoinType);
                topRR = RowResolver.getCombinedRR(leftRR, rightRR);
                if (namedColumns != null) {
                    ArrayList<String> tableAliases = new ArrayList<String>();
                    tableAliases.add(leftTableAlias);
                    tableAliases.add(rightTableAlias);
                    topRR.setNamedJoinInfo(new NamedJoinInfo(tableAliases, namedColumns, hiveJoinType));
                }
            }
            this.relToHiveColNameCalcitePosMap.put(topRel, this.buildHiveToCalciteColumnMap(topRR, topRel));
            this.relToHiveRR.put(topRel, topRR);
            return topRel;
        }

        private RelNode genJoinLogicalPlan(ASTNode joinParseTree, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode leftRel = null;
            RelNode rightRel = null;
            JoinType hiveJoinType = null;
            if (joinParseTree.getToken().getType() == 997) {
                String msg = String.format("UNIQUE JOIN is currently not supported in CBO, turn off cbo to use UNIQUE JOIN.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Unique_join);
            }
            switch (joinParseTree.getToken().getType()) {
                case 805: {
                    hiveJoinType = JoinType.LEFTOUTER;
                    break;
                }
                case 894: {
                    hiveJoinType = JoinType.RIGHTOUTER;
                    break;
                }
                case 762: {
                    hiveJoinType = JoinType.FULLOUTER;
                    break;
                }
                case 806: {
                    hiveJoinType = JoinType.LEFTSEMI;
                    break;
                }
                default: {
                    hiveJoinType = JoinType.INNER;
                }
            }
            ASTNode left = (ASTNode)joinParseTree.getChild(0);
            String leftTableAlias = null;
            if (left.getToken().getType() == 977 || left.getToken().getType() == 941 || left.getToken().getType() == 875) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)left.getChild(0)).toLowerCase();
                leftTableAlias = left.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
                leftTableAlias = left.getToken().getType() == 875 ? SemanticAnalyzer.unescapeIdentifier(left.getChild(1).getText().toLowerCase()) : leftTableAlias;
                leftRel = aliasToRel.get(leftTableAlias);
            } else if (SemanticAnalyzer.isJoinToken(left)) {
                leftRel = this.genJoinLogicalPlan(left, aliasToRel);
            } else assert (false);
            ASTNode right = (ASTNode)joinParseTree.getChild(1);
            String rightTableAlias = null;
            if (right.getToken().getType() == 977 || right.getToken().getType() == 941 || right.getToken().getType() == 875) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)right.getChild(0)).toLowerCase();
                rightTableAlias = right.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
                rightTableAlias = right.getToken().getType() == 875 ? SemanticAnalyzer.unescapeIdentifier(right.getChild(1).getText().toLowerCase()) : rightTableAlias;
                rightRel = aliasToRel.get(rightTableAlias);
            } else assert (false);
            ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
            return this.genJoinRelNode(leftRel, leftTableAlias, rightRel, rightTableAlias, hiveJoinType, joinCond);
        }

        private RelNode genTableLogicalPlan(String tableAlias, QB qb) throws SemanticException {
            RowResolver rr = new RowResolver();
            AbstractRelNode tableRel = null;
            try {
                ColumnInfo colInfo;
                String colName;
                if (qb.getParseInfo().getTabSample(tableAlias) != null || CalcitePlanner.this.getNameToSplitSampleMap().containsKey(tableAlias) || CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP) && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE)) {
                    String msg = String.format("Table Sample specified for %s. Currently we don't support Table Sample clauses in CBO, turn off cbo for queries on tableSamples.", tableAlias);
                    CalcitePlanner.this.LOG.debug(msg);
                    throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Table_sample_clauses);
                }
                Table tabMetaData = qb.getMetaData().getSrcForAlias(tableAlias);
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tabMetaData.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
                for (int i = 0; i < fields.size(); ++i) {
                    colName = fields.get(i).getFieldName();
                    colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), tableAlias, false);
                    colInfo.setSkewedCol(SemanticAnalyzer.isSkewedCol(tableAlias, qb, colName));
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                }
                ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
                ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
                for (FieldSchema part_col : tabMetaData.getPartCols()) {
                    colName = part_col.getName();
                    colInfo = new ColumnInfo(colName, TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), tableAlias, true);
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                    partitionColumns.add(colInfo);
                }
                TableType tableType = this.obtainTableType(tabMetaData);
                ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
                if (tableType == TableType.NATIVE) {
                    for (VirtualColumn vc : VirtualColumn.getRegistry(CalcitePlanner.this.conf)) {
                        colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                        rr.put(tableAlias, vc.getName().toLowerCase(), colInfo);
                        cInfoLst.add(colInfo);
                        virtualCols.add(vc);
                    }
                }
                if (tableType == TableType.DRUID) {
                    List<String> originalColumnNames = ((StandardStructObjectInspector)rowObjectInspector).getOriginalColumnNames();
                    ArrayList<ColumnInfo> cIList = new ArrayList<ColumnInfo>(originalColumnNames.size());
                    for (int i = 0; i < rr.getColumnInfos().size(); ++i) {
                        cIList.add(new ColumnInfo(originalColumnNames.get(i), rr.getColumnInfos().get(i).getType(), tableAlias, false));
                    }
                    RelDataType rowType = TypeConverter.getType(this.cluster, cIList);
                    String fullyQualifiedTabName = tabMetaData.getDbName();
                    fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + tabMetaData.getTableName() : tabMetaData.getTableName();
                    RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, CalcitePlanner.this.noColsMissingStats);
                    String address = HiveConf.getVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                    String dataSource = tabMetaData.getParameters().get("druid.datasource");
                    HashSet<String> metrics = new HashSet<String>();
                    ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
                    ArrayList<String> druidColNames = new ArrayList<String>();
                    for (RelDataTypeField field : rowType.getFieldList()) {
                        druidColTypes.add(field.getType());
                        druidColNames.add(field.getName());
                        if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                        metrics.add(field.getName());
                    }
                    List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
                    DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto(rowType), metrics, "__time", intervals);
                    HiveTableScan scan = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()));
                    tableRel = DruidQuery.create(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, druidTable, ImmutableList.of(scan));
                } else {
                    RelDataType rowType = TypeConverter.getType(this.cluster, rr, null);
                    String fullyQualifiedTabName = tabMetaData.getDbName();
                    fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + tabMetaData.getTableName() : tabMetaData.getTableName();
                    RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, CalcitePlanner.this.noColsMissingStats);
                    tableRel = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()));
                }
                ImmutableMap<String, Integer> hiveToCalciteColMap = this.buildHiveToCalciteColumnMap(rr, tableRel);
                this.relToHiveRR.put(tableRel, rr);
                this.relToHiveColNameCalcitePosMap.put(tableRel, hiveToCalciteColMap);
            }
            catch (Exception e) {
                if (e instanceof SemanticException) {
                    throw (SemanticException)e;
                }
                throw new RuntimeException(e);
            }
            return tableRel;
        }

        private TableType obtainTableType(Table tabMetaData) {
            if (tabMetaData.getStorageHandler() != null && tabMetaData.getStorageHandler().toString().equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                return TableType.DRUID;
            }
            return TableType.NATIVE;
        }

        private RelNode genFilterRelNode(ASTNode filterExpr, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean useCaching) throws SemanticException {
            ExprNodeDesc filterCondn = CalcitePlanner.this.genExprNodeDesc(filterExpr, this.relToHiveRR.get(srcRel), outerRR, null, useCaching);
            if (filterCondn instanceof ExprNodeConstantDesc && !filterCondn.getTypeString().equals("boolean")) {
                throw new CalciteSemanticException("Filter expression with non-boolean return type.", CalciteSemanticException.UnsupportedFeature.Filter_expression_with_non_boolean_return_type);
            }
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNode convertedFilterExpr = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel), outerRR, 0, true, this.subqueryId).convert(filterCondn);
            RexNode factoredFilterExpr = RexUtil.pullFactors(this.cluster.getRexBuilder(), convertedFilterExpr);
            HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, factoredFilterExpr);
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            return filterRel;
        }

        private boolean topLevelConjunctCheck(ASTNode searchCond, ObjectPair<Boolean, Integer> subqInfo) {
            if (searchCond.getType() == 202) {
                subqInfo.setFirst(Boolean.TRUE);
                if (subqInfo.getSecond() > 1) {
                    return false;
                }
            }
            if (searchCond.getType() == 942) {
                subqInfo.setSecond(subqInfo.getSecond() + 1);
                return subqInfo.getSecond() <= 1 || subqInfo.getFirst() == false;
            }
            for (int i = 0; i < searchCond.getChildCount(); ++i) {
                boolean validSubQuery = this.topLevelConjunctCheck((ASTNode)searchCond.getChild(i), subqInfo);
                if (validSubQuery) continue;
                return false;
            }
            return true;
        }

        private void subqueryRestrictionCheck(QB qb, ASTNode searchCond, RelNode srcRel, boolean forHavingClause, Set<ASTNode> corrScalarQueries) throws SemanticException {
            List<ASTNode> subQueriesInOriginalTree = SubQueryUtils.findSubQueries(searchCond);
            ASTNode clonedSearchCond = (ASTNode)SubQueryUtils.adaptor.dupTree((Object)searchCond);
            List<ASTNode> subQueries = SubQueryUtils.findSubQueries(clonedSearchCond);
            for (int i = 0; i < subQueriesInOriginalTree.size(); ++i) {
                String havingInputAlias;
                RowResolver inputRR;
                int sqIdx = qb.incrNumSubQueryPredicates();
                ASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
                ASTNode subQueryAST = subQueries.get(i);
                Boolean orInSubquery = new Boolean(false);
                Integer subqueryCount = new Integer(0);
                ObjectPair<Boolean, Integer> subqInfo = new ObjectPair<Boolean, Integer>(false, 0);
                if (!this.topLevelConjunctCheck(clonedSearchCond, subqInfo)) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(subQueryAST, "Only SubQuery expressions that are top level conjuncts are allowed"));
                }
                ASTNode outerQueryExpr = (ASTNode)subQueryAST.getChild(2);
                if (outerQueryExpr != null && outerQueryExpr.getType() == 942) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(outerQueryExpr, "IN/NOT IN subqueries are not allowed in LHS"));
                }
                QBSubQuery subQuery = SubQueryUtils.buildSubQuery(qb.getId(), sqIdx, subQueryAST, originalSubQueryAST, CalcitePlanner.this.ctx);
                boolean isCorrScalarWithAgg = subQuery.subqueryRestrictionsCheck(inputRR = this.relToHiveRR.get(srcRel), forHavingClause, havingInputAlias = null);
                if (!isCorrScalarWithAgg) continue;
                corrScalarQueries.add(originalSubQueryAST);
            }
        }

        private boolean genSubQueryRelNode(QB qb, ASTNode node, RelNode srcRel, boolean forHavingClause, Map<ASTNode, RelNode> subQueryToRelNode) throws SemanticException {
            HashSet<ASTNode> corrScalarQueriesWithAgg = new HashSet<ASTNode>();
            this.subqueryRestrictionCheck(qb, node, srcRel, forHavingClause, corrScalarQueriesWithAgg);
            ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
            stack.push(node);
            boolean isSubQuery = false;
            block3: while (!stack.isEmpty()) {
                ASTNode next = (ASTNode)stack.pop();
                switch (next.getType()) {
                    case 942: {
                        if (((ArrayList)next.getChildren()).size() == 3 && next.getChild(2).getType() == 942) {
                            throw new CalciteSemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(next.getChild(2), "SubQuery in LHS expressions are not supported."));
                        }
                        String sbQueryAlias = "sq_" + qb.incrNumSubQueryPredicates();
                        QB qbSQ = new QB(qb.getId(), sbQueryAlias, true);
                        SemanticAnalyzer.Phase1Ctx ctx1 = CalcitePlanner.this.initPhase1Ctx();
                        CalcitePlanner.this.doPhase1((ASTNode)next.getChild(1), qbSQ, ctx1, null);
                        CalcitePlanner.this.getMetaData(qbSQ);
                        RelNode subQueryRelNode = this.genLogicalPlan(qbSQ, false, this.relToHiveColNameCalcitePosMap.get(srcRel), this.relToHiveRR.get(srcRel));
                        subQueryToRelNode.put(next, subQueryRelNode);
                        if (corrScalarQueriesWithAgg.contains(next)) {
                            this.corrScalarRexSQWithAgg.add(subQueryRelNode);
                        }
                        isSubQuery = true;
                        continue block3;
                    }
                }
                int childCount = next.getChildCount();
                for (int i = childCount - 1; i >= 0; --i) {
                    stack.push((ASTNode)next.getChild(i));
                }
            }
            return isSubQuery;
        }

        private RelNode genFilterRelNode(QB qb, ASTNode searchCond, RelNode srcRel, Map<String, RelNode> aliasToRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            HashMap<ASTNode, RelNode> subQueryToRelNode = new HashMap<ASTNode, RelNode>();
            boolean isSubQuery = this.genSubQueryRelNode(qb, searchCond, srcRel, forHavingClause, subQueryToRelNode);
            if (isSubQuery) {
                ExprNodeDesc subQueryExpr = CalcitePlanner.this.genExprNodeDesc(searchCond, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, forHavingClause);
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                RexNode convertedFilterLHS = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel), outerRR, 0, true, this.subqueryId).convert(subQueryExpr);
                HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, convertedFilterLHS);
                this.relToHiveColNameCalcitePosMap.put(filterRel, this.relToHiveColNameCalcitePosMap.get(srcRel));
                this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
                ++this.subqueryId;
                return filterRel;
            }
            return this.genFilterRelNode(searchCond, srcRel, outerNameToPosMap, outerRR, forHavingClause);
        }

        private RelNode projectLeftOuterSide(RelNode srcRel, int numColumns) throws SemanticException {
            RowResolver iRR = this.relToHiveRR.get(srcRel);
            RowResolver oRR = new RowResolver();
            RowResolver.add(oRR, iRR, numColumns);
            ArrayList<RexInputRef> calciteColLst = new ArrayList<RexInputRef>();
            ArrayList<String> oFieldNames = new ArrayList<String>();
            RelDataType iType = srcRel.getRowType();
            for (int i = 0; i < iType.getFieldCount(); ++i) {
                RelDataTypeField fType = iType.getFieldList().get(i);
                String fName = iType.getFieldNames().get(i);
                calciteColLst.add(this.cluster.getRexBuilder().makeInputRef(fType.getType(), i));
                oFieldNames.add(fName);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, oFieldNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(oRR, selRel));
            this.relToHiveRR.put(selRel, oRR);
            return selRel;
        }

        private RelNode genFilterLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            RelNode filterRel = null;
            Iterator<ASTNode> whereClauseIterator = this.getQBParseInfo(qb).getDestToWhereExpr().values().iterator();
            if (whereClauseIterator.hasNext()) {
                filterRel = this.genFilterRelNode(qb, (ASTNode)whereClauseIterator.next().getChild(0), srcRel, aliasToRel, outerNameToPosMap, outerRR, forHavingClause);
            }
            return filterRel;
        }

        private AggregateCall convertGBAgg(AggInfo agg, RelNode input, List<RexNode> gbChildProjLst, RexNodeConverter converter, HashMap<String, Integer> rexNodeToPosMap, Integer childProjLstIndx) throws SemanticException {
            RelDataType aggFnRetType = TypeConverter.convert(agg.m_returnType, this.cluster.getTypeFactory());
            ArrayList<Integer> argList = new ArrayList<Integer>();
            RexNode rexNd = null;
            RelDataTypeFactory dtFactory = this.cluster.getTypeFactory();
            ImmutableList.Builder aggArgRelDTBldr = new ImmutableList.Builder();
            for (ExprNodeDesc expr : agg.m_aggParams) {
                rexNd = converter.convert(expr);
                Integer inputIndx = rexNodeToPosMap.get(rexNd.toString());
                if (inputIndx == null) {
                    gbChildProjLst.add(rexNd);
                    rexNodeToPosMap.put(rexNd.toString(), childProjLstIndx);
                    inputIndx = childProjLstIndx;
                    Integer n = childProjLstIndx;
                    Integer n2 = childProjLstIndx = Integer.valueOf(childProjLstIndx + 1);
                }
                argList.add(inputIndx);
                aggArgRelDTBldr.add(TypeConverter.convert(expr.getTypeInfo(), dtFactory));
            }
            SqlAggFunction aggregation = SqlFunctionConverter.getCalciteAggFn(agg.m_udfName, agg.m_distinct, (ImmutableList<RelDataType>)aggArgRelDTBldr.build(), aggFnRetType);
            return new AggregateCall(aggregation, agg.m_distinct, argList, aggFnRetType, null);
        }

        private RelNode genGBRelNode(List<ExprNodeDesc> gbExprs, List<AggInfo> aggInfoLst, List<Integer> groupSets, RelNode srcRel) throws SemanticException {
            Object object;
            ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
            boolean hasGroupSets = groupSets != null && !groupSets.isEmpty();
            ArrayList<RexNode> gbChildProjLst = Lists.newArrayList();
            HashMap<String, Integer> rexNodeToPosMap = new HashMap<String, Integer>();
            ArrayList<Integer> groupSetPositions = Lists.newArrayList();
            Integer gbIndx = 0;
            for (ExprNodeDesc key : gbExprs) {
                RexNode rnd = converter.convert(key);
                gbChildProjLst.add(rnd);
                groupSetPositions.add(gbIndx);
                rexNodeToPosMap.put(rnd.toString(), gbIndx);
                Integer n = gbIndx;
                gbIndx = gbIndx + 1;
                object = gbIndx;
            }
            ImmutableBitSet groupSet = ImmutableBitSet.of(groupSetPositions);
            ArrayList<ImmutableBitSet> transformedGroupSets = null;
            if (hasGroupSets) {
                HashSet<ImmutableBitSet> setTransformedGroupSets = new HashSet<ImmutableBitSet>(groupSets.size());
                object = groupSets.iterator();
                while (object.hasNext()) {
                    int val = (Integer)object.next();
                    setTransformedGroupSets.add(this.convert(val, groupSet.cardinality()));
                }
                transformedGroupSets = new ArrayList<ImmutableBitSet>(setTransformedGroupSets);
                Collections.sort(transformedGroupSets, ImmutableBitSet.COMPARATOR);
            }
            ArrayList<AggregateCall> aggregateCalls = Lists.newArrayList();
            for (AggInfo agg : aggInfoLst) {
                aggregateCalls.add(this.convertGBAgg(agg, srcRel, gbChildProjLst, converter, rexNodeToPosMap, gbChildProjLst.size()));
            }
            if (hasGroupSets) {
                AggregateCall aggCall = new AggregateCall(HiveGroupingID.INSTANCE, false, (List<Integer>)((Object)new ImmutableList.Builder().build()), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), HiveGroupingID.INSTANCE.getName());
                aggregateCalls.add(aggCall);
            }
            if (gbChildProjLst.isEmpty()) {
                gbChildProjLst.add(this.cluster.getRexBuilder().makeInputRef(srcRel, 0));
            }
            HiveProject gbInputRel = HiveProject.create(srcRel, gbChildProjLst, null);
            HiveAggregate aggregateRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), gbInputRel, transformedGroupSets != null, groupSet, transformedGroupSets, aggregateCalls);
            return aggregateRel;
        }

        private ImmutableBitSet convert(int value, int length) {
            BitSet bits = new BitSet();
            for (int index = length - 1; index >= 0; --index) {
                if (value % 2 != 0) {
                    bits.set(index);
                }
                value >>>= 1;
            }
            bits.flip(0, length);
            return ImmutableBitSet.FROM_BIT_SET.apply(bits);
        }

        private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, RowResolver gByInputRR, RowResolver gByRR) {
            if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 973) {
                String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
                gByRR.put(tab_alias, col_alias, colInfo);
            } else if (gByExpr.getType() == 973) {
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
                String tab_alias = null;
                try {
                    ColumnInfo pColInfo = gByInputRR.get(tab_alias, col_alias);
                    tab_alias = pColInfo == null ? null : pColInfo.getTabAlias();
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                gByRR.put(tab_alias, col_alias, colInfo);
            }
        }

        private void addToGBExpr(RowResolver groupByOutputRowResolver, RowResolver groupByInputRowResolver, ASTNode grpbyExpr, ExprNodeDesc grpbyExprNDesc, List<ExprNodeDesc> gbExprNDescLst, List<String> outputColumnNames) {
            int i = gbExprNDescLst.size();
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            gbExprNDescLst.add(grpbyExprNDesc);
            ColumnInfo oColInfo = new ColumnInfo(field, grpbyExprNDesc.getTypeInfo(), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, groupByInputRowResolver, groupByOutputRowResolver);
        }

        private AggInfo getHiveAggInfo(ASTNode aggAst, int aggFnLstArgIndx, RowResolver inputRR) throws SemanticException {
            AggInfo aInfo = null;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i <= aggFnLstArgIndx; ++i) {
                ASTNode paraExpr = (ASTNode)aggAst.getChild(i);
                ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, inputRR);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = aggAst.getType() == 764;
            TypeInfo udafRetType = null;
            String aggName = SemanticAnalyzer.unescapeIdentifier(aggAst.getChild(0).getText());
            if (FunctionRegistry.isRankingFunction(aggName)) {
                udafRetType = aggName.equalsIgnoreCase("percent_rank") ? TypeInfoFactory.doubleTypeInfo : TypeInfoFactory.intTypeInfo;
            } else {
                try {
                    boolean isAllColumns = aggAst.getType() == 765;
                    GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                    GenericUDAFEvaluator genericUDAFEvaluator = null;
                    if (aggName.toLowerCase().equals("lead") || aggName.toLowerCase().equals("lag")) {
                        ArrayList<ObjectInspector> originalParameterTypeInfos = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
                        genericUDAFEvaluator = FunctionRegistry.getGenericWindowingEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = ((ListTypeInfo)udaf.returnType).getListElementTypeInfo();
                    } else {
                        genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, aggAst, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = FunctionRegistry.pivotResult(aggName) ? ((ListTypeInfo)udaf.returnType).getListElementTypeInfo() : udaf.returnType;
                    }
                }
                catch (Exception e) {
                    CalcitePlanner.this.LOG.debug("CBO: Couldn't Obtain UDAF evaluators for " + aggName + ", trying to translate to GenericUDF");
                }
                if (udafRetType == null) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    tcCtx.setAllowDistinctFunctions(false);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc((ASTNode)aggAst.getChild(0), inputRR, tcCtx);
                    udafRetType = exp.getTypeInfo();
                }
            }
            aInfo = new AggInfo(aggParameters, udafRetType, aggName, isDistinct);
            return aInfo;
        }

        private RelNode genGBLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            boolean cubeRollupGrpSetPresent;
            ASTNode node;
            RelNode gbRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String detsClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qb.getParseInfo().getSelForClause(detsClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            if (selExprList.getToken().getType() == 900 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 651) {
                srcRel = this.genSelectLogicalPlan(qb, srcRel, srcRel, null, null);
                RowResolver rr = this.relToHiveRR.get(srcRel);
                qbp.setSelExprForClause(detsClauseName, SemanticAnalyzer.genSelectDIAST(rr));
            }
            if (selExprList.getToken().getType() == 900 && !qb.getAllWindowingSpecs().isEmpty()) {
                return null;
            }
            List<ASTNode> grpByAstExprs = CalcitePlanner.this.getGroupByForClause(qbp, detsClauseName);
            HashMap<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(detsClauseName);
            boolean hasGrpByAstExprs = grpByAstExprs != null && !grpByAstExprs.isEmpty();
            boolean hasAggregationTrees = aggregationTrees != null && !aggregationTrees.isEmpty();
            boolean bl = cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(detsClauseName).size() > 1) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
            }
            if (cubeRollupGrpSetPresent) {
                if (!HiveConf.getBoolVar(CalcitePlanner.this.conf, HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE)) {
                    throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    CalcitePlanner.this.checkExpressionsForGroupingSet(grpByAstExprs, qb.getParseInfo().getDistinctFuncExprsForClause(detsClauseName), aggregationTrees, this.relToHiveRR.get(srcRel));
                    if (qbp.getDestGroupingSets().size() > CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY)) {
                        String errorMsg = "The number of rows per input row due to grouping sets is " + qbp.getDestGroupingSets().size();
                        throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
                    }
                }
            }
            if (hasGrpByAstExprs || hasAggregationTrees) {
                Object field;
                ArrayList<ExprNodeDesc> gbExprNDescLst = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputColumnNames = new ArrayList<String>();
                RowResolver groupByInputRowResolver = this.relToHiveRR.get(srcRel);
                RowResolver groupByOutputRowResolver = new RowResolver();
                groupByOutputRowResolver.setIsExprResolver(true);
                if (hasGrpByAstExprs) {
                    for (int i = 0; i < grpByAstExprs.size(); ++i) {
                        ASTNode grpbyExpr = grpByAstExprs.get(i);
                        Map<ASTNode, ExprNodeDesc> astToExprNDescMap = CalcitePlanner.this.genAllExprNodeDesc(grpbyExpr, groupByInputRowResolver);
                        ExprNodeDesc grpbyExprNDesc = astToExprNDescMap.get(grpbyExpr);
                        if (grpbyExprNDesc == null) {
                            throw new CalciteSemanticException("Invalid Column Reference: " + grpbyExpr.dump(), CalciteSemanticException.UnsupportedFeature.Invalid_column_reference);
                        }
                        this.addToGBExpr(groupByOutputRowResolver, groupByInputRowResolver, grpbyExpr, grpbyExprNDesc, gbExprNDescLst, outputColumnNames);
                    }
                }
                int groupingColsSize = gbExprNDescLst.size();
                List<Integer> groupingSets = null;
                if (cubeRollupGrpSetPresent) {
                    if (qbp.getDestRollups().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSetsForRollup(grpByAstExprs.size());
                    } else if (qbp.getDestCubes().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSetsForCube(grpByAstExprs.size());
                    } else if (qbp.getDestGroupingSets().contains(detsClauseName)) {
                        groupingSets = CalcitePlanner.this.getGroupingSets(grpByAstExprs, qbp, detsClauseName);
                    }
                    int limit = groupingColsSize * 2;
                    while (groupingColsSize < limit) {
                        field = SemanticAnalyzer.getColumnInternalName(groupingColsSize);
                        outputColumnNames.add((String)field);
                        groupByOutputRowResolver.put(null, (String)field, new ColumnInfo((String)field, TypeInfoFactory.booleanTypeInfo, null, false));
                        ++groupingColsSize;
                    }
                }
                ArrayList<AggInfo> aggregations = new ArrayList<AggInfo>();
                if (hasAggregationTrees) {
                    assert (aggregationTrees != null);
                    for (ASTNode value : aggregationTrees.values()) {
                        String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
                        boolean isDistinct = value.getType() == 764;
                        boolean isAllColumns = value.getType() == 765;
                        ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
                        for (int i = 1; i < value.getChildCount(); ++i) {
                            ASTNode paraExpr = (ASTNode)value.getChild(i);
                            ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                            aggParameters.add(paraExprNode);
                        }
                        GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                        GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        AggInfo aInfo = new AggInfo(aggParameters, udaf.returnType, aggName, isDistinct);
                        aggregations.add(aInfo);
                        String field2 = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size() - 1);
                        outputColumnNames.add(field2);
                        groupByOutputRowResolver.putExpression(value, new ColumnInfo(field2, aInfo.m_returnType, "", false));
                    }
                }
                if (groupingSets != null && !groupingSets.isEmpty()) {
                    field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size());
                    outputColumnNames.add((String)field);
                    groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo((String)field, TypeInfoFactory.intTypeInfo, null, true));
                }
                gbRel = this.genGBRelNode(gbExprNDescLst, aggregations, groupingSets, srcRel);
                this.relToHiveColNameCalcitePosMap.put(gbRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver, gbRel));
                this.relToHiveRR.put(gbRel, groupByOutputRowResolver);
            }
            return gbRel;
        }

        /*
         * WARNING - void declaration
         */
        private Pair<RelNode, RelNode> genOBLogicalPlan(QB qb, RelNode srcRel, boolean outermostOB) throws SemanticException {
            String dest;
            HiveSortLimit sortRel = null;
            RelNode originalOBChild = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode obAST = qbp.getOrderByForClause(dest = qbp.getClauseNames().iterator().next());
            if (obAST != null) {
                String error;
                Integer limit = qb.getParseInfo().getDestLimit(dest);
                if (limit == null && (error = HiveConf.StrictChecks.checkNoLimit(CalcitePlanner.this.conf)) != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, error));
                }
                ArrayList<RexNode> newVCLst = new ArrayList<RexNode>();
                ArrayList<RelFieldCollation> fieldCollations = Lists.newArrayList();
                int fieldIndex = 0;
                List obASTExprLst = obAST.getChildren();
                ArrayList<Pair<ASTNode, TypeInfo>> vcASTTypePairs = new ArrayList<Pair<ASTNode, TypeInfo>>();
                RowResolver inputRR = this.relToHiveRR.get(srcRel);
                RowResolver outputRR = new RowResolver();
                RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), this.relToHiveColNameCalcitePosMap.get(srcRel), 0, false);
                int srcRelRecordSz = srcRel.getRowType().getFieldCount();
                for (int i = 0; i < obASTExprLst.size(); ++i) {
                    void var27_30;
                    ASTNode obASTExpr = (ASTNode)obASTExprLst.get(i);
                    ASTNode nullObASTExpr = (ASTNode)obASTExpr.getChild(0);
                    ASTNode ref = (ASTNode)nullObASTExpr.getChild(0);
                    Map<ASTNode, ExprNodeDesc> astToExprNDescMap = CalcitePlanner.this.genAllExprNodeDesc(ref, inputRR);
                    ExprNodeDesc obExprNDesc = astToExprNDescMap.get(ref);
                    if (obExprNDesc == null) {
                        throw new SemanticException("Invalid order by expression: " + obASTExpr.toString());
                    }
                    RexNode rnd = converter.convert(obExprNDesc);
                    if (rnd instanceof RexInputRef) {
                        fieldIndex = ((RexInputRef)rnd).getIndex();
                    } else {
                        fieldIndex = srcRelRecordSz + newVCLst.size();
                        newVCLst.add(rnd);
                        vcASTTypePairs.add(new Pair<ASTNode, TypeInfo>(ref, obExprNDesc.getTypeInfo()));
                    }
                    RelFieldCollation.Direction order = RelFieldCollation.Direction.DESCENDING;
                    if (obASTExpr.getType() == 978) {
                        order = RelFieldCollation.Direction.ASCENDING;
                    }
                    if (nullObASTExpr.getType() == 826) {
                        RelFieldCollation.NullDirection nullDirection = RelFieldCollation.NullDirection.FIRST;
                    } else if (nullObASTExpr.getType() == 827) {
                        RelFieldCollation.NullDirection nullDirection = RelFieldCollation.NullDirection.LAST;
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + nullObASTExpr.getType());
                    }
                    fieldCollations.add(new RelFieldCollation(fieldIndex, order, (RelFieldCollation.NullDirection)var27_30));
                }
                RelNode obInputRel = srcRel;
                if (!newVCLst.isEmpty()) {
                    List<RexNode> originalInputRefs = Lists.transform(srcRel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

                        @Override
                        public RexNode apply(RelDataTypeField input) {
                            return new RexInputRef(input.getIndex(), input.getType());
                        }
                    });
                    RowResolver obSyntheticProjectRR = new RowResolver();
                    if (!RowResolver.add(obSyntheticProjectRR, inputRR)) {
                        throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                    int vcolPos = inputRR.getRowSchema().getSignature().size();
                    for (Pair pair : vcASTTypePairs) {
                        obSyntheticProjectRR.putExpression((ASTNode)pair.getKey(), new ColumnInfo(SemanticAnalyzer.getColumnInternalName(vcolPos), (TypeInfo)pair.getValue(), null, false));
                        ++vcolPos;
                    }
                    obInputRel = this.genSelectRelNode(CompositeList.of(originalInputRefs, newVCLst), obSyntheticProjectRR, srcRel);
                    if (outermostOB) {
                        if (!RowResolver.add(outputRR, inputRR)) {
                            throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                    } else {
                        if (!RowResolver.add(outputRR, obSyntheticProjectRR)) {
                            throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                        originalOBChild = srcRel;
                    }
                } else if (!RowResolver.add(outputRR, inputRR)) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = traitSet.canonize(RelCollationImpl.of(fieldCollations));
                sortRel = new HiveSortLimit(this.cluster, traitSet, obInputRel, canonizedCollation, null, null);
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return new Pair<Object, Object>(sortRel, originalOBChild);
        }

        private RelNode genLimitLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            Integer fetch;
            HiveSortLimit sortRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            AbstractMap.SimpleEntry<Integer, Integer> entry = qbp.getDestToLimit().get(qbp.getClauseNames().iterator().next());
            Integer offset = entry == null ? 0 : entry.getKey();
            Integer n = fetch = entry == null ? null : entry.getValue();
            if (fetch != null) {
                RexLiteral offsetRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset.intValue()));
                RexLiteral fetchRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(fetch.intValue()));
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = traitSet.canonize(RelCollations.EMPTY);
                sortRel = new HiveSortLimit(this.cluster, traitSet, srcRel, canonizedCollation, offsetRN, fetchRN);
                RowResolver outputRR = new RowResolver();
                if (!RowResolver.add(outputRR, this.relToHiveRR.get(srcRel))) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return sortRel;
        }

        private List<RexNode> getPartitionKeys(PTFInvocationSpec.PartitionSpec ps, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexNode> pKeys = new ArrayList<RexNode>();
            if (ps != null) {
                ArrayList<PTFInvocationSpec.PartitionExpression> pExprs = ps.getExpressions();
                for (PTFInvocationSpec.PartitionExpression pExpr : pExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(pExpr.getExpression(), inputRR, tcCtx);
                    pKeys.add(converter.convert(exp));
                }
            }
            return pKeys;
        }

        private List<RexFieldCollation> getOrderKeys(PTFInvocationSpec.OrderSpec os, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexFieldCollation> oKeys = new ArrayList<RexFieldCollation>();
            if (os != null) {
                ArrayList<PTFInvocationSpec.OrderExpression> oExprs = os.getExpressions();
                for (PTFInvocationSpec.OrderExpression oExpr : oExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(oExpr.getExpression(), inputRR, tcCtx);
                    RexNode ordExp = converter.convert(exp);
                    HashSet<SqlKind> flags = new HashSet<SqlKind>();
                    if (oExpr.getOrder() == PTFInvocationSpec.Order.DESC) {
                        flags.add(SqlKind.DESCENDING);
                    }
                    if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST) {
                        flags.add(SqlKind.NULLS_FIRST);
                    } else if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_LAST) {
                        flags.add(SqlKind.NULLS_LAST);
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + (Object)((Object)oExpr.getNullOrder()));
                    }
                    oKeys.add(new RexFieldCollation(ordExp, (Set<SqlKind>)flags));
                }
            }
            return oKeys;
        }

        private RexWindowBound getBound(WindowingSpec.BoundarySpec bs, RexNodeConverter converter) {
            RexWindowBound rwb = null;
            if (bs != null) {
                SqlParserPos pos = new SqlParserPos(1, 1);
                SqlNumericLiteral amt = bs.getAmt() == 0 ? null : SqlLiteral.createExactNumeric(String.valueOf(bs.getAmt()), new SqlParserPos(2, 2));
                RexNode amtLiteral = null;
                SqlCall sc = null;
                if (amt != null) {
                    amtLiteral = this.cluster.getRexBuilder().makeLiteral((Object)new Integer(bs.getAmt()), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), true);
                }
                switch (bs.getDirection()) {
                    case PRECEDING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create(SqlWindow.createUnboundedPreceding(pos), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createPreceding(amt, pos);
                        rwb = RexWindowBound.create(sc, this.cluster.getRexBuilder().makeCall(sc.getOperator(), amtLiteral));
                        break;
                    }
                    case CURRENT: {
                        rwb = RexWindowBound.create(SqlWindow.createCurrentRow(new SqlParserPos(1, 1)), null);
                        break;
                    }
                    case FOLLOWING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create(SqlWindow.createUnboundedFollowing(new SqlParserPos(1, 1)), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createFollowing(amt, pos);
                        rwb = RexWindowBound.create(sc, this.cluster.getRexBuilder().makeCall(sc.getOperator(), amtLiteral));
                    }
                }
            }
            return rwb;
        }

        private int getWindowSpecIndx(ASTNode wndAST) {
            int wi = wndAST.getChildCount() - 1;
            if (wi <= 0 || wndAST.getChild(wi).getType() != 1016) {
                wi = -1;
            }
            return wi;
        }

        private Pair<RexNode, TypeInfo> genWindowingProj(QB qb, WindowingSpec.WindowExpressionSpec wExpSpec, RelNode srcRel) throws SemanticException {
            ImmutableList.Builder calciteAggFnArgsTypeBldr;
            ImmutableList.Builder calciteAggFnArgsBldr;
            RexNodeConverter converter;
            RelDataType calciteAggFnRetType;
            AggInfo hiveAggInfo;
            RexNode w = null;
            TypeInfo wHiveRetType = null;
            if (wExpSpec instanceof WindowingSpec.WindowFunctionSpec) {
                WindowingSpec.WindowFunctionSpec wFnSpec = (WindowingSpec.WindowFunctionSpec)wExpSpec;
                ASTNode windowProjAst = wFnSpec.getExpression();
                int wndSpecASTIndx = this.getWindowSpecIndx(windowProjAst);
                hiveAggInfo = this.getHiveAggInfo(windowProjAst, wndSpecASTIndx - 1, this.relToHiveRR.get(srcRel));
                wHiveRetType = hiveAggInfo.m_returnType;
                calciteAggFnRetType = TypeConverter.convert(hiveAggInfo.m_returnType, this.cluster.getTypeFactory());
                ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
                calciteAggFnArgsBldr = ImmutableList.builder();
                calciteAggFnArgsTypeBldr = ImmutableList.builder();
                for (int i = 0; i < hiveAggInfo.m_aggParams.size(); ++i) {
                    calciteAggFnArgsBldr.add(converter.convert((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)));
                    calciteAggFnArgsTypeBldr.add(TypeConverter.convert(((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)).getTypeInfo(), this.cluster.getTypeFactory()));
                }
            } else {
                throw new RuntimeException("Unsupported window Spec");
            }
            ImmutableCollection calciteAggFnArgs = calciteAggFnArgsBldr.build();
            ImmutableCollection calciteAggFnArgsType = calciteAggFnArgsTypeBldr.build();
            SqlAggFunction calciteAggFn = SqlFunctionConverter.getCalciteAggFn(hiveAggInfo.m_udfName, hiveAggInfo.m_distinct, (ImmutableList<RelDataType>)calciteAggFnArgsType, calciteAggFnRetType);
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            WindowingSpec.WindowSpec wndSpec = ((WindowingSpec.WindowFunctionSpec)wExpSpec).getWindowSpec();
            List<RexNode> partitionKeys = this.getPartitionKeys(wndSpec.getPartition(), converter, inputRR);
            List<RexFieldCollation> orderKeys = this.getOrderKeys(wndSpec.getOrder(), converter, inputRR);
            RexWindowBound upperBound = this.getBound(wndSpec.getWindowFrame().getStart(), converter);
            RexWindowBound lowerBound = this.getBound(wndSpec.getWindowFrame().getEnd(), converter);
            boolean isRows = wndSpec.getWindowFrame().getWindowType() == WindowingSpec.WindowType.ROWS;
            w = this.cluster.getRexBuilder().makeOver(calciteAggFnRetType, calciteAggFn, (List<RexNode>)((Object)calciteAggFnArgs), partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, isRows, true, false);
            return new Pair<RexNode, TypeInfo>(w, wHiveRetType);
        }

        private RelNode genSelectForWindowing(QB qb, RelNode srcRel, HashSet<ColumnInfo> newColumns) throws SemanticException {
            WindowingSpec wSpec;
            this.getQBParseInfo(qb);
            WindowingSpec windowingSpec = wSpec = !qb.getAllWindowingSpecs().isEmpty() ? qb.getAllWindowingSpecs().values().iterator().next() : null;
            if (wSpec == null) {
                return null;
            }
            wSpec.validateAndMakeEffective();
            ArrayList<WindowingSpec.WindowExpressionSpec> windowExpressions = wSpec.getWindowExpressions();
            if (windowExpressions == null || windowExpressions.isEmpty()) {
                return null;
            }
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            ArrayList<RexNode> projsForWindowSelOp = new ArrayList<RexNode>(HiveCalciteUtil.getProjsFromBelowAsInputRef(srcRel));
            RowResolver out_rwsch = new RowResolver();
            if (!RowResolver.add(out_rwsch, inputRR)) {
                CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
            }
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            for (WindowingSpec.WindowExpressionSpec wExprSpec : windowExpressions) {
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    wExprSpec.setExpression(SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), wExprSpec.getExpression(), !cubeRollupGrpSetPresent));
                }
                if (out_rwsch.getExpression(wExprSpec.getExpression()) != null) continue;
                Pair<RexNode, TypeInfo> wtp = this.genWindowingProj(qb, wExprSpec, srcRel);
                projsForWindowSelOp.add(wtp.getKey());
                ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(projsForWindowSelOp.size()), wtp.getValue(), null, false);
                out_rwsch.putExpression(wExprSpec.getExpression(), oColInfo);
                newColumns.add(oColInfo);
            }
            return this.genSelectRelNode(projsForWindowSelOp, out_rwsch, srcRel, windowExpressions);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel) throws CalciteSemanticException {
            return this.genSelectRelNode(calciteColLst, out_rwsch, srcRel, null);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel, List<WindowingSpec.WindowExpressionSpec> windowExpressions) throws CalciteSemanticException {
            HashSet<String> colNamesSet = new HashSet<String>();
            ArrayList<ColumnInfo> cInfoLst = out_rwsch.getRowSchema().getSignature();
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> windowToAlias = null;
            if (windowExpressions != null) {
                windowToAlias = new HashMap<String, String>();
                for (WindowingSpec.WindowExpressionSpec wes : windowExpressions) {
                    windowToAlias.put(wes.getExpression().toStringTree().toLowerCase(), wes.getAlias());
                }
            }
            for (int i = 0; i < calciteColLst.size(); ++i) {
                ColumnInfo cInfo = (ColumnInfo)cInfoLst.get(i);
                String[] qualifiedColNames = out_rwsch.reverseLookup(cInfo.getInternalName());
                String tmpColAlias = qualifiedColNames[1];
                if (tmpColAlias.contains(".") || tmpColAlias.contains(":")) {
                    tmpColAlias = cInfo.getInternalName();
                }
                if (tmpColAlias.startsWith("_c")) {
                    tmpColAlias = "_o_" + tmpColAlias;
                } else if (windowToAlias != null && windowToAlias.containsKey(tmpColAlias)) {
                    tmpColAlias = (String)windowToAlias.get(tmpColAlias);
                }
                int suffix = 1;
                while (colNamesSet.contains(tmpColAlias)) {
                    tmpColAlias = qualifiedColNames[1] + suffix;
                    ++suffix;
                }
                colNamesSet.add(tmpColAlias);
                columnNames.add(tmpColAlias);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, columnNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(out_rwsch, selRel));
            this.relToHiveRR.put(selRel, out_rwsch);
            return selRel;
        }

        private RelNode genSelectLogicalPlan(QB qb, RelNode srcRel, RelNode starSrcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            int startPosn;
            String funcName;
            FunctionInfo fi;
            boolean isInTransform;
            boolean hintPresent;
            RowResolver inputRR;
            HashSet<ColumnInfo> excludedColumns = new HashSet<ColumnInfo>();
            RelNode selForWindow = this.genSelectForWindowing(qb, srcRel, excludedColumns);
            srcRel = selForWindow == null ? srcRel : selForWindow;
            ArrayList<ExprNodeDesc> col_list = new ArrayList<ExprNodeDesc>();
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qbp.getSelForClause(selClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            RowResolver out_rwsch = new RowResolver();
            Integer pos = 0;
            RowResolver starRR = inputRR = this.relToHiveRR.get(srcRel);
            if (starSrcRel != null) {
                starRR = this.relToHiveRR.get(starSrcRel);
            }
            boolean selectStar = false;
            int posn = 0;
            boolean bl = hintPresent = selExprList.getChild(0).getType() == 343;
            if (hintPresent) {
                ++posn;
            }
            boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 988;
            if (isInTransform) {
                String msg = String.format("SELECT TRANSFORM is currently not supported in CBO, turn off cbo to use TRANSFORM.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_transform);
            }
            String udtfTableAlias = null;
            GenericUDTF genericUDTF = null;
            String genericUDTFName = null;
            ArrayList<String> udtfColAliases = new ArrayList<String>();
            ASTNode expr = (ASTNode)selExprList.getChild(posn).getChild(0);
            int exprType = expr.getType();
            if ((exprType == 763 || exprType == 765) && (fi = FunctionRegistry.getFunctionInfo(funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(expr, true))) != null && fi.getGenericUDTF() != null) {
                CalcitePlanner.this.LOG.debug("Find UDTF " + funcName);
                genericUDTF = fi.getGenericUDTF();
                genericUDTFName = funcName;
                if (!fi.isNative()) {
                    CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (genericUDTF != null && (selectStar = exprType == 765)) {
                    CalcitePlanner.this.genColListRegex(".*", null, (ASTNode)expr.getChild(0), col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                }
            }
            if (genericUDTF != null) {
                if (selExprList.getChildCount() > 1) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
                }
                ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
                block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                    ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                    switch (selExprChild.getType()) {
                        case 24: {
                            udtfColAliases.add(BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation(selExprChild);
                            continue block4;
                        }
                        case 949: {
                            assert (selExprChild.getChildCount() == 1);
                            udtfTableAlias = BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                            qb.addAlias(udtfTableAlias);
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                            continue block4;
                        }
                        default: {
                            throw new SemanticException("Find invalid token type " + selExprChild.getType() + " in UDTF.");
                        }
                    }
                }
                CalcitePlanner.this.LOG.debug("UDTF table alias is " + udtfTableAlias);
                CalcitePlanner.this.LOG.debug("UDTF col aliases are " + udtfColAliases);
            }
            ASTNode exprList = genericUDTF != null ? expr : selExprList;
            for (int i = startPosn = genericUDTF != null ? posn + 1 : posn; i < exprList.getChildCount(); ++i) {
                ExprNodeColumnDesc colExp;
                String[] altMapping;
                ExprNodeDesc exp;
                String recommended;
                String colAlias;
                String tabAlias;
                boolean hasAsClause;
                ASTNode child = (ASTNode)exprList.getChild(i);
                boolean bl3 = hasAsClause = !isInTransform && child.getChildCount() == 2;
                if (genericUDTF == null && child.getChildCount() > 2) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
                }
                if (genericUDTF != null) {
                    tabAlias = null;
                    colAlias = CalcitePlanner.this.getAutogenColAliasPrfxLbl() + i;
                    expr = child;
                } else {
                    expr = (ASTNode)child.getChild(0);
                    String[] colRef = SemanticAnalyzer.getColAlias(child, CalcitePlanner.this.getAutogenColAliasPrfxLbl(), inputRR, CalcitePlanner.this.autogenColAliasPrfxIncludeFuncName(), i);
                    tabAlias = colRef[0];
                    colAlias = colRef[1];
                    if (hasAsClause) {
                        CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                    }
                }
                HashMap<ASTNode, RelNode> subQueryToRelNode = new HashMap<ASTNode, RelNode>();
                boolean isSubQuery = this.genSubQueryRelNode(qb, expr, srcRel, false, subQueryToRelNode);
                if (isSubQuery) {
                    ExprNodeDesc subQueryExpr = CalcitePlanner.this.genExprNodeDesc(expr, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, false);
                    col_list.add(subQueryExpr);
                    ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), subQueryExpr.getWritableObjectInspector(), tabAlias, false);
                    if (out_rwsch.putWithCheck(tabAlias, colAlias, null, colInfo)) continue;
                    throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                if (expr.getType() == 651) {
                    pos = CalcitePlanner.this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    selectStar = true;
                    continue;
                }
                if (expr.getType() == 973 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    continue;
                }
                if (expr.getType() == 16 && expr.getChild(0).getType() == 973 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    continue;
                }
                if (ParseUtils.containsTokenOfType(expr, 764) && !(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Distinct without an aggregation.", CalciteSemanticException.UnsupportedFeature.Distinct_without_an_aggreggation);
                }
                TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                tcCtx.setAllowStatefulFunctions(true);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    expr = SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), expr, !cubeRollupGrpSetPresent);
                }
                if ((recommended = CalcitePlanner.this.recommendName(exp = CalcitePlanner.this.genExprNodeDesc(expr, inputRR, tcCtx), colAlias)) != null && out_rwsch.get(null, recommended) == null) {
                    colAlias = recommended;
                }
                col_list.add(exp);
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
                colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)exp).isSkewedCol() : false);
                if (!out_rwsch.putWithCheck(tabAlias, colAlias, null, colInfo)) {
                    throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                if (exp instanceof ExprNodeColumnDesc && (altMapping = inputRR.getAlternateMappings((colExp = (ExprNodeColumnDesc)exp).getColumn())) != null) {
                    out_rwsch.put(altMapping[0], altMapping[1], colInfo);
                }
                pos = pos + 1;
            }
            selectStar = selectStar && exprList.getChildCount() == posn + 1;
            ArrayList<RexNode> calciteColLst = new ArrayList<RexNode>();
            RexNodeConverter rexNodeConv = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, this.buildHiveColNameToInputPosMap(col_list, inputRR), this.relToHiveRR.get(srcRel), outerRR, 0, false, this.subqueryId);
            for (ExprNodeDesc colExpr : col_list) {
                calciteColLst.add(rexNodeConv.convert(colExpr));
            }
            RelNode outputRel = null;
            outputRel = genericUDTF != null ? this.genUDTFPlan(genericUDTF, genericUDTFName, udtfTableAlias, udtfColAliases, qb, calciteColLst, out_rwsch, srcRel) : this.genSelectRelNode(calciteColLst, out_rwsch, srcRel);
            if (selForWindow != null && selExprList.getToken().getType() == 900) {
                ImmutableBitSet groupSet = ImmutableBitSet.range(outputRel.getRowType().getFieldList().size());
                outputRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), outputRel, false, groupSet, null, new ArrayList<AggregateCall>());
                RowResolver groupByOutputRowResolver = new RowResolver();
                for (int i = 0; i < out_rwsch.getColumnInfos().size(); ++i) {
                    ColumnInfo colInfo = out_rwsch.getColumnInfos().get(i);
                    ColumnInfo newColInfo = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                    groupByOutputRowResolver.put(colInfo.getTabAlias(), colInfo.getAlias(), newColInfo);
                }
                this.relToHiveColNameCalcitePosMap.put(outputRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver, outputRel));
                this.relToHiveRR.put(outputRel, groupByOutputRowResolver);
            }
            return outputRel;
        }

        /*
         * WARNING - void declaration
         */
        private RelNode genUDTFPlan(GenericUDTF genericUDTF, String genericUDTFName, String outputTableAlias, ArrayList<String> colAliases, QB qb, List<RexNode> selectColLst, RowResolver selectRR, RelNode input) throws SemanticException {
            void var20_25;
            int numSuppliedAliases;
            QBParseInfo qbp = qb.getParseInfo();
            if (!qbp.getDestToGroupBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
            }
            if (!qbp.getDestToDistributeBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
            }
            if (!qbp.getDestToSortBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
            }
            if (!qbp.getDestToClusterBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
            }
            if (!qbp.getAliasToLateralViews().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
            }
            CalcitePlanner.this.LOG.debug("Table alias: " + outputTableAlias + " Col aliases: " + colAliases);
            ArrayList<ColumnInfo> inputCols = selectRR.getColumnInfos();
            ArrayList<String> colNames = new ArrayList<String>();
            ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
            for (int i = 0; i < inputCols.size(); ++i) {
                colNames.add(inputCols.get(i).getInternalName());
                colOIs[i] = inputCols.get(i).getObjectInspector();
            }
            StandardStructObjectInspector rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, Arrays.asList(colOIs));
            StructObjectInspector outputOI = genericUDTF.initialize(rowOI);
            int numUdtfCols = outputOI.getAllStructFieldRefs().size();
            if (colAliases.isEmpty()) {
                for (StructField structField : outputOI.getAllStructFieldRefs()) {
                    colAliases.add(structField.getFieldName());
                }
            }
            if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
                throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases but got " + numSuppliedAliases));
            }
            ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
            Iterator<String> colAliasesIter = colAliases.iterator();
            for (StructField structField : outputOI.getAllStructFieldRefs()) {
                String colAlias = colAliasesIter.next();
                assert (colAlias != null);
                ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), outputTableAlias, false);
                arrayList.add(col);
            }
            RowResolver out_rwsch = new RowResolver();
            boolean bl = false;
            while (var20_25 < arrayList.size()) {
                out_rwsch.put(outputTableAlias, colAliases.get((int)var20_25), (ColumnInfo)arrayList.get((int)var20_25));
                ++var20_25;
            }
            RelTraitSet relTraitSet = TraitsUtil.getDefaultTraitSet(this.cluster);
            RelDataType retType = TypeConverter.getType(this.cluster, out_rwsch, null);
            ImmutableList.Builder argTypeBldr = ImmutableList.builder();
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
            RowSchema rs = selectRR.getRowSchema();
            for (ColumnInfo ci : rs.getSignature()) {
                argTypeBldr.add(TypeConverter.convert(ci.getType(), dtFactory));
            }
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(genericUDTFName, genericUDTF, (ImmutableList<RelDataType>)argTypeBldr.build(), retType);
            ArrayList<RelNode> list = new ArrayList<RelNode>();
            list.add(input);
            RexNode rexNode = this.cluster.getRexBuilder().makeCall(calciteOp, selectColLst);
            HiveTableFunctionScan udtf = HiveTableFunctionScan.create(this.cluster, relTraitSet, list, rexNode, null, retType, null);
            this.relToHiveColNameCalcitePosMap.put(udtf, this.buildHiveToCalciteColumnMap(out_rwsch, udtf));
            this.relToHiveRR.put(udtf, out_rwsch);
            return udtf;
        }

        private RelNode genLogicalPlan(QBExpr qbexpr) throws SemanticException {
            switch (qbexpr.getOpcode()) {
                case NULLOP: {
                    return this.genLogicalPlan(qbexpr.getQB(), false, null, null);
                }
                case UNION: 
                case INTERSECT: 
                case INTERSECTALL: 
                case EXCEPT: 
                case EXCEPTALL: {
                    RelNode qbexpr1Ops = this.genLogicalPlan(qbexpr.getQBExpr1());
                    RelNode qbexpr2Ops = this.genLogicalPlan(qbexpr.getQBExpr2());
                    return this.genSetOpLogicalPlan(qbexpr.getOpcode(), qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
                }
            }
            return null;
        }

        private RelNode genLogicalPlan(QB qb, boolean outerMostQB, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            RelNode srcRel = null;
            RelNode filterRel = null;
            RelNode gbRel = null;
            RelNode gbHavingRel = null;
            RelNode selectRel = null;
            RelNode obRel = null;
            RelNode limitRel = null;
            HashMap<String, RelNode> aliasToRel = new HashMap<String, RelNode>();
            String reason = CalcitePlanner.canHandleQbForCbo(CalcitePlanner.this.queryProperties, CalcitePlanner.this.conf, false, CalcitePlanner.this.LOG.isDebugEnabled(), qb);
            if (reason != null) {
                String msg = "CBO can not handle Sub Query";
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug(msg + " because it: " + reason);
                }
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Subquery);
            }
            for (String subqAlias : qb.getSubqAliases()) {
                QBExpr qbexpr = qb.getSubqForAlias(subqAlias);
                RelNode relNode = this.genLogicalPlan(qbexpr);
                aliasToRel.put(subqAlias, relNode);
                if (!qb.getViewToTabSchema().containsKey(subqAlias)) continue;
                if (relNode instanceof HiveProject) {
                    if (this.viewProjectToTableSchema == null) {
                        this.viewProjectToTableSchema = new LinkedHashMap<HiveProject, Table>();
                    }
                    this.viewProjectToTableSchema.put((HiveProject)relNode, qb.getViewToTabSchema().get(subqAlias));
                    continue;
                }
                throw new SemanticException("View " + subqAlias + " is corresponding to " + relNode.toString() + ", rather than a HiveProject.");
            }
            for (String tableAlias : qb.getTabAliases()) {
                RelNode op = this.genTableLogicalPlan(tableAlias, qb);
                aliasToRel.put(tableAlias, op);
            }
            if (aliasToRel.isEmpty()) {
                throw new CalciteSemanticException("Unsupported", CalciteSemanticException.UnsupportedFeature.Others);
            }
            srcRel = qb.getParseInfo().getJoinExpr() != null ? this.genJoinLogicalPlan(qb.getParseInfo().getJoinExpr(), aliasToRel) : (RelNode)aliasToRel.values().iterator().next();
            filterRel = this.genFilterLogicalPlan(qb, srcRel, aliasToRel, outerNameToPosMap, outerRR, false);
            RelNode starSrcRel = srcRel = filterRel == null ? srcRel : filterRel;
            gbRel = this.genGBLogicalPlan(qb, srcRel);
            srcRel = gbRel == null ? srcRel : gbRel;
            gbHavingRel = this.genGBHavingLogicalPlan(qb, srcRel, aliasToRel);
            srcRel = gbHavingRel == null ? srcRel : gbHavingRel;
            selectRel = this.genSelectLogicalPlan(qb, srcRel, starSrcRel, outerNameToPosMap, outerRR);
            srcRel = selectRel == null ? srcRel : selectRel;
            Pair<RelNode, RelNode> obTopProjPair = this.genOBLogicalPlan(qb, srcRel, outerMostQB);
            obRel = obTopProjPair.getKey();
            RelNode topConstrainingProjArgsRel = obTopProjPair.getValue();
            srcRel = obRel == null ? srcRel : obRel;
            limitRel = this.genLimitLogicalPlan(qb, srcRel);
            RelNode relNode = srcRel = limitRel == null ? srcRel : limitRel;
            if (topConstrainingProjArgsRel != null) {
                List<RexNode> originalInputRefs = Lists.transform(topConstrainingProjArgsRel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

                    @Override
                    public RexNode apply(RelDataTypeField input) {
                        return new RexInputRef(input.getIndex(), input.getType());
                    }
                });
                RowResolver topConstrainingProjRR = new RowResolver();
                if (!RowResolver.add(topConstrainingProjRR, this.relToHiveRR.get(topConstrainingProjArgsRel))) {
                    CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                }
                srcRel = this.genSelectRelNode(originalInputRefs, topConstrainingProjRR, srcRel);
            }
            if (qb.getParseInfo().getAlias() != null) {
                RowResolver rr = this.relToHiveRR.get(srcRel);
                RowResolver newRR = new RowResolver();
                String alias = qb.getParseInfo().getAlias();
                for (ColumnInfo colInfo : rr.getColumnInfos()) {
                    String name = colInfo.getInternalName();
                    String[] tmp = rr.reverseLookup(name);
                    if ("".equals(tmp[0]) || tmp[1] == null) {
                        tmp[1] = colInfo.getInternalName();
                    }
                    ColumnInfo newCi = new ColumnInfo(colInfo);
                    newCi.setTabAlias(alias);
                    newRR.put(alias, tmp[1], newCi);
                }
                this.relToHiveRR.put(srcRel, newRR);
                this.relToHiveColNameCalcitePosMap.put(srcRel, this.buildHiveToCalciteColumnMap(newRR, srcRel));
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Created Plan for Query Block " + qb.getId());
            }
            CalcitePlanner.this.setQB(qb);
            return srcRel;
        }

        private RelNode genGBHavingLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode gbFilter = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String destClauseName = qbp.getClauseNames().iterator().next();
            ASTNode havingClause = qbp.getHavingForClause(qbp.getClauseNames().iterator().next());
            if (havingClause != null) {
                if (!(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Having clause without any group-by.", CalciteSemanticException.UnsupportedFeature.Having_clause_without_any_groupby);
                }
                ASTNode targetNode = (ASTNode)havingClause.getChild(0);
                this.validateNoHavingReferenceToAlias(qb, targetNode);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
                    targetNode = SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, destClauseName), targetNode, !cubeRollupGrpSetPresent);
                }
                gbFilter = this.genFilterRelNode(qb, targetNode, srcRel, aliasToRel, null, null, true);
            }
            return gbFilter;
        }

        private void validateNoHavingReferenceToAlias(QB qb, ASTNode havingExpr) throws CalciteSemanticException {
            QBParseInfo qbPI = qb.getParseInfo();
            Map<ASTNode, String> exprToAlias = qbPI.getAllExprToColumnAlias();
            Set<String> aggExprs = qbPI.getDestToAggregationExprs().values().iterator().next().keySet();
            for (Map.Entry<ASTNode, String> selExpr : exprToAlias.entrySet()) {
                ASTNode selAST = selExpr.getKey();
                if (!aggExprs.contains(selAST.toStringTree().toLowerCase())) continue;
                final String aliasToCheck = selExpr.getValue();
                final HashSet aliasReferences = new HashSet();
                TreeVisitorAction action = new TreeVisitorAction(){

                    public Object pre(Object t) {
                        Object c;
                        if (ParseDriver.adaptor.getType(t) == 973 && (c = ParseDriver.adaptor.getChild(t, 0)) != null && ParseDriver.adaptor.getType(c) == 24 && ParseDriver.adaptor.getText(c).equals(aliasToCheck)) {
                            aliasReferences.add(t);
                        }
                        return t;
                    }

                    public Object post(Object t) {
                        return t;
                    }
                };
                new TreeVisitor(ParseDriver.adaptor).visit((Object)havingExpr, action);
                if (aliasReferences.size() <= 0) continue;
                String havingClause = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(havingExpr.getTokenStartIndex(), havingExpr.getTokenStopIndex());
                String msg = String.format("Encountered Select alias '%s' in having clause '%s' This non standard behavior is not supported with cbo on. Turn off cbo for these queries.", aliasToCheck, havingClause);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_alias_in_having_clause);
            }
        }

        private ImmutableMap<String, Integer> buildHiveToCalciteColumnMap(RowResolver rr, RelNode rNode) {
            ImmutableMap.Builder<String, Integer> b = new ImmutableMap.Builder<String, Integer>();
            for (ColumnInfo ci : rr.getRowSchema().getSignature()) {
                b.put(ci.getInternalName(), rr.getPosition(ci.getInternalName()));
            }
            return b.build();
        }

        private ImmutableMap<String, Integer> buildHiveColNameToInputPosMap(List<ExprNodeDesc> col_list, RowResolver inputRR) {
            HashMap<Integer, ExprNodeDesc> hashCodeTocolumnDescMap = new HashMap<Integer, ExprNodeDesc>();
            ExprNodeDescUtils.getExprNodeColumnDesc(col_list, hashCodeTocolumnDescMap);
            ImmutableMap.Builder<String, Integer> hiveColNameToInputPosMapBuilder = new ImmutableMap.Builder<String, Integer>();
            for (ExprNodeDesc exprDesc : hashCodeTocolumnDescMap.values()) {
                String exprNodecolName = ((ExprNodeColumnDesc)exprDesc).getColumn();
                hiveColNameToInputPosMapBuilder.put(exprNodecolName, inputRR.getPosition(exprNodecolName));
            }
            return hiveColNameToInputPosMapBuilder.build();
        }

        private QBParseInfo getQBParseInfo(QB qb) throws CalciteSemanticException {
            return qb.getParseInfo();
        }

        private List<String> getTabAliases(RowResolver inputRR) {
            ArrayList<String> tabAliases = new ArrayList<String>();
            for (ColumnInfo ci : inputRR.getColumnInfos()) {
                tabAliases.add(ci.getTabAlias());
            }
            return tabAliases;
        }

        private class AggInfo {
            private final List<ExprNodeDesc> m_aggParams;
            private final TypeInfo m_returnType;
            private final String m_udfName;
            private final boolean m_distinct;

            private AggInfo(List<ExprNodeDesc> aggParams, TypeInfo returnType, String udfName, boolean isDistinct) {
                this.m_aggParams = aggParams;
                this.m_returnType = returnType;
                this.m_udfName = udfName;
                this.m_distinct = isDistinct;
            }
        }
    }

    private static enum ExtendedCBOProfile {
        JOIN_REORDERING,
        WINDOWING_POSTPROCESSING;

    }

    private static class ExceptionHelper {
        private static final Field CAUSE_FIELD = ExceptionHelper.getField(Throwable.class, "cause");
        private static final Field TARGET_FIELD = ExceptionHelper.getField(InvocationTargetException.class, "target");
        private static final Field MESSAGE_FIELD = ExceptionHelper.getField(Throwable.class, "detailMessage");

        private ExceptionHelper() {
        }

        private static Field getField(Class<?> clazz, String name) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable t) {
                return null;
            }
        }

        public static boolean resetCause(Throwable target, Throwable newCause) {
            try {
                Field field;
                if (MESSAGE_FIELD == null) {
                    return false;
                }
                Field field2 = field = target instanceof InvocationTargetException ? TARGET_FIELD : CAUSE_FIELD;
                if (field == null) {
                    return false;
                }
                Throwable oldCause = target.getCause();
                String oldMsg = target.getMessage();
                field.set(target, newCause);
                if (oldMsg != null && oldMsg.equals(oldCause.toString())) {
                    MESSAGE_FIELD.set(target, newCause == null ? null : newCause.toString());
                }
            }
            catch (Throwable se) {
                return false;
            }
            return true;
        }
    }

    public static class ASTSearcher {
        private final LinkedList<ASTNode> searchQueue = new LinkedList();

        public ASTNode simpleBreadthFirstSearch(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            for (int i = 0; i < tokens.length; ++i) {
                boolean found = false;
                int token = tokens[i];
                while (!this.searchQueue.isEmpty() && !found) {
                    ASTNode next = this.searchQueue.poll();
                    boolean bl = found = next.getType() == token;
                    if (found) {
                        if (i == tokens.length - 1) {
                            return next;
                        }
                        this.searchQueue.clear();
                    }
                    for (int j = 0; j < next.getChildCount(); ++j) {
                        this.searchQueue.add((ASTNode)next.getChild(j));
                    }
                }
                if (found) continue;
                return null;
            }
            return null;
        }

        public ASTNode depthFirstSearch(ASTNode ast, int token) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                ASTNode next = this.searchQueue.poll();
                if (next.getType() == token) {
                    return next;
                }
                for (int j = 0; j < next.getChildCount(); ++j) {
                    this.searchQueue.add((ASTNode)next.getChild(j));
                }
            }
            return null;
        }

        public ASTNode simpleBreadthFirstSearchAny(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                int i;
                ASTNode next = this.searchQueue.poll();
                for (i = 0; i < tokens.length; ++i) {
                    if (next.getType() != tokens[i]) continue;
                    return next;
                }
                for (i = 0; i < next.getChildCount(); ++i) {
                    this.searchQueue.add((ASTNode)next.getChild(i));
                }
            }
            return null;
        }

        public void reset() {
            this.searchQueue.clear();
        }
    }

    static class PreCboCtx
    extends SemanticAnalyzer.PlannerContext {
        private ASTNode nodeOfInterest;
        private Type type = Type.NONE;

        PreCboCtx() {
        }

        private void set(Type type, ASTNode ast) {
            if (this.type != Type.NONE) {
                BaseSemanticAnalyzer.STATIC_LOG.warn("Setting " + (Object)((Object)type) + " when already " + (Object)((Object)this.type) + "; node " + ast.dump() + " vs old node " + this.nodeOfInterest.dump());
                this.type = Type.UNEXPECTED;
                return;
            }
            this.type = type;
            this.nodeOfInterest = ast;
        }

        @Override
        void setCTASToken(ASTNode child) {
            this.set(Type.CTAS, child);
        }

        @Override
        void setViewToken(ASTNode child) {
            this.set(Type.VIEW, child);
        }

        @Override
        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
            if (!isTmpFileDest) {
                this.set(Type.INSERT, ast);
            }
        }

        @Override
        void setMultiInsertToken(ASTNode child) {
            this.set(Type.MULTI_INSERT, child);
        }

        @Override
        void resetToken() {
            this.type = Type.NONE;
            this.nodeOfInterest = null;
        }

        static enum Type {
            NONE,
            INSERT,
            MULTI_INSERT,
            CTAS,
            VIEW,
            UNEXPECTED;

        }
    }
}

