/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSemiJoinRule
extends RelOptRule {
    public static final HiveSemiJoinRule INSTANCE = new HiveSemiJoinRule(HiveRelFactories.HIVE_BUILDER);
    protected static final Logger LOG = LoggerFactory.getLogger(HiveSemiJoinRule.class);

    private HiveSemiJoinRule(RelBuilderFactory relBuilder) {
        super(HiveSemiJoinRule.operand(Project.class, HiveSemiJoinRule.some(HiveSemiJoinRule.operand(Join.class, HiveSemiJoinRule.some(HiveSemiJoinRule.operand(RelNode.class, HiveSemiJoinRule.any()), HiveSemiJoinRule.operand(Aggregate.class, HiveSemiJoinRule.any()))), new RelOptRuleOperand[0])), relBuilder, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LOG.debug("Matched HiveSemiJoinRule");
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        Object left = call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(3);
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
        ImmutableBitSet rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount());
        if (bits.intersects(rightBits)) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (join.getJoinType() == JoinRelType.LEFT) {
            call.transformTo(call.builder().push((RelNode)left).project(project.getProjects(), project.getRowType().getFieldNames()).build());
            return;
        }
        if (join.getJoinType() != JoinRelType.INNER) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        LOG.debug("All conditions matched for HiveSemiJoinRule. Going to apply transformation.");
        ArrayList<Integer> newRightKeyBuilder = Lists.newArrayList();
        List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
        for (int key : joinInfo.rightKeys) {
            newRightKeyBuilder.add(aggregateKeys.get(key));
        }
        ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
        RelNode newRight = aggregate.getInput();
        RexNode newCondition = RelOptUtil.createEquiJoinCondition(left, joinInfo.leftKeys, newRight, newRightKeys, rexBuilder);
        RelNode semi = null;
        if (aggregate.getInput() instanceof HepRelVertex && ((HepRelVertex)aggregate.getInput()).getCurrentRel() instanceof Join) {
            Join rightJoin = (Join)((HepRelVertex)aggregate.getInput()).getCurrentRel();
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            for (int i = 0; i < rightJoin.getRowType().getFieldCount(); ++i) {
                projects.add(rexBuilder.makeInputRef(rightJoin, i));
            }
            RelNode topProject = call.builder().push(rightJoin).project(projects, rightJoin.getRowType().getFieldNames(), true).build();
            semi = call.builder().push((RelNode)left).push(topProject).semiJoin(newCondition).build();
        } else {
            semi = call.builder().push((RelNode)left).push(aggregate.getInput()).semiJoin(newCondition).build();
        }
        call.transformTo(call.builder().push(semi).project(project.getProjects(), project.getRowType().getFieldNames()).build());
    }
}

