/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;

public class HiveRelColumnsAlignment
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<RelNode> alignDispatcher;
    private final RelBuilder relBuilder;

    public HiveRelColumnsAlignment(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
        this.alignDispatcher = ReflectUtil.createMethodDispatcher(RelNode.class, this, "align", RelNode.class, List.class);
    }

    public RelNode align(RelNode root) {
        RelNode newRoot = this.dispatchAlign(root, ImmutableList.of());
        return newRoot;
    }

    protected final RelNode dispatchAlign(RelNode node, List<RelFieldCollation> collations) {
        return this.alignDispatcher.invoke(node, collations);
    }

    public RelNode align(Aggregate rel, List<RelFieldCollation> collations) {
        LinkedHashSet<Integer> aggregateColumnsOrder = new LinkedHashSet<Integer>();
        ImmutableList.Builder propagateCollations = ImmutableList.builder();
        if (!rel.indicator && !collations.isEmpty()) {
            for (RelFieldCollation c : collations) {
                if (c.getFieldIndex() >= rel.getGroupCount() || !aggregateColumnsOrder.add(c.getFieldIndex())) continue;
                propagateCollations.add(c.copy(rel.getGroupSet().nth(c.getFieldIndex())));
            }
        }
        for (int i = 0; i < rel.getGroupCount(); ++i) {
            if (aggregateColumnsOrder.contains(i)) continue;
            propagateCollations.add(new RelFieldCollation(rel.getGroupSet().nth(i)));
        }
        RelNode child = this.dispatchAlign(rel.getInput(), (List<RelFieldCollation>)((Object)propagateCollations.build()));
        HiveAggregate newAggregate = (HiveAggregate)rel.copy(rel.getTraitSet(), ImmutableList.of(child));
        newAggregate.setAggregateColumnsOrder(aggregateColumnsOrder);
        return newAggregate;
    }

    public RelNode align(Join rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder propagateCollationsLeft = ImmutableList.builder();
        ImmutableList.Builder propagateCollationsRight = ImmutableList.builder();
        int nLeftColumns = rel.getLeft().getRowType().getFieldList().size();
        HashMap<Integer, RexCall> idxToConjuncts = new HashMap<Integer, RexCall>();
        HashMap<Integer, Integer> refToRef = new HashMap<Integer, Integer>();
        ArrayList<RexNode> conjuncts = new ArrayList<RexNode>();
        ArrayList<RexNode> otherConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : RelOptUtil.conjunctions(rel.getCondition())) {
            if (rexNode.getKind() != SqlKind.EQUALS) {
                otherConjuncts.add(rexNode);
                continue;
            }
            RexCall rexCall = (RexCall)rexNode;
            if (!(rexCall.getOperands().get(0) instanceof RexInputRef) || !(rexCall.getOperands().get(1) instanceof RexInputRef)) {
                otherConjuncts.add(rexNode);
                continue;
            }
            RexInputRef ref0 = (RexInputRef)rexCall.getOperands().get(0);
            RexInputRef ref1 = (RexInputRef)rexCall.getOperands().get(1);
            if (ref0.getIndex() < nLeftColumns && ref1.getIndex() >= nLeftColumns || ref1.getIndex() < nLeftColumns && ref0.getIndex() >= nLeftColumns) {
                idxToConjuncts.put(ref0.getIndex(), rexCall);
                idxToConjuncts.put(ref1.getIndex(), rexCall);
                refToRef.put(ref0.getIndex(), ref1.getIndex());
                refToRef.put(ref1.getIndex(), ref0.getIndex());
                continue;
            }
            otherConjuncts.add(rexNode);
        }
        for (RelFieldCollation relFieldCollation : collations) {
            RexNode rexNode = (RexNode)idxToConjuncts.get(relFieldCollation.getFieldIndex());
            if (rexNode == null) continue;
            conjuncts.add(rexNode);
            idxToConjuncts.remove(relFieldCollation.getFieldIndex());
            idxToConjuncts.remove(refToRef.get(relFieldCollation.getFieldIndex()));
            if (relFieldCollation.getFieldIndex() < nLeftColumns) {
                propagateCollationsLeft.add(relFieldCollation.copy(relFieldCollation.getFieldIndex()));
                propagateCollationsRight.add(relFieldCollation.copy((Integer)refToRef.get(relFieldCollation.getFieldIndex()) - nLeftColumns));
                continue;
            }
            propagateCollationsLeft.add(relFieldCollation.copy((Integer)refToRef.get(relFieldCollation.getFieldIndex())));
            propagateCollationsRight.add(relFieldCollation.copy(relFieldCollation.getFieldIndex() - nLeftColumns));
        }
        HashSet visited = new HashSet();
        for (Map.Entry entry : idxToConjuncts.entrySet()) {
            if (!visited.add(entry.getValue())) continue;
            conjuncts.add((RexNode)entry.getValue());
            if ((Integer)entry.getKey() < nLeftColumns) {
                propagateCollationsLeft.add(new RelFieldCollation((Integer)entry.getKey()));
                propagateCollationsRight.add(new RelFieldCollation((Integer)refToRef.get(entry.getKey()) - nLeftColumns));
                continue;
            }
            propagateCollationsLeft.add(new RelFieldCollation((Integer)refToRef.get(entry.getKey())));
            propagateCollationsRight.add(new RelFieldCollation((Integer)entry.getKey() - nLeftColumns));
        }
        conjuncts.addAll(otherConjuncts);
        RelNode relNode = this.dispatchAlign(rel.getLeft(), (List<RelFieldCollation>)((Object)propagateCollationsLeft.build()));
        RelNode relNode2 = this.dispatchAlign(rel.getRight(), (List<RelFieldCollation>)((Object)propagateCollationsRight.build()));
        Join newJoin = rel.copy(rel.getTraitSet(), RexUtil.composeConjunction(this.relBuilder.getRexBuilder(), conjuncts, false), relNode, relNode2, rel.getJoinType(), rel.isSemiJoinDone());
        return newJoin;
    }

    public RelNode align(SetOp rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder newInputs = new ImmutableList.Builder();
        for (RelNode input : rel.getInputs()) {
            newInputs.add(this.dispatchAlign(input, collations));
        }
        return rel.copy(rel.getTraitSet(), (List)((Object)newInputs.build()));
    }

    public RelNode align(Project rel, List<RelFieldCollation> collations) {
        boolean containsWindowing = false;
        for (RexNode rexNode : rel.getChildExps()) {
            if (!(rexNode instanceof RexOver)) continue;
            containsWindowing = true;
            break;
        }
        ImmutableList.Builder propagateCollations = ImmutableList.builder();
        if (!containsWindowing) {
            for (RelFieldCollation c : collations) {
                RexNode rexNode = rel.getChildExps().get(c.getFieldIndex());
                if (!(rexNode instanceof RexInputRef)) continue;
                int newIdx = ((RexInputRef)rexNode).getIndex();
                propagateCollations.add(c.copy(newIdx));
            }
        }
        RelNode relNode = this.dispatchAlign(rel.getInput(), (List<RelFieldCollation>)((Object)propagateCollations.build()));
        return rel.copy(rel.getTraitSet(), ImmutableList.of(relNode));
    }

    public RelNode align(Filter rel, List<RelFieldCollation> collations) {
        RelNode child = this.dispatchAlign(rel.getInput(), collations);
        return rel.copy(rel.getTraitSet(), ImmutableList.of(child));
    }

    public RelNode align(Sort rel, List<RelFieldCollation> collations) {
        RelNode child = this.dispatchAlign(rel.getInput(), rel.collation.getFieldCollations());
        return rel.copy(rel.getTraitSet(), ImmutableList.of(child));
    }

    public RelNode align(RelNode rel, List<RelFieldCollation> collations) {
        ImmutableList.Builder newInputs = new ImmutableList.Builder();
        for (RelNode input : rel.getInputs()) {
            newInputs.add(this.dispatchAlign(input, ImmutableList.of()));
        }
        return rel.copy(rel.getTraitSet(), (List<RelNode>)((Object)newInputs.build()));
    }
}

